/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.template;

import com.ibm.team.workitem.common.internal.identifiers.IAttributeType;
import com.ibm.team.workitem.common.internal.identifiers.IIdentifierMapping;
import com.ibm.team.workitem.common.internal.identifiers.IPublicAttribute;
import com.ibm.team.workitem.common.internal.identifiers.IPublicType;
import com.ibm.team.workitem.common.internal.identifiers.IdentifierMapping;
import com.ibm.team.workitem.common.internal.template.Messages;
import com.ibm.team.workitem.common.internal.template.TemplateIdentifierRegistry;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.template.IAttributeVariable;
import com.ibm.team.workitem.common.template.ITemplateTypeIdentifiers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeVariable
implements IAttributeVariable {
    private final Identifier<IPublicAttribute> fIdentifier;
    private Identifier<IPublicType> fType;

    public AttributeVariable(String declaration) {
        String identifier;
        if (declaration == null || declaration.length() == 0) {
            throw new IllegalArgumentException(Messages.getString("AttributeVariable.ERROR_ILLEGAL_VARIABLE_DECLARATION"));
        }
        String temp = declaration;
        if (temp.startsWith("${")) {
            temp = temp.substring("${".length());
        }
        if (temp.endsWith("}")) {
            temp = temp.substring(0, temp.length() - "}".length());
        }
        if (temp.indexOf(":") > -1) {
            String[] pair = temp.split(":");
            identifier = pair[0];
            this.fType = Identifier.create(IPublicType.class, pair[1]);
        } else {
            identifier = declaration;
        }
        this.fIdentifier = IdentifierMapping.createPublicAttributeIdentifier(ITemplateTypeIdentifiers.CHANGE_REQUEST, identifier);
    }

    public AttributeVariable(String identifier, Identifier<IPublicType> type) {
        if (identifier == null || identifier.length() == 0) {
            throw new IllegalArgumentException(Messages.getString("AttributeVariable.ERROR_ILLEGAL_VARIABLE_IDENTIFIER"));
        }
        if (type == null) {
            throw new IllegalArgumentException(Messages.getString("AttributeVariable.ERROR_ILLEGAL_VARIABLE_TYPE"));
        }
        this.fIdentifier = Identifier.create(IPublicAttribute.class, identifier);
        this.fType = type;
    }

    public AttributeVariable(Identifier<IPublicAttribute> identifier, Identifier<IPublicType> type) {
        if (identifier == null) {
            throw new IllegalArgumentException(Messages.getString("AttributeVariable.ERROR_ILLEGAL_VARIABLE_IDENTIFIER"));
        }
        if (type == null) {
            throw new IllegalArgumentException(Messages.getString("AttributeVariable.ERROR_ILLEGAL_VARIABLE_TYPE"));
        }
        this.fIdentifier = identifier;
        this.fType = type;
    }

    public AttributeVariable(IAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(Messages.getString("AttributeVariable.ERROR_NULL_ATTRIBUTE"));
        }
        Identifier<IAttribute> intID = IdentifierMapping.createInternalAttributeIdentifier(attribute);
        Identifier<IAttributeType> intTypID = IdentifierMapping.createInternalTypeIdentifier(attribute);
        IIdentifierMapping mapping = IdentifierMapping.create(TemplateIdentifierRegistry.class);
        this.fIdentifier = mapping.getPublicIdentifier(intID);
        this.fType = mapping.getPublicIdentifier(intTypID);
    }

    @Override
    public Identifier<IPublicAttribute> getIdentifier() {
        return this.fIdentifier;
    }

    @Override
    public Identifier<IPublicType> getType() {
        return this.fType;
    }

    public void setType(Identifier<IPublicType> type) {
        if (type == null) {
            throw new IllegalArgumentException(Messages.getString("AttributeVariable.6"));
        }
        this.fType = type;
    }

    @Override
    public String getDeclaration() {
        return "${" + this.fIdentifier.getStringIdentifier() + (this.fType != null ? ":" + this.fType.getStringIdentifier() : "") + "}";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fIdentifier == null ? 0 : this.fIdentifier.getStringIdentifier().hashCode());
        result = 31 * result + (this.fType == null ? 0 : this.fType.getStringIdentifier().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeVariable other = (AttributeVariable)obj;
        if (this.fIdentifier == null ? other.fIdentifier != null : !this.fIdentifier.getStringIdentifier().equals(other.fIdentifier.getStringIdentifier())) {
            return false;
        }
        return !(this.fType == null ? other.fType != null : !this.fType.getStringIdentifier().equals(other.fType.getStringIdentifier()));
    }

    public String toString() {
        return this.getDeclaration();
    }
}

