/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query.util;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.workitem.common.internal.query.IExportDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportLocations {
    public static final String URL_PARAM_COLUMNS = "col";
    public static final String URL_PARAM_EXPORTER = "exporter";
    public static final String URL_PARAM_VALUE_ID = "id";
    public static final String URL_PARAM_LINK_STYLE = "_linkStyle";
    public static final String URL_PARAM_LINK_STYLE_ABSOLUTE = "absolute";

    public static Location createExportLocation(IQueryDescriptorHandle handle, IExportDescriptor exportDescriptor, Map<String, List<String>> queryParams, String repoUrl) {
        return ExportLocations.createExportLocation(handle, exportDescriptor.getContentType(), queryParams, repoUrl);
    }

    public static Location createExportLocation(IQueryDescriptorHandle handle, ExportType exportType, Map<String, List<String>> queryParams, String repoUrl) {
        return ExportLocations.createExportLocation(handle, exportType.toString(), queryParams, repoUrl);
    }

    private static Location createExportLocation(IQueryDescriptorHandle handle, String mediaType, Map<String, List<String>> queryParams, String repoUrl) {
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        parameters.put("_mediaType", Collections.singletonList(mediaType));
        if (queryParams != null) {
            parameters.putAll(queryParams);
        }
        String queryString = ExportLocations.createQueryString(parameters);
        return Location.itemLocation((IItemHandle)handle, (String)repoUrl, (String)queryString, null);
    }

    public static String createQueryString(Map<String, List<String>> parameters) {
        if (parameters == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        Iterator<String> keyIterator = parameters.keySet().iterator();
        while (keyIterator.hasNext()) {
            String key = keyIterator.next();
            List<String> values = parameters.get(key);
            if (values == null) continue;
            Iterator<String> valueIterator = values.iterator();
            while (valueIterator.hasNext()) {
                buffer.append(key);
                buffer.append("=");
                buffer.append(valueIterator.next());
                if (!keyIterator.hasNext() && !valueIterator.hasNext()) continue;
                buffer.append("&");
            }
        }
        return buffer.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExportType {
        CSV("text/csv"),
        HTML("text/html");

        private final String fId;

        private ExportType(String id) {
            this.fId = id;
        }

        public String toString() {
            return this.fId;
        }
    }
}

