/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ProcessCommon;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IQuery;
import com.ibm.team.repository.common.query.ast.IDynamicQueryModel;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.IManyItemQueryModel;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.ISingleItemQueryModel;
import com.ibm.team.workitem.common.internal.expression.ITransformationContext;
import com.ibm.team.workitem.common.internal.model.Category;
import com.ibm.team.workitem.common.model.AttributeOperation;
import com.ibm.team.workitem.common.model.IWorkItem;

public class TeamAreaEqualsOperation
extends AttributeOperation {
    private boolean fInvert;
    private final String DEVELOPMENTLINE_PROPERTY = ProcessCommon.getPropertyName(IIteration.class, (String)"developmentLine");

    public TeamAreaEqualsOperation(String identifier, String displayName, boolean invert) {
        super(identifier, displayName);
        this.fInvert = invert;
    }

    public boolean evaluate(Object left, Object right) {
        return false;
    }

    public IPredicate getPredicate(ITransformationContext context) throws TeamRepositoryException {
        IQuery query = context.getQuery();
        ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)context.getValue();
        IDevelopmentLine devLine = context.getAuditableCommon().getDevelopmentLine(teamAreaHandle, null);
        IManyItemQueryModel categoryTeamAreas = (IManyItemQueryModel)context.getReference(IWorkItem.CATEGORY_PROPERTY).getReference(Category.TEAM_AREAS_PROPERTY);
        IDynamicQueryModel target = context.getReference(IWorkItem.TARGET_PROPERTY);
        ISingleItemQueryModel targetDevelopmentLine = (ISingleItemQueryModel)target.getReference(this.DEVELOPMENTLINE_PROPERTY);
        ISingleItemQueryModel categoryDefaultTeamArea = (ISingleItemQueryModel)context.getReference(IWorkItem.CATEGORY_PROPERTY).getReference(Category.DEFAULT_TEAM_AREA_PROPERTY);
        IItemHandleInputArg teamAreaInputArg = query.newItemHandleArg();
        context.addParameter(teamAreaHandle);
        IPredicate predicate = categoryDefaultTeamArea._eq(teamAreaInputArg)._and(target._isNull());
        IPredicate isInTeamAreaList = categoryTeamAreas._contains(teamAreaInputArg);
        if (devLine != null) {
            IItemHandleInputArg devLineInputArg = query.newItemHandleArg();
            context.addParameter(devLine.getItemHandle());
            predicate = predicate._or(isInTeamAreaList._and(targetDevelopmentLine._eq(devLineInputArg)));
        } else {
            predicate = predicate._or(isInTeamAreaList._and(targetDevelopmentLine._isNull()));
        }
        return this.fInvert ? predicate._not() : predicate;
    }

    public boolean isNegation() {
        return this.fInvert;
    }
}

