/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.query;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.query.ast.IBoolean;
import com.ibm.team.repository.common.query.ast.IBooleanField;
import com.ibm.team.repository.common.query.ast.IBooleanInputArg;
import com.ibm.team.repository.common.query.ast.IDateTime;
import com.ibm.team.repository.common.query.ast.IDateTimeField;
import com.ibm.team.repository.common.query.ast.IEnum;
import com.ibm.team.repository.common.query.ast.IEnumField;
import com.ibm.team.repository.common.query.ast.IEnumInputArg;
import com.ibm.team.repository.common.query.ast.IField;
import com.ibm.team.repository.common.query.ast.IFilterElement;
import com.ibm.team.repository.common.query.ast.IItemHandleInputArg;
import com.ibm.team.repository.common.query.ast.INumeric;
import com.ibm.team.repository.common.query.ast.INumericField;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.ISingleItemQueryModel;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.query.ast.IStringField;
import com.ibm.team.repository.common.query.ast.IStringInputArg;
import com.ibm.team.repository.common.query.ast.IUUID;
import com.ibm.team.repository.common.query.ast.IUUIDField;
import com.ibm.team.repository.common.query.ast.IUUIDInputArg;
import com.ibm.team.workitem.common.expression.variables.TimeSpan;
import com.ibm.team.workitem.common.internal.expression.ITransformationContext;
import com.ibm.team.workitem.common.internal.util.SeparatedStringList;
import com.ibm.team.workitem.common.model.AttributeOperation;
import java.sql.Timestamp;
import java.util.Collection;

public class EqualsOperation
extends AttributeOperation {
    private boolean fInvert;

    public EqualsOperation(String identifier, String displayName, boolean invert) {
        super(identifier, displayName);
        this.fInvert = invert;
    }

    public boolean evaluate(Object left, Object right) {
        boolean result = this.internalEvaluate(left, right);
        return this.fInvert ? !result : result;
    }

    private boolean internalEvaluate(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        if (left instanceof IItemHandle && right instanceof IItemHandle) {
            return ((IItemHandle)left).sameItemId((IItemHandle)right);
        }
        if (right instanceof Collection) {
            Collection collection = (Collection)right;
            boolean equals = false;
            for (Object object : collection) {
                equals |= this.evaluate(left, object);
            }
            return equals;
        }
        return left.equals(right);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IPredicate getPredicate(ITransformationContext context) {
        if (context.isField()) {
            IField field = context.getField();
            if (context.getValue() == null) {
                if (!context.getAttribute().isStateExtension()) return this.handleNull(context, field);
                return this.handleStateExtension(context, null);
            }
            if (field instanceof IStringField) {
                String value = context.getValue().toString();
                if ("tags".equals(context.getAttribute().getAttributeType()) && value.length() > 0) {
                    return this.handleTagField(context, (IStringField)field, value);
                }
                IStringInputArg inputArg = context.getQuery().newStringArg();
                context.addParameter(context.getValue());
                if (!context.getAttribute().isStateExtension()) return this.handleString(context, (IStringField)field, inputArg);
                return this.handleStateExtension(context, (IFilterElement)inputArg);
            }
            if (field instanceof IDateTimeField) {
                return this.handleDateTimeField(context);
            }
            if (field instanceof INumericField) {
                INumeric inputArg = this.createNumericInputArg(context);
                context.addParameter(context.getValue());
                if (!context.getAttribute().isStateExtension()) return this.handleNumeric(context, (INumericField)field, inputArg);
                return this.handleStateExtension(context, (IFilterElement)inputArg);
            }
            if (field instanceof IBooleanField) {
                IBooleanInputArg inputArg = context.getQuery().newBooleanArg();
                context.addParameter(context.getValue());
                if (!context.getAttribute().isStateExtension()) return this.handleBoolean(context, (IBooleanField)field, inputArg);
                return this.handleStateExtension(context, (IFilterElement)inputArg);
            }
            if (field instanceof IUUIDField) {
                IUUIDInputArg inputArg = context.getQuery().newUUIDArg();
                context.addParameter(context.getValue());
                if (!context.getAttribute().isStateExtension()) return this.handleUUID(context, (IUUIDField)field, inputArg);
                return this.handleStateExtension(context, (IFilterElement)inputArg);
            }
            if (!(field instanceof IEnumField)) throw new IllegalArgumentException("Unknown field type");
            IEnumInputArg inputArg = context.getQuery().newEnumArg();
            context.addParameter(context.getValue());
            if (!context.getAttribute().isStateExtension()) return this.handleEnum(context, (IEnumField)field, inputArg);
            return this.handleStateExtension(context, (IFilterElement)inputArg);
        }
        if (context.getValue() == null) {
            if (!context.getAttribute().isStateExtension()) return this.handleNullReference(context);
            return this.handleStateExtension(context, null);
        }
        IItemHandleInputArg inputArg = context.getQuery().newItemHandleArg();
        context.addParameter(context.getValue());
        if (!context.getAttribute().isStateExtension()) return this.handleItem(context, inputArg);
        return this.handleStateExtension(context, (IFilterElement)inputArg);
    }

    private IPredicate handleItem(ITransformationContext context, IItemHandleInputArg inputArg) {
        IPredicate predicate = ((ISingleItemQueryModel)context.getReference())._eq(inputArg);
        return this.fInvert ? this.invertNullAware(context, predicate) : predicate;
    }

    private IPredicate handleNullReference(ITransformationContext context) {
        IPredicate predicate = context.getReference()._isNull();
        return this.fInvert ? this.invertNullAware(context, predicate) : predicate;
    }

    private IPredicate handleEnum(ITransformationContext context, IEnumField field, IEnumInputArg inputArg) {
        IPredicate predicate = field._eq((IEnum)inputArg);
        return this.fInvert ? this.invertNullAware(context, predicate) : predicate;
    }

    private IPredicate handleUUID(ITransformationContext context, IUUIDField field, IUUIDInputArg inputArg) {
        IPredicate predicate = field._eq((IUUID)inputArg);
        return this.fInvert ? this.invertNullAware(context, predicate) : predicate;
    }

    private IPredicate handleBoolean(ITransformationContext context, IBooleanField field, IBooleanInputArg inputArg) {
        IPredicate predicate = field._eq((IBoolean)inputArg);
        return this.fInvert ? this.invertNullAware(context, predicate) : predicate;
    }

    private IPredicate handleNumeric(ITransformationContext context, INumericField field, INumeric inputArg) {
        IPredicate predicate = field._eq(inputArg);
        return this.fInvert ? this.invertNullAware(context, predicate) : predicate;
    }

    private IPredicate handleString(ITransformationContext context, IStringField field, IStringInputArg inputArg) {
        IPredicate predicate = field._eq((IString)inputArg);
        return this.fInvert ? this.invertNullAware(context, predicate) : predicate;
    }

    private IPredicate handleNull(ITransformationContext context, IField field) {
        IPredicate predicate = field._isNull();
        return this.fInvert ? this.invertNullAware(context, predicate) : predicate;
    }

    private IPredicate handleStateExtension(ITransformationContext context, IFilterElement inputArg) {
        IStringInputArg key = context.createStateExtensionKey();
        if (this.fInvert) {
            if (inputArg == null) {
                return context.getStateExtensionQueryModel()._isNullValue((IString)key)._not();
            }
            return context.getStateExtensionQueryModel()._notEqKeyValue((IString)key, inputArg)._or(context.getStateExtensionQueryModel()._isNullValue((IString)key));
        }
        if (inputArg == null) {
            return context.getStateExtensionQueryModel()._isNullValue((IString)key);
        }
        return context.getStateExtensionQueryModel()._eqKeyValue((IString)key, inputArg);
    }

    private IPredicate handleTagField(ITransformationContext context, IStringField field, String value) {
        IPredicate predicate = field._like((IString)context.getQuery().newStringArg(), '\\');
        context.addLikeParameter("%%|%s|%%", SeparatedStringList.escape(value));
        if (this.fInvert) {
            predicate = predicate._not();
        }
        if (context.getAttribute().isStateExtension()) {
            predicate = context.createOldStateExtensionPredicate(predicate);
        }
        return predicate;
    }

    private IPredicate handleDateTimeField(ITransformationContext context) {
        IDateTimeField field = (IDateTimeField)context.getField();
        TimeSpan timeSpan = this.createTimeSpan(context);
        if (context.getAttribute().isStateExtension()) {
            if (this.fInvert) {
                IStringInputArg key1 = context.createStateExtensionKey();
                IPredicate lt = context.getStateExtensionQueryModel()._ltKeyValue((IString)key1, (IFilterElement)context.getQuery().newDateTimeArg());
                context.addParameter(timeSpan.getStart());
                IStringInputArg key2 = context.createStateExtensionKey();
                IPredicate gt = context.getStateExtensionQueryModel()._gtKeyValue((IString)key2, (IFilterElement)context.getQuery().newDateTimeArg());
                context.addParameter(timeSpan.getEnd());
                return lt._or(gt);
            }
            IStringInputArg key1 = context.createStateExtensionKey();
            IPredicate gtOrEq = context.getStateExtensionQueryModel()._gtOrEqKeyValue((IString)key1, (IFilterElement)context.getQuery().newDateTimeArg());
            context.addParameter(timeSpan.getStart());
            IStringInputArg key2 = context.createStateExtensionKey();
            IPredicate ltOrEq = context.getStateExtensionQueryModel()._ltOrEqKeyValue((IString)key2, (IFilterElement)context.getQuery().newDateTimeArg());
            context.addParameter(timeSpan.getEnd());
            return gtOrEq._and(ltOrEq);
        }
        context.addParameter(timeSpan.getStart());
        context.addParameter(timeSpan.getEnd());
        IPredicate predicate = field._gtOrEq((IDateTime)context.getQuery().newDateTimeArg())._and(field._ltOrEq((IDateTime)context.getQuery().newDateTimeArg()));
        return this.fInvert ? predicate._not() : predicate;
    }

    private TimeSpan createTimeSpan(ITransformationContext context) {
        Object value = context.getValue();
        if (value instanceof Timestamp) {
            return TimeSpan.createTimeSpan((Timestamp)value, 5, context.getTimeZone());
        }
        return (TimeSpan)value;
    }

    public boolean isNegation() {
        return this.fInvert;
    }
}

