/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.oslc.mappings;

import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.links.common.registry.ILinkType;
import com.ibm.team.links.common.registry.ILinkTypeRegistry;
import com.ibm.team.repository.common.FileLocator;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.internal.oslc.mappings.AttributeDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.IAttributeDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.LinkAttributeDescriptor;
import com.ibm.team.workitem.common.internal.oslc.mappings.Messages;
import com.ibm.team.workitem.common.internal.oslc.utl.XMLParseException;
import com.ibm.team.workitem.common.internal.oslc.utl.XMLParserUtil;
import com.ibm.team.workitem.common.internal.oslc.utl.XMLPath;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import java.net.URL;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeRegistry {
    private static AttributeRegistry fgRegistry;
    private final Map<String, AttributeTypeDescriptor> fTypeDescriptors = new HashMap<String, AttributeTypeDescriptor>();
    private final Map<String, String> fNamespaceByPrefix = new HashMap<String, String>();
    private final Map<String, String> fWorkItemIdMap = new HashMap<String, String>();
    private final Map<String, String> fWorkItemNsMap = new HashMap<String, String>();
    private Timestamp fLastModified;

    public static synchronized AttributeRegistry getInstance() {
        if (fgRegistry == null) {
            URL url = FileLocator.find((String)"com.ibm.team.workitem.common", (IPath)new Path("resources/rest/oslc-attribute-definitions.xml"));
            fgRegistry = AttributeRegistry.readRegistry(url);
            fgRegistry.readLinkAttributes();
        }
        return fgRegistry;
    }

    private static AttributeRegistry readRegistry(URL url) {
        AttributeRegistry registry = new AttributeRegistry();
        try {
            XMLParserUtil parser = new XMLParserUtil(new AttributeHandler(registry));
            parser.parse(url);
            registry.readLinkAttributes();
            registry.setLastModified(System.currentTimeMillis());
            return registry;
        }
        catch (XMLParseException x) {
            WorkItemCommonPlugin.log(Messages.getServerString("AttributeRegistry.ATTR_DEF_PARSING_FAILED"), x);
            return registry;
        }
    }

    private AttributeRegistry() {
    }

    public boolean hasAttributeType(String attributeType) {
        return this.fTypeDescriptors.get(attributeType) != null;
    }

    public AttributeTypeDescriptor getTypeDescriptor(String attributeType) {
        return this.fTypeDescriptors.get(attributeType);
    }

    public Collection<IAttributeDescriptor> getAttributes(String attributeType) {
        AttributeTypeDescriptor typeMapping = this.fTypeDescriptors.get(attributeType);
        return typeMapping != null ? typeMapping.getAttributeDescriptors() : Collections.emptyList();
    }

    public IAttributeDescriptor getAttributeDescriptor(String attributeType, String attributeId) {
        AttributeTypeDescriptor typeMapping = this.fTypeDescriptors.get(attributeType);
        return typeMapping != null ? typeMapping.getAttributeDescriptor(attributeId) : null;
    }

    private String getNamespace(String nsPrefix) {
        return this.fNamespaceByPrefix.get(nsPrefix);
    }

    private void declareNamespace(String prefix, String uri) {
        this.fNamespaceByPrefix.put(prefix, uri);
    }

    public Timestamp getLastModified() {
        return this.fLastModified;
    }

    public String getExternalWorkItemAttributeId(String internalId) {
        String id = this.fWorkItemIdMap.get(internalId);
        return id != null ? id : internalId;
    }

    public String getExternalWorkItemAttributeNamespace(String internalId) {
        return this.fWorkItemNsMap.get(internalId);
    }

    public String getInternalAttributeIdentifier(String attributeType, String identifier, String nsUri) {
        if ("workItem".equals(attributeType)) {
            Set<Map.Entry<String, String>> set = this.fWorkItemIdMap.entrySet();
            for (Map.Entry<String, String> entry : set) {
                if (!entry.getValue().equals(identifier)) continue;
                return entry.getKey();
            }
            return null;
        }
        IAttributeDescriptor descriptor = this.getAttributeDescriptor(attributeType, identifier);
        return descriptor != null ? descriptor.getIdentifier() : null;
    }

    private void setLastModified(long lastModified) {
        this.fLastModified = new Timestamp(lastModified);
    }

    private void setWorkItemIdMapping(String identifier, String externalId, String ns) {
        String internalId = WorkItemAttributes.getAttributeId(Identifier.create(IAttribute.class, identifier));
        this.fWorkItemIdMap.put(internalId, externalId);
        if (ns != null) {
            Assert.isTrue((boolean)this.fNamespaceByPrefix.containsKey(ns), (String)ns);
            this.fWorkItemNsMap.put(internalId, this.fNamespaceByPrefix.get(ns));
        }
    }

    private void readLinkAttributes() {
        AttributeTypeDescriptor workItemTypeDescriptor = this.fTypeDescriptors.get("workItem");
        Collection links = ILinkTypeRegistry.INSTANCE.allEntries();
        for (ILinkType linkType : links) {
            IEndPointDescriptor target;
            IEndPointDescriptor source = linkType.getSourceEndPointDescriptor();
            if (this.isSupported(source, target = linkType.getTargetEndPointDescriptor())) {
                workItemTypeDescriptor.addAttributeDescriptor(this.createLinkAttribute(target));
            }
            if (WorkItemLinkTypes.isSymmetric(source) || !this.isSupported(target, source)) continue;
            workItemTypeDescriptor.addAttributeDescriptor(this.createLinkAttribute(source));
        }
    }

    private LinkAttributeDescriptor createLinkAttribute(IEndPointDescriptor endPoint) {
        String internalId = this.getIdentifier(endPoint);
        String identifier = this.getExternalWorkItemAttributeId(internalId);
        String ns = this.getExternalWorkItemAttributeNamespace(internalId);
        return new LinkAttributeDescriptor("workItem", endPoint, identifier, ns == null ? "http://jazz.net/xmlns/prod/jazz/rtc/cm/1.0/" : ns);
    }

    private boolean isSupported(IEndPointDescriptor source, IEndPointDescriptor target) {
        return source.getReferencedItemType() == IWorkItem.ITEM_TYPE;
    }

    private String getIdentifier(IEndPointDescriptor endPoint) {
        String endPointId = endPoint.getId();
        if (endPointId == null) {
            endPointId = endPoint.isSource() ? "s" : "t";
        }
        return String.format("%s.%s", endPoint.getLinkType().getLinkTypeId(), endPointId);
    }

    public static class AttributeHandler {
        private static final String REF_ID = "refId";
        private static final String ID = "id";
        private static final String PATH = "path";
        private static final String FROM = "from";
        private static final String TO = "to";
        private static final String NS_REF = "ns";
        private static final String NS_PREFIX = "prefix";
        private static final String NS_URI = "uri";
        private static final String DEFAULT = "default";
        private static final String ATTRIBUTE_TYPE = "attributeType";
        private final AttributeRegistry fRegistry;
        private final Map<String, AttributeDescriptor> fAttributes = new HashMap<String, AttributeDescriptor>();
        private String fDefaultNs;

        private AttributeHandler(AttributeRegistry registry) {
            this.fRegistry = registry;
        }

        @XMLPath(value="/configuration/namespaces/ns")
        public void handleNamespace(Attributes attributes) {
            String prefix = attributes.getValue(NS_PREFIX);
            String uri = attributes.getValue(NS_URI);
            Boolean isDefault = Boolean.parseBoolean(attributes.getValue(DEFAULT));
            Assert.isNotNull((Object)prefix);
            Assert.isNotNull((Object)uri);
            if (isDefault.booleanValue()) {
                this.fDefaultNs = prefix;
            }
            this.fRegistry.declareNamespace(prefix, uri);
        }

        @XMLPath(value="/configuration/attributes/attribute")
        public AttributeDescriptor handleAttributeDeclaration(Attributes attributes) {
            String referenceId = attributes.getValue(REF_ID);
            Assert.isNotNull((Object)referenceId);
            Assert.isTrue((!this.fAttributes.containsKey(referenceId) ? 1 : 0) != 0, (String)referenceId);
            AttributeDescriptor descriptor = new AttributeDescriptor();
            this.fAttributes.put(referenceId, descriptor);
            return descriptor;
        }

        @XMLPath(value="/configuration/attributes/attribute/identifier#content")
        public void handleAttributeId(Attributes attributes, String content, AttributeDescriptor parent) {
            Assert.isNotNull((Object)content);
            String nsUri = this.getNamespace(attributes.getValue(NS_REF));
            parent.setIdentifier(content);
            parent.setNamespace(nsUri);
        }

        @XMLPath(value="/configuration/attributes/attribute/type#content")
        public void handleAttributeType(Attributes attributes, String content, AttributeDescriptor parent) {
            Assert.isNotNull((Object)content);
            parent.setAttributeType(content);
        }

        @XMLPath(value="/configuration/attributes/attribute/name#content")
        public void handleAttributeName(Attributes attributes, String content, AttributeDescriptor parent) {
            Assert.isNotNull((Object)content);
            parent.setDisplayName(content);
        }

        @XMLPath(value="/configuration/attributes/attribute/isCollection#content")
        public void handleAttributeIsCollection(Attributes attributes, String content, AttributeDescriptor parent) {
            Assert.isNotNull((Object)content);
            parent.setCollection(Boolean.parseBoolean(content));
        }

        @XMLPath(value="/configuration/attributes/attribute/isReadOnly#content")
        public void handleAttributeIsReadOnly(Attributes attributes, String content, AttributeDescriptor parent) {
            Assert.isNotNull((Object)content);
            parent.setReadOnly(Boolean.parseBoolean(content));
        }

        @XMLPath(value="/configuration/types/type")
        public AttributeTypeDescriptor handleType(Attributes attributes) {
            String typeId = attributes.getValue(ATTRIBUTE_TYPE);
            String id = attributes.getValue(ID);
            String nsUri = this.getNamespace(attributes.getValue(NS_REF));
            Assert.isNotNull((Object)typeId);
            return new AttributeTypeDescriptor(this.fRegistry, typeId, id, nsUri);
        }

        @XMLPath(value="/configuration/types/type/reference#content")
        public void handleReference(Attributes attributes, String content, AttributeTypeDescriptor parent) {
            String emfPath = attributes.getValue(PATH);
            AttributeDescriptor attributeDescriptor = this.fAttributes.get(content);
            Assert.isNotNull((Object)attributeDescriptor, (String)content);
            parent.addAttributeDescriptor(attributeDescriptor, emfPath);
        }

        @XMLPath(value="/configuration/types/type/map")
        public void handleMapping(Attributes attributes, AttributeTypeDescriptor parent) {
            if ("workItem".equals(parent.getAttributeType())) {
                String from = attributes.getValue(FROM);
                String to = attributes.getValue(TO);
                String ns = attributes.getValue(NS_REF);
                Assert.isNotNull((Object)from);
                Assert.isNotNull((Object)to);
                this.fRegistry.setWorkItemIdMapping(from, to, ns == null ? this.fDefaultNs : ns);
            }
        }

        private String getNamespace(String nsPrefix) {
            return this.fRegistry.getNamespace(nsPrefix == null ? this.fDefaultNs : nsPrefix);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttributeTypeDescriptor {
        private final Map<String, IAttributeDescriptor> fAttributeDescriptors = new LinkedHashMap<String, IAttributeDescriptor>();
        private final String fTypeId;
        private final String fId;
        private final String fNsRef;

        private AttributeTypeDescriptor(AttributeRegistry registry, String typeId, String id, String nsRef) {
            Assert.isNotNull((Object)typeId);
            registry.fTypeDescriptors.put(typeId, this);
            this.fTypeId = typeId;
            this.fId = id;
            this.fNsRef = nsRef;
        }

        public String getAttributeType() {
            return this.fTypeId;
        }

        public String getIdentifier() {
            return this.fId == null ? this.fTypeId : this.fId;
        }

        public String getNamespace() {
            return this.fNsRef;
        }

        private void addAttributeDescriptor(AttributeDescriptor descriptor, String referencePath) {
            AttributeDescriptor attribute = new AttributeDescriptor(this.fTypeId, descriptor.getIdentifier(), descriptor.getAttributeType(), descriptor.getDisplayName(), referencePath, descriptor.getNamespace(), descriptor.isReadOnly(), descriptor.isCollection());
            this.fAttributeDescriptors.put(attribute.getIdentifier(), attribute);
        }

        private void addAttributeDescriptor(LinkAttributeDescriptor descriptor) {
            this.fAttributeDescriptors.put(descriptor.getIdentifier(), descriptor);
        }

        public IAttributeDescriptor getAttributeDescriptor(String identifier) {
            return this.fAttributeDescriptors.get(identifier);
        }

        public Collection<IAttributeDescriptor> getAttributeDescriptors() {
            return this.fAttributeDescriptors.values();
        }
    }
}

