/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IDefaultValueProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.Messages;
import com.ibm.team.workitem.common.internal.util.ItemQueryIterator;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomDefaultContributorProvider
implements IDefaultValueProvider<IContributor> {
    @Override
    public IContributor getDefaultValue(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
        IConfiguration value = configuration.getChild("value");
        if (value == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getString("CustomDefaultContributorProvider.CONFIGURED_VALUE_NOT_PRESENT"), (Object)(workItem != null ? Integer.valueOf(workItem.getId()) : Messages.getString("CustomDefaultContributorProvider.NONE_WORK_ITEM")), (Object[])new Object[]{attribute.getDisplayName()}));
        }
        String userId = value.getString("content");
        if (userId == null || "".equals(userId.trim())) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getString("CustomDefaultContributorProvider.CONFIGURED_VALUE_NOT_PRESENT"), (Object)(workItem != null ? Integer.valueOf(workItem.getId()) : Messages.getString("CustomDefaultContributorProvider.NONE_WORK_ITEM")), (Object[])new Object[]{attribute.getDisplayName()}));
        }
        IContributorHandle contributor = null;
        ItemQueryIterator<IContributorHandle> iterator = WorkItemQueries.contributorByUserId(workItemCommon.getAuditableCommon(), userId);
        if (iterator.hasNext(monitor)) {
            contributor = iterator.next(monitor);
        }
        if (contributor == null) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.getString("CustomDefaultContributorProvider.CONTRIBUTOR_NOT_FOUND"), (Object)userId, (Object[])new Object[]{workItem != null ? Integer.valueOf(workItem.getId()) : Messages.getString("CustomDefaultContributorProvider.NONE_WORK_ITEM"), attribute.getDisplayName()}));
        }
        return workItemCommon.getAuditableCommon().resolveAuditable((IAuditableHandle)contributor, ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
    }
}

