/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.workitem.common.internal.attributeValueProviders.FallbackProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.Messages;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.model.AttributeTypes;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class AttributeValueProviderDescriptor {
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String ATTRIBUTE_TYPE = "attributeType";
    private static final String CLASS = "class";
    private static final String ENUMERATION_TYPE = "enumeration";
    private static final String ALL_TYPES = "*";
    private final IConfigurationElement fElement;
    private final String fId;
    private final String fName;
    private final HashSet<String> fAttributeTypes;

    public AttributeValueProviderDescriptor(IConfigurationElement element) {
        this.fElement = element;
        this.fId = this.fElement.getAttribute(ID);
        this.fName = this.fElement.getAttribute(NAME);
        this.fAttributeTypes = new HashSet();
        IConfigurationElement[] iConfigurationElementArray = element.getChildren(ATTRIBUTE_TYPE);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            String id = child.getAttribute(ID);
            if (id != null && id.length() > 0) {
                this.fAttributeTypes.add(id);
            }
            ++n2;
        }
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public Object getProvider() {
        try {
            return this.fElement.createExecutableExtension(CLASS);
        }
        catch (CoreException e) {
            WorkItemCommonPlugin.log(Messages.getString("AttributeValueProviderDescriptor.INSTANTIATION_FAILED"), (Exception)((Object)e));
            return new FallbackProvider();
        }
    }

    public boolean canHandle(String attributeType) {
        if (AttributeTypes.isEnumerationAttributeType(attributeType)) {
            return this.fAttributeTypes.contains(ENUMERATION_TYPE);
        }
        return this.fAttributeTypes.contains(attributeType) || this.fAttributeTypes.contains(ALL_TYPES);
    }
}

