/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorInfo;
import com.ibm.team.process.common.advice.IAdvisorInfoCollector;
import com.ibm.team.process.common.advice.IReportInfo;
import com.ibm.team.process.common.advice.runtime.IOperationAdvisor;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.ISaveParameter;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.Messages;
import com.ibm.team.workitem.common.internal.RequiredPropertiesManager;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IState;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.text.WorkItemTextUtilities;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class RequiredPropertiesAdvisor
implements IOperationAdvisor {
    private static final String REQUIRED_PROPERTIES = "requiredProperties";
    private static final String WORK_ITEM = "workItem";
    private static final String ATTRIBUTE = "attribute";
    private static final String CREATION = "creation";
    private static final String ID_ATTR = "id";
    private static final String UUID_ATTR = "UUID";
    public static final String ID = "com.ibm.team.workitem.advisor.requiredProperties";

    public void run(AdvisableOperation operation, IProcessConfigurationElement advisorConfiguration, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        Object data = operation.getOperationData();
        if (data instanceof ISaveParameter) {
            ISaveParameter saveParameter = (ISaveParameter)data;
            this.addProblems(advisorConfiguration, saveParameter, collector, monitor);
        }
    }

    private void addProblems(IProcessConfigurationElement advisorConfiguration, ISaveParameter saveParameter, IAdvisorInfoCollector collector, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditable auditable = saveParameter.getNewState();
        if (auditable instanceof IWorkItem) {
            IWorkItem workItem;
            IAuditableCommon auditableCommon = saveParameter.getSaveOperationParameter().getAuditableCommon();
            IWorkItemCommon workItemCommon = auditableCommon.getPeer(IWorkItemCommon.class);
            IWorkItemType workItemType = workItemCommon.findWorkItemType((workItem = (IWorkItem)auditable).getProjectArea(), workItem.getWorkItemType(), monitor);
            if (workItemType == null) {
                return;
            }
            List<String> list = RequiredPropertiesManager.readAdvisorConfiguration(workItemType, advisorConfiguration);
            List<Object> workflowProperties = Collections.emptyList();
            String stateId = RequiredPropertiesAdvisor.findTargetStateId(workItem, saveParameter.getWorkflowAction(), workItemCommon, monitor);
            if (stateId != null) {
                workflowProperties = RequiredPropertiesManager.readWorkflowAdvisorConfiguration(workItemType, stateId, advisorConfiguration);
            }
            if (!workflowProperties.isEmpty()) {
                list.addAll(workflowProperties);
            }
            String[] properties = list.toArray(new String[list.size()]);
            int i = 0;
            while (i < properties.length) {
                IAttribute attribute = workItemCommon.findAttribute(workItem.getProjectArea(), properties[i], monitor);
                if (attribute != null && workItem.isAttributeSet(attribute) && this.equals(this.getValue(workItem, attribute), attribute.getNullValue(auditableCommon, monitor))) {
                    TimeZone userTimeZone = saveParameter.getSaveOperationParameter().getUserTimeZone();
                    IAdvisorInfo info = collector.createProblemInfo(this.getSummary(attribute), this.getDescription(workItem, attribute, userTimeZone), ID);
                    info.setProblemObject((Object)workItem.getItemHandle());
                    try {
                        info.setData(this.createData(workItem, attribute));
                    }
                    catch (IOException iOException) {}
                    collector.addInfo((IReportInfo)info);
                }
                ++i;
            }
        }
    }

    public static String findTargetStateId(IWorkItem workItem, String actionId, IWorkItemCommon workItemCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        Identifier<IState> state = workItem.getState2();
        IWorkflowInfo wfInfo = ((WorkItemCommon)workItemCommon).findWorkflowInfo(workItem, monitor);
        if (state == null && actionId == null && wfInfo != null) {
            String string = actionId = wfInfo.getStartActionId() == null ? null : wfInfo.getStartActionId().getStringIdentifier();
        }
        if (wfInfo != null && state != null && !Arrays.asList(wfInfo.getAllStateIds()).contains(state)) {
            String string = actionId = wfInfo.getStartActionId() == null ? null : wfInfo.getStartActionId().getStringIdentifier();
        }
        if (actionId != null && wfInfo != null && (state = wfInfo.getActionResultState(Identifier.create(IWorkflowAction.class, actionId))) == null) {
            String string = actionId = wfInfo.getStartActionId() == null ? null : wfInfo.getStartActionId().getStringIdentifier();
            if (actionId != null) {
                state = wfInfo.getActionResultState(Identifier.create(IWorkflowAction.class, actionId));
            }
        }
        if (state != null) {
            String stateId = state.getStringIdentifier();
            try {
                Integer.parseInt(stateId);
                stateId = "s" + stateId;
            }
            catch (NumberFormatException numberFormatException) {}
            return stateId;
        }
        return null;
    }

    private Object getValue(IWorkItem workItem, IAttribute attribute) {
        Object value = workItem.getValue(attribute);
        if (AttributeTypes.STRING_TYPES.contains(attribute.getAttributeType()) && value instanceof String) {
            value = ((String)value).trim();
        } else if (AttributeTypes.HTML_TYPES.contains(attribute.getAttributeType()) && value instanceof String) {
            value = XMLString.createFromXMLText((String)((String)value)).getPlainText().trim();
        }
        return value;
    }

    private boolean equals(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        if (left instanceof IItemHandle && right instanceof IItemHandle) {
            return ((IItemHandle)left).sameItemId((IItemHandle)right);
        }
        return left.equals(right);
    }

    private String createData(IWorkItem workItem, IAttribute attribute) throws IOException {
        XMLMemento memento = XMLMemento.createWriteRoot((String)REQUIRED_PROPERTIES);
        IMemento wi = memento.createChild(WORK_ITEM);
        if (workItem.isNewItem()) {
            wi.putBoolean(CREATION, true);
        } else {
            wi.putInteger(ID_ATTR, workItem.getId());
        }
        wi.putString(UUID_ATTR, workItem.getItemId().getUuidValue());
        IMemento attr = memento.createChild(ATTRIBUTE);
        attr.putString(UUID_ATTR, attribute.getItemId().getUuidValue());
        attr.putString(ID_ATTR, attribute.getIdentifier());
        return memento.asXMLString();
    }

    private String getSummary(IAttribute attribute) {
        return NLS.bind((String)Messages.getString("RequiredPropertiesAdvisor.ATTRIBUTE_NOT_SET_SUMMARY"), (Object)attribute.getDisplayName(), (Object[])new Object[0]);
    }

    private String getDescription(IWorkItem workItem, IAttribute attribute, TimeZone userTimeZone) {
        return NLS.bind((String)Messages.getString("RequiredPropertiesAdvisor.ATTRIBUTE_NOT_SET_DESCRIPTION"), (Object)attribute.getDisplayName(), (Object[])new Object[]{WorkItemTextUtilities.formatWorkItemId(workItem, userTimeZone)});
    }

    public static UUID getWorkItemItemId(IReportInfo info) throws CoreException {
        String data = info.getData();
        XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(data));
        IMemento work = memento.getChild(WORK_ITEM);
        String uuidValue = work.getString(UUID_ATTR);
        return UUID.valueOf((String)uuidValue);
    }

    public static int getWorkItemId(IReportInfo info) throws CoreException {
        String data = info.getData();
        XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(data));
        IMemento work = memento.getChild(WORK_ITEM);
        return Integer.valueOf(work.getString(ID_ATTR));
    }

    public static boolean isNewItem(IReportInfo info) throws CoreException {
        String data = info.getData();
        XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(data));
        IMemento work = memento.getChild(WORK_ITEM);
        Boolean creation = work.getBoolean(CREATION);
        return creation != null && creation != false;
    }

    public static String getAttributeId(IReportInfo info) throws CoreException {
        String data = info.getData();
        XMLMemento memento = XMLMemento.createReadRoot((Reader)new StringReader(data));
        IMemento attr = memento.getChild(ATTRIBUTE);
        return attr.getString(ID_ATTR);
    }
}

