/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.FeatureMap;

public class PropertyUtil {
    public static Object get(EObject eObject, String property) {
        EStructuralFeature feature = PropertyUtil.getFeature(eObject, property);
        if (feature == null) {
            return new Accessor(eObject, property).get();
        }
        return eObject.eGet(feature);
    }

    public static Object get(IAuditable auditable, String property) {
        return PropertyUtil.get((EObject)auditable, property);
    }

    public static void set(IAuditable auditable, String property, Object value) {
        EObject eObject = (EObject)auditable;
        EStructuralFeature feature = PropertyUtil.getFeature(eObject, property);
        if (feature == null) {
            new Accessor(eObject, property).set(value);
        } else {
            eObject.eSet(feature, value);
        }
    }

    public static void unset(IWorkItem workItem, String property) {
        EObject eObject = (EObject)workItem;
        EStructuralFeature feature = PropertyUtil.getFeature(eObject, property);
        if (feature == null) {
            new Accessor(eObject, property).unset();
        } else {
            eObject.eUnset(feature);
        }
    }

    public static EStructuralFeature getFeature(IAuditable object, String propertyName) {
        return PropertyUtil.getFeature((EObject)object, propertyName);
    }

    public static boolean isContainment(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature instanceof EReference && ((EReference)eStructuralFeature).isContainment() && eStructuralFeature.getEType() != EcorePackage.Literals.ESTRING_TO_STRING_MAP_ENTRY;
    }

    public static EStructuralFeature getFeature(EObject object, String propertyName) {
        EClass eClass = object.eClass();
        EStructuralFeature structuralFeature = eClass.getEStructuralFeature(propertyName);
        return structuralFeature;
    }

    private static class Accessor {
        private static final String DELIMITERS = "/[].";
        private EObject fEObject;
        private EStructuralFeature fFeature;
        private int fIndex;

        public Accessor(EObject eObject, String path) {
            this.fEObject = eObject;
            this.parse(path);
        }

        private void parse(String path) {
            this.fFeature = null;
            this.fIndex = -1;
            StringTokenizer tokenizer = new StringTokenizer(path, DELIMITERS, true);
            while (tokenizer.hasMoreElements()) {
                String indexToken;
                String token = tokenizer.nextToken();
                if ("[".equals(token)) {
                    indexToken = tokenizer.nextToken();
                    int index = Integer.parseInt(indexToken);
                    this.fIndex = index - 1;
                    Assert.isTrue((boolean)"]".equals(tokenizer.nextToken()));
                    continue;
                }
                if ("/".equals(token)) {
                    this.fEObject = (EObject)this.get();
                    continue;
                }
                if (".".equals(token)) {
                    indexToken = tokenizer.nextToken();
                    this.fIndex = Integer.parseInt(indexToken);
                    continue;
                }
                this.fFeature = PropertyUtil.getFeature(this.fEObject, token);
            }
        }

        public Object get() {
            if (this.fFeature == null) {
                return this.fEObject;
            }
            Object value = this.fEObject.eGet(this.fFeature, true);
            if (this.fIndex >= 0 && (value = ((List)value).get(this.fIndex)) instanceof FeatureMap.Entry) {
                value = ((FeatureMap.Entry)value).getValue();
            }
            return value;
        }

        public void set(Object value) {
            if (this.fIndex >= 0) {
                List list = (List)this.fEObject.eGet(this.fFeature, true);
                list.set(this.fIndex, value);
            } else {
                this.fEObject.eSet(this.fFeature, value);
            }
        }

        public void unset() {
            this.fEObject.eUnset(this.fFeature);
        }
    }
}

