/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.expression;

import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.expression.ExpressionVisitor;
import com.ibm.team.workitem.common.expression.ProgressExpressionVisitor;
import com.ibm.team.workitem.common.expression.SerializationException;
import com.ibm.team.workitem.common.internal.expression.IPersistableElement;
import com.ibm.team.workitem.common.internal.expression.ISerializationContext;
import com.ibm.team.workitem.common.internal.expression.IXMLElementKeys;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectClause
implements IXMLElementKeys {
    private IItemType fItemType;
    private ArrayList<String> fColumnIdentifiers = new ArrayList();

    public SelectClause() {
        this(IWorkItem.ITEM_TYPE);
    }

    public SelectClause(IItemType type) {
        this.fItemType = type;
    }

    public IItemType getItemType() {
        return this.fItemType;
    }

    public void init(IPersistableElement query, ISerializationContext context) throws SerializationException {
        IPersistableElement select;
        if (query.hasChild("select") && (select = query.getChild("select")).hasChild("column")) {
            IPersistableElement[] columns;
            IPersistableElement[] iPersistableElementArray = columns = select.getChildren("column");
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                IPersistableElement column = iPersistableElementArray[n2];
                String attributeIdentifier = column.getAttribute("attribute");
                this.fColumnIdentifiers.add(context.getAttribute(attributeIdentifier, ISerializationContext.AttributeContext.COLUMN));
                ++n2;
            }
        }
        this.fItemType = context.getItemType();
    }

    public void saveState(IPersistableElement query) {
        IPersistableElement select = query.createChild("select");
        for (String columnIdentifier : this.fColumnIdentifiers) {
            IPersistableElement column = select.createChild("column");
            column.setAttribute("attribute", columnIdentifier);
        }
    }

    public boolean hasColumns() {
        return this.fColumnIdentifiers.size() > 0;
    }

    public void addColumnIdentifier(String identifier) {
        this.fColumnIdentifiers.add(identifier);
    }

    public void addColumnIdentifiers(List<String> identifiers) {
        this.fColumnIdentifiers.addAll(identifiers);
    }

    public void removeColumnIdentifier(String identifier) {
        this.fColumnIdentifiers.remove(identifier);
    }

    public List<String> getColumnIdentifiers() {
        return Collections.unmodifiableList(this.fColumnIdentifiers);
    }

    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }

    public void accept(ProgressExpressionVisitor visitor, IProgressMonitor monitor) throws TeamRepositoryException {
        visitor.visit(this, monitor);
    }
}

