/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.client.iterator;

import com.ibm.team.build.client.iterator.IBuildResultRecordIterator;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.internal.client.ITeamBuildRecordClient;
import com.ibm.team.build.internal.client.iterator.Messages;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.query.IItemQueryPage;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildResultRecordIterator
implements IBuildResultRecordIterator {
    private IItemQueryPage fQueryPage;
    private Iterator fQueryIterator;
    private ITeamBuildRecordClient fRecordClient;
    private String[] fProperties = IBuildResult.PROPERTIES_COMPLETE;
    protected int fPageSize = 512;

    public BuildResultRecordIterator(ITeamRepository teamRepository, IItemQueryPage queryPage, String[] properties) {
        ValidationHelper.validateNotNull((String)"teamRepository", (Object)teamRepository);
        ValidationHelper.validateNotNull((String)"queryPage", (Object)queryPage);
        ValidationHelper.validateNotNullElements((String)"properties", (Object[])properties);
        this.fRecordClient = (ITeamBuildRecordClient)teamRepository.getClientLibrary(ITeamBuildRecordClient.class);
        this.fProperties = properties;
        this.fQueryPage = queryPage;
        this.fQueryIterator = queryPage.getItemHandles().iterator();
    }

    @Override
    public synchronized boolean hasNext() throws TeamRepositoryException {
        this.updatePosition(null);
        return this.fQueryIterator.hasNext();
    }

    @Override
    public synchronized IBuildResultRecord next(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        if (!progressMonitor.isCanceled()) {
            this.updatePosition(progressMonitor);
            if (this.fQueryIterator.hasNext()) {
                return this.getBuildResultRecord((IItemHandle)this.fQueryIterator.next(), progressMonitor);
            }
            return null;
        }
        throw new OperationCanceledException();
    }

    @Override
    public synchronized IBuildResultRecord[] next(int numRecords, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        if (numRecords > 512) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BuildResultRecordIterator_MAX_RECORD_ITERATION_EXCEEDED, (Object)512));
        }
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        ArrayList<IItemHandle> itemHandles = new ArrayList<IItemHandle>();
        int i = 0;
        while (i < numRecords && !progressMonitor.isCanceled()) {
            this.updatePosition(progressMonitor);
            if (!this.fQueryIterator.hasNext()) break;
            itemHandles.add((IItemHandle)this.fQueryIterator.next());
            ++i;
        }
        if (progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        return this.getBuildResultRecords(itemHandles, progressMonitor);
    }

    @Override
    public int size() {
        return this.fQueryPage.getResultSize();
    }

    private void updatePosition(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        while (!this.fQueryIterator.hasNext() && this.fQueryPage.hasNext()) {
            this.fQueryPage = (IItemQueryPage)this.fRecordClient.fetchPage(this.fQueryPage.getToken(), this.fQueryPage.getNextStartPosition(), this.fPageSize, progressMonitor);
            this.fQueryIterator = this.fQueryPage.getItemHandles().iterator();
        }
    }

    private IBuildResultRecord[] getBuildResultRecords(ArrayList<IItemHandle> itemHandles, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IBuildResultHandle[] resultHandles = new IBuildResultHandle[itemHandles.size()];
        int i = 0;
        while (i < resultHandles.length) {
            resultHandles[i] = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(itemHandles.get(i).getItemId(), null);
            ++i;
        }
        IBuildResultRecord[] records = this.fRecordClient.getBuildResultRecords(resultHandles, this.fProperties, progressMonitor);
        LinkedList<IBuildResultRecord> nonNullRecords = new LinkedList<IBuildResultRecord>();
        IBuildResultRecord[] iBuildResultRecordArray = records;
        int n = records.length;
        int n2 = 0;
        while (n2 < n) {
            IBuildResultRecord buildResultRecord = iBuildResultRecordArray[n2];
            if (buildResultRecord != null) {
                nonNullRecords.add(buildResultRecord);
            }
            ++n2;
        }
        if (records.length == nonNullRecords.size()) {
            return records;
        }
        return nonNullRecords.toArray(new IBuildResultRecord[nonNullRecords.size()]);
    }

    private IBuildResultRecord getBuildResultRecord(IItemHandle itemHandle, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IBuildResultHandle buildResultHandle = (IBuildResultHandle)IBuildResult.ITEM_TYPE.createItemHandle(itemHandle.getItemId(), null);
        return this.fRecordClient.getBuildResultRecord(buildResultHandle, this.fProperties, progressMonitor);
    }
}

