/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.client;

import com.ibm.team.build.internal.client.IBuildDefinitionStatusRecordListener;
import com.ibm.team.build.internal.client.IBuildResultRecordListener;
import com.ibm.team.build.internal.common.model.dto.IBuildDefinitionStatusRecord;
import com.ibm.team.build.internal.common.model.dto.IBuildResultRecord;
import org.eclipse.core.runtime.ListenerList;

public class BuildRecordEventManager {
    private final ListenerList fBuildResultRecordListeners = new ListenerList();
    private final ListenerList fBuildDefinitionStatusRecordListeners = new ListenerList();
    private static BuildRecordEventManager fInstance = new BuildRecordEventManager();

    private BuildRecordEventManager() {
    }

    public static BuildRecordEventManager getInstance() {
        return fInstance;
    }

    public void addListener(IBuildResultRecordListener listener) {
        this.fBuildResultRecordListeners.add((Object)listener);
    }

    public void addListener(IBuildDefinitionStatusRecordListener listener) {
        this.fBuildDefinitionStatusRecordListeners.add((Object)listener);
    }

    public void removeListener(IBuildResultRecordListener listener) {
        this.fBuildResultRecordListeners.remove((Object)listener);
    }

    public void removeListener(IBuildDefinitionStatusRecordListener listener) {
        this.fBuildDefinitionStatusRecordListeners.remove((Object)listener);
    }

    public void notifyRecordsReceived(IBuildResultRecord[] records) {
        Object[] listeners;
        Object[] objectArray = listeners = this.fBuildResultRecordListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            IBuildResultRecordListener listener = (IBuildResultRecordListener)object;
            listener.recordsReceived(records);
            ++n2;
        }
    }

    public void notifyRecordsReceived(IBuildDefinitionStatusRecord[] records) {
        Object[] listeners;
        Object[] objectArray = listeners = this.fBuildDefinitionStatusRecordListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            IBuildDefinitionStatusRecordListener listener = (IBuildDefinitionStatusRecordListener)object;
            listener.recordsReceived(records);
            ++n2;
        }
    }

    public int getBuildDefinitionListenerCount() {
        return this.fBuildDefinitionStatusRecordListeners.size();
    }

    public int getBuildResultListenerCount() {
        return this.fBuildResultRecordListeners.size();
    }
}

