/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.engine;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.engine.Messages;
import java.util.ArrayList;

public class QuotedStringTokenizer {
    private static boolean withinQuotes;

    static {
        new QuotedStringTokenizer();
    }

    private QuotedStringTokenizer() {
    }

    public static String[] getTokens(String string) {
        ValidationHelper.validateNotNull((String)"string", (Object)string);
        ArrayList<String> tokens = new ArrayList<String>();
        char[] chars = new char[string.length()];
        string.getChars(0, string.length(), chars, 0);
        StringBuffer token = new StringBuffer();
        withinQuotes = false;
        int i = 0;
        while (i < chars.length) {
            if (QuotedStringTokenizer.isWhitespaceCharacter(chars[i])) {
                if (withinQuotes) {
                    token.append(chars[i]);
                } else if (token.length() > 0) {
                    tokens.add(token.toString());
                    token = new StringBuffer();
                }
            } else if (QuotedStringTokenizer.isQuotePreceededByBackslash(chars, i)) {
                token.append(chars[i]);
            } else if (!QuotedStringTokenizer.isBackslashFollowedByQuote(chars, i)) {
                if (QuotedStringTokenizer.isQuoteCharacter(chars[i])) {
                    if (withinQuotes) {
                        withinQuotes = false;
                        if (token.length() > 0) {
                            tokens.add(token.toString());
                            token = new StringBuffer();
                        }
                    } else {
                        withinQuotes = true;
                    }
                } else {
                    token.append(chars[i]);
                }
            }
            ++i;
        }
        if (token.length() > 0) {
            tokens.add(token.toString());
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    private static boolean isQuotePreceededByBackslash(char[] characters, int index) {
        if (index > 0 && QuotedStringTokenizer.isQuoteCharacter(characters[index])) {
            return QuotedStringTokenizer.isBackslashCharacter(characters[index - 1]);
        }
        return false;
    }

    private static boolean isBackslashFollowedByQuote(char[] characters, int index) {
        if (characters.length > index + 1 && QuotedStringTokenizer.isBackslashCharacter(characters[index])) {
            return QuotedStringTokenizer.isQuoteCharacter(characters[index + 1]);
        }
        return false;
    }

    private static boolean isQuoteCharacter(char character) {
        String string = new String(new char[]{character});
        return string.equals(Messages.QuotedStringTokenizer_DOUBLE_QUOTE_CHARACTER);
    }

    private static boolean isBackslashCharacter(char character) {
        String string = new String(new char[]{character});
        return string.equals(Messages.QuotedStringTokenizer_BACK_SLASH_CHARACTER);
    }

    private static boolean isWhitespaceCharacter(char character) {
        if (character == ' ') {
            return true;
        }
        if (character == '\t') {
            return true;
        }
        if (character == '\n') {
            return true;
        }
        if (character == '\r') {
            return true;
        }
        return character == '\f';
    }
}

