/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.engine;

import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.internal.engine.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyVariableHelper {
    private static final String VARIABLE_START = "${";
    private static final String VARIABLE_END = "}";

    public static List<String> substituteBuildPropertyVariables(Map<String, String> buildProperties) {
        boolean substitutionsMade = true;
        ArrayList<String> substitutions = new ArrayList<String>();
        while (PropertyVariableHelper.containsAnyVariables(buildProperties.values()) && substitutionsMade) {
            substitutionsMade = false;
            for (Map.Entry<String, String> valueEntry : buildProperties.entrySet()) {
                String originalValue = valueEntry.getValue();
                if (!originalValue.contains(VARIABLE_START)) continue;
                String newValue = originalValue;
                for (Map.Entry<String, String> nameEntry : buildProperties.entrySet()) {
                    if (newValue.contains(PropertyVariableHelper.variableReference(valueEntry.getKey()))) {
                        PropertyVariableHelper.handleCycle(substitutions, valueEntry.getKey(), newValue);
                    }
                    newValue = newValue.replace(PropertyVariableHelper.variableReference(nameEntry.getKey()), nameEntry.getValue());
                }
                if (newValue.equals(originalValue)) continue;
                substitutions.add(NLS.bind((String)Messages.PropertyVariableHelper_SUBSTITUTION, (Object[])new String[]{valueEntry.getKey(), originalValue, valueEntry.getKey(), newValue}));
                substitutionsMade = true;
                valueEntry.setValue(newValue);
            }
        }
        return substitutions;
    }

    public static List<String> substituteConfigurationElementPropertyVariables(List<IBuildConfigurationElement> configElements, Map<String, String> buildProperties) {
        ArrayList<String> substitutions = new ArrayList<String>();
        for (IBuildConfigurationElement element : configElements) {
            if (!element.isVariableSubstitutionAllowed()) continue;
            for (Object object : element.getConfigurationProperties()) {
                IConfigurationProperty configProperty = (IConfigurationProperty)object;
                String originalValue = configProperty.getValue();
                if (!originalValue.contains(VARIABLE_START)) continue;
                for (Map.Entry<String, String> buildProperty : buildProperties.entrySet()) {
                    String newValue = originalValue.replace(PropertyVariableHelper.variableReference(buildProperty.getKey()), buildProperty.getValue());
                    if (!newValue.equals(originalValue)) {
                        substitutions.add(NLS.bind((String)Messages.PropertyVariableHelper_SUBSTITUTION_FOR_ELEMENT, (Object[])new String[]{element.getElementId(), configProperty.getName(), originalValue, configProperty.getName(), newValue}));
                        originalValue = newValue;
                    }
                    configProperty.setValue(newValue);
                }
            }
        }
        return substitutions;
    }

    private static void handleCycle(List<String> substitutions, String propertyName, String propertyValue) {
        StringBuffer message = new StringBuffer();
        message.append(NLS.bind((String)Messages.PropertyVariableHelper_CYCLE, (Object)propertyName, (Object)propertyValue));
        if (!substitutions.isEmpty()) {
            String newline = System.getProperty("line.separator");
            message.append(newline);
            message.append(Messages.PropertyVariableHelper_CYCLE_DESCRIPTION);
            message.append(newline);
            for (String substitution : substitutions) {
                message.append(substitution);
                message.append(newline);
            }
        }
        throw new IllegalArgumentException(message.toString());
    }

    private static String variableReference(String propertyName) {
        return VARIABLE_START + propertyName + VARIABLE_END;
    }

    private static boolean containsAnyVariables(Collection<String> propertyValues) {
        for (String propertyValue : propertyValues) {
            if (!propertyValue.contains(VARIABLE_START)) continue;
            return true;
        }
        return false;
    }
}

