/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.engine;

import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.internal.engine.CommandLineBuildParticipant;
import com.ibm.team.build.internal.engine.InvalidPropertyValueException;
import com.ibm.team.build.internal.engine.Messages;
import com.ibm.team.build.internal.engine.MissingPropertyException;
import com.ibm.team.build.internal.engine.QuotedStringTokenizer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenBuildParticipant
extends CommandLineBuildParticipant {
    private static final String MAVEN_LAUNCHER_CLASS = "org.codehaus.classworlds.Launcher";
    private static final String MAVEN_BOOT_DIRECTORY = "boot";
    private static final String MAVEN_CONF_FILE = "bin/m2.conf";
    private static final String JAVA_BIN_DIR = "bin";
    private static final String JAVA_EXE_NAME = "java";
    private static final String JAVA_EXE_NAME_WINDOWS = "java.exe";
    private static final String CLASSPATH_ARG = "-classpath";

    @Override
    protected List<String> getCommandLine(IBuildRequest buildRequest) throws Exception {
        ArrayList<String> commandLine = new ArrayList<String>();
        File mavenHome = this.getMavenHome(buildRequest);
        commandLine.add(this.getJavaCommand(buildRequest));
        commandLine.add(CLASSPATH_ARG);
        commandLine.add(this.getClassPath(buildRequest, mavenHome));
        commandLine.addAll(this.getVmArgs(buildRequest, mavenHome));
        commandLine.add(MAVEN_LAUNCHER_CLASS);
        commandLine.addAll(this.getMavenGoals(buildRequest));
        return commandLine;
    }

    @Override
    protected String getPropertiesFileFromProperty(IBuildRequest buildRequest) {
        String propertiesFile = null;
        IBuildConfigurationElement element = buildRequest.getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.maven");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.maven.propertiesFile");
        if (property != null && property.getValue().trim().length() > 0) {
            propertiesFile = this.convertToPlatformSeparator(property.getValue().trim());
        }
        return propertiesFile;
    }

    protected String getClassPath(IBuildRequest buildRequest, File mavenHome) {
        StringBuffer buffer = new StringBuffer();
        File bootDirectory = new File(mavenHome, MAVEN_BOOT_DIRECTORY);
        if (bootDirectory.isDirectory()) {
            File[] listFiles = bootDirectory.listFiles();
            int i = 0;
            while (i < listFiles.length) {
                File file = listFiles[i];
                if (file.getName().toLowerCase().endsWith(".jar")) {
                    if (i > 0) {
                        buffer.append(File.pathSeparatorChar);
                    }
                    buffer.append(file.getAbsolutePath());
                }
                ++i;
            }
        }
        return buffer.toString();
    }

    @Override
    protected File getWorkingDirectory(IBuildRequest buildRequest) throws Exception {
        return this.getProjectLocation(buildRequest);
    }

    @Override
    protected void validateProperties(IBuildRequest buildRequest) throws Exception {
        this.validateProjectLocation(buildRequest);
        this.validateMavenHome(buildRequest);
        this.validateMavenArgs(buildRequest);
        this.validateJavaHome(buildRequest);
        this.validateWorkingDir(buildRequest);
    }

    private void validateMavenArgs(IBuildRequest buildRequest) throws Exception {
        this.getMavenGoals(buildRequest);
    }

    private void validateProjectLocation(IBuildRequest buildRequest) throws InvalidPropertyValueException, MissingPropertyException, IOException {
        this.getProjectLocation(buildRequest);
    }

    private File getMavenHome(IBuildRequest buildRequest) throws Exception {
        IBuildConfigurationElement element = buildRequest.getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.maven");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.maven.mavenHome");
        if (property == null) {
            throw new MissingPropertyException(NLS.bind((String)Messages.MavenBuildParticipant_MISSING_PROPERTY, (Object)"com.ibm.team.build.maven.mavenHome", (Object)"com.ibm.team.build.maven"));
        }
        String homePropertyValue = property.getValue();
        File mavenHome = new File(this.convertToPlatformSeparator(homePropertyValue));
        if (!mavenHome.exists()) {
            throw new InvalidPropertyValueException(NLS.bind((String)Messages.MavenBuildParticipant_MISSING_LOCATION, (Object)mavenHome.getAbsolutePath(), (Object)"com.ibm.team.build.maven.mavenHome"));
        }
        return mavenHome;
    }

    private void validateMavenHome(IBuildRequest buildRequest) throws Exception {
        this.getMavenHome(buildRequest);
    }

    private File getJavaHome(IBuildRequest buildRequest) throws InvalidPropertyValueException, IOException {
        IBuildConfigurationElement element = buildRequest.getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.maven");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.maven.javaHome");
        File javaHomeFile = new File(System.getProperty("java.home"));
        if (property != null && property.getValue().trim().length() > 0) {
            javaHomeFile = new File(this.convertToPlatformSeparator(property.getValue()));
            if (!javaHomeFile.exists()) {
                throw new InvalidPropertyValueException(NLS.bind((String)Messages.MavenBuildParticipant_MISSING_LOCATION, (Object)javaHomeFile.getCanonicalPath(), (Object)"com.ibm.team.build.maven.javaHome"));
            }
            File javaExecutableFile = new File(javaHomeFile, this.getJavaExecutableRelativePath());
            if (!javaExecutableFile.exists()) {
                throw new InvalidPropertyValueException(NLS.bind((String)Messages.MavenBuildParticipant_MISSING_LOCATION_CONTENTS, (Object[])new String[]{javaHomeFile.getCanonicalPath(), "com.ibm.team.build.maven.javaHome", javaExecutableFile.getCanonicalPath()}));
            }
        }
        return javaHomeFile;
    }

    private void validateJavaHome(IBuildRequest buildRequest) throws InvalidPropertyValueException, IOException {
        this.getJavaHome(buildRequest);
    }

    protected String getJavaExecutableName() {
        String os = System.getProperty("os.name");
        if (os.toLowerCase().indexOf("windows") >= 0) {
            return JAVA_EXE_NAME_WINDOWS;
        }
        return JAVA_EXE_NAME;
    }

    protected List<String> getMavenGoals(IBuildRequest buildRequest) throws Exception {
        ArrayList<String> goals = new ArrayList<String>();
        String userArgs = this.getProperty(buildRequest, "com.ibm.team.build.maven.mavenGoals");
        if (userArgs.trim().length() > 0) {
            String[] tokens = QuotedStringTokenizer.getTokens(userArgs);
            int i = 0;
            while (i < tokens.length) {
                goals.add(tokens[i]);
                ++i;
            }
        }
        return goals;
    }

    private List<String> getVmArgs(IBuildRequest buildRequest, File mavenHome) {
        ArrayList<String> vmArgs = new ArrayList<String>();
        File confFile = new File(mavenHome, MAVEN_CONF_FILE);
        if (confFile.exists()) {
            vmArgs.add("-Dclassworlds.conf=" + confFile.getAbsolutePath());
        }
        vmArgs.add("-Dmaven.home=" + mavenHome.getAbsolutePath());
        String args = this.getProperty(buildRequest, "com.ibm.team.build.maven.javaVMArgs");
        if (args.trim().length() > 0) {
            String[] tokens = QuotedStringTokenizer.getTokens(args);
            int i = 0;
            while (i < tokens.length) {
                vmArgs.add(tokens[i]);
                ++i;
            }
        }
        return vmArgs;
    }

    private String getJavaCommand(IBuildRequest buildRequest) throws InvalidPropertyValueException, IOException {
        return new File(this.getJavaHome(buildRequest), this.getJavaExecutableRelativePath()).getCanonicalPath();
    }

    private String getProperty(IBuildRequest buildRequest, String propertyName) {
        IBuildConfigurationElement element = buildRequest.getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.maven");
        IConfigurationProperty property = element.getConfigurationProperty(propertyName);
        if (property == null) {
            return "";
        }
        return property.getValue();
    }

    private File getProjectLocation(IBuildRequest buildRequest) throws InvalidPropertyValueException, MissingPropertyException, IOException {
        IBuildConfigurationElement element = buildRequest.getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.maven");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.maven.projectLocation");
        if (property == null) {
            throw new MissingPropertyException(NLS.bind((String)Messages.MavenBuildParticipant_MISSING_PROPERTY, (Object)"com.ibm.team.build.maven.projectLocation", (Object)"com.ibm.team.build.maven"));
        }
        String projectLocation = property.getValue();
        File file = new File(this.convertToPlatformSeparator(projectLocation));
        if (!file.exists()) {
            throw new InvalidPropertyValueException(NLS.bind((String)Messages.MavenBuildParticipant_MISSING_LOCATION, (Object)file.getCanonicalPath(), (Object)"com.ibm.team.build.maven.projectLocation"));
        }
        return file;
    }

    protected String getJavaExecutableRelativePath() {
        return JAVA_BIN_DIR + File.separator + this.getJavaExecutableName();
    }

    private String convertToPlatformSeparator(String input) {
        String converted = null;
        if (input != null) {
            converted = input.replace("/", File.separator);
            converted = converted.replace("\\", File.separator);
        }
        return converted;
    }
}

