/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.engine;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.engine.AbstractPostBuildParticipant;
import com.ibm.team.build.internal.engine.Messages;
import com.ibm.team.build.internal.publishing.JdtCompileLogPublisher;
import com.ibm.team.repository.common.IItemHandle;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class JdtPublishingPostBuildParticipant
extends AbstractPostBuildParticipant {
    public BuildStatus postBuild(IProgressMonitor monitor) throws Exception {
        String fileOrDirectory;
        IConfigurationProperty property;
        IBuildResult result = (IBuildResult)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)this.getBuildRequest().getBuildResult(), 1, monitor);
        IBuildConfigurationElement element = this.getBuildRequest().getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.jdt.publishing");
        if (element != null && (property = element.getConfigurationProperty("com.ibm.team.build.jdt.publishing.log")) != null && (fileOrDirectory = property.getValue()) != null && fileOrDirectory.length() > 0) {
            File file = new File(fileOrDirectory);
            if (file.exists()) {
                JdtCompileLogPublisher publisher = new JdtCompileLogPublisher();
                Collection contributions = publisher.publish(result, file.getAbsolutePath(), this.getTeamRepository(), monitor);
                if (file.isDirectory()) {
                    this.getBuildLog().println(NLS.bind((String)Messages.JdtPublishingPostBuildParticipant_PUBLISHED_DIRECTORY, (Object)contributions.size(), (Object)file.getAbsolutePath()));
                } else {
                    this.getBuildLog().println(NLS.bind((String)Messages.JdtPublishingPostBuildParticipant_PUBLISHED_FILE, (Object)contributions.size(), (Object)file.getAbsolutePath()));
                }
            } else {
                throw new IOException(NLS.bind((String)Messages.JdtPublishingPostBuildParticipant_NOT_FOUND, (Object)file.getAbsolutePath()));
            }
        }
        return BuildStatus.OK;
    }
}

