/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.engine;

import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.BuildItemFactory;
import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinitionInstance;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultContribution;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.engine.AbstractPreBuildParticipant;
import com.ibm.team.build.internal.engine.Messages;
import com.ibm.team.build.internal.publishing.WorkItemPublisher;
import com.ibm.team.build.internal.scm.AcceptReport;
import com.ibm.team.build.internal.scm.ComponentLoadRules;
import com.ibm.team.build.internal.scm.LoadComponents;
import com.ibm.team.build.internal.scm.SourceControlUtility;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.IWorkspaceHandle;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class JazzScmPreBuildParticipant
extends AbstractPreBuildParticipant {
    public static final String SNAPSHOT_UUID_PROPERTY_KEY = "team.scm.snapshotUUID";
    private static final boolean RENAME_BEFORE_DELETE = Boolean.parseBoolean(System.getProperty("team.scm.renameBeforeDelete", "false"));

    public boolean shouldBuild(IProgressMonitor monitor) throws Exception {
        IBuildProperty property = this.getBuildRequest().getBuildDefinitionInstance().getProperty("team.scm.buildOnlyIfChanges");
        if (property != null && property.getValue().equals("true") && (property = this.getBuildRequest().getBuildDefinitionInstance().getProperty("team.scm.workspaceUUID")) != null && property.getValue().length() > 0) {
            IWorkspace workspace = this.getWorkspace(property.getValue(), this.getTeamRepository(), monitor);
            this.getBuildLog().print(NLS.bind((String)Messages.JazzScmPreBuildParticipant_CHECKING_FOR_CHANGES, (Object)workspace.getName()));
            AcceptReport report = SourceControlUtility.checkForIncoming((ITeamRepository)this.getTeamRepository(), (IWorkspaceHandle)workspace, (IProgressMonitor)monitor);
            int changes = report.getAcceptChangeSets().length;
            changes += report.getDiscardChangeSets().length;
            changes += report.getComponentAdds().length;
            if ((changes += report.getComponentRemovals().length) > 0) {
                this.getBuildLog().println(NLS.bind((String)Messages.JazzScmPreBuildParticipant_FOUND_CHANGES, (Object)changes));
            } else {
                this.getBuildLog().println(Messages.JazzScmPreBuildParticipant_NO_CHANGES);
            }
            return changes > 0;
        }
        return true;
    }

    public BuildStatus preBuild(IProgressMonitor monitor) throws Exception {
        IBuildResult result = (IBuildResult)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)this.getBuildRequest().getBuildResult(), 1, monitor);
        ITeamBuildClient buildClient = (ITeamBuildClient)this.getTeamRepository().getClientLibrary(ITeamBuildClient.class);
        IBuildConfigurationElement element = this.getBuildRequest().getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.jazzscm");
        if (element != null) {
            String workspaceUuid = this.getWorkspaceUuid(this.getBuildRequest().getBuildDefinitionInstance());
            String fetchDestination = this.getFetchDestination(this.getBuildRequest().getBuildDefinitionInstance());
            String componentLoadRuleUuids = this.getComponentLoadRuleUuids(this.getBuildRequest().getBuildDefinitionInstance());
            boolean includeComponents = this.getIncludeComponents(this.getBuildRequest().getBuildDefinitionInstance());
            String componentUuids = this.getLoadComponentUuids(this.getBuildRequest().getBuildDefinitionInstance());
            if (workspaceUuid == null) {
                return BuildStatus.OK;
            }
            if (fetchDestination == null) {
                return BuildStatus.OK;
            }
            File fetchDestinationFile = new File(fetchDestination);
            IWorkspace workspace = this.getWorkspace(workspaceUuid, this.getTeamRepository(), monitor);
            String parentActivityId = buildClient.startBuildActivity((IBuildResultHandle)result, Messages.JazzScmPreBuildParticipant_PRE_BUILD_ACTIVITY, null, false, monitor);
            try {
                boolean deleteBeforeFetch;
                FileSystemCore.startUp();
                IWorkspaceConnection workspaceConnection = SCMPlatform.getWorkspaceManager((ITeamRepository)this.getTeamRepository()).getWorkspaceConnection((IWorkspaceHandle)workspace, monitor);
                boolean synchronizeLoad = false;
                boolean acceptBeforeFetch = this.getAcceptBeforeFetch(this.getBuildRequest().getBuildDefinitionInstance());
                if (!result.isPersonalBuild() && acceptBeforeFetch) {
                    this.getBuildLog().println(NLS.bind((String)Messages.JazzScmPreBuildParticipant_ACCEPTING, (Object)workspace.getName()));
                    buildClient.startBuildActivity((IBuildResultHandle)result, Messages.JazzScmPreBuildParticipant_ACTIVITY_ACCEPTING_CHANGES, parentActivityId, true, monitor);
                    String snapshotName = String.valueOf(this.getBuildRequest().getBuildDefinitionInstance().getBuildDefinitionId()) + "_" + result.getLabel();
                    this.performAccept(workspace, snapshotName, (IBuildResultHandle)result, this.getTeamRepository(), monitor);
                    synchronizeLoad = true;
                }
                if (deleteBeforeFetch = this.getDeleteBeforeFetch(this.getBuildRequest().getBuildDefinitionInstance())) {
                    boolean deleteSucceeded;
                    this.getBuildLog().println(NLS.bind((String)Messages.JazzScmPreBuildParticipant_DELETING_DESTINATION, (Object)fetchDestinationFile.getCanonicalPath()));
                    File toDelete = fetchDestinationFile;
                    if (RENAME_BEFORE_DELETE) {
                        String alternateName = String.valueOf(toDelete.getName()) + "." + System.currentTimeMillis();
                        File renamedFile = new File(toDelete.getParentFile(), alternateName);
                        if (toDelete.renameTo(renamedFile)) {
                            toDelete = renamedFile;
                        } else {
                            this.getBuildLog().println(NLS.bind((String)"Could not rename '{0}' to '{1}'.  Proceeding with delete using old name.", (Object)toDelete, (Object)renamedFile));
                        }
                    }
                    if (!(deleteSucceeded = this.delete(toDelete, monitor)) || fetchDestinationFile.exists()) {
                        throw new TeamBuildException(NLS.bind((String)Messages.CommandLineBuildParticipant_UNABLE_TO_DELETE, (Object)fetchDestinationFile.getCanonicalPath()));
                    }
                }
                this.getBuildLog().println(NLS.bind((String)Messages.JazzScmPreBuildParticipant_FETCHING, (Object)fetchDestinationFile.getCanonicalPath()));
                buildClient.startBuildActivity((IBuildResultHandle)result, Messages.JazzScmPreBuildParticipant_ACTIVITY_FETCHING, parentActivityId, true, monitor);
                Collection loadRules = new ComponentLoadRules(componentLoadRuleUuids).getLoadRules(this.getTeamRepository(), workspace, monitor);
                Collection components = new LoadComponents(this.getTeamRepository(), componentUuids).getComponentHandles();
                SourceControlUtility.updateFileCopyArea((IWorkspaceConnection)workspaceConnection, (String)fetchDestinationFile.getCanonicalPath(), (boolean)includeComponents, (Collection)components, (boolean)synchronizeLoad, (Collection)loadRules, (IProgressMonitor)monitor);
                this.addWorkspaceContribution(workspace, (IBuildResultHandle)result, this.getTeamRepository(), monitor);
            }
            finally {
                FileSystemCore.shutDown();
                buildClient.completeBuildActivity((IBuildResultHandle)result, parentActivityId, monitor);
            }
        }
        return BuildStatus.OK;
    }

    private IWorkspace getWorkspace(String uuid, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        UUID workspaceUuid = null;
        try {
            workspaceUuid = UUID.valueOf((String)uuid);
        }
        catch (IllegalArgumentException exception) {
            throw new TeamBuildException(NLS.bind((String)Messages.CommandLineBuildParticipant_INVALID_UUID, (Object)uuid), (Throwable)exception);
        }
        IItem item = null;
        IWorkspaceHandle workspaceHandle = (IWorkspaceHandle)IWorkspace.ITEM_TYPE.createItemHandle(workspaceUuid, null);
        try {
            item = this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)workspaceHandle, 1, monitor);
        }
        catch (ItemNotFoundException exception) {
            throw new TeamBuildException(NLS.bind((String)Messages.CommandLineBuildParticipant_WORKSPACE_NOT_FOUND, (Object)uuid), (Throwable)exception);
        }
        catch (PermissionDeniedException permissionDeniedException) {
            throw new TeamBuildException(NLS.bind((String)Messages.JazzScmPreBuildParticipant_WORKSPACE_PERMISSION_DENIED, (Object)this.getTeamRepository().getUserId(), (Object)uuid));
        }
        if (!(item instanceof IWorkspaceHandle)) {
            throw new TeamBuildException(NLS.bind((String)Messages.CommandLineBuildParticipant_NOT_A_WORKSPACE, (Object)uuid, (Object)item.getItemType().getName()));
        }
        return (IWorkspace)item;
    }

    protected boolean delete(File file, IProgressMonitor monitor) throws Exception {
        return this.deleteUsingJavaIO(file, monitor);
    }

    private boolean deleteUsingJavaIO(File file, IProgressMonitor monitor) {
        if (file.delete() || !file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            File[] children;
            File[] fileArray = children = file.listFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                this.deleteUsingJavaIO(child, monitor);
                ++n2;
            }
        }
        return file.delete();
    }

    private void performAccept(IWorkspace workspace, String snapshotName, IBuildResultHandle resultHandle, ITeamRepository teamRepository, IProgressMonitor monitor) throws TeamRepositoryException {
        AcceptReport acceptReport = SourceControlUtility.acceptAllIncoming((ITeamRepository)teamRepository, (IWorkspaceHandle)workspace, (String)snapshotName, (IProgressMonitor)monitor);
        IChangeSetHandle[] changeSetHandles = acceptReport.getAcceptChangeSets();
        IBaselineSet snapshot = acceptReport.getSnapshot();
        if (snapshot != null) {
            this.getBuildProperties().put(SNAPSHOT_UUID_PROPERTY_KEY, snapshot.getItemId().getUuidValue());
            this.addSnapshotContribution(snapshot, resultHandle, teamRepository, monitor);
        }
        WorkItemPublisher workItemPublisher = new WorkItemPublisher();
        workItemPublisher.publish(resultHandle, changeSetHandles, teamRepository);
    }

    private void addWorkspaceContribution(IWorkspace workspace, IBuildResultHandle resultHandle, ITeamRepository teamRepository, IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
        contribution.setExtendedContributionTypeId("buildWorkspace");
        contribution.setImpactsPrimaryResult(false);
        contribution.setLabel(workspace.getName());
        contribution.setExtendedContribution((IItemHandle)workspace);
        ITeamBuildClient client = (ITeamBuildClient)this.getTeamRepository().getClientLibrary(ITeamBuildClient.class);
        client.addBuildResultContribution(resultHandle, contribution, monitor);
    }

    private void addSnapshotContribution(IBaselineSet snapshot, IBuildResultHandle resultHandle, ITeamRepository teamRepository, IProgressMonitor monitor) throws IllegalArgumentException, TeamRepositoryException {
        IBuildResultContribution contribution = BuildItemFactory.createBuildResultContribution();
        contribution.setExtendedContributionTypeId("buildSnapshot");
        contribution.setImpactsPrimaryResult(false);
        contribution.setLabel(NLS.bind((String)Messages.CommandLineBuildParticipant_SNAPSHOT_LABEL, (Object)snapshot.getName()));
        contribution.setExtendedContribution((IItemHandle)snapshot);
        ITeamBuildClient client = (ITeamBuildClient)this.getTeamRepository().getClientLibrary(ITeamBuildClient.class);
        client.addBuildResultContribution(resultHandle, contribution, monitor);
    }

    private String getWorkspaceUuid(IBuildDefinitionInstance instance) {
        IBuildProperty property = instance.getProperty("team.scm.workspaceUUID");
        if (property != null && property.getValue().length() > 0) {
            return property.getValue();
        }
        return null;
    }

    private String getComponentLoadRuleUuids(IBuildDefinitionInstance instance) {
        IBuildProperty property = instance.getProperty("team.scm.componentLoadRules");
        if (property != null && property.getValue().length() > 0) {
            return property.getValue();
        }
        return null;
    }

    protected String getFetchDestination(IBuildDefinitionInstance instance) throws IOException {
        IBuildProperty property = instance.getProperty("team.scm.fetchDestination");
        if (property != null && property.getValue().length() > 0) {
            return this.convertToPlatformSeparator(property.getValue());
        }
        File currentDirectory = new File(System.getProperty("user.dir"));
        return currentDirectory.getCanonicalPath();
    }

    private boolean getAcceptBeforeFetch(IBuildDefinitionInstance instance) {
        IBuildProperty property = instance.getProperty("team.scm.acceptBeforeFetch");
        if (property != null && property.getValue().length() > 0) {
            return Boolean.valueOf(property.getValue());
        }
        return false;
    }

    private boolean getIncludeComponents(IBuildDefinitionInstance instance) {
        IBuildProperty property = instance.getProperty("team.scm.includeComponents");
        if (property != null && property.getValue().length() > 0) {
            return Boolean.valueOf(property.getValue());
        }
        return false;
    }

    private String getLoadComponentUuids(IBuildDefinitionInstance instance) {
        IBuildProperty property = instance.getProperty("team.scm.loadComponents");
        if (property != null && property.getValue().length() > 0) {
            return property.getValue();
        }
        return null;
    }

    private boolean getDeleteBeforeFetch(IBuildDefinitionInstance instance) {
        IBuildProperty property = instance.getProperty("team.scm.deleteDestinationBeforeFetch");
        if (property != null && property.getValue().length() > 0) {
            return Boolean.valueOf(property.getValue());
        }
        return false;
    }

    private String convertToPlatformSeparator(String input) {
        String converted = null;
        if (input != null) {
            converted = input.replace("/", File.separator);
            converted = converted.replace("\\", File.separator);
        }
        return converted;
    }
}

