/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.engine;

import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.engine.AbstractPostBuildParticipant;
import com.ibm.team.build.internal.engine.Messages;
import com.ibm.team.build.internal.publishing.JUnitLogPublisher;
import com.ibm.team.repository.common.IItemHandle;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

public class JUnitPublishingPostBuildParticipant
extends AbstractPostBuildParticipant {
    public BuildStatus postBuild(IProgressMonitor monitor) throws Exception {
        String fileOrDirectory;
        IConfigurationProperty property;
        IBuildResult result = (IBuildResult)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)this.getBuildRequest().getBuildResult(), 1, monitor);
        IBuildConfigurationElement element = this.getBuildRequest().getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.junit.publishing");
        if (element != null && (property = element.getConfigurationProperty("com.ibm.team.build.junit.publishing.log")) != null && (fileOrDirectory = property.getValue()) != null && fileOrDirectory.length() > 0) {
            File file = new File(fileOrDirectory);
            if (file.exists()) {
                JUnitLogPublisher publisher = new JUnitLogPublisher();
                String[] warnings = publisher.publish(result, fileOrDirectory, null, this.getTeamRepository(), monitor);
                if (file.isDirectory()) {
                    this.getBuildLog().println(NLS.bind((String)Messages.JUnitPostBuildParticipant_PUBLISHED_DIRECTORY, (Object)file.getAbsolutePath()));
                } else {
                    this.getBuildLog().println(NLS.bind((String)Messages.JUnitPostBuildParticipant_PUBLISHED_LOG, (Object)file.getAbsolutePath()));
                }
                if (warnings.length > 0) {
                    this.getBuildLog().println(NLS.bind((String)Messages.JUnitPostBuildParticipant_WARNINGS, (Object)warnings.length));
                    String[] stringArray = warnings;
                    int n = warnings.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String warning = stringArray[n2];
                        this.getBuildLog().println("\t" + warning);
                        ++n2;
                    }
                }
            } else {
                throw new IOException(NLS.bind((String)Messages.JUnitPostBuildParticipant_NOT_FOUND, (Object)file.getAbsolutePath()));
            }
        }
        return BuildStatus.OK;
    }
}

