/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.engine;

import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.engine.IllegalCommandLineException;
import com.ibm.team.build.internal.engine.Messages;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;

public class CommandLineParser {
    public static final String ID_UUID_MUTUALLY_EXCLUSIVE_MSG = NLS.bind((String)Messages.CommandLineParser_X_AND_Y_ARE_MUTUALLY_EXCLUSIVE, (Object)"-engineId", (Object[])new Object[]{"-engineUUID"});
    private static final long DEFAULT_SLEEP_TIME_SECONDS = 30L;
    private static final String DEFAULT_PASSWORD = "";
    private String fRepository;
    private String fUserId;
    private String fEngineId;
    private String fEngineUUID;
    private String fPassword;
    private long fSleepTime = -1L;
    private File fLogFile;
    private boolean fVerbose;
    private File fPasswordFile;
    private File fCreatePasswordFile;

    public CommandLineParser(String[] args) throws IllegalCommandLineException, IllegalArgumentException {
        this.parseArguments(args);
        this.validateArguments();
    }

    public static String getUsageMessage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(System.getProperty("line.separator"));
        buffer.append(NLS.bind((String)Messages.CommandLineParser_USAGE_EXAMPLE, (Object)"-repository", (Object[])new Object[]{"-userId"}));
        buffer.append(System.getProperty("line.separator"));
        buffer.append(System.getProperty("line.separator"));
        buffer.append(Messages.CommandLineParser_USAGE_REQUIRED);
        buffer.append(System.getProperty("line.separator"));
        buffer.append(NLS.bind((String)Messages.CommandLineParser_USAGE_REQUIRED_REPOSITORY, (Object)"-repository", (Object[])new Object[0]));
        buffer.append(System.getProperty("line.separator"));
        buffer.append(NLS.bind((String)Messages.CommandLineParser_USAGE_REQUIRED_USER, (Object)"-userId", (Object[])new Object[0]));
        buffer.append(System.getProperty("line.separator"));
        buffer.append(System.getProperty("line.separator"));
        buffer.append(Messages.CommandLineParser_USAGE_OPTIONAL);
        buffer.append(System.getProperty("line.separator"));
        buffer.append(NLS.bind((String)Messages.CommandLineParser_USAGE_OPTIONAL_ENGINE, (Object)"-engineId", (Object[])new Object[]{IBuildEngine.DEFAULT_ENGINE_ID}));
        buffer.append(System.getProperty("line.separator"));
        buffer.append(NLS.bind((String)Messages.CommandLineParser_USAGE_OPTIONAL_PASSWORD, (Object)"-pass", (Object[])new Object[0]));
        buffer.append(System.getProperty("line.separator"));
        buffer.append(NLS.bind((String)Messages.CommandLineParser_USAGE_OPTIONAL_PASSWORD_FILE, (Object)"-passwordFile", (Object[])new Object[]{"-createPasswordFile"}));
        buffer.append(System.getProperty("line.separator"));
        buffer.append(NLS.bind((String)Messages.CommandLineParser_USAGE_OPTIONAL_CREATE_PASSWORD_FILE, (Object)"-createPasswordFile", (Object[])new Object[0]));
        buffer.append(System.getProperty("line.separator"));
        buffer.append(NLS.bind((String)Messages.CommandLineParser_USAGE_OPTIONAL_SLEEPTIME, (Object)"-sleepTime", (Object[])new Object[0]));
        buffer.append(System.getProperty("line.separator"));
        buffer.append(NLS.bind((String)Messages.CommandLineParser_USAGE_OPTIONAL_VERBOSE, (Object)"-verbose", (Object[])new Object[0]));
        buffer.append(System.getProperty("line.separator"));
        buffer.append(System.getProperty("line.separator"));
        return buffer.toString();
    }

    public String getEngineId() {
        if (this.fEngineId == null) {
            return IBuildEngine.DEFAULT_ENGINE_ID;
        }
        return this.fEngineId;
    }

    public String getEngineUUID() {
        return this.fEngineUUID;
    }

    public String getUserId() {
        return this.fUserId;
    }

    public String getPassword() {
        if (this.fPassword == null) {
            return DEFAULT_PASSWORD;
        }
        return this.fPassword;
    }

    public String getRepository() {
        return this.fRepository;
    }

    public long getSleepTime() {
        if (this.fSleepTime == -1L) {
            return 30L;
        }
        return this.fSleepTime;
    }

    public File getLogFile() {
        return this.fLogFile;
    }

    public File getPasswordFile() {
        return this.fPasswordFile;
    }

    public File getCreatePasswordFile() {
        return this.fCreatePasswordFile;
    }

    public boolean getVerbose() {
        return this.fVerbose;
    }

    private void parseArguments(String[] args) throws IllegalCommandLineException, IllegalArgumentException {
        ValidationHelper.validateNotNull((String)"args", (Object[])args);
        ValidationHelper.validateNotNullElements((String)"args", (Object[])args);
        int i = 0;
        while (i < args.length) {
            String argumentName = args[i];
            if (argumentName.equalsIgnoreCase("-repository")) {
                if (args.length > i + 1) {
                    this.fRepository = args[i + 1];
                    ++i;
                }
            } else if (argumentName.equalsIgnoreCase("-userId")) {
                if (args.length > i + 1) {
                    this.fUserId = args[i + 1];
                    ++i;
                }
            } else if (argumentName.equalsIgnoreCase("-pass")) {
                if (args.length > i + 1) {
                    this.fPassword = args[i + 1];
                    ++i;
                }
            } else if (argumentName.equalsIgnoreCase("-engineId")) {
                if (args.length > i + 1) {
                    this.fEngineId = args[i + 1];
                    ++i;
                }
            } else if (argumentName.equalsIgnoreCase("-engineUUID")) {
                if (args.length > i + 1) {
                    this.fEngineUUID = args[i + 1];
                    ++i;
                }
            } else if (argumentName.equalsIgnoreCase("-logFile")) {
                if (args.length > i + 1) {
                    this.fLogFile = new File(args[i + 1]);
                    ++i;
                }
            } else if (argumentName.equalsIgnoreCase("-passwordFile")) {
                if (args.length > i + 1) {
                    this.fPasswordFile = new File(args[i + 1]);
                    ++i;
                }
            } else if (argumentName.equalsIgnoreCase("-createPasswordFile")) {
                if (args.length > i + 1) {
                    this.fCreatePasswordFile = new File(args[i + 1]);
                    ++i;
                }
            } else if (argumentName.equalsIgnoreCase("-sleepTime")) {
                if (args.length > i + 1) {
                    try {
                        this.fSleepTime = Long.parseLong(args[i + 1]);
                        ++i;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IllegalCommandLineException(NLS.bind((String)Messages.CommandLineParser_INVALID_ARGUMENT, (Object)"-sleepTime", (Object[])new Object[]{args[i + 1]}));
                    }
                }
            } else if (argumentName.equalsIgnoreCase("-verbose")) {
                this.fVerbose = true;
            }
            ++i;
        }
    }

    private void validateArguments() throws IllegalCommandLineException {
        if (this.fCreatePasswordFile != null) {
            if (this.fEngineId != null || this.fLogFile != null || this.fPasswordFile != null || this.fPassword != null || this.fSleepTime != -1L || this.fRepository != null || this.fUserId != null) {
                throw new IllegalCommandLineException(NLS.bind((String)Messages.CommandLineParser_USAGE_CREATE_ONLY, (Object)"-createPasswordFile", (Object[])new Object[0]));
            }
            return;
        }
        if (this.fEngineUUID != null && this.fEngineId != null) {
            throw new IllegalCommandLineException(ID_UUID_MUTUALLY_EXCLUSIVE_MSG);
        }
        if (this.fRepository == null) {
            throw new IllegalCommandLineException(NLS.bind((String)Messages.CommandLineParser_MISSING_ARGUMENT, (Object)"-repository", (Object[])new Object[0]));
        }
        if (this.fUserId == null) {
            throw new IllegalCommandLineException(NLS.bind((String)Messages.CommandLineParser_MISSING_ARGUMENT, (Object)"-userId", (Object[])new Object[0]));
        }
        if (this.fPassword != null && this.fPasswordFile != null) {
            throw new IllegalCommandLineException(NLS.bind((String)Messages.CommandLineParser_USAGE_PASSWORD_ONE_OF, (Object)"-pass", (Object[])new Object[]{"-passwordFile"}));
        }
    }
}

