/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.engine;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.engine.AbstractBuildParticipant;
import com.ibm.team.build.internal.engine.InvalidPropertyValueException;
import com.ibm.team.build.internal.engine.Messages;
import com.ibm.team.build.internal.engine.MissingPropertyException;
import com.ibm.team.build.internal.engine.QuotedStringTokenizer;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineBuildParticipant
extends AbstractBuildParticipant {
    protected Process fBuildProcess;
    private Thread fProcessOutputThread;
    private String fPropertiesFile;
    private String fTempPropertiesFile;

    @Override
    public BuildStatus build(IProgressMonitor monitor) throws Exception {
        BuildStatus status = BuildStatus.OK;
        this.validateProperties(this.getBuildRequest());
        try {
            this.createPropertiesFile(this.getBuildRequest());
            this.fBuildProcess = this.execute(this.getBuildRequest(), this.getWorkingDirectory(this.getBuildRequest()));
            this.fBuildProcess.getOutputStream().close();
            this.logProcessOutputAsync(this.fBuildProcess, this.getBuildLog());
            int exitValue = this.fBuildProcess.waitFor();
            this.fProcessOutputThread.join(10000L);
            if (exitValue != 0) {
                this.getBuildLog().println(NLS.bind((String)Messages.CommandLineBuildParticipant_COMMAND_LINE_FAILED, (Object)exitValue));
                status = BuildStatus.ERROR;
            }
        }
        finally {
            if (this.fBuildProcess != null) {
                this.fBuildProcess.destroy();
            }
            this.fBuildProcess = null;
            if (this.fTempPropertiesFile != null) {
                new File(this.fTempPropertiesFile).delete();
            }
        }
        return status;
    }

    protected void validateProperties(IBuildRequest buildRequest) throws Exception {
        this.validateWorkingDir(this.getBuildRequest());
        this.validateCommandLine(this.getBuildRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interrupt() throws Exception {
        CommandLineBuildParticipant commandLineBuildParticipant = this;
        synchronized (commandLineBuildParticipant) {
            if (this.fBuildProcess != null) {
                this.fBuildProcess.destroy();
                this.getBuildLog().println(Messages.CommandLineBuildParticipant_BUILD_INTERRUPTED);
                this.setResultStatus(this.getBuildRequest().getBuildResult(), BuildStatus.ERROR, this.getTeamRepository());
            }
        }
    }

    protected void validateWorkingDir(IBuildRequest buildRequest) throws Exception {
        this.getWorkingDirectory(buildRequest);
    }

    private String doGetCommandLine(IBuildRequest buildRequest) throws InvalidPropertyValueException, MissingPropertyException {
        IBuildConfigurationElement element = buildRequest.getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.cmdline");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.cmdline.command");
        if (property == null) {
            throw new MissingPropertyException(NLS.bind((String)Messages.CommandLineBuildParticipant_MISSING_PROPERTY_IN_CONFIG_ELEMENT, (Object)"com.ibm.team.build.cmdline.command", (Object)"com.ibm.team.build.cmdline"));
        }
        String commandLine = property.getValue();
        if (commandLine.length() < 1) {
            throw new InvalidPropertyValueException("com.ibm.team.build.cmdline.command", commandLine, buildRequest.getBuildDefinitionInstance().getBuildDefinitionId());
        }
        return commandLine;
    }

    private void validateCommandLine(IBuildRequest buildRequest) throws InvalidPropertyValueException, MissingPropertyException {
        this.doGetCommandLine(buildRequest);
    }

    private String getCommandLineArguments(IBuildRequest buildRequest) {
        IBuildConfigurationElement element = buildRequest.getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.cmdline");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.cmdline.arguments");
        String arguments = "";
        if (property != null && property.getValue().trim().length() > 0) {
            arguments = property.getValue().trim();
        }
        return arguments;
    }

    protected List<String> getCommandLine(IBuildRequest buildRequest) throws Exception {
        ArrayList<String> command = new ArrayList<String>();
        String commandLine = this.doGetCommandLine(buildRequest);
        String[] tokens = QuotedStringTokenizer.getTokens(commandLine);
        int i = 0;
        while (i < tokens.length) {
            command.add(tokens[i]);
            ++i;
        }
        String arguments = this.getCommandLineArguments(buildRequest);
        tokens = QuotedStringTokenizer.getTokens(arguments);
        int i2 = 0;
        while (i2 < tokens.length) {
            command.add(tokens[i2]);
            ++i2;
        }
        return command;
    }

    protected Process execute(IBuildRequest buildRequest, File workingDir) throws Exception {
        List<String> commandLine = this.getCommandLine(buildRequest);
        ProcessBuilder builder = new ProcessBuilder(commandLine);
        builder.directory(workingDir);
        builder.redirectErrorStream(true);
        return builder.start();
    }

    private synchronized void setResultStatus(IBuildResultHandle buildResultHandle, BuildStatus status, ITeamRepository teamRepository) throws TeamRepositoryException {
        String[] requiredProperties = new String[]{IBuildResult.PROPERTY_BUILD_STATUS};
        IBuildResult buildResult = (IBuildResult)teamRepository.itemManager().fetchPartialItem((IItemHandle)buildResultHandle, 1, Arrays.asList(requiredProperties), null);
        buildResult = (IBuildResult)buildResult.getWorkingCopy();
        buildResult.setStatus(status);
        ITeamBuildClient teamBuildClient = ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository);
        teamBuildClient.save(buildResult, null);
    }

    protected void logProcessOutputAsync(Process process, PrintWriter writer) {
        this.fProcessOutputThread = new Thread(new StreamRedirector(process.getInputStream(), writer));
        this.fProcessOutputThread.start();
    }

    protected String getPropertiesFile() {
        return this.fPropertiesFile;
    }

    protected String getPropertiesFileFromProperty(IBuildRequest buildRequest) {
        String propertiesFile = null;
        IBuildConfigurationElement element = buildRequest.getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.cmdline");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.cmdline.propertiesFile");
        if (property != null && property.getValue().trim().length() > 0) {
            propertiesFile = this.convertToPlatformSeparator(property.getValue().trim());
        }
        return propertiesFile;
    }

    private void createPropertiesFile(IBuildRequest buildRequest) throws IOException {
        File file;
        File parent;
        this.fPropertiesFile = this.getPropertiesFileFromProperty(buildRequest);
        if (this.fPropertiesFile == null) {
            File temp = File.createTempFile("jbe-properties", ".properties");
            this.fTempPropertiesFile = this.fPropertiesFile = temp.getAbsolutePath();
        }
        if ((parent = (file = new File(this.fPropertiesFile)).getParentFile()) != null) {
            parent.mkdirs();
        }
        Properties properties = new Properties();
        Map<String, String> buildProperties = this.getBuildProperties();
        for (String key : buildProperties.keySet()) {
            properties.put(key, buildProperties.get(key));
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            properties.store(outputStream, null);
        }
        finally {
            outputStream.close();
        }
    }

    protected File getWorkingDirectory(IBuildRequest buildRequest) throws Exception {
        String propertyValue;
        File workingDirectory = new File(System.getProperty("user.dir"));
        IConfigurationProperty property = this.getWorkingDirProperty(buildRequest);
        if (property != null && property.getValue() != null && (propertyValue = property.getValue().trim()).length() > 0) {
            File file = new File(this.convertToPlatformSeparator(propertyValue));
            if (!file.exists()) {
                throw this.getMissingWorkingDirException(file);
            }
            return file;
        }
        return workingDirectory;
    }

    protected Exception getMissingWorkingDirException(File file) throws IOException {
        return new InvalidPropertyValueException(NLS.bind((String)Messages.CommandLineBuildParticipant_WORKING_DIR_DOES_NOT_EXIST, (Object)file.getCanonicalPath(), (Object)"com.ibm.team.build.cmdline.workingDir"));
    }

    protected IConfigurationProperty getWorkingDirProperty(IBuildRequest request) {
        IBuildConfigurationElement element = request.getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.cmdline");
        return element.getConfigurationProperty("com.ibm.team.build.cmdline.workingDir");
    }

    private String convertToPlatformSeparator(String input) {
        String converted = null;
        if (input != null) {
            converted = input.replace("/", File.separator);
            converted = converted.replace("\\", File.separator);
        }
        return converted;
    }

    private class StreamRedirector
    implements Runnable {
        private final BufferedReader fInputStreamReader;
        private final PrintWriter fOutputStreamWriter;

        public StreamRedirector(InputStream inputStream, PrintWriter writer) {
            this.fInputStreamReader = new BufferedReader(new InputStreamReader(inputStream));
            this.fOutputStreamWriter = writer;
        }

        public void run() {
            try {
                String line = null;
                while ((line = this.fInputStreamReader.readLine()) != null) {
                    this.fOutputStreamWriter.println(line);
                }
            }
            catch (IOException exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

