/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.engine;

import com.ibm.team.build.client.ClientFactory;
import com.ibm.team.build.client.ITeamBuildClient;
import com.ibm.team.build.client.ITeamBuildRequestClient;
import com.ibm.team.build.common.MultipleErrorTeamBuildException;
import com.ibm.team.build.common.TeamBuildException;
import com.ibm.team.build.common.TeamBuildStateException;
import com.ibm.team.build.common.model.BuildPhase;
import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildDefinitionInstance;
import com.ibm.team.build.common.model.IBuildEngine;
import com.ibm.team.build.common.model.IBuildEngineHandle;
import com.ibm.team.build.common.model.IBuildProperty;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IBuildRequestHandle;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.common.model.IBuildResultHandle;
import com.ibm.team.build.engine.AbstractBuildEngineParticipant;
import com.ibm.team.build.engine.AbstractBuildParticipant;
import com.ibm.team.build.engine.AbstractPostBuildParticipant;
import com.ibm.team.build.engine.AbstractPreBuildParticipant;
import com.ibm.team.build.internal.client.ProxyHelper;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.engine.BuildEngineParticipantExtension;
import com.ibm.team.build.internal.engine.ConnectionInfo;
import com.ibm.team.build.internal.engine.Messages;
import com.ibm.team.build.internal.engine.PropertyVariableHelper;
import com.ibm.team.build.internal.publishing.LogPublisher;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildLoop {
    protected static final int ABANDON_RUNNABLE_SLEEP_TIME = 30000;
    private static final long PARTICIPANT_THREAD_TIMEOUT_MILLISECONDS = 60000L;
    private ConnectionInfo fConnectionInfo;
    private long fSleepTime;
    private boolean fBuildLoopRunning;
    private Thread fBuildLoopThread;
    private List<BuildEngineParticipantExtension> fBuildEngineParticipantExtensions;
    private AbstractBuildEngineParticipant fCurrentParticipant;
    private Thread fParticipantThread;
    protected NullProgressMonitor fParticipantProgressMonitor;
    private List<AbstractPreBuildParticipant> fPreBuildParticipants = new ArrayList<AbstractPreBuildParticipant>();
    private List<AbstractBuildParticipant> fBuildParticipants = new ArrayList<AbstractBuildParticipant>();
    private List<AbstractPostBuildParticipant> fPostBuildParticipants = new ArrayList<AbstractPostBuildParticipant>();
    private ITeamRepository fTeamRepository;
    protected IBuildRequest fBuildRequest;
    private boolean fVerbose;
    private PrintWriter fBuildLogWriter;
    protected File fBuildLogFile;
    protected String fBuildLabel;

    public BuildLoop(ConnectionInfo connectionInfo, List<BuildEngineParticipantExtension> buildEngineParticipants, long sleepTime, boolean verbose) {
        this.fConnectionInfo = connectionInfo;
        this.fBuildEngineParticipantExtensions = buildEngineParticipants;
        this.fVerbose = verbose;
        this.fSleepTime = sleepTime;
        ValidationHelper.validateNotNull((String)"connectionInfo", (Object)connectionInfo);
        if (sleepTime < 1L) {
            throw new IllegalArgumentException(Messages.BuildLoop_SLEEP_TIME_INVALID);
        }
    }

    public synchronized Thread start() {
        if (!this.fBuildLoopRunning) {
            this.fBuildLoopRunning = true;
            this.fBuildLoopThread = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    BuildLoop.this.runLoop();
                    BuildLoop buildLoop = BuildLoop.this;
                    synchronized (buildLoop) {
                        BuildLoop.this.fBuildLoopRunning = false;
                    }
                }
            });
            this.fBuildLoopThread.start();
        }
        return this.fBuildLoopThread;
    }

    public synchronized void stop() {
        if (this.fBuildLoopRunning) {
            this.fBuildLoopRunning = false;
            try {
                this.interruptParticipants();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * Exception decompiling
     */
    protected void runLoop() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [58[CATCHBLOCK]], but top level block is 18[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String getLocalHostNoException() {
        String result = Messages.BuildLoop_INFO_CANNOT_GET_HOSTNAME;
        try {
            result = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {}
        return result;
    }

    protected void completeNotNecessary(IBuildResultHandle resultHandle) throws TeamBuildStateException, TeamRepositoryException {
        ITeamBuildRequestClient requestClient = ClientFactory.getTeamBuildRequestClient((ITeamRepository)this.fTeamRepository);
        this.verbosePrint(NLS.bind((String)Messages.BuildLoop_BUILD_NOT_NECESSARY, (Object)this.fBuildLabel, (Object[])new Object[0]));
        requestClient.makeBuildComplete(resultHandle, true, IBuildResult.PROPERTIES_REQUIRED, null);
    }

    private void performPropertyVariableSubstitutions(IBuildRequest buildRequest, Map<String, String> buildProperties) {
        List<String> substitutions = PropertyVariableHelper.substituteBuildPropertyVariables(buildProperties);
        this.updateRequestWithSubstitutedProperties(this.fBuildRequest, buildProperties);
        this.printSubstitutedProperties(substitutions, Messages.BuildLoop_SUBSTITUTED_BUILD_VARIABLES);
        substitutions = PropertyVariableHelper.substituteConfigurationElementPropertyVariables(this.fBuildRequest.getBuildDefinitionInstance().getConfigurationElements(), buildProperties);
        this.printSubstitutedProperties(substitutions, Messages.BuildLoop_SUBSTITUTED_CONFIG_VARIABLES);
    }

    private void updateRequestWithSubstitutedProperties(IBuildRequest buildRequest, Map<String, String> buildProperties) {
        IBuildDefinitionInstance definitionInstance = buildRequest.getBuildDefinitionInstance();
        for (Map.Entry<String, String> buildProperty : buildProperties.entrySet()) {
            IBuildProperty property = definitionInstance.getProperty(buildProperty.getKey());
            if (property == null) continue;
            property.setValue(buildProperty.getValue());
        }
    }

    private void printSubstitutedProperties(List<String> substitutedBuildProperties, String title) {
        if (!substitutedBuildProperties.isEmpty()) {
            this.printToBuildLog("");
            this.printToBuildLog(title);
            for (String description : substitutedBuildProperties) {
                this.printToBuildLog("\t" + description);
            }
            this.printToBuildLog("");
        }
    }

    protected void closeAndPublishLog(BuildStatus buildStatus, ITeamBuildRequestClient requestClient) {
        if (this.fBuildLogWriter != null) {
            if (this.fBuildLogWriter.checkError()) {
                this.print(NLS.bind((String)Messages.BuildLoop_ERROR_WRITING_LOG_FILE, (Object)this.fBuildLogFile.getAbsolutePath(), (Object[])new Object[0]));
            }
            this.fBuildLogWriter.close();
            this.fBuildLogWriter = null;
            try {
                this.publishLog(this.fBuildLogFile.getAbsolutePath(), this.fBuildRequest, buildStatus);
                this.fBuildLogFile.delete();
            }
            catch (TeamRepositoryException exception) {
                this.printStackTrace(exception);
            }
            this.fBuildLogFile = null;
        }
    }

    protected void closeAndDeleteLog() {
        if (this.fBuildLogWriter != null) {
            this.fBuildLogWriter.close();
            this.fBuildLogWriter = null;
            this.fBuildLogFile.delete();
            this.fBuildLogFile = null;
        }
    }

    private BuildStatus invokeParticipants(IBuildRequest buildRequest) throws Exception {
        final BuildStatus[] overallStatus = new BuildStatus[]{BuildStatus.OK};
        final Exception[] exceptions = new Exception[1];
        this.fParticipantThread = new Thread(new Runnable(){

            public void run() {
                try {
                    BuildStatus preBuildStatus = BuildLoop.this.invokePreBuildParticipants(BuildLoop.this.fBuildRequest, (IProgressMonitor)BuildLoop.this.fParticipantProgressMonitor);
                    BuildStatus buildStatus = BuildLoop.this.invokeBuildParticipants(BuildLoop.this.fBuildRequest, (IProgressMonitor)BuildLoop.this.fParticipantProgressMonitor);
                    BuildStatus postBuildStatus = BuildLoop.this.invokePostBuildParticipants(BuildLoop.this.fBuildRequest, (IProgressMonitor)BuildLoop.this.fParticipantProgressMonitor);
                    if (preBuildStatus.isMoreSevere(overallStatus[0])) {
                        overallStatus[0] = preBuildStatus;
                    }
                    if (buildStatus.isMoreSevere(overallStatus[0])) {
                        overallStatus[0] = buildStatus;
                    }
                    if (postBuildStatus.isMoreSevere(overallStatus[0])) {
                        overallStatus[0] = postBuildStatus;
                    }
                }
                catch (Exception exception) {
                    exceptions[0] = exception;
                }
            }
        });
        this.fParticipantThread.start();
        this.fParticipantThread.join();
        if (exceptions[0] != null) {
            throw exceptions[0];
        }
        return overallStatus[0];
    }

    protected void sleep(long milliseconds) throws InterruptedException {
        if (milliseconds < 1000L) {
            this.verbosePrint(NLS.bind((String)Messages.BuildLoop_SLEEP_MILLISECONDS, (Object)milliseconds, (Object[])new Object[0]));
            Thread.sleep(milliseconds);
        } else {
            long secondsToSleep = milliseconds / 1000L;
            this.verbosePrint("");
            this.verbosePrint(NLS.bind((String)Messages.BuildLoop_SLEEP_SECONDS, (Object)secondsToSleep, (Object[])new Object[0]));
            int i = 0;
            while ((long)i < secondsToSleep) {
                if (!this.isBuildLoopRunning()) {
                    return;
                }
                Thread.sleep(1000L);
                ++i;
            }
        }
    }

    private IBuildEngine lookupBuildEngine(ConnectionInfo connectionInfo, ITeamRepository teamRepository) throws IllegalArgumentException, TeamRepositoryException {
        IBuildEngine buildEngine;
        String buildEngineUUID = connectionInfo.getBuildEngineUUID();
        if (buildEngineUUID != null) {
            buildEngine = this.lookupBuildEngineByUUID(buildEngineUUID, teamRepository);
            if (buildEngine == null) {
                this.print(NLS.bind((String)Messages.BuildLoop_NON_EXISTANT_BUILD_ENGINE_WITH_UUID, (Object)buildEngineUUID, (Object[])new Object[]{teamRepository.getUserId()}));
                return null;
            }
        } else {
            String buildEngineId = connectionInfo.getBuildEngineId();
            ITeamBuildClient buildClient = ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository);
            buildEngine = buildClient.getBuildEngine(buildEngineId, null);
            if (buildEngine == null) {
                this.print(NLS.bind((String)Messages.BuildLoop_NON_EXISTANT_BUILD_ENGINE, (Object)buildEngineId, (Object[])new Object[]{teamRepository.getUserId()}));
                return null;
            }
        }
        return buildEngine;
    }

    protected void initializeBuildEngineParticipants(IBuildRequest request, IBuildEngine engine, ITeamRepository teamRepository, PrintWriter buildLogWriter, Map<String, String> properties, boolean verbose, long buildStartTime) throws IllegalArgumentException, CoreException {
        this.fPreBuildParticipants.clear();
        this.fBuildParticipants.clear();
        this.fPostBuildParticipants.clear();
        for (BuildEngineParticipantExtension extension : this.fBuildEngineParticipantExtensions) {
            AbstractBuildEngineParticipant participant = extension.createParticipant();
            participant.initialize(request, engine, teamRepository, buildLogWriter, properties, verbose, buildStartTime);
            if (extension.getBuildPhaseAttribute().equals((Object)BuildPhase.PRE_BUILD)) {
                this.fPreBuildParticipants.add((AbstractPreBuildParticipant)participant);
                continue;
            }
            if (extension.getBuildPhaseAttribute().equals((Object)BuildPhase.POST_BUILD)) {
                this.fPostBuildParticipants.add((AbstractPostBuildParticipant)participant);
                continue;
            }
            this.fBuildParticipants.add((AbstractBuildParticipant)participant);
        }
    }

    private Map<String, String> collectBuildProperties(IBuildRequest buildRequest, IBuildEngine buildEngine) throws TeamRepositoryException {
        IBuildProperty property;
        HashMap<String, String> properties = new HashMap<String, String>();
        IBuildResultHandle buildResultHandle = buildRequest.getBuildResult();
        properties.put("buildResultUUID", buildResultHandle.getItemId().getUuidValue());
        properties.put("requestUUID", buildRequest.getItemId().getUuidValue());
        properties.put("buildDefinitionId", buildRequest.getBuildDefinitionInstance().getBuildDefinitionId());
        properties.put("repositoryAddress", ((ITeamRepository)buildRequest.getOrigin()).getRepositoryURI());
        IBuildResult result = (IBuildResult)this.fTeamRepository.itemManager().fetchCompleteItem((IItemHandle)buildRequest.getBuildResult(), 1, null);
        if (result.isPersonalBuild()) {
            properties.put("personalBuild", "true");
        }
        for (Object object : buildEngine.getProperties()) {
            property = (IBuildProperty)object;
            properties.put(property.getName(), property.getValue());
        }
        for (Object object : buildRequest.getBuildDefinitionInstance().getProperties()) {
            property = (IBuildProperty)object;
            properties.put(property.getName(), property.getValue());
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BuildStatus invokePreBuildParticipants(IBuildRequest buildRequest, IProgressMonitor monitor) throws Exception {
        List<AbstractPreBuildParticipant> participants = this.getPreBuildParticipants(buildRequest);
        BuildStatus status = BuildStatus.OK;
        for (AbstractPreBuildParticipant participant : participants) {
            BuildLoop buildLoop = this;
            synchronized (buildLoop) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                this.fCurrentParticipant = participant;
            }
            String message = NLS.bind((String)Messages.BuildLoop_INVOKING_PREBUILD, (Object)participant.getConfigurationElementId(), (Object[])new Object[0]);
            this.printToBuildLog(message);
            this.verbosePrint(message);
            BuildStatus participantStatus = participant.preBuild(monitor);
            if (!participantStatus.isMoreSevere(status)) continue;
            status = participantStatus;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BuildStatus invokeBuildParticipants(IBuildRequest buildRequest, IProgressMonitor monitor) throws Exception {
        List<AbstractBuildParticipant> participants = this.getBuildParticipants(buildRequest);
        BuildStatus status = BuildStatus.OK;
        for (AbstractBuildParticipant participant : participants) {
            BuildLoop buildLoop = this;
            synchronized (buildLoop) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                this.fCurrentParticipant = participant;
            }
            String message = NLS.bind((String)Messages.BuildLoop_INVOKING_BUILD, (Object)participant.getConfigurationElementId(), (Object[])new Object[0]);
            this.printToBuildLog(message);
            this.verbosePrint(message);
            BuildStatus participantStatus = participant.build(monitor);
            if (!participantStatus.isMoreSevere(status)) continue;
            status = participantStatus;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BuildStatus invokePostBuildParticipants(IBuildRequest buildRequest, IProgressMonitor monitor) throws Exception {
        LinkedList<Throwable> throwables = new LinkedList<Throwable>();
        List<AbstractPostBuildParticipant> participants = this.getPostBuildParticipants(buildRequest);
        BuildStatus status = BuildStatus.OK;
        for (AbstractPostBuildParticipant participant : participants) {
            BuildLoop buildLoop = this;
            synchronized (buildLoop) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                this.fCurrentParticipant = participant;
            }
            try {
                String message = NLS.bind((String)Messages.BuildLoop_INVOKING_POSTBUILD, (Object)participant.getConfigurationElementId(), (Object[])new Object[0]);
                this.printToBuildLog(message);
                this.verbosePrint(message);
                BuildStatus participantStatus = participant.postBuild(monitor);
                if (!participantStatus.isMoreSevere(status)) continue;
                status = participantStatus;
            }
            catch (Throwable throwable) {
                throwables.add(throwable);
            }
        }
        if (throwables.size() > 0) {
            throw new MultipleErrorTeamBuildException(throwables.toArray(new Throwable[throwables.size()]));
        }
        return status;
    }

    private void setLabel(String buildLabel, IBuildResult result) throws IllegalArgumentException, TeamRepositoryException {
        ITeamRepository teamRepository = (ITeamRepository)result.getOrigin();
        ITeamBuildClient teamBuildClient = ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository);
        result = (IBuildResult)result.getWorkingCopy();
        result.setLabel(buildLabel);
        teamBuildClient.save(result, null);
    }

    private String getLabelPrefix(IBuildRequest buildRequest) {
        for (Object object : buildRequest.getBuildDefinitionInstance().getProperties()) {
            IBuildProperty property = (IBuildProperty)object;
            if (!property.getName().equals("buildLabelPrefix")) continue;
            return property.getValue();
        }
        return "";
    }

    protected String generateLabel(Calendar calendar) {
        return MessageFormat.format("{0,number,0000}{1,number,00}{2,number,00}-{3,number,00}{4,number,00}", calendar.get(1), calendar.get(2) + 1, calendar.get(5), calendar.get(11), calendar.get(12));
    }

    private void validateBuilder(IBuildRequest buildRequest) throws TeamBuildException {
        boolean foundBuilder = false;
        for (Object object : buildRequest.getBuildDefinitionInstance().getConfigurationElements()) {
            IBuildConfigurationElement element = (IBuildConfigurationElement)object;
            if (!element.getBuildPhase().equals((Object)BuildPhase.BUILD)) continue;
            foundBuilder = true;
            break;
        }
        if (!foundBuilder) {
            throw new TeamBuildException(NLS.bind((String)Messages.BuildLoop_MISSING_CONFIG_ELEMENT, (Object)buildRequest.getBuildDefinitionInstance().getBuildDefinitionId(), (Object[])new Object[0]));
        }
    }

    protected void completeBuild(IBuildRequest request, ITeamBuildRequestClient client) throws Exception {
        List<String> requiredProperties = Arrays.asList(IBuildResult.PROPERTY_BUILD_STATE, IBuildResult.PROPERTY_LABEL);
        IBuildResult buildResult = (IBuildResult)this.getTeamRepository().itemManager().fetchPartialItem((IItemHandle)request.getBuildResult(), 1, requiredProperties, null);
        if (buildResult.getState() == BuildState.CANCELED || buildResult.getState() == BuildState.INCOMPLETE || buildResult.getState() == BuildState.COMPLETED) {
            return;
        }
        if (buildResult.getState() != BuildState.IN_PROGRESS) {
            client.startBuild((IBuildRequestHandle)request, IBuildResult.PROPERTIES_REQUIRED, null);
        }
        client.makeBuildComplete(request.getBuildResult(), false, IBuildResult.PROPERTIES_REQUIRED, null);
        this.verbosePrint(NLS.bind((String)Messages.BuildLoop_BUILD_COMPLETE, (Object)buildResult.getLabel(), (Object[])new Object[0]));
    }

    protected void handleLogPublishingException(Exception exception) {
        this.printStackTrace(exception);
    }

    protected void handleBuildCompletionException(Exception exception) {
        this.printStackTrace(exception);
    }

    protected void printStackTrace(Throwable exception) {
        exception.printStackTrace();
    }

    protected void handleException(Throwable throwable, IBuildRequest buildRequest, ITeamRepository teamRepository) {
        block5: {
            if (buildRequest != null) {
                try {
                    this.setResultStatus(buildRequest.getBuildResult(), BuildStatus.ERROR, teamRepository);
                    if (this.fBuildLogWriter != null) {
                        throwable.printStackTrace(this.fBuildLogWriter);
                        break block5;
                    }
                    this.publishErrorLog(buildRequest.getBuildResult(), Messages.BuildLoop_BUILD_ERROR_LOG_LABEL, throwable, teamRepository);
                }
                catch (Exception exception) {
                    this.printStackTrace(exception);
                }
            } else {
                this.printError(NLS.bind((String)Messages.BuildLoop_EXCEPTION_IN_BUILD_LOOP, (Object)throwable.getMessage(), (Object[])new Object[0]));
                this.printStackTrace(throwable);
            }
        }
    }

    protected void handleConnectionRelatedException(String message) {
        this.print(message);
        if (this.fBuildLogWriter != null) {
            this.fBuildLogWriter.println(message);
        }
    }

    protected void publishLog(String logFilePath, IBuildRequest buildRequest, BuildStatus buildStatus) throws TeamRepositoryException {
        LogPublisher publisher = new LogPublisher(logFilePath, Messages.CommandLineBuildParticipant_BUILD_LOG_FILE_LABEL, "text/plain", "UTF-8");
        publisher.publish(buildRequest.getBuildResult(), buildStatus, this.fTeamRepository);
    }

    protected void publishErrorLog(IBuildResultHandle buildResultHandle, String label, Throwable throwable, ITeamRepository teamRepository) throws IOException, TeamRepositoryException {
        File tempFile = File.createTempFile(Messages.BuildLoop_BUILD_ERROR_LOG_FILE_NAME, ".log");
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(tempFile, true), true);
            throwable.printStackTrace(printStream);
            printStream.close();
            LogPublisher publisher = new LogPublisher(tempFile.getAbsolutePath(), label);
            publisher.publish(buildResultHandle, BuildStatus.ERROR, teamRepository);
        }
        finally {
            tempFile.delete();
        }
    }

    private void setResultStatus(IBuildResultHandle buildResultHandle, BuildStatus status, ITeamRepository teamRepository) throws TeamRepositoryException {
        String[] requiredProperties = new String[]{IBuildResult.PROPERTY_BUILD_STATUS};
        IBuildResult buildResult = (IBuildResult)teamRepository.itemManager().fetchPartialItem((IItemHandle)buildResultHandle, 1, Arrays.asList(requiredProperties), null);
        buildResult = (IBuildResult)buildResult.getWorkingCopy();
        buildResult.setStatus(status);
        ITeamBuildClient teamBuildClient = ClientFactory.getTeamBuildClient((ITeamRepository)teamRepository);
        teamBuildClient.save(buildResult, null);
    }

    protected boolean shouldBuild(IBuildRequest buildRequest, ITeamRepository teamRepository, IProgressMonitor monitor) throws Exception {
        String message = Messages.BuildLoop_SHOULD_BUILD_OCCUR;
        this.verbosePrint(message);
        this.printToBuildLog(message);
        if (this.isScheduledRequest(buildRequest)) {
            List<AbstractPreBuildParticipant> participants = this.getPreBuildParticipants(buildRequest);
            if (participants.isEmpty()) {
                message = Messages.BuildLoop_YES_NO_PRE_BUILD_PARTICIPANTS;
                this.verbosePrint(message);
                this.printToBuildLog(message);
                return true;
            }
            for (AbstractPreBuildParticipant participant : participants) {
                if (!participant.shouldBuild(monitor)) continue;
                message = NLS.bind((String)Messages.BuildLoop_PARTICIPANT_SAYS_YES, (Object)participant.getConfigurationElementId(), (Object[])new Object[0]);
                this.verbosePrint(message);
                this.printToBuildLog(message);
                return true;
            }
            this.verbosePrint(Messages.BuildLoop_PARTICIPANTS_SAY_NO);
            return false;
        }
        message = Messages.BuildLoop_ALWAYS_BUILD_USER_REQUEST;
        this.verbosePrint(message);
        this.printToBuildLog(message);
        return true;
    }

    private boolean isScheduledRequest(IBuildRequest buildRequest) {
        return this.containsProperty(buildRequest, "scheduledBuild", "true");
    }

    private List<AbstractPreBuildParticipant> getPreBuildParticipants(IBuildRequest buildRequest) {
        ArrayList<AbstractPreBuildParticipant> preBuildParticipants = new ArrayList<AbstractPreBuildParticipant>();
        List configurationElements = buildRequest.getBuildDefinitionInstance().getConfigurationElements();
        for (Object object : configurationElements) {
            IBuildConfigurationElement element = (IBuildConfigurationElement)object;
            if (!element.getBuildPhase().equals((Object)BuildPhase.PRE_BUILD)) continue;
            boolean participantFound = false;
            for (AbstractPreBuildParticipant participant : this.fPreBuildParticipants) {
                if (!participant.getConfigurationElementId().equals(element.getElementId())) continue;
                preBuildParticipants.add(participant);
                participantFound = true;
            }
            if (participantFound) continue;
            this.handleEngineParticipantNotFound(element);
        }
        return preBuildParticipants;
    }

    private List<AbstractBuildParticipant> getBuildParticipants(IBuildRequest buildRequest) {
        ArrayList<AbstractBuildParticipant> buildParticipants = new ArrayList<AbstractBuildParticipant>();
        List configurationElements = buildRequest.getBuildDefinitionInstance().getConfigurationElements();
        for (Object object : configurationElements) {
            IBuildConfigurationElement element = (IBuildConfigurationElement)object;
            if (!element.getBuildPhase().equals((Object)BuildPhase.BUILD)) continue;
            boolean participantFound = false;
            for (AbstractBuildParticipant participant : this.fBuildParticipants) {
                if (!participant.getConfigurationElementId().equals(element.getElementId())) continue;
                buildParticipants.add(participant);
                participantFound = true;
            }
            if (participantFound) continue;
            this.handleEngineParticipantNotFound(element);
        }
        return buildParticipants;
    }

    private List<AbstractPostBuildParticipant> getPostBuildParticipants(IBuildRequest buildRequest) {
        ArrayList<AbstractPostBuildParticipant> postBuildParticipants = new ArrayList<AbstractPostBuildParticipant>();
        List configurationElements = buildRequest.getBuildDefinitionInstance().getConfigurationElements();
        for (Object object : configurationElements) {
            IBuildConfigurationElement element = (IBuildConfigurationElement)object;
            if (!element.getBuildPhase().equals((Object)BuildPhase.POST_BUILD)) continue;
            boolean participantFound = false;
            for (AbstractPostBuildParticipant participant : this.fPostBuildParticipants) {
                if (!participant.getConfigurationElementId().equals(element.getElementId())) continue;
                postBuildParticipants.add(participant);
                participantFound = true;
            }
            if (participantFound) continue;
            this.handleEngineParticipantNotFound(element);
        }
        return postBuildParticipants;
    }

    private void handleEngineParticipantNotFound(IBuildConfigurationElement buildConfigElement) {
        String message = NLS.bind((String)Messages.BuildLoop_NO_ENGINE_PARTICIPANT, (Object)buildConfigElement.getBuildPhase().name().toLowerCase(), (Object[])new Object[]{buildConfigElement.getName()});
        this.print(message);
        this.printToBuildLog(message);
    }

    private boolean containsProperty(IBuildRequest request, String name, String value) {
        String propertyValue;
        Map properties = request.getBuildDefinitionProperties();
        return properties != null && (propertyValue = (String)properties.get(name)) != null && propertyValue.equals(value);
    }

    protected ITeamRepository getTeamRepository() throws TeamRepositoryException {
        if (this.fTeamRepository == null || !this.fTeamRepository.loggedIn()) {
            this.fTeamRepository = TeamPlatform.getTeamRepositoryService().getUnmanagedRepository(this.fConnectionInfo.getRepositoryAddress());
            this.fTeamRepository.registerLoginHandler(new ITeamRepository.ILoginHandler(){

                public ITeamRepository.ILoginHandler.ILoginInfo challenge(ITeamRepository repo) {
                    return new ITeamRepository.ILoginHandler.ILoginInfo(){

                        public String getUserId() {
                            return BuildLoop.this.fConnectionInfo.getUserId();
                        }

                        public String getPassword() {
                            return BuildLoop.this.fConnectionInfo.getPassword();
                        }
                    };
                }
            });
            String host = ProxyHelper.getProxyHost((String)this.fConnectionInfo.getRepositoryAddress());
            if (host != null) {
                int port = ProxyHelper.getProxyPort((String)this.fConnectionInfo.getRepositoryAddress());
                this.fTeamRepository.setProxy(host, port, this.fConnectionInfo.getUserId(), this.fConnectionInfo.getPassword());
                this.verbosePrint(NLS.bind((String)Messages.BuildLoop_USING_PROXY, (Object)host, (Object[])new Object[]{port, this.fConnectionInfo.getRepositoryAddress()}));
            } else {
                this.verbosePrint(NLS.bind((String)Messages.BuildLoop_NOT_USING_PROXY, (Object)this.fConnectionInfo.getRepositoryAddress(), (Object[])new Object[0]));
            }
            if (!this.fTeamRepository.loggedIn()) {
                try {
                    this.fTeamRepository.login(null);
                }
                catch (TeamRepositoryException exception) {
                    this.print(NLS.bind((String)Messages.BuildLoop_ERROR_LOGGING_IN, (Object)this.fTeamRepository.getRepositoryURI(), (Object[])new Object[]{this.fTeamRepository.getUserId()}));
                    throw exception;
                }
            }
        }
        return this.fTeamRepository;
    }

    private IBuildRequest getNextRequest(IBuildEngine buildEngine, ITeamRepository teamRepository) throws IllegalArgumentException, TeamRepositoryException {
        if (buildEngine.isActive()) {
            this.verbosePrint(Messages.BuildLoop_SEARCH_FOR_REQUEST);
            ITeamBuildRequestClient requestClient = ClientFactory.getTeamBuildRequestClient((ITeamRepository)teamRepository);
            return requestClient.getNextRequest((IBuildEngineHandle)buildEngine, IBuildRequest.PROPERTIES_COMPLETE, null);
        }
        this.verbosePrint(NLS.bind((String)Messages.BuildLoop_ENGINE_NOT_ACTIVE, (Object)buildEngine.getId(), (Object[])new Object[0]));
        return null;
    }

    private IBuildEngine lookupBuildEngineByUUID(String buildEngineUuidString, ITeamRepository teamRepository) throws IllegalArgumentException, TeamRepositoryException {
        IBuildEngine buildEngine = null;
        UUID buildEngineUuid = UUID.valueOf((String)buildEngineUuidString);
        IBuildEngineHandle buildEngineHandle = (IBuildEngineHandle)IBuildEngine.ITEM_TYPE.createItemHandle(buildEngineUuid, null);
        try {
            buildEngine = (IBuildEngine)teamRepository.itemManager().fetchCompleteItem((IItemHandle)buildEngineHandle, 1, null);
        }
        catch (ItemNotFoundException itemNotFoundException) {
        }
        catch (PermissionDeniedException permissionDeniedException) {}
        return buildEngine;
    }

    protected void printToBuildLog(String message) {
        this.fBuildLogWriter.println(this.formatMessage(message));
    }

    protected void print(String message) {
        System.out.println(this.formatMessage(message));
    }

    protected void verbosePrint(String message) {
        if (this.fVerbose) {
            this.print(message);
        }
    }

    protected void printError(String message) {
        System.err.println(this.formatMessage(message));
    }

    protected String formatMessage(String message) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = dateFormat.format(new Date(System.currentTimeMillis()));
        return NLS.bind((String)Messages.BuildLoop_LOG_PREFIX, (Object)timestamp, (Object[])new Object[]{message});
    }

    protected boolean isBuildLoopRunning() {
        return this.fBuildLoopRunning;
    }

    protected long getSleepTime() {
        return this.fSleepTime * 1000L;
    }

    protected long getAbandonedSleepTime() {
        return 30000L;
    }

    private synchronized boolean interruptParticipants() throws Exception {
        boolean interrupted = false;
        if (this.fCurrentParticipant != null) {
            try {
                this.verbosePrint(NLS.bind((String)Messages.BuildLoop_INTERRUPT_PARTICIPANT, (Object)this.fCurrentParticipant.getConfigurationElementId(), (Object[])new Object[0]));
                this.fCurrentParticipant.interrupt();
            }
            catch (Exception exception) {
                this.verbosePrint(Messages.BuildLoop_IGNORING_INTERRUPT_EXCEPTION);
            }
            this.fParticipantProgressMonitor.setCanceled(true);
            this.verbosePrint(Messages.BuildLoop_CANCELED_PARTICIPANT_MONITOR);
            try {
                this.verbosePrint(Messages.BuildLoop_WAITING_FOR_PARTICIPANT);
                this.fParticipantThread.join(this.getParticipantInterruptTimeout());
                if (this.fParticipantThread.isAlive()) {
                    String id = this.fBuildRequest.getBuildDefinitionInstance().getBuildDefinitionId();
                    this.printError(NLS.bind((String)Messages.BuildLoop_TIMED_OUT_WAITING_FOR_PARTICIPANT, (Object)id, (Object[])new Object[]{this.fBuildLabel}));
                    this.printToBuildLog(NLS.bind((String)Messages.BuildLoop_TIMED_OUT_WAITING_FOR_PARTICIPANT, (Object)id, (Object[])new Object[]{this.fBuildLabel}));
                } else {
                    this.verbosePrint(Messages.BuildLoop_PARTICIPANT_COMPLETED);
                }
            }
            catch (InterruptedException interruptedException) {
                this.verbosePrint(Messages.BuildLoop_INTERRUPT_PROCESS_INTERRUPTED);
            }
            interrupted = true;
        }
        this.verbosePrint(Messages.BuildLoop_INTERRUPT_PROCESS_COMPLETE);
        return interrupted;
    }

    protected long getParticipantInterruptTimeout() {
        return 60000L;
    }

    private class AbandonedBuildRunnable
    implements Runnable {
        private IBuildResult fBuildResult;
        private boolean fStopped = false;
        private long fAbandonSleepTime;

        public AbandonedBuildRunnable(IBuildResult buildResult, long sleepTime) {
            this.fBuildResult = buildResult;
            this.fAbandonSleepTime = sleepTime;
        }

        public void run() {
            try {
                List<String> properties = Arrays.asList(IBuildResult.PROPERTY_BUILD_STATE);
                while (!this.fStopped) {
                    this.fBuildResult = (IBuildResult)BuildLoop.this.fTeamRepository.itemManager().fetchPartialItem((IItemHandle)this.fBuildResult, 1, properties, null);
                    if (this.fBuildResult.getState() == BuildState.INCOMPLETE) {
                        BuildLoop.this.verbosePrint(NLS.bind((String)Messages.BuildLoop_DISCOVERED_BUILD_ABANDONED, (Object)this.fBuildResult.getLabel(), (Object[])new Object[0]));
                        BuildLoop.this.printToBuildLog(NLS.bind((String)Messages.BuildLoop_DISCOVERED_BUILD_ABANDONED, (Object)this.fBuildResult.getLabel(), (Object[])new Object[0]));
                        BuildLoop.this.interruptParticipants();
                        BuildLoop.this.verbosePrint(NLS.bind((String)Messages.BuildLoop_BUILD_WAS_ABANDONED, (Object)this.fBuildResult.getLabel(), (Object[])new Object[0]));
                        BuildLoop.this.printToBuildLog(NLS.bind((String)Messages.BuildLoop_BUILD_WAS_ABANDONED, (Object)this.fBuildResult.getLabel(), (Object[])new Object[0]));
                        this.stop();
                        continue;
                    }
                    Thread.sleep(this.fAbandonSleepTime);
                }
            }
            catch (Exception exception) {}
        }

        public void stop() {
            this.fStopped = true;
        }
    }
}

