/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.engine;

import com.ibm.team.build.internal.engine.BuildEngineParticipantExtension;
import com.ibm.team.build.internal.engine.Messages;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildEngineParticipantExtensionManager {
    public static final String EXTENSION_POINT_ID_BUILD_ENGINE_PARTICIPANTS = "com.ibm.team.build.engine.buildEngineParticipants";
    protected static BuildEngineParticipantExtensionManager fManager = null;
    private List<BuildEngineParticipantExtension> fExtentions = this.loadBuildEngineParticipantExtensions();

    protected BuildEngineParticipantExtensionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BuildEngineParticipantExtensionManager getInstance() {
        Class<BuildEngineParticipantExtensionManager> clazz = BuildEngineParticipantExtensionManager.class;
        synchronized (BuildEngineParticipantExtensionManager.class) {
            if (fManager == null) {
                fManager = new BuildEngineParticipantExtensionManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return fManager;
        }
    }

    public List<BuildEngineParticipantExtension> getBuildEngineParticipantExtensions() {
        return this.fExtentions;
    }

    protected IConfigurationElement[] getConfigurationElements(IExtensionPoint extensionPoint) {
        return extensionPoint.getConfigurationElements();
    }

    private List<BuildEngineParticipantExtension> loadBuildEngineParticipantExtensions() {
        LinkedList<BuildEngineParticipantExtension> extensions = new LinkedList<BuildEngineParticipantExtension>();
        IExtensionPoint extensionPoint = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_POINT_ID_BUILD_ENGINE_PARTICIPANTS);
        if (extensionPoint != null) {
            IConfigurationElement[] configurationElements = this.getConfigurationElements(extensionPoint);
            int i = 0;
            while (i < configurationElements.length) {
                IConfigurationElement configElement = configurationElements[i];
                try {
                    BuildEngineParticipantExtension extension = new BuildEngineParticipantExtension(configElement);
                    if (!extensions.contains(extension)) {
                        extensions.add(extension);
                    } else {
                        this.handleDuplicateExtensions(configElement);
                    }
                }
                catch (IllegalArgumentException exception) {
                    this.handleIllegalArgumentException(exception, configElement);
                }
                ++i;
            }
        }
        return extensions;
    }

    private void handleDuplicateExtensions(IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getAttribute("id"), configElement.getContributor().getName()};
        String message = NLS.bind((String)Messages.BuildEngineParticipantExtensionManager_DUPLICATE_EXTENSION, (Object[])params);
        this.printError(message);
    }

    private void handleIllegalArgumentException(IllegalArgumentException exception, IConfigurationElement configElement) {
        Object[] params = new String[]{this.getExtensionFQN(configElement), configElement.getContributor().getName()};
        String message = NLS.bind((String)Messages.BuildEngineParticipantExtensionManager_ILLEGAL_OR_MISSING_ATTRIBUTE, (Object[])params);
        message = String.valueOf(message) + " " + exception.getLocalizedMessage();
        this.printError(message);
    }

    private String getExtensionFQN(IConfigurationElement configElement) {
        return String.valueOf(configElement.getNamespaceIdentifier()) + "." + configElement.getName();
    }

    protected void printError(String error) {
        System.err.println(error);
    }
}

