/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.engine;

import com.ibm.team.build.common.model.BuildPhase;
import com.ibm.team.build.engine.AbstractBuildEngineParticipant;
import com.ibm.team.build.engine.AbstractBuildParticipant;
import com.ibm.team.build.engine.AbstractPostBuildParticipant;
import com.ibm.team.build.engine.AbstractPreBuildParticipant;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.engine.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;

public class BuildEngineParticipantExtension {
    public static final String BUILD_CONFIGURATION_ELEMENT_ID_ATTRIBUTE = "configurationElementId";
    public static final String ID_ATTRIBUTE = "id";
    public static final String CLASS_ATTRIBUTE = "class";
    public static final String BUILD_PHASE_ATTRIBUTE = "buildPhase";
    private String fIdAttribute;
    private String fBuildConfigurationElementIdAttribute;
    private String fClassAttribute;
    private BuildPhase fBuildPhaseAttribute;
    private IConfigurationElement fConfigurationElement;

    public BuildEngineParticipantExtension(IConfigurationElement configurationElement) {
        ValidationHelper.validateNotNull((String)"configElement", (Object)configurationElement);
        this.fConfigurationElement = configurationElement;
        this.fIdAttribute = configurationElement.getAttribute(ID_ATTRIBUTE);
        this.fBuildConfigurationElementIdAttribute = configurationElement.getAttribute(BUILD_CONFIGURATION_ELEMENT_ID_ATTRIBUTE);
        this.fClassAttribute = configurationElement.getAttribute(CLASS_ATTRIBUTE);
        String buildPhase = configurationElement.getAttribute(BUILD_PHASE_ATTRIBUTE);
        if (buildPhase != null) {
            this.fBuildPhaseAttribute = BuildPhase.valueOf((String)buildPhase);
        }
        this.validateAttributes();
    }

    public String getClassAttribute() {
        return this.fClassAttribute;
    }

    public String getElementIdAttribute() {
        return this.fBuildConfigurationElementIdAttribute;
    }

    public String getIdAttribute() {
        return this.fIdAttribute;
    }

    public BuildPhase getBuildPhaseAttribute() {
        return this.fBuildPhaseAttribute;
    }

    public AbstractBuildEngineParticipant createParticipant() throws IllegalArgumentException, CoreException {
        return this.createExecutableExtension();
    }

    public String getPluginName() {
        return this.fConfigurationElement.getContributor().getName();
    }

    public int hashCode() {
        return this.fIdAttribute.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildEngineParticipantExtension other = (BuildEngineParticipantExtension)obj;
        return this.fIdAttribute.equals(other.fIdAttribute);
    }

    private void validateAttributes() {
        ValidationHelper.validateNotNull((String)ID_ATTRIBUTE, (Object)this.fIdAttribute);
        ValidationHelper.validateNotEmpty((String)ID_ATTRIBUTE, (String)this.fIdAttribute.trim());
        ValidationHelper.validateNotNull((String)BUILD_CONFIGURATION_ELEMENT_ID_ATTRIBUTE, (Object)this.fBuildConfigurationElementIdAttribute);
        ValidationHelper.validateNotEmpty((String)BUILD_CONFIGURATION_ELEMENT_ID_ATTRIBUTE, (String)this.fBuildConfigurationElementIdAttribute.trim());
        ValidationHelper.validateNotNull((String)CLASS_ATTRIBUTE, (Object)this.fClassAttribute);
        ValidationHelper.validateNotEmpty((String)CLASS_ATTRIBUTE, (String)this.fClassAttribute.trim());
        ValidationHelper.validateNotNull((String)BUILD_PHASE_ATTRIBUTE, (Object)this.fBuildPhaseAttribute);
        if (this.fBuildPhaseAttribute.equals((Object)BuildPhase.UNSPECIFIED)) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.BuildEngineParticipantExtension_ILLEGAL_BUILD_PHASE, (Object)BuildPhase.UNSPECIFIED.name()));
        }
    }

    private AbstractBuildEngineParticipant createExecutableExtension() throws CoreException, IllegalArgumentException {
        Object executableExtension = this.fConfigurationElement.createExecutableExtension(CLASS_ATTRIBUTE);
        switch (this.fBuildPhaseAttribute) {
            case PRE_BUILD: {
                ValidationHelper.validateIsType((String)CLASS_ATTRIBUTE, AbstractPreBuildParticipant.class, (Object)executableExtension);
                break;
            }
            case BUILD: {
                ValidationHelper.validateIsType((String)CLASS_ATTRIBUTE, AbstractBuildParticipant.class, (Object)executableExtension);
                break;
            }
            case POST_BUILD: {
                ValidationHelper.validateIsType((String)CLASS_ATTRIBUTE, AbstractPostBuildParticipant.class, (Object)executableExtension);
                break;
            }
        }
        AbstractBuildEngineParticipant participant = (AbstractBuildEngineParticipant)executableExtension;
        participant.setConfigurationElementId(this.fBuildConfigurationElementIdAttribute);
        return participant;
    }
}

