/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.engine;

import com.ibm.team.build.internal.PasswordHelper;
import com.ibm.team.build.internal.engine.BuildEngineParticipantExtension;
import com.ibm.team.build.internal.engine.BuildEngineParticipantExtensionManager;
import com.ibm.team.build.internal.engine.BuildEnginePlugin;
import com.ibm.team.build.internal.engine.BuildLoop;
import com.ibm.team.build.internal.engine.CommandLineParser;
import com.ibm.team.build.internal.engine.ConnectionInfo;
import com.ibm.team.build.internal.engine.IllegalCommandLineException;
import com.ibm.team.build.internal.engine.Messages;
import com.ibm.team.repository.common.util.ObfuscationHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.GeneralSecurityException;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.varia.NullAppender;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildEngineApplication
implements IApplication {
    private BuildLoop fBuildLoop;
    public static final String SLEEP_TIME_ARGUMENT_NAME = "-sleepTime";
    public static final String LOG_FILE_ARGUMENT_NAME = "-logFile";
    public static final String ENGINE_ID_ARGUMENT_NAME = "-engineId";
    public static final String ENGINE_UUID_ARGUMENT_NAME = "-engineUUID";
    public static final String PASSWORD_ARGUMENT_NAME = "-pass";
    public static final String USER_ID_ARGUMENT_NAME = "-userId";
    public static final String REPOSITORY_ARGUMENT_NAME = "-repository";
    public static final String VERBOSE_ARGUMENT_NAME = "-verbose";
    public static final String PASSWORD_FILE_ARGUMENT_NAME = "-passwordFile";
    public static final String CREATE_PASSWORD_FILE_ARGUMENT_NAME = "-createPasswordFile";

    public Object start(IApplicationContext context) throws Exception {
        String[] args = (String[])context.getArguments().get("application.args");
        BasicConfigurator.configure((Appender)new NullAppender());
        CommandLineParser commandLineParser = null;
        try {
            commandLineParser = new CommandLineParser(args);
        }
        catch (IllegalCommandLineException exception) {
            this.printError(exception.getLocalizedMessage());
            this.printError(CommandLineParser.getUsageMessage());
            return IApplication.EXIT_OK;
        }
        if (commandLineParser.getCreatePasswordFile() != null) {
            String password = this.getPasswordFromUser();
            this.createPasswordFile(commandLineParser.getCreatePasswordFile(), password);
            return IApplication.EXIT_OK;
        }
        String password = this.getPassword(commandLineParser);
        if (password == null) {
            return IApplication.EXIT_OK;
        }
        ConnectionInfo connectionInfo = new ConnectionInfo(commandLineParser.getRepository(), commandLineParser.getEngineId(), commandLineParser.getEngineUUID(), commandLineParser.getUserId(), password);
        this.fBuildLoop = this.getBuildLoop(connectionInfo, this.getBuildEngineParticipants(), commandLineParser.getSleepTime(), commandLineParser.getVerbose());
        Thread thread = this.fBuildLoop.start();
        BuildEnginePlugin plugin = BuildEnginePlugin.getDefault();
        if (plugin != null) {
            plugin.setCleanupTask(new Runnable(){

                public void run() {
                    BuildEngineApplication.this.fBuildLoop.stop();
                }
            });
        }
        try {
            thread.join();
        }
        catch (InterruptedException interruptedException) {}
        return IApplication.EXIT_OK;
    }

    public void stop() {
        this.fBuildLoop.stop();
    }

    protected void printError(String message) {
        System.err.println(message);
    }

    protected void printOutput(String message) {
        System.out.println(message);
    }

    protected BuildLoop getBuildLoop(ConnectionInfo connectionInfo, List<BuildEngineParticipantExtension> buildEngineParticipants, long sleepTime, boolean verbose) {
        return new BuildLoop(connectionInfo, buildEngineParticipants, sleepTime, verbose);
    }

    private List<BuildEngineParticipantExtension> getBuildEngineParticipants() {
        List<BuildEngineParticipantExtension> extensions = BuildEngineParticipantExtensionManager.getInstance().getBuildEngineParticipantExtensions();
        for (BuildEngineParticipantExtension extension : extensions) {
            try {
                extension.createParticipant();
            }
            catch (Exception exception) {
                this.printError(NLS.bind((String)Messages.BuildEngineApplication_EXCEPTION_CREATING_EXTENSION, (Object)extension.getPluginName(), (Object)exception.getLocalizedMessage()));
            }
        }
        return extensions;
    }

    private String getPassword(CommandLineParser commandLineParser) throws IOException, GeneralSecurityException {
        File passwordFile = commandLineParser.getPasswordFile();
        if (passwordFile != null) {
            try {
                return PasswordHelper.getPassword((File)passwordFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.printError(NLS.bind((String)Messages.BuildEngineApplication_PASSWORD_FILE_NOT_FOUND, (Object)passwordFile.getAbsolutePath()));
                return null;
            }
        }
        return commandLineParser.getPassword();
    }

    private void createPasswordFile(File passwordFile, String password) throws IOException, GeneralSecurityException {
        FileOutputStream outputStream = new FileOutputStream(passwordFile);
        outputStream.write(ObfuscationHelper.encrypt((byte[])password.getBytes()));
        outputStream.close();
        this.printOutput(System.getProperty("line.separator"));
        this.printOutput(NLS.bind((String)Messages.BuildEngineApplication_PASSWORD_STORED, (Object)passwordFile.getAbsolutePath()));
        this.printOutput(System.getProperty("line.separator"));
        this.printOutput(Messages.BuildEngineApplication_ENCRYPTION_WARNING);
    }

    private String getPasswordFromUser() throws IOException {
        this.printOutput(System.getProperty("line.separator"));
        this.printOutput(Messages.BuildEngineApplication_PASSWORD_SHOWN_WARNING);
        System.out.print(Messages.BuildEngineApplication_PASSWORD_PROMPT);
        BufferedReader reader = this.getReader();
        return reader.readLine();
    }

    protected BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader(System.in));
    }
}

