/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.engine;

import com.ibm.team.build.common.model.IBuildConfigurationElement;
import com.ibm.team.build.common.model.IBuildRequest;
import com.ibm.team.build.common.model.IConfigurationProperty;
import com.ibm.team.build.internal.engine.CommandLineBuildParticipant;
import com.ibm.team.build.internal.engine.InvalidPropertyValueException;
import com.ibm.team.build.internal.engine.Messages;
import com.ibm.team.build.internal.engine.MissingPropertyException;
import com.ibm.team.build.internal.engine.QuotedStringTokenizer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AntBuildParticipant
extends CommandLineBuildParticipant {
    private static final String TARGET_SEPARATOR = ",";
    protected static final String ANT_LAUNCHER_CLASS = "org.apache.tools.ant.launch.Launcher";
    protected static final String ANT_LIB_DIR = "lib";
    protected static final String ANT_LAUNCHER_JAR = "ant-launcher.jar";
    protected static final String BUILD_ENGINE_PLUGIN_ID = "com.ibm.team.build.engine";
    protected static final String JAVA_BIN_DIR = "bin";
    protected static final String JAVA_EXE_NAME = "java";
    protected static final String JAVA_EXE_NAME_WINDOWS = "java.exe";
    protected static final String CLASSPATH_ARG = "-classpath";

    @Override
    protected List<String> getCommandLine(IBuildRequest buildRequest) throws Exception {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.getJavaCommand(buildRequest));
        commandLine.add(CLASSPATH_ARG);
        commandLine.add(this.getClassPath(buildRequest));
        commandLine.addAll(this.getVmArgs(buildRequest));
        commandLine.add(ANT_LAUNCHER_CLASS);
        commandLine.addAll(this.getAntArgs(buildRequest));
        return commandLine;
    }

    @Override
    protected void validateProperties(IBuildRequest buildRequest) throws Exception {
        this.validateBuildFile(buildRequest);
        this.validateAntHome(buildRequest);
        this.validateAntArgs(buildRequest);
        this.validateJavaHome(buildRequest);
        this.validateWorkingDir(buildRequest);
    }

    private void validateAntArgs(IBuildRequest buildRequest) throws Exception {
        this.getAntArgs(buildRequest);
    }

    private void validateBuildFile(IBuildRequest buildRequest) throws InvalidPropertyValueException, MissingPropertyException, IOException {
        this.getBuildFile(buildRequest);
    }

    private File getAntHome(IBuildRequest buildRequest) throws Exception {
        IBuildConfigurationElement element = buildRequest.getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.ant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.antHome");
        if (property == null) {
            throw new MissingPropertyException(NLS.bind((String)Messages.CommandLineBuildParticipant_MISSING_PROPERTY_IN_CONFIG_ELEMENT, (Object)"com.ibm.team.build.ant.antHome", (Object)"com.ibm.team.build.ant"));
        }
        String antHomePropertyValue = property.getValue();
        if (antHomePropertyValue.length() < 1 && (antHomePropertyValue = this.getAntHomePath()) == null) {
            throw new Exception(Messages.AntBuildParticipant_ANT_DEFAULT_NOT_FOUND);
        }
        File antHome = new File(this.convertToPlatformSeparator(antHomePropertyValue));
        if (!antHome.exists()) {
            throw new InvalidPropertyValueException(NLS.bind((String)Messages.AntRequestHandler_LOCATION_MISSING, (Object)antHome, (Object)"com.ibm.team.build.ant.antHome"));
        }
        String launcherJarPath = this.getAntLauncherJarRelativePath();
        File launcher = new File(antHome, launcherJarPath);
        if (!launcher.exists()) {
            throw new InvalidPropertyValueException(NLS.bind((String)Messages.AntRequestHandler_LOCATION_MISSING_CONTENTS, (Object[])new String[]{antHome.getCanonicalPath(), "com.ibm.team.build.ant.antHome", launcherJarPath}));
        }
        return antHome;
    }

    private String getAntHomePath() {
        try {
            return this.getBundleLocation("org.apache.ant");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private File getBuildToolkitLocation() throws Exception {
        try {
            File file = new File(this.getPlatformLocation());
            return new File(file, ".." + File.separator + ".." + File.separator + "buildtoolkit");
        }
        catch (Exception exception) {
            throw new Exception(Messages.AntBuildParticipant_EXCEPTION_GETTING_TOOLKIT, exception);
        }
    }

    protected String getBundleLocation(String pluginId) throws IOException {
        String location = null;
        Bundle bundle = Platform.getBundle((String)pluginId);
        if (bundle != null) {
            URL entry = bundle.getEntry("/");
            URL resolvedUrl = FileLocator.resolve((URL)entry);
            Path path = new Path(resolvedUrl.getPath());
            path = path.removeTrailingSeparator();
            location = path.toOSString();
        }
        return location;
    }

    protected String getPlatformLocation() throws IOException {
        String platformLocation = null;
        Location location = Platform.getInstallLocation();
        if (location != null) {
            URL url = location.getURL();
            URL resolvedUrl = FileLocator.resolve((URL)url);
            Path path = new Path(resolvedUrl.getPath());
            path = path.removeTrailingSeparator();
            platformLocation = path.toOSString();
        }
        return platformLocation;
    }

    private void validateAntHome(IBuildRequest buildRequest) throws Exception {
        this.getAntHome(buildRequest);
    }

    private File getJavaHome(IBuildRequest buildRequest) throws InvalidPropertyValueException, IOException {
        IBuildConfigurationElement element = buildRequest.getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.ant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.javaHome");
        File javaHomeFile = new File(System.getProperty("java.home"));
        if (property != null && property.getValue().trim().length() > 0) {
            javaHomeFile = new File(this.convertToPlatformSeparator(property.getValue()));
            if (!javaHomeFile.exists()) {
                throw new InvalidPropertyValueException(NLS.bind((String)Messages.AntRequestHandler_LOCATION_MISSING, (Object)javaHomeFile.getCanonicalPath(), (Object)"com.ibm.team.build.ant.javaHome"));
            }
            File javaExecutableFile = new File(javaHomeFile, this.getJavaExecutableRelativePath());
            if (!javaExecutableFile.exists()) {
                throw new InvalidPropertyValueException(NLS.bind((String)Messages.AntRequestHandler_LOCATION_MISSING_CONTENTS, (Object[])new String[]{javaHomeFile.getCanonicalPath(), "com.ibm.team.build.ant.javaHome", javaExecutableFile.getCanonicalPath()}));
            }
        }
        return javaHomeFile;
    }

    private void validateJavaHome(IBuildRequest buildRequest) throws InvalidPropertyValueException, IOException {
        this.getJavaHome(buildRequest);
    }

    @Override
    protected Exception getMissingWorkingDirException(File file) throws IOException {
        return new InvalidPropertyValueException(NLS.bind((String)Messages.CommandLineBuildParticipant_WORKING_DIR_DOES_NOT_EXIST, (Object)file.getCanonicalPath(), (Object)"com.ibm.team.build.ant.workingDir"));
    }

    @Override
    protected IConfigurationProperty getWorkingDirProperty(IBuildRequest request) {
        IBuildConfigurationElement element = request.getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.ant");
        return element.getConfigurationProperty("com.ibm.team.build.ant.workingDir");
    }

    protected String getJavaExecutableName() {
        String os = System.getProperty("os.name");
        if (os.toLowerCase().indexOf("windows") >= 0) {
            return JAVA_EXE_NAME_WINDOWS;
        }
        return JAVA_EXE_NAME;
    }

    protected List<String> getAntArgs(IBuildRequest buildRequest) throws Exception {
        String targetsString;
        ArrayList<String> antArgs = new ArrayList<String>();
        File buildFile = this.getBuildFile(buildRequest);
        antArgs.add("-f");
        antArgs.add(buildFile.getCanonicalPath());
        antArgs.add("-propertyfile");
        antArgs.add(this.getPropertiesFile());
        String userArgs = this.getAntProperty(buildRequest, "com.ibm.team.build.ant.antArgs");
        if (userArgs != null) {
            String[] tokens = QuotedStringTokenizer.getTokens(userArgs);
            int i = 0;
            while (i < tokens.length) {
                antArgs.add(tokens[i]);
                ++i;
            }
        }
        if (this.shouldIncludeToolkitInAntLib(buildRequest)) {
            File buildToolkitPath = this.getBuildToolkitLocation();
            if (!buildToolkitPath.exists()) {
                throw new Exception(NLS.bind((String)Messages.AntBuildParticipant_TOOLKIT_NOT_FOUND, (Object)buildToolkitPath.getCanonicalPath()));
            }
            antArgs.add("-lib");
            antArgs.add(buildToolkitPath.getCanonicalPath());
        }
        if ((targetsString = this.getAntProperty(buildRequest, "com.ibm.team.build.ant.targets")).trim().length() > 0) {
            String[] targets;
            String[] stringArray = targets = targetsString.split(TARGET_SEPARATOR);
            int n = targets.length;
            int n2 = 0;
            while (n2 < n) {
                String target = stringArray[n2];
                antArgs.add(target.trim());
                ++n2;
            }
        }
        return antArgs;
    }

    private boolean shouldIncludeToolkitInAntLib(IBuildRequest buildRequest) {
        boolean includeToolkit = false;
        IBuildConfigurationElement element = buildRequest.getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.ant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.includeToolkit");
        if (property != null) {
            includeToolkit = Boolean.valueOf(property.getValue());
        }
        return includeToolkit;
    }

    protected List<String> getVmArgs(IBuildRequest buildRequest) {
        String host;
        ArrayList<String> vmArgs = new ArrayList<String>();
        String args = this.getAntProperty(buildRequest, "com.ibm.team.build.ant.javaVMArgs");
        if (args != null) {
            String[] tokens = QuotedStringTokenizer.getTokens(args);
            int i = 0;
            while (i < tokens.length) {
                vmArgs.add(tokens[i]);
                ++i;
            }
        }
        if ((host = System.getProperty("http.proxyHost")) != null) {
            String port = System.getProperty("http.proxyPort", "80");
            vmArgs.add(NLS.bind((String)"-D{0}={1}", (Object)"http.proxyHost", (Object)host));
            vmArgs.add(NLS.bind((String)"-D{0}={1}", (Object)"http.proxyPort", (Object)port));
        }
        if ((host = System.getProperty("https.proxyHost")) != null) {
            String port = System.getProperty("https.proxyPort", "443");
            vmArgs.add(NLS.bind((String)"-D{0}={1}", (Object)"https.proxyHost", (Object)host));
            vmArgs.add(NLS.bind((String)"-D{0}={1}", (Object)"https.proxyPort", (Object)port));
        }
        return vmArgs;
    }

    private String getClassPath(IBuildRequest buildRequest) throws Exception {
        File antHome = this.getAntHome(buildRequest);
        return new File(antHome, this.getAntLauncherJarRelativePath()).getCanonicalPath();
    }

    private String getJavaCommand(IBuildRequest buildRequest) throws InvalidPropertyValueException, IOException {
        return new File(this.getJavaHome(buildRequest), this.getJavaExecutableRelativePath()).getCanonicalPath();
    }

    private String getAntProperty(IBuildRequest buildRequest, String propertyName) {
        IBuildConfigurationElement element = buildRequest.getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.ant");
        IConfigurationProperty property = element.getConfigurationProperty(propertyName);
        if (property == null) {
            return "";
        }
        return property.getValue();
    }

    private File getBuildFile(IBuildRequest buildRequest) throws InvalidPropertyValueException, MissingPropertyException, IOException {
        IBuildConfigurationElement element = buildRequest.getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.ant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.buildFile");
        if (property == null) {
            throw new MissingPropertyException(NLS.bind((String)Messages.CommandLineBuildParticipant_MISSING_PROPERTY_IN_CONFIG_ELEMENT, (Object)"com.ibm.team.build.ant.buildFile", (Object)"com.ibm.team.build.ant"));
        }
        String buildFile = property.getValue();
        if (buildFile.length() < 1) {
            throw new InvalidPropertyValueException("com.ibm.team.build.ant.buildFile", buildFile, buildRequest.getBuildDefinitionInstance().getBuildDefinitionId());
        }
        File file = new File(this.convertToPlatformSeparator(buildFile));
        if (!file.exists()) {
            throw new InvalidPropertyValueException(NLS.bind((String)Messages.AntRequestHandler_LOCATION_MISSING, (Object)file.getCanonicalPath(), (Object)"com.ibm.team.build.ant.buildFile"));
        }
        return file;
    }

    protected String getAntLauncherJarRelativePath() {
        return ANT_LIB_DIR + File.separator + ANT_LAUNCHER_JAR;
    }

    protected String getJavaExecutableRelativePath() {
        return JAVA_BIN_DIR + File.separator + this.getJavaExecutableName();
    }

    @Override
    protected String getPropertiesFileFromProperty(IBuildRequest buildRequest) {
        String propertiesFile = null;
        IBuildConfigurationElement element = buildRequest.getBuildDefinitionInstance().getConfigurationElement("com.ibm.team.build.ant");
        IConfigurationProperty property = element.getConfigurationProperty("com.ibm.team.build.ant.propertiesFile");
        if (property != null && property.getValue().trim().length() > 0) {
            propertiesFile = this.convertToPlatformSeparator(property.getValue().trim());
        }
        return propertiesFile;
    }

    private String convertToPlatformSeparator(String input) {
        String converted = null;
        if (input != null) {
            converted = input.replace("/", File.separator);
            converted = converted.replace("\\", File.separator);
        }
        return converted;
    }
}

