/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.helper;

import com.ibm.team.build.internal.common.helper.ValidationHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FileHelper {
    static {
        new FileHelper();
    }

    private FileHelper() {
    }

    public static String fileToString(String filePath) throws IOException, IllegalArgumentException {
        ValidationHelper.validateNotNull("filePath", filePath);
        ValidationHelper.validateNotEmpty("filePath", filePath);
        return FileHelper.fileToString(new File(filePath));
    }

    public static String fileToString(File file) throws IOException, IllegalArgumentException {
        ValidationHelper.validateNotNull("file", file);
        StringBuffer fileContents = new StringBuffer();
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            byte[] buffer = new byte[4096];
            int bytesRead = inputStream.read(buffer);
            while (bytesRead != -1) {
                fileContents.append(new String(buffer, 0, bytesRead));
                bytesRead = inputStream.read(buffer);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return fileContents.toString();
    }

    public static void stringToFile(String fileContents, String filePath) throws IOException, IllegalArgumentException {
        ValidationHelper.validateNotNull("fileContents", fileContents);
        ValidationHelper.validateNotEmpty("fileContents", fileContents);
        ValidationHelper.validateNotNull("filePath", filePath);
        ValidationHelper.validateNotEmpty("filePath", filePath);
        FileHelper.stringToFile(fileContents, new File(filePath));
    }

    public static void stringToFile(String fileContents, File file) throws IOException, IllegalArgumentException {
        ValidationHelper.validateNotNull("fileContents", fileContents);
        ValidationHelper.validateNotEmpty("fileContents", fileContents);
        ValidationHelper.validateNotNull("file", file);
        File parentFile = file.getParentFile();
        if (parentFile != null) {
            parentFile.mkdirs();
        }
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(file);
            outputStream.write(fileContents.getBytes());
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }
}

