/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.build.internal.common.events;

import com.ibm.team.build.common.model.BuildState;
import com.ibm.team.build.common.model.BuildStatus;
import com.ibm.team.build.common.model.IBuildResult;
import com.ibm.team.build.internal.common.events.BuildChangeEvent;
import com.ibm.team.build.internal.common.helper.ValidationHelper;
import com.ibm.team.build.internal.common.l10n.Messages;
import com.ibm.team.build.internal.common.model.BuildResult;
import com.ibm.team.repository.common.IChangeEvent;

public abstract class BuildResultEvent
extends BuildChangeEvent {
    protected static final String KEY_PREFIX = "build.IBuildResult.";
    public static final String KEY_BUILD_DEFINITION_ID = "build.IBuildResult.buildDefinitionId";
    public static final String KEY_BUILD_STATUS = "build.IBuildResult.status";
    public static final String KEY_BUILD_STATE = "build.IBuildResult.state";
    public static final String KEY_BUILD_LABEL = "build.IBuildResult.label";
    public static final String KEY_BUILD_REQUESTOR_ID = "build.IBuildResult.requestorId";
    public static final String KEY_PERSONAL_BUILD = "build.IBuildResult.personalBuild";
    public static final String KEY_BUILD_TAGS = "build.IBuildResult.tags";

    protected BuildResultEvent(IChangeEvent changeEvent, boolean isLookbackEvent) {
        super(changeEvent, isLookbackEvent);
        if (IBuildResult.ITEM_TYPE != changeEvent.getItem().getItemType()) {
            throw new IllegalArgumentException(Messages.getCommonString("BuildResultEvent.0"));
        }
    }

    public String getBuildDefinitionId() {
        String value = this.getChangeEvent().getStringExtension(KEY_BUILD_DEFINITION_ID);
        if (value instanceof String) {
            return value;
        }
        return null;
    }

    public BuildStatus getBuildStatus() {
        String value = this.getChangeEvent().getStringExtension(KEY_BUILD_STATUS);
        if (value instanceof String) {
            return BuildStatus.valueOf(value);
        }
        return null;
    }

    public BuildState getBuildState() {
        String value = this.getChangeEvent().getStringExtension(KEY_BUILD_STATE);
        if (value instanceof String) {
            return BuildState.valueOf(value);
        }
        return null;
    }

    public String getBuildLabel() {
        String value = this.getChangeEvent().getStringExtension(KEY_BUILD_LABEL);
        if (value instanceof String) {
            return value;
        }
        return null;
    }

    public String getBuildTags() {
        String value = this.getChangeEvent().getStringExtension(KEY_BUILD_TAGS);
        if (value instanceof String) {
            return value;
        }
        return "";
    }

    public String getRequestorId() {
        return this.getChangeEvent().getStringExtension(KEY_BUILD_REQUESTOR_ID);
    }

    public boolean isPersonalBuild() {
        String isPersonalBuild = this.getChangeEvent().getStringExtension(KEY_PERSONAL_BUILD);
        return isPersonalBuild.equals("true");
    }

    public static void setBuildResultStateExtensions(IChangeEvent event, IBuildResult buildResult, String buildDefinitionId, String requestorId) {
        ValidationHelper.validateNotNull("event", event);
        ValidationHelper.validateNotNull("buildResult", buildResult);
        buildResult.getBuildRequests();
        BuildResultEvent.setStateExtension(event, KEY_BUILD_DEFINITION_ID, buildDefinitionId);
        BuildResultEvent.setStateExtension(event, KEY_BUILD_STATUS, buildResult.getStatus().name());
        BuildResultEvent.setStateExtension(event, KEY_BUILD_STATE, ((BuildResult)buildResult).getState().name());
        BuildResultEvent.setStateExtension(event, KEY_BUILD_LABEL, buildResult.getLabel());
        BuildResultEvent.setStateExtension(event, KEY_PERSONAL_BUILD, Boolean.toString(buildResult.isPersonalBuild()));
        BuildResultEvent.setStateExtension(event, KEY_BUILD_TAGS, buildResult.getTags());
        if (requestorId != null && requestorId.length() > 0) {
            BuildResultEvent.setStateExtension(event, KEY_BUILD_REQUESTOR_ID, requestorId);
        }
    }
}

