/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.IProcessAttachment;
import com.ibm.team.process.common.IProcessAttachmentHandle;
import com.ibm.team.process.common.IProcessDefinition;
import com.ibm.team.process.internal.common.NLS;
import com.ibm.team.process.internal.common.model.AbstractModel;
import com.ibm.team.process.internal.common.util.Messages;
import com.ibm.team.process.internal.common.util.ProcessExporter;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProcessDefinitionExporter
extends ProcessExporter {
    public static final String VERSION_1 = "1";
    public static final String VERSION_2 = "2";
    private final IDefinitionExportContext fContext;
    private final IProcessDefinition fDefinition;

    public ProcessDefinitionExporter(IProcessDefinition definition, IDefinitionExportContext context) {
        this.fDefinition = definition;
        this.fContext = context;
    }

    public ProcessExporter.IProcessExportContext getContext() {
        return this.fContext;
    }

    public void exportProcessContainerToDirectory(String directoryPath, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        IContent state;
        Map processData;
        IContent spec;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IProcessAttachmentHandle[] attachmentHandles = this.fDefinition.getAttachments();
        monitor.beginTask("", attachmentHandles.length * 1000 + 400);
        String name = this.fDefinition.getName();
        String contentPath = this.fDefinition.getProcessContentPath();
        String summary = this.fDefinition.getDescription().getSummary();
        String processId = this.fDefinition.getProcessId();
        IContent description = this.fDefinition.getDescription().getDetails();
        File selectedDir = new File(directoryPath);
        if (!selectedDir.exists()) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionExportUtil.1"), directoryPath));
        }
        if (!selectedDir.isDirectory()) {
            throw new TeamRepositoryException(NLS.bind(Messages.getCommonString("ProcessDefinitionExportUtil.2"), directoryPath));
        }
        File baseDir = this.createDirectory(selectedDir, processId != null ? processId : name);
        this.writeStringToFile(baseDir, "name.txt", name);
        if (contentPath != null && contentPath.length() > 0) {
            this.writeStringToFile(baseDir, "contentURL.txt", contentPath);
        }
        if (processId != null && processId.length() > 0) {
            this.writeStringToFile(baseDir, "processId.txt", processId);
        }
        if (summary != null && summary.length() > 0) {
            this.writeStringToFile(baseDir, "summary.txt", summary);
        }
        if (description != null) {
            this.writeFile(baseDir, "description.txt", description, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        }
        if ((spec = (IContent)(processData = this.fDefinition.getProcessData()).get("com.ibm.team.internal.process.compiled.xml")) != null) {
            this.writeFile(baseDir, "specification.txt", spec, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        }
        if ((state = (IContent)processData.get("com.ibm.team.internal.process.state.xml")) != null) {
            this.writeFile(baseDir, "state.txt", state, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        }
        if (attachmentHandles.length > 0) {
            StringBuffer buffer = new StringBuffer();
            File attachmentDir = this.createDirectory(baseDir, "attachments");
            List attachments = this.fContext.fetchCompleteItems(Arrays.asList(attachmentHandles), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            int i = 0;
            for (IProcessAttachment attachment : attachments) {
                Path path = new Path(attachment.getPath());
                buffer.append(path.toString()).append(System.getProperty("line.separator"));
                IContent content = attachment.getContent();
                StringBuffer fileName = new StringBuffer(Integer.toString(i++));
                String extension = path.getFileExtension();
                if (extension != null) {
                    fileName.append('.').append(extension);
                }
                this.writeFile(attachmentDir, fileName.toString(), content, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
            this.writeStringToFile(baseDir, "attachments.txt", buffer.toString());
        }
        this.writeStringToFile(baseDir, "components.txt", this.computeComponentModelContent());
        this.writeStringToFile(baseDir, "version.txt", VERSION_2);
    }

    public void exportProcessContainerToArchive(File exportDirectory, File archivePath, IProgressMonitor monitor) throws TeamRepositoryException, IOException {
        this.exportProcessContainerToDirectory(exportDirectory.toString(), monitor);
        this.createZip(exportDirectory, archivePath);
    }

    public String computeComponentModelContent() throws IOException {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element root = document.createElement("components");
            document.appendChild(root);
            IExtension[] extensions = this.fContext.getComponentExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if ("component".equals(element.getName())) {
                        IConfigurationElement[] models = element.getChildren("model");
                        int k = 0;
                        while (k < models.length) {
                            IConfigurationElement model = models[k];
                            String modelURI = model.getAttribute("uri");
                            String modelVersion = model.getAttribute("version");
                            if (modelURI != null && modelVersion != null) {
                                Element component = document.createElement("component");
                                component.setAttribute("uri", modelURI);
                                component.setAttribute("version", modelVersion);
                                root.appendChild(component);
                            }
                            ++k;
                        }
                    }
                    ++j;
                }
                ++i;
            }
            return AbstractModel.serializeDocument(document);
        }
        catch (TransformerException e) {
            throw new IOException(e.getMessage());
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static interface IDefinitionExportContext
    extends ProcessExporter.IProcessExportContext {
        public IExtension[] getComponentExtensions();
    }
}

