/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.util;

import com.ibm.team.process.common.IBehaviorConfiguration;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IIterationConfiguration;
import com.ibm.team.process.common.IIterationType;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.process.common.IRole;
import com.ibm.team.process.common.IRole2;
import com.ibm.team.process.common.ISimpleMap;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.process.common.ITeamAreaHierarchy;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.process.common.advice.IAdvisorDeclaration;
import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProjectOperation;
import com.ibm.team.process.common.advice.TeamOperationCanceledException;
import com.ibm.team.process.internal.common.CurrentIterationInfo;
import com.ibm.team.process.internal.common.ItemHandleAwareHashMap;
import com.ibm.team.process.internal.common.RolePersistence;
import com.ibm.team.process.internal.common.advice.AdvicePackage;
import com.ibm.team.process.internal.common.advice.ConfigurationSource;
import com.ibm.team.process.internal.common.advice.PermissionSource;
import com.ibm.team.process.internal.common.advice.runtime.ILicenseChecker;
import com.ibm.team.process.internal.common.advice.runtime.OperationAdviceManager;
import com.ibm.team.process.internal.common.model.ElementBuilderDirectives;
import com.ibm.team.process.internal.common.model.ModelGenerator;
import com.ibm.team.process.internal.common.model.customization.IterationTypeConfiguration;
import com.ibm.team.process.internal.common.model.customization.TeamCustomizationModel;
import com.ibm.team.process.internal.common.model.settings.BehaviorElement;
import com.ibm.team.process.internal.common.model.settings.BehaviorRoleElement;
import com.ibm.team.process.internal.common.model.settings.ChangeEventConfiguration;
import com.ibm.team.process.internal.common.model.settings.IterationConfiguration;
import com.ibm.team.process.internal.common.model.settings.OperationBehaviorConfiguration;
import com.ibm.team.process.internal.common.model.settings.OperationConfiguration;
import com.ibm.team.process.internal.common.model.settings.OperationPermissionsConfiguration;
import com.ibm.team.process.internal.common.model.settings.PermissionActionElement;
import com.ibm.team.process.internal.common.model.settings.PermissionsElement;
import com.ibm.team.process.internal.common.model.settings.PermissionsRoleElement;
import com.ibm.team.process.internal.common.model.settings.ProcessConfiguration;
import com.ibm.team.process.internal.common.model.specification.ConfigurationDataElement;
import com.ibm.team.process.internal.common.model.specification.DataElement;
import com.ibm.team.process.internal.common.model.specification.DevelopmentLineConfiguration;
import com.ibm.team.process.internal.common.model.specification.InitializationElement;
import com.ibm.team.process.internal.common.model.specification.ProcessSpecificationModel;
import com.ibm.team.process.internal.common.model.specification.ProjectConfigurationElement;
import com.ibm.team.process.internal.common.model.specification.TeamConfigurationElement;
import com.ibm.team.process.internal.common.util.Messages;
import com.ibm.team.process.internal.common.util.ProcessModelCache;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class AbstractProcess {
    public static final String ID_ENFORCE_PROCESS_PERMISSIONS = "com.ibm.team.process.enforceProcessPermissions";
    private static final int PERMISSIONS_TYPE = 0;
    private static final int BEHAVIOR_TYPE = 1;
    private static final int CHANGE_EVENT_TYPE = 2;
    protected IProjectArea fProjectArea;
    protected static final HashSet fgInitializingThreads = new HashSet();
    private ProcessModelCache fModelCache;
    public static final IRole fgDefaultRole = new IRole2(){

        public String getId() {
            return "default";
        }

        public String getDescription() {
            return Messages.getCommonString("AbstractProcess.0");
        }

        public int getCardinality() {
            return 0;
        }

        public String getRoleName() {
            return Messages.getCommonString("AbstractProcess.13");
        }

        public String getRoleLabel() {
            String label = this.getRoleName();
            if (label != null && label.trim().length() > 0) {
                return label;
            }
            return this.getId();
        }
    };

    protected AbstractProcess(IProjectArea projectArea, ProcessModelCache modelCache) {
        this.fProjectArea = projectArea;
        this.fModelCache = modelCache;
    }

    protected abstract String createStringFromContent(IContent var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected abstract IContributorHandle getContributor();

    protected abstract CurrentIterationInfo[] getCurrentIterationInfos(IDevelopmentLine var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected abstract IItem fetchCompleteItem(IItemHandle var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected abstract IDevelopmentLine getDevelopmentLine(IProcessArea var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected abstract OperationAdviceManager getOperationAdviceManager();

    protected abstract ILicenseChecker getLicenseChecker();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOperationReport executeInitializer(ProjectOperation initializer, IProgressMonitor monitor) throws TeamRepositoryException {
        HashSet hashSet;
        IOperationReport iOperationReport;
        monitor = this.getProgressMonitor(monitor);
        this.assertSameProjectArea(initializer.getProcessArea());
        monitor.beginTask("", 1000);
        try {
            OperationBehaviorConfiguration behavior = this.getInitializationBehaviorConfiguration(initializer.getOperationIdentifier(), (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            ItemHandleAwareHashMap permissions = new ItemHandleAwareHashMap();
            HashSet hashSet2 = fgInitializingThreads;
            synchronized (hashSet2) {
                fgInitializingThreads.add(Thread.currentThread());
            }
            iOperationReport = this.getOperationAdviceManager().advise(initializer, 1, permissions, behavior, null, (IProgressMonitor)new SubProgressMonitor(monitor, 950));
            hashSet = fgInitializingThreads;
        }
        catch (Throwable throwable) {
            HashSet hashSet3 = fgInitializingThreads;
            synchronized (hashSet3) {
                fgInitializingThreads.remove(Thread.currentThread());
            }
            monitor.done();
            throw throwable;
        }
        synchronized (hashSet) {
            fgInitializingThreads.remove(Thread.currentThread());
        }
        monitor.done();
        return iOperationReport;
    }

    public IOperationReport advise(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.doAdvise(operation, 0, null, monitor);
    }

    public IOperationReport adviseAndExecute(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.doAdvise(operation, 1, null, monitor);
    }

    protected IOperationReport doAdvise(AdvisableOperation operation, int mode, IOperationReport oldReport, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        this.assertSameProjectArea(operation.getProcessArea());
        monitor.beginTask("", 1000);
        try {
            try {
                this.getLicenseChecker().assertLicense(operation.getOperationIdentifier(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            catch (LicenseNotGrantedException e) {
                TeamOperationCanceledException exception = this.getOperationAdviceManager().createLicenseNotGrantedException(e, operation, mode);
                throw exception;
            }
            IDevelopmentLine line = this.getOperationDevelopmentLine(operation.getProcessArea(), operation.getDevelopmentLine(), (IProgressMonitor)new SubProgressMonitor(monitor, 25));
            operation.setDevelopmentLine(line);
            ISimpleMap permissions = this.getPermissionsMap(operation, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
            OperationBehaviorConfiguration behavior = this.getBehaviorConfiguration(operation, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
            IOperationReport iOperationReport = this.getOperationAdviceManager().advise(operation, mode, permissions, behavior, oldReport, (IProgressMonitor)new SubProgressMonitor(monitor, 925));
            return iOperationReport;
        }
        finally {
            monitor.done();
        }
    }

    public IAdvisorDeclaration[] getAdvisorDeclarations(IBehaviorConfiguration configuration) {
        if (configuration instanceof OperationBehaviorConfiguration) {
            return this.getOperationAdviceManager().getAdvisorDeclarations((OperationBehaviorConfiguration)configuration);
        }
        return new IAdvisorDeclaration[0];
    }

    public IAdvisorDeclaration[] getAdvisorDeclarations(IProcessArea processArea, String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            IDevelopmentLine line = this.getDevelopmentLine(processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            OperationBehaviorConfiguration behaviorConfiguration = this.getBehaviorConfiguration(processArea, line, operationId, (IProgressMonitor)new SubProgressMonitor(monitor, 900));
            IAdvisorDeclaration[] iAdvisorDeclarationArray = this.getAdvisorDeclarations(behaviorConfiguration);
            return iAdvisorDeclarationArray;
        }
        finally {
            monitor.done();
        }
    }

    public IAdvisorDeclaration[] getAdvisorDeclarations(String projectOperationId, IProgressMonitor monitor) throws TeamRepositoryException {
        OperationBehaviorConfiguration behaviorConfiguration = this.getStaticBehaviorConfiguration(this.fProjectArea, projectOperationId, monitor);
        return this.getAdvisorDeclarations(behaviorConfiguration);
    }

    public boolean[] getPermittedActions(IProcessArea processArea, String operationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        List<String> actionList = Arrays.asList(actions);
        IDevelopmentLine line = this.getDevelopmentLine(processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        boolean[] permitted = new boolean[actions.length];
        HashSet permittedActions = new HashSet();
        OperationPermissionsConfiguration[] permissionConfigs = this.getPermissionConfigurations(processArea, line, operationId, actions, (IProgressMonitor)new SubProgressMonitor(monitor, 900));
        if (permissionConfigs != null) {
            int i = 0;
            while (i < permissionConfigs.length && permittedActions.size() < actions.length) {
                OperationPermissionsConfiguration config = permissionConfigs[i];
                permittedActions.addAll(this.getPermittedActions(actionList, config));
                ++i;
            }
            i = 0;
            while (i < actions.length) {
                permitted[i] = permittedActions.contains(actions[i]);
                ++i;
            }
        }
        return permitted;
    }

    public boolean[] getPermittedActions(String projectOperationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        List<String> actionList = Arrays.asList(actions);
        boolean[] permitted = new boolean[actions.length];
        HashSet permittedActions = new HashSet();
        OperationPermissionsConfiguration[] permissionConfigs = this.getStaticPermissionConfigurations(this.fProjectArea, projectOperationId, actions, monitor);
        if (permissionConfigs != null) {
            int i = 0;
            while (i < permissionConfigs.length && permittedActions.size() < actions.length) {
                OperationPermissionsConfiguration config = permissionConfigs[i];
                permittedActions.addAll(this.getPermittedActions(actionList, config));
                ++i;
            }
            i = 0;
            while (i < actions.length) {
                permitted[i] = permittedActions.contains(actions[i]);
                ++i;
            }
        }
        return permitted;
    }

    protected ISimpleMap getPermissionsMap(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            ItemHandleAwareHashMap permissions = new ItemHandleAwareHashMap();
            IProcessArea primaryArea = operation.getProcessArea();
            String operationId = operation.getOperationIdentifier();
            OperationPermissionsConfiguration[] permissionConfigs = operation instanceof ProjectOperation ? this.getStaticPermissionConfigurations((IProjectArea)operation.getProcessArea(), operation.getOperationIdentifier(), operation.getActions(), (IProgressMonitor)new SubProgressMonitor(monitor, 500)) : this.getPermissionConfigurations(primaryArea, operation.getDevelopmentLine(), operationId, operation.getActions(), (IProgressMonitor)new SubProgressMonitor(monitor, 250));
            if (permissionConfigs != null) {
                permissions.put(primaryArea, permissionConfigs);
            }
            IProcessArea[] secondaryAreas = operation.getSecondaryProcessAreas();
            SubProgressMonitor secondaryMonitor = new SubProgressMonitor(monitor, 500);
            secondaryMonitor.beginTask("", 1000 * secondaryAreas.length);
            int i = 0;
            while (i < secondaryAreas.length) {
                IProcessArea secondaryArea = secondaryAreas[i];
                this.assertSameProjectArea(secondaryArea);
                String[] secondaryActions = operation.getSecondaryActions(secondaryArea);
                IDevelopmentLine secondaryLine = this.getOperationDevelopmentLine(secondaryArea, operation.getSecondaryDevelopmentLine(secondaryArea), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)secondaryMonitor, 250));
                permissionConfigs = this.getPermissionConfigurations(secondaryArea, secondaryLine, operationId, secondaryActions, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)secondaryMonitor, 750));
                if (permissionConfigs != null) {
                    permissions.put(secondaryArea, permissionConfigs);
                }
                ++i;
            }
            ItemHandleAwareHashMap itemHandleAwareHashMap = permissions;
            return itemHandleAwareHashMap;
        }
        finally {
            monitor.done();
        }
    }

    public IProcessConfigurationData getProjectConfigurationData(String configPointId, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            this.fProjectArea = (IProjectArea)this.fetchCompleteItem((IItemHandle)this.getProjectArea(), (IProgressMonitor)new SubProgressMonitor(monitor, 500));
            IContent content = (IContent)this.fProjectArea.getProcessData().get("com.ibm.team.internal.process.compiled.xml");
            if (content != null) {
                ConfigurationDataElement[] configurations = this.computeConfigurationData(this.createStringFromContent(content, (IProgressMonitor)new SubProgressMonitor(monitor, 500)));
                int i = 0;
                while (i < configurations.length) {
                    ConfigurationDataElement configuration = configurations[i];
                    if (configuration.getId().equals(configPointId)) {
                        ConfigurationDataElement configurationDataElement = configuration;
                        return configurationDataElement;
                    }
                    ++i;
                }
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }

    private ConfigurationDataElement[] computeConfigurationData(String specification) {
        DataElement data;
        ProcessSpecificationModel model = new ProcessSpecificationModel();
        Exception exception = model.initialize(specification);
        if (exception != null) {
            throw new IllegalArgumentException(exception.getMessage());
        }
        ProjectConfigurationElement projectConfiguration = model.getProjectConfiguration();
        if (projectConfiguration != null && (data = projectConfiguration.getData()) != null) {
            return data.getConfigurationData();
        }
        return new ConfigurationDataElement[0];
    }

    protected ProcessSpecificationModel getSpecificationModel(IProjectArea projectArea, IContent content, final IDevelopmentLine line, final CurrentIterationInfo[] currentIterationInfos, IProgressMonitor monitor) throws TeamRepositoryException {
        ProcessSpecificationModel model = (ProcessSpecificationModel)this.fModelCache.get(projectArea, content, line, currentIterationInfos);
        if (model == null) {
            Exception exception;
            model = new ProcessSpecificationModel(){

                protected ModelGenerator createModelGenerator() {
                    ModelGenerator generator = super.createModelGenerator();
                    generator.setDirective(ElementBuilderDirectives.DEVELOPMENT_LINE, line);
                    generator.setDirective(ElementBuilderDirectives.ITERATION_PATH_INFOS, currentIterationInfos);
                    return generator;
                }
            };
            if (content != null && (exception = model.initialize(this.createStringFromContent(content, monitor))) != null) {
                throw new IllegalArgumentException(exception.getMessage());
            }
            this.fModelCache.put(projectArea, content, line, currentIterationInfos, model);
        }
        return model;
    }

    protected TeamCustomizationModel getCustomizationModel(ITeamArea teamArea, IContent content, final IDevelopmentLine line, final CurrentIterationInfo[] currentIterationInfos, IProgressMonitor monitor) throws TeamRepositoryException {
        TeamCustomizationModel model = (TeamCustomizationModel)this.fModelCache.get(teamArea, content, line, currentIterationInfos);
        if (model == null) {
            Exception exception;
            model = new TeamCustomizationModel(){

                protected ModelGenerator createModelGenerator() {
                    ModelGenerator generator = super.createModelGenerator();
                    generator.setDirective(ElementBuilderDirectives.DEVELOPMENT_LINE, line);
                    generator.setDirective(ElementBuilderDirectives.ITERATION_PATH_INFOS, currentIterationInfos);
                    return generator;
                }
            };
            if (content != null && (exception = model.initialize(this.createStringFromContent(content, monitor))) != null) {
                throw new IllegalArgumentException(exception.getMessage());
            }
            this.fModelCache.put(teamArea, content, line, currentIterationInfos, model);
        }
        return model;
    }

    protected OperationBehaviorConfiguration getStaticBehaviorConfiguration(IProjectArea projectArea, String operationIdentifier, IProgressMonitor monitor) throws TeamRepositoryException {
        ProcessSpecificationModel model;
        ProjectConfigurationElement projectConfiguration;
        this.assertSameProjectArea(projectArea);
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.1"), 1000);
        projectArea = (IProjectArea)this.fetchCompleteItem((IItemHandle)projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 300));
        IContent content = (IContent)projectArea.getProcessData().get("com.ibm.team.internal.process.compiled.xml");
        if (content != null && (projectConfiguration = (model = this.getSpecificationModel(projectArea, content, null, null, (IProgressMonitor)new SubProgressMonitor(monitor, 300))).getProjectConfiguration()) != null) {
            IRole[] roles = this.getContributorRoles(this.getContributor(), projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
            int i = 0;
            while (i < roles.length) {
                IRole role = roles[i];
                String roleId = role.getId();
                OperationBehaviorConfiguration operation = this.getBehaviorOperation(projectConfiguration.getBehavior(), roleId, operationIdentifier);
                if (operation != null) {
                    ConfigurationSource source = AdvicePackage.eINSTANCE.getAdviceFactory().createConfigurationSource();
                    source.setSourceArea(projectArea);
                    source.setSourceAreaItemUuid(projectArea.getItemId().getUuidValue());
                    source.setContentKey("com.ibm.team.internal.process.compiled.xml");
                    if (role instanceof IRole2) {
                        source.setRoleId(((IRole2)role).getRoleLabel());
                    } else {
                        source.setRoleId(roleId);
                    }
                    source.setContentUuid(content.getContentId().getUuidValue());
                    operation = (OperationBehaviorConfiguration)operation.createCopyWithSource(source);
                    return operation;
                }
                ++i;
            }
        }
        return null;
    }

    protected ChangeEventConfiguration getStaticChangeEventConfiguration(IProjectArea projectArea, String eventId, IProgressMonitor monitor) throws TeamRepositoryException {
        ChangeEventConfiguration configuration;
        ProcessSpecificationModel model;
        ProjectConfigurationElement projectConfiguration;
        this.assertSameProjectArea(projectArea);
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.2"), 1000);
        projectArea = (IProjectArea)this.fetchCompleteItem((IItemHandle)projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 300));
        IContent content = (IContent)projectArea.getProcessData().get("com.ibm.team.internal.process.compiled.xml");
        if (content != null && (projectConfiguration = (model = this.getSpecificationModel(projectArea, content, null, null, (IProgressMonitor)new SubProgressMonitor(monitor, 300))).getProjectConfiguration()) != null && (configuration = this.getChangeEvent(projectConfiguration.getBehavior(), eventId)) != null) {
            return configuration;
        }
        return null;
    }

    protected OperationPermissionsConfiguration[] getStaticPermissionConfigurations(IProjectArea projectArea, String operationIdentifier, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<OperationPermissionsConfiguration> roleConfigurations;
        ArrayList<OperationPermissionsConfiguration> permissionConfigurations;
        ArrayList<String> remainingActions;
        block13: {
            this.assertSameProjectArea(projectArea);
            monitor = this.getProgressMonitor(monitor);
            monitor.beginTask(Messages.getCommonString("AbstractProcess.3"), 1000);
            remainingActions = new ArrayList<String>();
            int i = 0;
            while (i < actions.length) {
                remainingActions.add(actions[i]);
                ++i;
            }
            permissionConfigurations = new ArrayList<OperationPermissionsConfiguration>();
            roleConfigurations = new ArrayList<OperationPermissionsConfiguration>();
            try {
                ProcessSpecificationModel model;
                ProjectConfigurationElement projectConfiguration;
                if (!this.shouldCheckPermissions((IProgressMonitor)new SubProgressMonitor(monitor, 10))) {
                    OperationPermissionsConfiguration[] operationPermissionsConfigurationArray = this.createAnyPermissions();
                    return operationPermissionsConfigurationArray;
                }
                IContent content = (IContent)(projectArea = (IProjectArea)this.fetchCompleteItem((IItemHandle)projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 290))).getProcessData().get("com.ibm.team.internal.process.compiled.xml");
                if (content == null || (projectConfiguration = (model = this.getSpecificationModel(projectArea, content, null, null, (IProgressMonitor)new SubProgressMonitor(monitor, 300))).getProjectConfiguration()) == null) break block13;
                IRole[] roles = this.getContributorRoles(this.getContributor(), projectArea, (IProgressMonitor)new SubProgressMonitor(monitor, 400));
                int i2 = 0;
                while (i2 < roles.length) {
                    IRole role = roles[i2];
                    String roleId = role.getId();
                    OperationPermissionsConfiguration operation = this.getPermissionOperation(projectConfiguration.getPermissions(), roleId, operationIdentifier);
                    if (operation != null) {
                        PermissionSource source = AdvicePackage.eINSTANCE.getAdviceFactory().createPermissionSource();
                        source.setSourceArea(projectArea);
                        source.setSourceAreaItemUuid(projectArea.getItemId().getUuidValue());
                        source.setContentKey("com.ibm.team.internal.process.compiled.xml");
                        if (role instanceof IRole2) {
                            source.setRoleId(((IRole2)role).getRoleLabel());
                        } else {
                            source.setRoleId(roleId);
                        }
                        source.setContentUuid(content.getContentId().getUuidValue());
                        operation = (OperationPermissionsConfiguration)operation.createCopyWithSource(source);
                        roleConfigurations.add(operation);
                        List permitted = this.getPermittedActions(remainingActions, operation);
                        if (permitted.size() > 0) {
                            remainingActions.removeAll(permitted);
                            source.setPermittedActions(permitted.toArray(new String[permitted.size()]));
                            permissionConfigurations.add(operation);
                        }
                        if (remainingActions.size() == 0) {
                            break;
                        }
                    }
                    ++i2;
                }
            }
            finally {
                monitor.done();
            }
        }
        if (remainingActions.size() == 0) {
            return permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
        }
        return roleConfigurations.toArray(new OperationPermissionsConfiguration[roleConfigurations.size()]);
    }

    protected OperationBehaviorConfiguration getBehaviorConfiguration(AdvisableOperation operation, IProgressMonitor monitor) throws TeamRepositoryException {
        if (operation instanceof ProjectOperation) {
            return this.getStaticBehaviorConfiguration((IProjectArea)operation.getProcessArea(), operation.getOperationIdentifier(), monitor);
        }
        return this.getBehaviorConfiguration(operation.getProcessArea(), operation.getDevelopmentLine(), operation.getOperationIdentifier(), monitor);
    }

    public OperationBehaviorConfiguration getBehaviorConfiguration(IProcessArea startingArea, IDevelopmentLine developmentLine, String operationId, IProgressMonitor monitor) throws TeamRepositoryException {
        return (OperationBehaviorConfiguration)this.getBehaviorOrEventConfiguration(startingArea, developmentLine, operationId, 1, monitor);
    }

    protected ChangeEventConfiguration getChangeEventConfiguration(IProcessArea startingArea, IDevelopmentLine developmentLine, String eventId) throws TeamRepositoryException {
        return (ChangeEventConfiguration)this.getBehaviorOrEventConfiguration(startingArea, developmentLine, eventId, 2, null);
    }

    public ProcessConfiguration getBehaviorOrEventConfiguration(IProcessArea startingArea, IDevelopmentLine line, String configurationId, int configurationType, IProgressMonitor monitor) throws TeamRepositoryException {
        this.assertSameProjectArea(startingArea);
        if (configurationType == 0) {
            throw new IllegalArgumentException(Messages.getCommonString("AbstractProcess.4"));
        }
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.5"), 1000);
        try {
            CurrentIterationInfo[] currentIterationInfos = null;
            if (line != null) {
                currentIterationInfos = this.getCurrentIterationInfos(line, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
            IRole[] roles = this.getContributorRoles(this.getContributor(), startingArea, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            this.fProjectArea = (IProjectArea)this.fetchCompleteItem((IItemHandle)this.getProjectArea(), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            SubProgressMonitor rolesMonitor = new SubProgressMonitor(monitor, 960);
            rolesMonitor.beginTask("", 1000 * roles.length);
            int i = 0;
            while (i < roles.length) {
                IRole role = roles[i];
                ProcessConfiguration configuration = null;
                IContent content = (IContent)this.fProjectArea.getProcessData().get("com.ibm.team.internal.process.compiled.xml");
                if (content != null) {
                    configuration = this.getCurrentProcessConfiguration(this.fProjectArea, content, line, currentIterationInfos, role, configurationId, startingArea, "com.ibm.team.internal.process.compiled.xml", configurationType, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)rolesMonitor, 100));
                }
                if (configuration != null && configuration.isFinal()) {
                    ProcessConfiguration processConfiguration = configuration;
                    return processConfiguration;
                }
                ProcessConfiguration lowerConfig = null;
                content = (IContent)this.fProjectArea.getProcessData().get("com.ibm.team.internal.process.settings.xml");
                if (content != null) {
                    lowerConfig = this.getCurrentProcessConfiguration(this.fProjectArea, content, line, currentIterationInfos, role, configurationId, startingArea, "com.ibm.team.internal.process.compiled.xml", configurationType, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)rolesMonitor, 100));
                }
                if (lowerConfig != null && (configuration = lowerConfig).isFinal()) {
                    ProcessConfiguration processConfiguration = configuration;
                    return processConfiguration;
                }
                List teamAreaHandles = this.computeTeamAreaPath(startingArea);
                int numAreas = teamAreaHandles.size();
                SubProgressMonitor hierarchyMonitor = new SubProgressMonitor((IProgressMonitor)rolesMonitor, 700);
                hierarchyMonitor.beginTask("", 1000 * numAreas);
                int j = numAreas - 1;
                while (j >= 0) {
                    ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)teamAreaHandles.get(j);
                    ITeamArea teamArea = (ITeamArea)this.fetchCompleteItem((IItemHandle)teamAreaHandle, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)hierarchyMonitor, 500));
                    content = (IContent)teamArea.getProcessData().get("com.ibm.team.internal.process.settings.xml");
                    if (content != null) {
                        lowerConfig = this.getCurrentProcessConfiguration(teamArea, content, line, currentIterationInfos, role, configurationId, startingArea, "com.ibm.team.internal.process.compiled.xml", configurationType, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)hierarchyMonitor, 500));
                    }
                    if (lowerConfig != null && (configuration = lowerConfig).isFinal()) {
                        ProcessConfiguration processConfiguration = configuration;
                        return processConfiguration;
                    }
                    --j;
                }
                hierarchyMonitor.done();
                if (configuration != null) {
                    ProcessConfiguration processConfiguration = configuration;
                    return processConfiguration;
                }
                ++i;
            }
        }
        finally {
            monitor.done();
        }
        return null;
    }

    public OperationPermissionsConfiguration[] getPermissionConfigurations(IProcessArea startingArea, IDevelopmentLine line, String configurationId, String[] actions, IProgressMonitor monitor) throws TeamRepositoryException {
        this.assertSameProjectArea(startingArea);
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.7"), 1000);
        ArrayList<String> remainingActions = new ArrayList<String>();
        int i = 0;
        while (i < actions.length) {
            remainingActions.add(actions[i]);
            ++i;
        }
        ArrayList<ProcessConfiguration> permissionConfigurations = new ArrayList<ProcessConfiguration>();
        ArrayList<ProcessConfiguration> roleConfigurations = new ArrayList<ProcessConfiguration>();
        try {
            if (!this.shouldCheckPermissions((IProgressMonitor)new SubProgressMonitor(monitor, 10))) {
                OperationPermissionsConfiguration[] operationPermissionsConfigurationArray = this.createAnyPermissions();
                return operationPermissionsConfigurationArray;
            }
            CurrentIterationInfo[] currentIterationInfos = null;
            if (line != null) {
                currentIterationInfos = this.getCurrentIterationInfos(line, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            }
            IRole[] roles = this.getContributorRoles(this.getContributor(), startingArea, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            this.fProjectArea = (IProjectArea)this.fetchCompleteItem((IItemHandle)this.getProjectArea(), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            SubProgressMonitor rolesMonitor = new SubProgressMonitor(monitor, 960);
            rolesMonitor.beginTask("", 1000 * roles.length);
            int i2 = 0;
            while (i2 < roles.length) {
                IRole role = roles[i2];
                ProcessConfiguration configuration = null;
                IContent content = (IContent)this.fProjectArea.getProcessData().get("com.ibm.team.internal.process.compiled.xml");
                if (content != null) {
                    configuration = (OperationPermissionsConfiguration)this.getCurrentProcessConfiguration(this.fProjectArea, content, line, currentIterationInfos, role, configurationId, startingArea, "com.ibm.team.internal.process.compiled.xml", 0, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)rolesMonitor, 100));
                }
                if (configuration != null && configuration.isFinal()) {
                    roleConfigurations.add(configuration);
                    List permitted = this.getPermittedActions(remainingActions, (OperationPermissionsConfiguration)configuration);
                    if (permitted.size() > 0) {
                        ((PermissionSource)((OperationConfiguration)configuration).getSource()).setPermittedActions(permitted.toArray(new String[permitted.size()]));
                        remainingActions.removeAll(permitted);
                        permissionConfigurations.add(configuration);
                        if (remainingActions.size() == 0) {
                            OperationPermissionsConfiguration[] operationPermissionsConfigurationArray = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                            return operationPermissionsConfigurationArray;
                        }
                    }
                } else {
                    OperationPermissionsConfiguration lowerConfig = null;
                    content = (IContent)this.fProjectArea.getProcessData().get("com.ibm.team.internal.process.settings.xml");
                    if (content != null) {
                        lowerConfig = (OperationPermissionsConfiguration)this.getCurrentProcessConfiguration(this.fProjectArea, content, line, currentIterationInfos, role, configurationId, startingArea, "com.ibm.team.internal.process.compiled.xml", 0, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)rolesMonitor, 100));
                    }
                    if (lowerConfig != null && (configuration = lowerConfig).isFinal()) {
                        roleConfigurations.add(configuration);
                        List permitted = this.getPermittedActions(remainingActions, (OperationPermissionsConfiguration)configuration);
                        if (permitted.size() > 0) {
                            ((PermissionSource)((OperationConfiguration)configuration).getSource()).setPermittedActions(permitted.toArray(new String[permitted.size()]));
                            remainingActions.removeAll(permitted);
                            permissionConfigurations.add(configuration);
                            if (remainingActions.size() == 0) {
                                OperationPermissionsConfiguration[] operationPermissionsConfigurationArray = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                                return operationPermissionsConfigurationArray;
                            }
                        }
                    } else {
                        List teamAreaHandles = this.computeTeamAreaPath(startingArea);
                        int numAreas = teamAreaHandles.size();
                        SubProgressMonitor hierarchyMonitor = new SubProgressMonitor((IProgressMonitor)rolesMonitor, 700);
                        hierarchyMonitor.beginTask("", 1000 * numAreas);
                        int j = numAreas - 1;
                        while (j >= 0) {
                            ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)teamAreaHandles.get(j);
                            ITeamArea teamArea = (ITeamArea)this.fetchCompleteItem((IItemHandle)teamAreaHandle, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)hierarchyMonitor, 500));
                            content = (IContent)teamArea.getProcessData().get("com.ibm.team.internal.process.settings.xml");
                            if (content != null) {
                                lowerConfig = (OperationPermissionsConfiguration)this.getCurrentProcessConfiguration(teamArea, content, line, currentIterationInfos, role, configurationId, startingArea, "com.ibm.team.internal.process.compiled.xml", 0, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)hierarchyMonitor, 500));
                            }
                            if (lowerConfig != null && (configuration = lowerConfig).isFinal()) {
                                roleConfigurations.add(configuration);
                                break;
                            }
                            --j;
                        }
                        hierarchyMonitor.done();
                        if (configuration != null) {
                            List permitted;
                            if (!configuration.isFinal()) {
                                roleConfigurations.add(configuration);
                            }
                            if ((permitted = this.getPermittedActions(remainingActions, (OperationPermissionsConfiguration)configuration)).size() > 0) {
                                ((PermissionSource)((OperationConfiguration)configuration).getSource()).setPermittedActions(permitted.toArray(new String[permitted.size()]));
                                remainingActions.removeAll(permitted);
                                permissionConfigurations.add(configuration);
                                if (remainingActions.size() == 0) {
                                    OperationPermissionsConfiguration[] operationPermissionsConfigurationArray = permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
                                    return operationPermissionsConfigurationArray;
                                }
                            }
                        }
                    }
                }
                ++i2;
            }
        }
        finally {
            monitor.done();
        }
        if (remainingActions.size() == 0) {
            return permissionConfigurations.toArray(new OperationPermissionsConfiguration[permissionConfigurations.size()]);
        }
        return roleConfigurations.toArray(new OperationPermissionsConfiguration[roleConfigurations.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldCheckPermissions(IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            this.getLicenseChecker().assertLicense(ID_ENFORCE_PROCESS_PERMISSIONS, monitor);
        }
        catch (LicenseNotGrantedException licenseNotGrantedException) {
            return false;
        }
        HashSet hashSet = fgInitializingThreads;
        synchronized (hashSet) {
            block6: {
                if (!fgInitializingThreads.contains(Thread.currentThread())) break block6;
                return false;
            }
        }
        return true;
    }

    private OperationPermissionsConfiguration[] createAnyPermissions() {
        final PermissionActionElement anyAction = new PermissionActionElement(null, null, null, null){

            public String getId() {
                return "any";
            }
        };
        OperationPermissionsConfiguration anyConfig = new OperationPermissionsConfiguration(null, null, null, null){

            public PermissionActionElement[] getActions() {
                return new PermissionActionElement[]{anyAction};
            }
        };
        return new OperationPermissionsConfiguration[]{anyConfig};
    }

    protected ProcessConfiguration getCurrentProcessConfiguration(ITeamArea teamArea, IContent content, IDevelopmentLine line, CurrentIterationInfo[] currentIterationInfos, IRole role, String configurationId, IProcessArea startingArea, String contentKey, int configurationType, IProgressMonitor monitor) throws TeamRepositoryException {
        TeamCustomizationModel model = this.getCustomizationModel(teamArea, content, line, currentIterationInfos, monitor);
        String roleId = role.getId();
        ProcessConfiguration configuration = null;
        switch (configurationType) {
            case 1: {
                configuration = this.getBehaviorOperation(model.getBehavior(), roleId, configurationId);
                break;
            }
            case 0: {
                configuration = this.getPermissionOperation(model.getPermissions(), roleId, configurationId);
                break;
            }
            case 2: {
                configuration = this.getChangeEvent(model.getBehavior(), configurationId);
                break;
            }
            default: {
                return null;
            }
        }
        IterationTypeConfiguration[] typeConfigurations = model.getIterationTypeConfigurations();
        ProcessConfiguration lowerOperation = this.getCurrentOperationConfiguration(model.getIterationConfigurations(), currentIterationInfos, typeConfigurations, 0, roleId, configurationId, configurationType);
        if (lowerOperation != null) {
            configuration = lowerOperation;
        }
        if (configuration instanceof OperationConfiguration) {
            ConfigurationSource source = configurationType == 0 ? AdvicePackage.eINSTANCE.getAdviceFactory().createPermissionSource() : AdvicePackage.eINSTANCE.getAdviceFactory().createConfigurationSource();
            source.setSourceArea(teamArea);
            source.setSourceAreaItemUuid(teamArea.getItemId().getUuidValue());
            source.setContentKey(contentKey);
            if (role instanceof IRole2) {
                source.setRoleId(((IRole2)role).getRoleLabel());
            } else {
                source.setRoleId(roleId);
            }
            source.setContentUuid(content.getContentId().getUuidValue());
            source.setFinal(configuration.isFinal());
            configuration = ((OperationConfiguration)configuration).createCopyWithSource(source);
        }
        return configuration;
    }

    protected ProcessConfiguration getCurrentProcessConfiguration(IProjectArea projectArea, IContent content, IDevelopmentLine line, CurrentIterationInfo[] currentIterationInfos, IRole role, String operationId, IProcessArea startingArea, String contentKey, int configurationType, IProgressMonitor monitor) throws TeamRepositoryException {
        ProcessSpecificationModel model = this.getSpecificationModel(projectArea, content, line, currentIterationInfos, monitor);
        TeamConfigurationElement teamConfiguration = model.getTeamConfiguration();
        if (teamConfiguration == null) {
            return null;
        }
        String roleId = role.getId();
        ProcessConfiguration configuration = null;
        switch (configurationType) {
            case 1: {
                configuration = this.getBehaviorOperation(teamConfiguration.getBehavior(), roleId, operationId);
                break;
            }
            case 0: {
                configuration = this.getPermissionOperation(teamConfiguration.getPermissions(), roleId, operationId);
                break;
            }
            case 2: {
                configuration = this.getChangeEvent(teamConfiguration.getBehavior(), operationId);
                break;
            }
            default: {
                return null;
            }
        }
        if (line != null) {
            IterationTypeConfiguration[] typeConfigurations;
            ProcessConfiguration lowerConfig;
            DevelopmentLineConfiguration matchingLineConfig = null;
            DevelopmentLineConfiguration[] lineConfigs = teamConfiguration.getDevelopmentLineConfigurations();
            String lineId = line.getId();
            int i = 0;
            while (i < lineConfigs.length) {
                DevelopmentLineConfiguration lineConfig = lineConfigs[i];
                if (lineId.equals(lineConfig.getId())) {
                    matchingLineConfig = lineConfig;
                    break;
                }
                ++i;
            }
            if (matchingLineConfig != null) {
                ProcessConfiguration lowerConfig2;
                switch (configurationType) {
                    case 1: {
                        lowerConfig2 = this.getBehaviorOperation(matchingLineConfig.getBehavior(), roleId, operationId);
                        break;
                    }
                    case 0: {
                        lowerConfig2 = this.getPermissionOperation(matchingLineConfig.getPermissions(), roleId, operationId);
                        break;
                    }
                    case 2: {
                        lowerConfig2 = this.getChangeEvent(matchingLineConfig.getBehavior(), operationId);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                if (lowerConfig2 != null) {
                    configuration = lowerConfig2;
                }
            }
            IIterationConfiguration[] iterationConfigs = null;
            if (matchingLineConfig != null) {
                iterationConfigs = matchingLineConfig.getIterations();
            }
            if ((lowerConfig = this.getCurrentOperationConfiguration(iterationConfigs, currentIterationInfos, typeConfigurations = teamConfiguration.getIterationTypeConfigurations(), 0, roleId, operationId, configurationType)) != null) {
                configuration = lowerConfig;
            }
        }
        if (configuration instanceof OperationConfiguration) {
            ConfigurationSource source = configurationType == 0 ? AdvicePackage.eINSTANCE.getAdviceFactory().createPermissionSource() : AdvicePackage.eINSTANCE.getAdviceFactory().createConfigurationSource();
            source.setSourceArea(projectArea);
            source.setSourceAreaItemUuid(projectArea.getItemId().getUuidValue());
            source.setContentKey(contentKey);
            if (role instanceof IRole2) {
                source.setRoleId(((IRole2)role).getRoleLabel());
            } else {
                source.setRoleId(roleId);
            }
            source.setContentUuid(content.getContentId().getUuidValue());
            source.setFinal(configuration.isFinal());
            configuration = ((OperationConfiguration)configuration).createCopyWithSource(source);
        }
        return configuration;
    }

    private ProcessConfiguration getCurrentOperationConfiguration(IIterationConfiguration[] iterationConfigs, CurrentIterationInfo[] currentIterationInfos, IterationTypeConfiguration[] typeConfigs, int currentDepth, String roleId, String operationId, int configurationType) throws TeamRepositoryException {
        ProcessConfiguration configuration = null;
        if (currentIterationInfos != null && currentDepth < currentIterationInfos.length) {
            ProcessConfiguration lowerConfig;
            CurrentIterationInfo iterationInfo = currentIterationInfos[currentDepth];
            String currentId = iterationInfo.getIteration().getId();
            IterationConfiguration matchingIterationConfig = null;
            if (iterationConfigs != null) {
                int i = 0;
                block10: while (i < iterationConfigs.length) {
                    IterationConfiguration iterationConfig = (IterationConfiguration)iterationConfigs[i];
                    String id = iterationConfig.getId();
                    if (id != null && id.equals(currentId)) {
                        matchingIterationConfig = iterationConfig;
                        switch (configurationType) {
                            case 1: {
                                configuration = this.getBehaviorOperation(matchingIterationConfig.getBehavior(), roleId, operationId);
                                break block10;
                            }
                            case 0: {
                                configuration = this.getPermissionOperation(matchingIterationConfig.getPermissions(), roleId, operationId);
                                break block10;
                            }
                            case 2: {
                                configuration = this.getChangeEvent(matchingIterationConfig.getBehavior(), operationId);
                                break block10;
                            }
                            default: {
                                return null;
                            }
                        }
                    }
                    ++i;
                }
            }
            IIterationType iterationType = iterationInfo.getIterationType();
            if (configuration == null && iterationType != null) {
                int j = 0;
                block11: while (j < typeConfigs.length) {
                    IterationTypeConfiguration typeConfig = typeConfigs[j];
                    String configTypeId = typeConfig.getId();
                    if (configTypeId != null && configTypeId.equals(iterationType.getId())) {
                        switch (configurationType) {
                            case 1: {
                                configuration = this.getBehaviorOperation(typeConfig.getBehavior(), roleId, operationId);
                                break block11;
                            }
                            case 0: {
                                configuration = this.getPermissionOperation(typeConfig.getPermissions(), roleId, operationId);
                                break block11;
                            }
                            case 2: {
                                configuration = this.getChangeEvent(typeConfig.getBehavior(), operationId);
                                break block11;
                            }
                            default: {
                                return null;
                            }
                        }
                    }
                    ++j;
                }
            }
            IIterationConfiguration[] childConfigs = null;
            if (matchingIterationConfig != null) {
                childConfigs = matchingIterationConfig.getChildIterations();
            }
            if ((lowerConfig = this.getCurrentOperationConfiguration(childConfigs, currentIterationInfos, typeConfigs, currentDepth + 1, roleId, operationId, configurationType)) != null) {
                configuration = lowerConfig;
            }
        }
        return configuration;
    }

    private OperationPermissionsConfiguration getPermissionOperation(PermissionsElement permissions, String roleId, String operationId) {
        if (permissions != null) {
            PermissionsRoleElement[] roleElements = permissions.getRoleElements();
            int i = 0;
            while (i < roleElements.length) {
                PermissionsRoleElement roleElement = roleElements[i];
                if (roleElement.getId().equals(roleId)) {
                    OperationPermissionsConfiguration[] operations = roleElement.getOperations();
                    int j = 0;
                    while (j < operations.length) {
                        OperationPermissionsConfiguration operation = operations[j];
                        if (operation.getId().equals(operationId)) {
                            return operation;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private OperationBehaviorConfiguration getBehaviorOperation(BehaviorElement behavior, String roleId, String operationId) {
        if (behavior != null) {
            BehaviorRoleElement[] roleElements = behavior.getRoleElements();
            int i = 0;
            while (i < roleElements.length) {
                BehaviorRoleElement roleElement = roleElements[i];
                if (roleElement.getId().equals(roleId)) {
                    OperationBehaviorConfiguration[] operations = roleElement.getOperations();
                    int j = 0;
                    while (j < operations.length) {
                        OperationBehaviorConfiguration operation = operations[j];
                        if (operation.getId().equals(operationId)) {
                            return operation;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    private ChangeEventConfiguration getChangeEvent(BehaviorElement behavior, String eventId) {
        if (behavior != null) {
            ChangeEventConfiguration[] events = behavior.getChangeEventElements();
            int j = 0;
            while (j < events.length) {
                ChangeEventConfiguration event = events[j];
                if (event.getId().equals(eventId)) {
                    return event;
                }
                ++j;
            }
        }
        return null;
    }

    private List computeTeamAreaPath(IProcessArea processArea) {
        ArrayList<ITeamAreaHandle> teamAreaHandles = new ArrayList<ITeamAreaHandle>();
        if (processArea instanceof ITeamArea) {
            ITeamAreaHierarchy hierarchy = this.fProjectArea.getTeamAreaHierarchy();
            ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)((Object)processArea);
            while (teamAreaHandle != null) {
                teamAreaHandles.add(teamAreaHandle);
                teamAreaHandle = hierarchy.getParent(teamAreaHandle);
            }
        }
        return teamAreaHandles;
    }

    protected OperationBehaviorConfiguration getInitializationBehaviorConfiguration(String configPointId, IProgressMonitor monitor) throws TeamRepositoryException {
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask("", 1000);
        try {
            InitializationElement initialization;
            this.fProjectArea = (IProjectArea)this.fetchCompleteItem((IItemHandle)this.getProjectArea(), (IProgressMonitor)new SubProgressMonitor(monitor, 200));
            Map processData = this.fProjectArea.getProcessData();
            IContent content = (IContent)processData.get("com.ibm.team.internal.process.compiled.xml");
            if (content != null && (initialization = this.computeInitialization(this.createStringFromContent(content, (IProgressMonitor)new SubProgressMonitor(monitor, 800)))) != null) {
                OperationBehaviorConfiguration[] configurations = initialization.getOperations();
                int index = 0;
                while (index < configurations.length) {
                    OperationBehaviorConfiguration configuration = configurations[index];
                    if (configuration.getId().equals(configPointId)) {
                        ConfigurationSource source = AdvicePackage.eINSTANCE.getAdviceFactory().createConfigurationSource();
                        source.setSourceArea(this.fProjectArea);
                        source.setSourceAreaItemUuid(this.fProjectArea.getItemId().getUuidValue());
                        source.setContentKey("com.ibm.team.internal.process.compiled.xml");
                        source.setContentUuid(content.getContentId().getUuidValue());
                        OperationBehaviorConfiguration operationBehaviorConfiguration = configuration = (OperationBehaviorConfiguration)configuration.createCopyWithSource(source);
                        return operationBehaviorConfiguration;
                    }
                    ++index;
                }
            }
            return null;
        }
        finally {
            monitor.done();
        }
    }

    protected InitializationElement computeInitialization(String stateContentData) {
        ProcessSpecificationModel model = new ProcessSpecificationModel();
        Exception exception = model.initialize(stateContentData);
        if (exception != null) {
            throw new IllegalArgumentException(exception.getMessage());
        }
        ProjectConfigurationElement projectConfiguration = model.getProjectConfiguration();
        if (projectConfiguration != null) {
            return projectConfiguration.getInitialization();
        }
        return null;
    }

    public IRole[] getRoles(IProcessArea startingArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.assertSameProjectArea(startingArea);
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.9"), 1000);
        try {
            ArrayList<IRole> allRoles = new ArrayList<IRole>();
            this.fProjectArea = (IProjectArea)this.fetchCompleteItem((IItemHandle)this.getProjectArea(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            SubProgressMonitor hierarchyMonitor = new SubProgressMonitor(monitor, 700);
            hierarchyMonitor.beginTask("", 1000);
            if (startingArea instanceof ITeamArea) {
                ITeamAreaHierarchy hierarchy = this.fProjectArea.getTeamAreaHierarchy();
                ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)((Object)startingArea);
                while (teamAreaHandle != null) {
                    ITeamArea teamArea = (ITeamArea)this.fetchCompleteItem((IItemHandle)teamAreaHandle, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)hierarchyMonitor, 50));
                    this.addRoles(allRoles, teamArea, "com.ibm.team.internal.process.settings.xml", (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)hierarchyMonitor, 50));
                    teamAreaHandle = hierarchy.getParent(teamArea);
                }
            }
            hierarchyMonitor.done();
            this.addRoles(allRoles, this.fProjectArea, "com.ibm.team.internal.process.settings.xml", (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            this.addRoles(allRoles, this.fProjectArea, "com.ibm.team.internal.process.compiled.xml", (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            allRoles.add(fgDefaultRole);
            IRole[] iRoleArray = allRoles.toArray(new IRole[allRoles.size()]);
            return iRoleArray;
        }
        finally {
            monitor.done();
        }
    }

    private void addRoles(List allRoles, IProcessArea processArea, String contentKey, IProgressMonitor monitor) throws TeamRepositoryException {
        IRole[] areaRoles = this.getRoles(processArea, contentKey, monitor);
        int i = 0;
        while (i < areaRoles.length) {
            if (!this.containsRole(allRoles, areaRoles[i])) {
                allRoles.add(areaRoles[i]);
            }
            ++i;
        }
    }

    protected boolean containsRole(List roles, IRole role) {
        for (IRole existing : roles) {
            if (!role.getId().equals(existing.getId())) continue;
            return true;
        }
        return false;
    }

    public IRole[] getContributorRoles(IContributorHandle contributor, IProcessArea startingArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.assertSameProjectArea(startingArea);
        monitor = this.getProgressMonitor(monitor);
        monitor.beginTask(Messages.getCommonString("AbstractProcess.10"), 1000);
        RolePersistence rolePersistence = new RolePersistence(this.getRoles(startingArea, (IProgressMonitor)new SubProgressMonitor(monitor, 100)));
        ArrayList<IRole> assignedRoles = new ArrayList<IRole>();
        this.fProjectArea = (IProjectArea)this.fetchCompleteItem((IItemHandle)this.getProjectArea(), (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        SubProgressMonitor hierarchyMonitor = new SubProgressMonitor(monitor, 700);
        hierarchyMonitor.beginTask("", 1000);
        if (startingArea instanceof ITeamArea) {
            ITeamAreaHierarchy hierarchy = this.fProjectArea.getTeamAreaHierarchy();
            ITeamAreaHandle teamAreaHandle = (ITeamAreaHandle)((Object)startingArea);
            while (teamAreaHandle != null) {
                ITeamArea teamArea = (ITeamArea)this.fetchCompleteItem((IItemHandle)teamAreaHandle, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)hierarchyMonitor, 50));
                this.addContributorRoles(assignedRoles, teamArea, contributor, rolePersistence, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)hierarchyMonitor, 50));
                teamAreaHandle = hierarchy.getParent(teamArea);
            }
        }
        hierarchyMonitor.done();
        this.addContributorRoles(assignedRoles, this.fProjectArea, contributor, rolePersistence, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
        assignedRoles.add(fgDefaultRole);
        return assignedRoles.toArray(new IRole[assignedRoles.size()]);
    }

    private void addContributorRoles(List allRoles, IProcessArea processArea, IContributorHandle contributor, RolePersistence rolePersistance, IProgressMonitor monitor) throws TeamRepositoryException {
        IRole[] foundRoles;
        String roleData = RolePersistence.getPersistentRoleData(processArea.getTeamData(), contributor);
        if (roleData != null && (foundRoles = rolePersistance.deserialize(roleData)) != null && foundRoles.length > 0) {
            int i = 0;
            while (i < foundRoles.length) {
                if (!this.containsRole(allRoles, foundRoles[i])) {
                    allRoles.add(foundRoles[i]);
                }
                ++i;
            }
        }
    }

    protected IRole[] getRoles(IProcessArea processArea, String contentKey, IProgressMonitor monitor) throws TeamRepositoryException {
        IContent content = (IContent)processArea.getProcessData().get(contentKey);
        if (content != null) {
            if (processArea instanceof ITeamArea) {
                TeamCustomizationModel model = this.getCustomizationModel((ITeamArea)processArea, content, null, null, monitor);
                return model.getRoleDefinitions();
            }
            ProcessSpecificationModel model = this.getSpecificationModel((IProjectArea)processArea, content, null, null, monitor);
            return model.getRoleDefinitions();
        }
        return new IRole[0];
    }

    private List getPermittedActions(List actions, OperationPermissionsConfiguration configuration) {
        return OperationAdviceManager.getPermittedActions(actions, configuration);
    }

    protected IDevelopmentLine getOperationDevelopmentLine(IProcessArea processArea, IDevelopmentLine operationLine, IProgressMonitor monitor) throws TeamRepositoryException {
        if (processArea instanceof ITeamArea) {
            return this.getDevelopmentLine(processArea, monitor);
        }
        IDevelopmentLine line = this.getDevelopmentLine(processArea, monitor);
        if (line != null) {
            return line;
        }
        return operationLine;
    }

    protected void assertSameProjectArea(IProcessArea processArea) {
        if (processArea == null) {
            throw new IllegalArgumentException(Messages.getCommonString("AbstractProcess.11"));
        }
        IProjectAreaHandle actual = processArea.getProjectArea();
        if (!this.getProjectArea().sameItemId((IItemHandle)actual)) {
            throw new IllegalArgumentException(Messages.getCommonString("AbstractProcess.12"));
        }
    }

    public IProjectArea getProjectArea() {
        return this.fProjectArea;
    }

    protected IProgressMonitor getProgressMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }
}

