/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.process.internal.common.model.customization;

import com.ibm.team.process.internal.common.ITeamConfiguration;
import com.ibm.team.process.internal.common.InternalProcessCommon;
import com.ibm.team.process.internal.common.model.AbstractElementBuilder;
import com.ibm.team.process.internal.common.model.AbstractModel;
import com.ibm.team.process.internal.common.model.ElementBuilderDirectives;
import com.ibm.team.process.internal.common.model.ModelGenerator;
import com.ibm.team.process.internal.common.model.customization.IterationTypeConfiguration;
import com.ibm.team.process.internal.common.model.customization.TeamCustomizationBuilder;
import com.ibm.team.process.internal.common.model.customization.TeamCustomizationElement;
import com.ibm.team.process.internal.common.model.settings.BehaviorElement;
import com.ibm.team.process.internal.common.model.settings.IterationConfiguration;
import com.ibm.team.process.internal.common.model.settings.PermissionsElement;
import java.io.IOException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TeamCustomizationModel
extends AbstractModel {
    public static final int COMPLETE = 2;
    public static final int NO_PROCESS_CONFIGURATIONS = 4;
    private final int fFlags;

    public TeamCustomizationModel() {
        this(2);
    }

    public TeamCustomizationModel(int flags) {
        this.fFlags = flags;
    }

    protected ModelGenerator createModelGenerator() {
        ModelGenerator generator = new ModelGenerator(this);
        if ((this.fFlags & 4) != 0) {
            generator.setDirective(ElementBuilderDirectives.ITERATION_STRUCTURE_ONLY, Boolean.TRUE);
        }
        return generator;
    }

    public TeamCustomizationElement getRoot() {
        List childElements = this.getChildElements();
        if (childElements.size() > 0) {
            return (TeamCustomizationElement)childElements.get(0);
        }
        return null;
    }

    public PermissionsElement getPermissions() {
        TeamCustomizationElement root = this.getRoot();
        if (root != null) {
            return root.getPermissions();
        }
        return null;
    }

    public BehaviorElement getBehavior() {
        TeamCustomizationElement root = this.getRoot();
        if (root != null) {
            return root.getBehavior();
        }
        return null;
    }

    public IterationConfiguration[] getIterationConfigurations() {
        TeamCustomizationElement root = this.getRoot();
        if (root != null) {
            return root.getIterationConfigurations();
        }
        return new IterationConfiguration[0];
    }

    public IterationTypeConfiguration[] getIterationTypeConfigurations() {
        TeamCustomizationElement root = this.getRoot();
        if (root != null) {
            return root.getIterationTypeConfigurations();
        }
        return new IterationTypeConfiguration[0];
    }

    public IterationTypeConfiguration getIterationTypeConfiguration(String interationTypeId) {
        TeamCustomizationElement root = this.getRoot();
        if (root != null) {
            return root.getIterationTypeConfiguration(interationTypeId);
        }
        return null;
    }

    public static String toXMLData(TeamCustomizationElement customization) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = customization.createElement(document);
            root.setAttribute("xmlns", "http://com.ibm.team.process");
            document.appendChild(root);
            return AbstractModel.serializeDocument(document);
        }
        catch (ParserConfigurationException e) {
            InternalProcessCommon.log(e);
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException();
        }
        catch (TransformerException e) {
            InternalProcessCommon.log(e);
        }
        catch (IOException e) {
            InternalProcessCommon.log(e);
        }
        return null;
    }

    public AbstractElementBuilder getRootBuilder() {
        return new TeamCustomizationBuilder();
    }

    public ITeamConfiguration getTeamConfiguration() {
        return this.getRoot();
    }
}

