/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.util.LocationUtil;
import com.ibm.team.repository.common.transport.HostUtil;
import com.ibm.team.repository.common.transport.HttpUtil;
import com.ibm.team.repository.common.transport.TeamServiceException;
import com.ibm.team.repository.transport.client.ClientHttpUtil;
import com.ibm.team.repository.transport.client.IOAuthHandler;
import com.ibm.team.repository.transport.client.ITeamRawRestServiceClient;
import com.ibm.team.repository.transport.client.ReleasingAndAbortingInputStream;
import com.ibm.team.repository.transport.client.RemoteTeamServer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.HashMap;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class RestClientConnectionBase {
    protected final RemoteTeamServer _remoteTeamServer;
    protected final String _repoUri;
    protected final URI _requestUri;
    protected final IOAuthHandler _oauthHandler;
    protected final String _proxyUriRoot;
    protected final String _blankPageUri;
    protected final HashMap<String, String> _headers = new HashMap();
    protected HttpMethod _httpMethod = null;
    private ITeamRawRestServiceClient.IRawRestClientConnection.Response _response = null;
    private static final String UserAgent = RestClientConnectionBase.class.getName();
    private static final String PROXY_CONTEXT_SEGMENT = "proxy";
    private static final String SLASH = "/";
    private static final Log logger = LogFactory.getLog(RestClientConnectionBase.class);

    protected RestClientConnectionBase(RemoteTeamServer server, URI uri, IOAuthHandler handler) throws URISyntaxException {
        if (server == null) {
            throw new IllegalArgumentException("server must not be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("relUri must not be null");
        }
        this._repoUri = RestClientConnectionBase.getRepoUri(server);
        this._requestUri = uri.isAbsolute() ? uri : new URI(String.valueOf(RestClientConnectionBase.getRepoUri(server)) + RestClientConnectionBase.trimLeadingSlash(uri.toString()));
        this._remoteTeamServer = server;
        this._oauthHandler = handler;
        this._proxyUriRoot = RestClientConnectionBase.buildProxyUri(server);
        this._blankPageUri = String.valueOf(this._repoUri) + "web/com.ibm.team.repository.web/ui/internal/oauth/OAuthRedirectPopup.html";
    }

    public void addRequestHeader(String name, String value) {
        if (this._httpMethod != null) {
            throw new IllegalStateException("Cannot add request headers to a connection has been previously run");
        }
        if (name == null || name.length() == 0) {
            return;
        }
        if (value == null) {
            value = "";
        }
        this._headers.put(name, value);
    }

    public ITeamRawRestServiceClient.IRawRestClientConnection.Response doGet() throws TeamServiceException, TeamRepositoryException {
        return this.doMethod((HttpMethod)new GetMethod());
    }

    public ITeamRawRestServiceClient.IRawRestClientConnection.Response doHead() throws TeamServiceException, TeamRepositoryException {
        return this.doMethod((HttpMethod)new HeadMethod());
    }

    public ITeamRawRestServiceClient.IRawRestClientConnection.Response doPost(InputStream content, long contentLength, String contentType) throws TeamServiceException, TeamRepositoryException {
        PostMethod postMethod = new PostMethod();
        InputStreamRequestEntity requestEntity = new InputStreamRequestEntity((InputStream)new BufferedInputStream(content, 16384), contentType);
        postMethod.setRequestEntity((RequestEntity)requestEntity);
        return this.doMethod((HttpMethod)postMethod);
    }

    public ITeamRawRestServiceClient.IRawRestClientConnection.Response doPut(InputStream content, long contentLength, String contentType) throws TeamServiceException, TeamRepositoryException {
        PutMethod putMethod = new PutMethod();
        InputStreamRequestEntity requestEntity = new InputStreamRequestEntity((InputStream)new BufferedInputStream(content, 16384), contentType);
        putMethod.setRequestEntity((RequestEntity)requestEntity);
        return this.doMethod((HttpMethod)putMethod);
    }

    public ITeamRawRestServiceClient.IRawRestClientConnection.Response doDelete() throws TeamServiceException, TeamRepositoryException {
        return this.doMethod((HttpMethod)new DeleteMethod());
    }

    protected ITeamRawRestServiceClient.IRawRestClientConnection.Response doMethod(HttpMethod method) throws TeamServiceException, TeamRepositoryException {
        TeamRepositoryException caughtException;
        int status;
        block8: {
            if (this._httpMethod != null) {
                throw new IllegalStateException("do* called multiple times on the same connection");
            }
            this._httpMethod = method;
            this.prepareMethod();
            status = -1;
            caughtException = null;
            try {
                status = this.executeMethod();
            }
            catch (TeamRepositoryException e) {
                caughtException = e;
                if (!this._httpMethod.hasBeenUsed()) break block8;
                status = this._httpMethod.getStatusCode();
            }
        }
        Header[] headers = this._httpMethod.getResponseHeaders();
        HashMap<String, String> headersMap = new HashMap<String, String>(headers.length);
        Header[] headerArray = headers;
        int n = headers.length;
        int n2 = 0;
        while (n2 < n) {
            Header header = headerArray[n2];
            headersMap.put(header.getName(), header.getValue());
            ++n2;
        }
        ReleasingAndAbortingInputStream responseStream = null;
        try {
            responseStream = new ReleasingAndAbortingInputStream(this._httpMethod);
        }
        catch (IOException e) {
            this._httpMethod.releaseConnection();
            throw new TeamServiceException(e.getMessage(), (Throwable)e);
        }
        String statusText = null;
        if (this._httpMethod.hasBeenUsed()) {
            statusText = this._httpMethod.getStatusText();
        }
        this._response = new ITeamRawRestServiceClient.IRawRestClientConnection.Response(responseStream, headersMap, status, statusText);
        if (caughtException != null) {
            throw caughtException;
        }
        return this._response;
    }

    protected void prepareMethod() throws TeamServiceException {
        String userid;
        this._httpMethod.setDoAuthentication(true);
        try {
            URI uri = this.bindProxyUri();
            String formatString = "%s";
            if (uri.getQuery() != null) {
                formatString = String.valueOf(formatString) + "?%s";
            }
            if (uri.getFragment() != null) {
                formatString = String.valueOf(formatString) + "#%s";
            }
            try {
                uri = new URI(String.format(formatString, uri.getRawPath(), uri.getRawQuery(), uri.getRawFragment()));
            }
            catch (URISyntaxException e) {
                logger.warn((Object)String.format("URISyntaxException parsing URI: %s", e.getMessage()));
            }
            this._httpMethod.setPath(uri.toASCIIString());
        }
        catch (IllegalStateException e) {
            throw new TeamServiceException(e.getMessage(), (Throwable)e);
        }
        catch (TeamRepositoryException e) {
            throw new TeamServiceException(e.getMessage(), (Throwable)e);
        }
        this._httpMethod.setRequestHeader("http.useragent", UserAgent);
        if (this._httpMethod.getRequestHeader("Accept") == null) {
            this._httpMethod.setRequestHeader("Accept", HttpUtil.MediaType.XML.toString());
        }
        if (this._httpMethod.getRequestHeader("Accept-Charset") == null) {
            this._httpMethod.setRequestHeader("Accept-Charset", HttpUtil.CharsetEncoding.UTF8.toString());
        }
        if (this._httpMethod.getRequestHeader("Accept-Language") == null) {
            ClientHttpUtil.setAcceptLanguageHeader(this._httpMethod);
        }
        if ((userid = this._remoteTeamServer.getUserid()) != null) {
            try {
                userid = URLEncoder.encode(userid, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            this._httpMethod.addRequestHeader("X-com-ibm-team-userid", userid);
        }
        for (String key : this._headers.keySet()) {
            String value = this._headers.get(key);
            this._httpMethod.setRequestHeader(key, value);
        }
    }

    public ITeamRawRestServiceClient.IRawRestClientConnection.Response getResponse() {
        return this._response;
    }

    /*
     * Exception decompiling
     */
    protected int executeMethod() throws TeamServiceException, TeamRepositoryException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected URI bindProxyUri() throws TeamRepositoryException {
        try {
            boolean equivalentApps;
            String uri = this._requestUri.toString();
            URI repoUri = new URI(this._repoUri);
            boolean bl = equivalentApps = HostUtil.authorityEquiv((URI)repoUri, (URI)this._requestUri) && RestClientConnectionBase.startsWithPath(this._requestUri, repoUri);
            if (!equivalentApps) {
                uri = String.format("%s?uri=%s", this._proxyUriRoot, LocationUtil.encode((String)uri));
                return new URI(uri);
            }
            return this._requestUri;
        }
        catch (URISyntaxException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new TeamRepositoryException((Throwable)e);
        }
    }

    private static boolean startsWithPath(URI baseUri, URI compareUri) {
        String basePath;
        String comparePath = compareUri.getPath();
        if (comparePath == null) {
            comparePath = "";
        }
        if (!comparePath.endsWith(SLASH)) {
            comparePath = String.valueOf(comparePath) + SLASH;
        }
        if ((basePath = baseUri.getPath()) == null) {
            basePath = "";
        }
        if (!basePath.endsWith(SLASH)) {
            basePath = String.valueOf(basePath) + SLASH;
        }
        return basePath.startsWith(comparePath);
    }

    private static String buildProxyUri(RemoteTeamServer server) {
        String repoUri = server.getRepositoryURL();
        return String.valueOf(repoUri) + PROXY_CONTEXT_SEGMENT;
    }

    private static String getRepoUri(RemoteTeamServer server) {
        String repoUri = server.getRepositoryURL();
        return repoUri;
    }

    private static String trimLeadingSlash(String uri) {
        if (uri == null) {
            return uri;
        }
        if (uri.startsWith(SLASH) || uri.startsWith(SLASH)) {
            if (uri.length() > 1) {
                return uri.substring(1);
            }
            uri = new String();
        }
        return uri;
    }
}

