/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.common.transport.AbstractTeamServer;
import com.ibm.team.repository.common.transport.ComponentConfiguration;
import com.ibm.team.repository.common.transport.ICertificateValidator;
import com.ibm.team.repository.common.transport.ITeamRestService;
import com.ibm.team.repository.common.transport.ITeamService;
import com.ibm.team.repository.common.transport.TeamServerConfiguration;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.auth.TransportAuthUtil;
import com.ibm.team.repository.transport.client.IOAuthHandler;
import com.ibm.team.repository.transport.client.InterruptableSocketFactory;
import com.ibm.team.repository.transport.client.RemoteTeamRestService;
import com.ibm.team.repository.transport.client.RemoteTeamService;
import com.ibm.team.repository.transport.client.SecureInterruptableSocketFactory;
import com.ibm.team.repository.transport.internal.nls.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteTeamServer
extends AbstractTeamServer {
    private static final String NLS_REMOTE_TEAM_SERVER_CLOSING_CONNECTIONS = "_NoId.RemoteTeamServer.ClosingConnections";
    private static final String BACK_SLASH_REGEXP = "\\\\";
    private static final String OS_NAME_PROP = "os.name";
    private static final String OS_WINDOWS = "WINDOWS";
    private static final String COMPUTER_NAME_EV = "ComputerName";
    private MultiThreadedHttpConnectionManager connectionManager;
    private HttpClient httpClient;
    private final String repoProtocol;
    private final String repoHost;
    private int repoPort;
    private final String repoPath;
    private final AuthScope authScope;
    private final int defaultPort;
    private final ICertificateValidator certificateValidator;
    private String proxyHost;
    private int proxyPort = -1;
    private String proxyUserName;
    private String proxyPassword;
    private AuthScope proxyAuthScope;
    private SecureInterruptableSocketFactory secureSocketFactory;
    private static final List<RemoteTeamServer> serverList = new ArrayList<RemoteTeamServer>(5);
    private IOAuthHandler oauthHandler;

    static {
        Logger logger = Logger.getLogger("org.apache.commons.httpclient.HttpMethodDirector");
        logger.setLevel(Level.WARNING);
    }

    public RemoteTeamServer(String urString) {
        this(urString, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteTeamServer(String urlString, ICertificateValidator validator) {
        super(urlString);
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        this.repoProtocol = url.getProtocol();
        this.repoHost = url.getHost();
        this.repoPort = url.getPort();
        this.repoPath = url.getPath();
        this.defaultPort = url.getDefaultPort();
        if (-1 == this.repoPort) {
            this.repoPort = this.defaultPort;
        }
        if (this.repoProtocol == null) {
            throw new IllegalArgumentException();
        }
        if (this.repoHost == null) {
            throw new IllegalArgumentException();
        }
        if (-1 == this.repoPort) {
            throw new IllegalStateException("No port available or specified in repository URL");
        }
        this.authScope = new AuthScope(this.repoHost, this.repoPort, AuthScope.ANY_REALM);
        this.certificateValidator = validator;
        List<RemoteTeamServer> list = serverList;
        synchronized (list) {
            serverList.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSessionState() {
        List<RemoteTeamServer> list = serverList;
        synchronized (list) {
            int i = serverList.size();
            while (i > 0) {
                RemoteTeamServer server = serverList.remove(i - 1);
                server.storePrefs(server.loadSessionState);
                --i;
            }
        }
    }

    private synchronized void ensureInitialized() {
        if (this.httpClient == null) {
            HttpConnectionManagerParams connectionManagerParams = new HttpConnectionManagerParams();
            connectionManagerParams.setDefaultMaxConnectionsPerHost(1000);
            connectionManagerParams.setMaxTotalConnections(1000);
            connectionManagerParams.setTcpNoDelay(true);
            connectionManagerParams.setLinger(-1);
            connectionManagerParams.setStaleCheckingEnabled(true);
            this.connectionManager = new MultiThreadedHttpConnectionManager();
            this.connectionManager.setParams(connectionManagerParams);
            HostConfiguration hostConfiguration = new HostConfiguration();
            if ("https".equalsIgnoreCase(this.repoProtocol)) {
                SecureInterruptableSocketFactory socketFactory = this.secureSocketFactory = new SecureInterruptableSocketFactory(this.certificateValidator);
                Protocol protocol = new Protocol("https", (ProtocolSocketFactory)socketFactory, this.defaultPort);
                hostConfiguration.setHost(this.repoHost, this.repoPort, protocol);
            } else {
                Protocol protocol = new Protocol("http", (ProtocolSocketFactory)new InterruptableSocketFactory(), this.defaultPort);
                hostConfiguration.setHost(this.repoHost, this.repoPort, protocol);
            }
            this.httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
            this.httpClient.setHostConfiguration(hostConfiguration);
            this.setProxy();
        }
    }

    public synchronized void loadPrefs() {
    }

    private synchronized void storePrefs(boolean savePrefs) {
    }

    public void setCredentials(String userid, String password) {
        super.setCredentials(userid, password);
        this.ensureInitialized();
        TransportAuthUtil.setCredentials((HttpClient)this.httpClient, (AuthScope)this.authScope, (String)userid, (String)password);
    }

    @Deprecated
    public String[] getHttpCredentials() {
        String[] result = new String[2];
        this.ensureInitialized();
        UsernamePasswordCredentials storedCredentials = (UsernamePasswordCredentials)this.httpClient.getState().getCredentials(this.getAuthScope());
        if (storedCredentials == null) {
            return result;
        }
        result[0] = storedCredentials.getUserName();
        result[1] = storedCredentials.getPassword();
        if (result[0] == null) {
            result[0] = new String();
        }
        if (result[1] == null) {
            result[1] = new String();
        }
        return result;
    }

    private static Credentials buildProxyCredentials(String userName, String password) {
        UsernamePasswordCredentials credentials;
        if (System.getProperty(OS_NAME_PROP).toUpperCase().startsWith(OS_WINDOWS)) {
            String hostName;
            String domainName = new String();
            String[] s = userName.split(BACK_SLASH_REGEXP);
            if (s.length == 2) {
                domainName = s[0];
                userName = s[1];
            }
            if ((hostName = System.getenv(COMPUTER_NAME_EV)) == null) {
                hostName = new String();
            }
            credentials = new NTCredentials(userName, password, hostName, domainName);
        } else {
            credentials = new UsernamePasswordCredentials(userName, password);
        }
        return credentials;
    }

    private void setProxy() {
        if (this.httpClient != null) {
            if (this.proxyHost == null || this.proxyPort < 1) {
                this.httpClient.getHostConfiguration().setProxyHost(null);
                this.httpClient.getState().clearProxyCredentials();
            } else {
                this.httpClient.getHostConfiguration().setProxy(this.proxyHost, this.proxyPort);
                if (this.proxyUserName == null) {
                    this.httpClient.getState().clearProxyCredentials();
                } else {
                    Credentials credentials = RemoteTeamServer.buildProxyCredentials(this.proxyUserName, this.proxyPassword);
                    this.httpClient.getState().setProxyCredentials(this.proxyAuthScope, credentials);
                }
            }
        }
    }

    public void setProxy(String host, int port, String userName, String password) {
        this.proxyHost = host;
        this.proxyPort = port;
        this.proxyUserName = userName;
        this.proxyPassword = password;
        this.proxyAuthScope = host == null || port < 1 || userName == null ? null : new AuthScope(host, port);
        this.setProxy();
    }

    public void setConfiguration(TeamServerConfiguration configuration) {
        super.setConfiguration(configuration);
        this.ensureInitialized();
        HttpConnectionManagerParams connectionManagerParams = this.connectionManager.getParams();
        connectionManagerParams.setConnectionTimeout(configuration.getSocketTimeout());
        connectionManagerParams.setSoTimeout(configuration.getSocketTimeout());
        this.connectionManager.setParams(connectionManagerParams);
    }

    public ITeamService createTeamService(Class<?> serviceClass, Object implementation, String version, List<ComponentConfiguration> componentConfigurations) {
        if (serviceClass == null) {
            throw new IllegalArgumentException("serviceClass must not be null");
        }
        if (implementation != null) {
            throw new IllegalArgumentException(NLS.bind((String)"{0} implementation must be null", serviceClass, (Object[])new Object[0]));
        }
        ClassLoader serviceClassLoader = serviceClass.getClassLoader();
        if (ITeamRestService.class.isAssignableFrom(serviceClass)) {
            return new RemoteTeamRestService(this, serviceClass, serviceClassLoader, version);
        }
        return new RemoteTeamService(this, serviceClass, serviceClassLoader, version, componentConfigurations);
    }

    protected Object buildServiceImplementation(Class<?> serviceClass) {
        return null;
    }

    public boolean isLocal() {
        return false;
    }

    public synchronized void closeConnections(boolean savePrefs) {
        if (this.connectionManager != null) {
            final MultiThreadedHttpConnectionManager tempConnectionManager = this.connectionManager;
            this.connectionManager = null;
            new Job(Messages.getClientString(NLS_REMOTE_TEAM_SERVER_CLOSING_CONNECTIONS)){

                protected IStatus run(IProgressMonitor arg0) {
                    tempConnectionManager.closeIdleConnections(1L);
                    tempConnectionManager.deleteClosedConnections();
                    tempConnectionManager.shutdown();
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        this.httpClient = null;
    }

    public synchronized void closeConnections() {
        this.closeConnections(this.loadSessionState);
    }

    public synchronized HttpClient getHttpClient() {
        this.ensureInitialized();
        return this.httpClient;
    }

    public String getRepositoryPath() {
        return this.repoPath;
    }

    public AuthScope getAuthScope() {
        return this.authScope;
    }

    public AuthScope getProxyAuthScope() {
        return this.proxyAuthScope;
    }

    public X509Certificate[] getServerCertificatePath() {
        SecureInterruptableSocketFactory factory = this.secureSocketFactory;
        if (factory == null) {
            return null;
        }
        return factory.getLastKnownServerCertificatePath();
    }

    public void setOAuthHandler(IOAuthHandler handler) {
        this.oauthHandler = handler;
    }

    public IOAuthHandler getOAuthHandler() {
        return this.oauthHandler;
    }
}

