/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.rcp.common.collection;

import java.lang.ref.ReferenceQueue;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReferenceMap<K, V>
extends AbstractMap<K, V> {
    private HashMap<K, InverseReference<K, V>> realMap = new HashMap();
    private ReferenceQueue<V> referenceQueue = new ReferenceQueue();

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<Map.Entry<K, InverseReference<K, V>>> iterator;
                    {
                        this.iterator = AbstractReferenceMap.this.realMap.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final Map.Entry iterResult = this.iterator.next();
                        return new Map.Entry<K, V>(){
                            private V value;
                            {
                                this.value = ((InverseReference)entry.getValue()).getValue();
                            }

                            @Override
                            public K getKey() {
                                return iterResult.getKey();
                            }

                            @Override
                            public V getValue() {
                                return this.value;
                            }

                            @Override
                            public V setValue(V value) {
                                Object result = this.value;
                                this.value = value;
                                InverseReference ref = AbstractReferenceMap.this.constructReference(iterResult.getKey(), value, AbstractReferenceMap.this.referenceQueue);
                                iterResult.setValue(ref);
                                return result;
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        this.iterator.remove();
                    }
                };
            }

            @Override
            public int size() {
                return AbstractReferenceMap.this.realMap.size();
            }
        };
    }

    protected abstract InverseReference<K, V> constructReference(K var1, V var2, ReferenceQueue<V> var3);

    @Override
    public void clear() {
        this.realMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        this.purge();
        return this.realMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        this.purge();
        return super.containsValue(value);
    }

    @Override
    public V get(Object key) {
        this.purge();
        InverseReference<K, V> ref = this.realMap.get(key);
        if (ref == null) {
            return null;
        }
        return ref.getValue();
    }

    @Override
    public Set<K> keySet() {
        this.purge();
        return this.realMap.keySet();
    }

    @Override
    public boolean isEmpty() {
        this.purge();
        return this.realMap.isEmpty();
    }

    @Override
    public V put(K key, V value) {
        InverseReference<K, V> oldValue = this.realMap.put(key, this.constructReference(key, value, this.referenceQueue));
        V result = oldValue != null ? (V)oldValue.getValue() : null;
        this.purge();
        return result;
    }

    @Override
    public V remove(Object key) {
        InverseReference<K, V> oldValue = this.realMap.remove(key);
        if (oldValue != null) {
            return oldValue.getValue();
        }
        return null;
    }

    @Override
    public int size() {
        this.purge();
        return this.realMap.size();
    }

    @Override
    public Collection<V> values() {
        this.purge();
        return super.values();
    }

    private void purge() {
        InverseReference next;
        while ((next = (InverseReference)((Object)this.referenceQueue.poll())) != null) {
            Object key = next.getKey();
            if (key == null) continue;
            this.realMap.remove(key);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConcreteEntry<K, V>
    implements Map.Entry<K, V> {
        private K key;
        private V value;

        public ConcreteEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static interface InverseReference<K, V> {
        public K getKey();

        public V getValue();
    }
}

