/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.streams;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class UnsynchronizedBufferedOutputStream
extends FilterOutputStream {
    private static final String STREAM_IS_CLOSED = "Stream is closed";
    private byte[] buffer;
    private int pos;

    public UnsynchronizedBufferedOutputStream(OutputStream out) {
        this(out, 8192);
    }

    public UnsynchronizedBufferedOutputStream(OutputStream out, int bufferSize) {
        super(out);
        this.buffer = new byte[bufferSize];
    }

    public void write(int b) throws IOException {
        if (this.buffer == null) {
            throw new IOException(STREAM_IS_CLOSED);
        }
        this.buffer[this.pos++] = (byte)b;
        if (this.pos == this.buffer.length) {
            this.flushToStream();
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.buffer == null) {
            throw new IOException(STREAM_IS_CLOSED);
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.buffer.length - this.pos > len) {
            System.arraycopy(b, off, this.buffer, this.pos, len);
            this.pos += len;
        } else if (this.pos == 0) {
            this.out.write(b, off, len);
        } else {
            int copied = this.buffer.length - this.pos;
            System.arraycopy(b, off, this.buffer, this.pos, copied);
            this.pos = this.buffer.length;
            this.flushToStream();
            off += copied;
            if ((len -= copied) >= this.buffer.length) {
                this.out.write(b, off, len);
            } else {
                System.arraycopy(b, off, this.buffer, this.pos, len);
                this.pos += len;
            }
        }
    }

    public void close() throws IOException {
        if (this.buffer != null) {
            this.flushToStream();
            this.buffer = null;
            OutputStream stream = this.out;
            this.out = null;
            stream.close();
        }
    }

    public void flushToStream() throws IOException {
        if (this.pos != 0) {
            this.out.write(this.buffer, 0, this.pos);
            this.pos = 0;
        }
    }

    public void flush() throws IOException {
        if (this.buffer == null) {
            throw new IOException(STREAM_IS_CLOSED);
        }
        this.flushToStream();
        this.out.flush();
    }
}

