/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.internal.repository.rcp.dbhm;

import com.ibm.team.internal.repository.rcp.dbhm.BadHeapException;
import com.ibm.team.internal.repository.rcp.dbhm.CachedDiskBackedHashMap;
import com.ibm.team.internal.repository.rcp.dbhm.DBHMException;
import com.ibm.team.internal.repository.rcp.dbhm.PersistentBTreeHeap;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedByteArrayInputStream;
import com.ibm.team.internal.repository.rcp.streams.UnsynchronizedByteArrayOutputStream;
import com.ibm.team.repository.common.util.NLS;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentDiskBackedHashMap<K, V>
extends CachedDiskBackedHashMap<K, V> {
    private boolean doneInitializing;
    private boolean closed;

    public PersistentDiskBackedHashMap(long initialCapacity, double loadFactor, int maxCacheSize, String path) {
        this(initialCapacity, loadFactor, maxCacheSize, new File(path));
    }

    public PersistentDiskBackedHashMap(long initialCapacity, double loadFactor, int maxCacheSize, File file) {
        super(initialCapacity, loadFactor, maxCacheSize);
        try {
            this.initFromFile(file);
        }
        catch (IOException e) {
            throw new DBHMException(e);
        }
    }

    public PersistentDiskBackedHashMap(long initialCapacity, double loadFactor, String path) {
        this(initialCapacity, loadFactor, new File(path));
    }

    public PersistentDiskBackedHashMap(long initialCapacity, double loadFactor, File file) {
        super(initialCapacity, loadFactor);
        try {
            this.initFromFile(file);
        }
        catch (IOException e) {
            throw new DBHMException(e);
        }
    }

    public PersistentDiskBackedHashMap(long initialCapacity, String path) {
        this(initialCapacity, new File(path));
    }

    public PersistentDiskBackedHashMap(long initialCapacity, File file) {
        super(initialCapacity);
        try {
            this.initFromFile(file);
        }
        catch (IOException e) {
            throw new DBHMException(e);
        }
    }

    public PersistentDiskBackedHashMap(String path) {
        this(new File(path));
    }

    public PersistentDiskBackedHashMap(File file) {
        try {
            this.initFromFile(file);
        }
        catch (IOException e) {
            throw new DBHMException(e);
        }
    }

    protected void initFromFile(File f) throws IOException {
        PersistentBTreeHeap h = this.newPersistentBTreeHeap(f);
        boolean success = false;
        try {
            byte[] data = h.getPersistedData();
            if (data.length == 0) {
                this.heap = h;
                this.doneInitializing = true;
                this.initTablePtr();
            } else {
                DataInputStream in = new DataInputStream(new UnsynchronizedByteArrayInputStream(data));
                byte format = in.readByte();
                if (format != 1) {
                    String msg = NLS.bind((String)"Old format version {0} does not match version {1}.", (Object)format, (Object[])new Object[]{1});
                    throw new IOException(msg);
                }
                this.tablePtr = in.readLong();
                this.size = in.readLong();
                this.capacity = in.readLong();
                this.numHeapADTs = in.readLong();
                this.readCustomMetadata(in);
                this.heap = h;
                super.init();
                this.doneInitializing = true;
            }
            success = true;
        }
        catch (Throwable throwable) {
            if (!success) {
                try {
                    h.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (!success) {
            try {
                h.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected PersistentBTreeHeap newPersistentBTreeHeap(File f) throws IOException {
        try {
            return new PersistentBTreeHeap(f);
        }
        catch (BadHeapException e) {
            throw new DBHMException(e);
        }
    }

    @Override
    protected void initHeap() throws IOException {
        if (this.doneInitializing) {
            super.initHeap();
        }
    }

    @Override
    protected void initTablePtr() throws IOException {
        if (this.doneInitializing) {
            super.initTablePtr();
        }
    }

    public void close() throws IOException {
        this.persist();
        ((PersistentBTreeHeap)this.heap).close();
        this.closed = true;
    }

    public void persist() throws IOException {
        this.flushCache();
        UnsynchronizedByteArrayOutputStream out = new UnsynchronizedByteArrayOutputStream(24);
        DataOutputStream dOut = new DataOutputStream(out);
        dOut.writeByte(1);
        dOut.writeLong(this.tablePtr);
        dOut.writeLong(this.size);
        dOut.writeLong(this.capacity);
        dOut.writeLong(this.numHeapADTs);
        this.writeCustomMetadata(dOut);
        dOut.flush();
        ((PersistentBTreeHeap)this.heap).setPersistedData(out.toByteArray());
        ((PersistentBTreeHeap)this.heap).persist();
    }

    protected void writeCustomMetadata(DataOutputStream out) throws IOException {
    }

    protected void readCustomMetadata(DataInputStream in) throws IOException {
    }

    protected void finalize() throws Throwable {
        if (!this.closed) {
            try {
                this.close();
            }
            catch (IOException iOException) {}
        }
        super.finalize();
    }
}

