/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.util;

import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.util.IComponentProperties;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ComponentProperties
implements IComponentProperties {
    private static final Log LOGGER = LogFactory.getLog(ComponentProperties.class);
    private static final String PROPERTIES_FILENAME_EXTENSION = "properties";
    private Properties properties;

    protected final String basicGetFilename() {
        char dot = '.';
        Class<?> clazz = this.getClass();
        String className = clazz.getName();
        int index = className.lastIndexOf(dot) + 1;
        String name = className.substring(index);
        String filename = String.valueOf(name) + dot + PROPERTIES_FILENAME_EXTENSION;
        return filename;
    }

    protected final void basicPrintOn(StringBuffer buffer) {
        String value = super.toString();
        buffer.append(value);
        this.printPropertyPrefixOn(buffer);
        this.printPropertiesFilenameOn(buffer);
    }

    private void checkArgumentIsNotNull(Object argument, String argumentName) {
        if (argument != null) {
            return;
        }
        String value = argumentName == null ? "argumentName" : argumentName;
        String message = String.format("%s must not be null", value);
        throw new IllegalArgumentException(message);
    }

    private void checkKeyIsLegal(String key) {
        this.checkArgumentIsNotNull(key, "key");
        boolean legal = this.isKeyLegal(key);
        if (legal) {
            return;
        }
        String msg = NLS.bind("The key \"{0}\" is illegal, it does not start with \"{1}\"", key, this.getPropertyPrefix());
        throw new IllegalArgumentException(msg);
    }

    public boolean getBooleanProperty(String key) {
        boolean value = this.getBooleanProperty(key, false);
        return value;
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String defaultValueString = Boolean.toString(defaultValue);
        String value = this.getProperty(key, defaultValueString);
        boolean booleanValue = Boolean.parseBoolean(value);
        return booleanValue;
    }

    public int getIntegerProperty(String key, int defaultValue) {
        String defaultValueString = Integer.toString(defaultValue);
        String value = this.getProperty(key, defaultValueString);
        int intValue = Integer.parseInt(value);
        return intValue;
    }

    public long getLongProperty(String key, long defaultValue) {
        String defaultValueString = Long.toString(defaultValue);
        String value = this.getProperty(key, defaultValueString);
        long longValue = Long.parseLong(value);
        return longValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties() {
        ComponentProperties componentProperties = this;
        synchronized (componentProperties) {
            if (this.properties == null) {
                Properties properties = this.loadProperties();
                this.setProperties(properties);
            }
            return this.properties;
        }
    }

    protected String getPropertiesFilename() {
        String filename = this.basicGetFilename();
        return filename;
    }

    public String getProperty(String key) {
        String value = this.getProperty(key, null);
        return value;
    }

    public String getProperty(String key, String defaultValue) {
        Properties properties;
        this.checkKeyIsLegal(key);
        String value = System.getProperty(key, null);
        if (value == null && (value = (properties = this.getProperties()).getProperty(key, defaultValue)) != null) {
            value = value.trim();
        }
        return value;
    }

    protected abstract String getPropertyPrefix();

    private boolean isKeyLegal(String key) {
        String prefix = this.getPropertyPrefix();
        boolean legal = this.isKeyLegal(key, prefix);
        return legal;
    }

    private boolean isKeyLegal(String key, String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix must not be null");
        }
        boolean legal = key.startsWith(prefix);
        return legal;
    }

    private Properties loadProperties() {
        String filename = this.getPropertiesFilename();
        Properties properties = this.loadProperties(filename);
        return properties;
    }

    private Properties loadProperties(String filename) {
        if (filename == null) {
            throw new IllegalArgumentException("filename must not be null");
        }
        Properties properties = new Properties();
        InputStream stream = null;
        Class<?> clazz = this.getClass();
        try {
            try {
                stream = clazz.getResourceAsStream(filename);
                properties.load(stream);
                this.validatePropertyKeys(properties);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException exception) {
            String message = NLS.bind(Messages.getServerString("ComponentProperties.ErrorLoadingProperties"), filename, new Object[0]);
            this.logError(message, exception);
        }
        return properties;
    }

    protected final void logError(String message, Throwable exception) {
        LOGGER.error((Object)message, exception);
    }

    protected final void logWarning(String message) {
        LOGGER.warn((Object)message);
    }

    protected void printOn(StringBuffer buffer) {
        this.basicPrintOn(buffer);
    }

    protected final void printPropertiesFilenameOn(StringBuffer buffer) {
        String value = this.getPropertiesFilename();
        buffer.append(", file=");
        buffer.append(value);
    }

    protected final void printPropertyPrefixOn(StringBuffer buffer) {
        String value = this.getPropertyPrefix();
        buffer.append(", prefix=");
        buffer.append(value);
    }

    private void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String setProperty(String key, String value) {
        this.checkKeyIsLegal(key);
        this.checkArgumentIsNotNull(value, "value");
        String oldValue = System.setProperty(key, value);
        return oldValue;
    }

    public final String toString() {
        StringBuffer buffer = new StringBuffer(150);
        this.printOn(buffer);
        String value = buffer.toString();
        return value;
    }

    private void validatePropertyKey(String key) {
        boolean legal = this.isKeyLegal(key);
        if (legal) {
            return;
        }
        String msg = NLS.bind("The \"{0}\" key \"{1}\" is illegal, it does not start with \"{2}\"", this.getPropertiesFilename(), key, this.getPropertyPrefix());
        this.logWarning(msg);
    }

    private void validatePropertyKeys(Properties properties) {
        Enumeration<?> keys = properties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.validatePropertyKey(key);
        }
    }
}

