/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.transport;

import com.ibm.team.repository.common.transport.IParameterWrapper;
import com.ibm.team.repository.common.transport.ParameterConverter;
import com.ibm.team.repository.common.transport.ServiceMethodInvocationError;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.util.URIUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterWrapperHandler {
    private static final String QUESTION_MARK_SEPARATOR = "?";
    private static final String AMPERSAND_SEPARATOR = "&";
    private static final String EMPTY_STRING = "";
    private static final char EQUALS = '=';
    private static final Log logger = LogFactory.getLog(ParameterConverter.class);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static ParameterWrapperHandler defaultHandler = new ParameterWrapperHandler();

    public static Object createParameterWrapperFromRequest(Class clazz, HttpServletRequest httpServletRequest) {
        if (clazz == null) {
            return null;
        }
        return defaultHandler.createFromRequest(clazz, httpServletRequest.getParameterMap());
    }

    public static String createQueryString(Class clazz, IParameterWrapper parameterWrapper, boolean isPost) {
        if (clazz == null) {
            return EMPTY_STRING;
        }
        return defaultHandler.createQueryString(parameterWrapper, isPost);
    }

    protected Iterable<Field> accessibleFieldsIn(Class<?> type) {
        Field[] fields = type.getFields();
        ArrayList<Field> list = new ArrayList<Field>(fields.length);
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int modifiers = field.getModifiers();
            if (Modifier.isPublic(modifiers) && !Modifier.isTransient(modifiers)) {
                list.add(field);
            }
            ++n2;
        }
        return list;
    }

    public String createQueryString(IParameterWrapper parameterWrapper, boolean isPost) {
        if (parameterWrapper == null) {
            return EMPTY_STRING;
        }
        StringBuffer sb = new StringBuffer();
        String separator = isPost ? EMPTY_STRING : QUESTION_MARK_SEPARATOR;
        for (Field field : this.accessibleFieldsIn(parameterWrapper.getClass())) {
            ParameterConverter pc;
            boolean isArrayType = false;
            Class<?> fieldBaseType = field.getType();
            if (fieldBaseType.isArray()) {
                isArrayType = true;
                fieldBaseType = fieldBaseType.getComponentType();
            }
            if ((pc = this.findParameterConverterForClass(fieldBaseType)) == null) continue;
            if (!isArrayType) {
                try {
                    String key = field.getName();
                    Object val = field.get(parameterWrapper);
                    if (val == null) continue;
                    String value = pc.convertToString(fieldBaseType, val);
                    sb.append(separator);
                    separator = AMPERSAND_SEPARATOR;
                    sb.append(URIUtil.encodeWithinQuery((String)key));
                    sb.append('=');
                    sb.append(URIUtil.encodeWithinQuery((String)value));
                    continue;
                }
                catch (URIException e) {
                    throw new ServiceMethodInvocationError(e);
                }
                catch (IllegalAccessException illegalAccessException) {
                    continue;
                }
            }
            try {
                Object array = field.get(parameterWrapper);
                if (array == null) continue;
                int length = Array.getLength(array);
                String key = field.getName();
                key = URIUtil.encodeWithinQuery((String)key);
                int j = 0;
                while (j < length) {
                    Object valueObject = Array.get(array, j);
                    if (valueObject != null) {
                        String value = pc.convertToString(fieldBaseType, valueObject);
                        sb.append(separator);
                        separator = AMPERSAND_SEPARATOR;
                        sb.append(key);
                        sb.append('=');
                        sb.append(URIUtil.encodeWithinQuery((String)value));
                    }
                    ++j;
                }
            }
            catch (URIException e) {
                throw new ServiceMethodInvocationError(e);
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        String result = sb.toString();
        return result;
    }

    public ParameterConverter findParameterConverterForClass(Class fieldBaseType) {
        return ParameterConverter.getParameterConverterForClass(fieldBaseType);
    }

    public Object createFromRequest(Class clazz, Map<String, String[]> input) {
        Object result;
        try {
            result = clazz.newInstance();
        }
        catch (InstantiationException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        catch (IllegalAccessException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
            return null;
        }
        for (Field field : this.accessibleFieldsIn(clazz)) {
            ParameterConverter pc;
            String[] params = input.get(field.getName());
            if (params == null) {
                params = EMPTY_STRING_ARRAY;
            }
            boolean isArrayType = false;
            Class<?> fieldBaseType = field.getType();
            if (fieldBaseType.isArray()) {
                isArrayType = true;
                fieldBaseType = fieldBaseType.getComponentType();
            }
            if ((pc = this.findParameterConverterForClass(fieldBaseType)) == null) continue;
            Object value = null;
            if (!isArrayType) {
                if (params.length != 0) {
                    value = pc.convertToObject(fieldBaseType, params[0]);
                }
            } else {
                ArrayList<Object> valueList = new ArrayList<Object>();
                int j = 0;
                while (j < params.length) {
                    Object valueElement = pc.convertToObject(fieldBaseType, params[j]);
                    if (valueElement != null) {
                        valueList.add(valueElement);
                    }
                    ++j;
                }
                value = Array.newInstance(fieldBaseType, valueList.size());
                int i = 0;
                while (i < valueList.size()) {
                    Array.set(value, i, valueList.get(i));
                    ++i;
                }
            }
            if (value == null) continue;
            try {
                field.set(result, value);
            }
            catch (IllegalAccessException e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }
}

