/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.query;

import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.query.IDataField;
import com.ibm.team.repository.common.query.IDataRow;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataRow
implements IDataRow {
    static final String ILLEGAL_DATATYPE_MSG = "Illegal Data Type Code specified in data query.";
    private final List<? extends IDataField> dataFields;
    private final Map<? extends String, ? extends Integer> namesToPositions;
    private final List<? extends String> rawData;
    private final int startIndex;

    public DataRow(List<? extends IDataField> fields, Map<? extends String, ? extends Integer> namesToPositions, List<? extends String> data, int startIndex) {
        this.dataFields = fields;
        this.namesToPositions = namesToPositions;
        this.rawData = data;
        this.startIndex = startIndex;
    }

    @Override
    public boolean getBoolean(String fieldName) {
        return this.getBoolean(this.namesToPositions.get(fieldName));
    }

    private Boolean getBooleanForPosition(int fieldPosition) {
        String aValue = this.rawData.get(this.startIndex + fieldPosition);
        if (aValue == null) {
            return Boolean.FALSE;
        }
        if ("1".equals(aValue)) {
            return Boolean.TRUE;
        }
        return (boolean)Boolean.valueOf(aValue);
    }

    @Override
    public boolean getBoolean(int fieldPosition) {
        return this.getBooleanForPosition(fieldPosition);
    }

    @Override
    public BigDecimal getDecimal(String fieldName) {
        return this.getDecimal(this.namesToPositions.get(fieldName));
    }

    @Override
    public BigDecimal getDecimal(int fieldPosition) {
        String aValue = this.rawData.get(this.startIndex + fieldPosition);
        if (aValue == null) {
            return null;
        }
        return new BigDecimal(aValue);
    }

    @Override
    public int getInt(String fieldName) {
        return this.getInt(this.namesToPositions.get(fieldName));
    }

    @Override
    public int getInt(int fieldPosition) {
        String aValue = this.rawData.get(this.startIndex + fieldPosition);
        if (aValue == null) {
            return 0;
        }
        return Integer.parseInt(aValue);
    }

    @Override
    public long getLong(String fieldName) {
        return this.getLong(this.namesToPositions.get(fieldName));
    }

    @Override
    public long getLong(int fieldPosition) {
        String aValue = this.rawData.get(this.startIndex + fieldPosition);
        if (aValue == null) {
            return 0L;
        }
        return Long.parseLong(aValue);
    }

    @Override
    public Object getObject(String fieldName) {
        return this.getObject(this.namesToPositions.get(fieldName));
    }

    @Override
    public Object getObject(int fieldPosition) {
        String objectAsString = this.rawData.get(this.startIndex + fieldPosition);
        if (objectAsString == null) {
            return null;
        }
        int typeCode = this.dataFields.get(fieldPosition).getFieldType();
        Object object = null;
        switch (typeCode) {
            case 1: {
                object = this.getBooleanForPosition(fieldPosition);
                break;
            }
            case 5: {
                object = new BigDecimal(objectAsString);
                break;
            }
            case 0: {
                object = new Integer(objectAsString);
                break;
            }
            case 6: {
                object = new Long(objectAsString);
                break;
            }
            case 8: {
                object = new Float(objectAsString);
                break;
            }
            case 9: {
                object = new Double(objectAsString);
                break;
            }
            case 2: {
                object = new String(objectAsString);
                break;
            }
            case 3: {
                object = Timestamp.valueOf(objectAsString);
                break;
            }
            case 4: {
                object = UUID.valueOf(objectAsString);
                break;
            }
            case 7: {
                object = ItemUtil.string2ItemType(objectAsString);
                break;
            }
            default: {
                throw new IllegalArgumentException(ILLEGAL_DATATYPE_MSG);
            }
        }
        return object;
    }

    @Override
    public String getString(String fieldName) {
        return this.getString(this.namesToPositions.get(fieldName));
    }

    @Override
    public String getString(int fieldPosition) {
        return this.rawData.get(this.startIndex + fieldPosition);
    }

    @Override
    public Timestamp getTimestamp(String fieldName) {
        return this.getTimestamp(this.namesToPositions.get(fieldName));
    }

    @Override
    public Timestamp getTimestamp(int fieldPosition) {
        String aValue = this.rawData.get(this.startIndex + fieldPosition);
        if (aValue == null) {
            return null;
        }
        if (!aValue.contains(String.valueOf(':'))) {
            return new Timestamp(Long.valueOf(aValue));
        }
        return Timestamp.valueOf(aValue);
    }

    @Override
    public UUID getUUID(String fieldName) {
        return this.getUUID(this.namesToPositions.get(fieldName));
    }

    @Override
    public UUID getUUID(int fieldPosition) {
        String aValue = this.rawData.get(this.startIndex + fieldPosition);
        if (aValue == null) {
            return null;
        }
        return UUID.valueOf(aValue);
    }

    @Override
    public IItemType getItemType(String fieldName) {
        return this.getItemType(this.namesToPositions.get(fieldName));
    }

    @Override
    public IItemType getItemType(int fieldPosition) {
        String aValue = this.rawData.get(this.startIndex + fieldPosition);
        if (aValue == null) {
            return null;
        }
        return ItemUtil.string2ItemType(aValue);
    }

    @Override
    public double getDouble(String fieldName) {
        return this.getDouble(this.namesToPositions.get(fieldName));
    }

    @Override
    public double getDouble(int fieldPosition) {
        String aValue = this.rawData.get(this.startIndex + fieldPosition);
        if (aValue == null) {
            return 0.0;
        }
        return Double.parseDouble(aValue);
    }

    @Override
    public float getFloat(String fieldName) {
        return this.getFloat(this.namesToPositions.get(fieldName));
    }

    @Override
    public float getFloat(int fieldPosition) {
        String aValue = this.rawData.get(this.startIndex + fieldPosition);
        if (aValue == null) {
            return 0.0f;
        }
        return Float.parseFloat(aValue);
    }
}

