/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.model.impl;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ComponentRegistry;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.model.Item;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.model.impl.TypeImpl;
import com.ibm.team.repository.common.query.ast.IDynamicItemQueryModel;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

public class ItemTypeImpl
extends TypeImpl
implements ItemType {
    private static final long serialVersionUID = 1L;

    protected ItemTypeImpl() {
    }

    protected EClass eStaticClass() {
        return RepositoryPackage.Literals.ITEM_TYPE;
    }

    public boolean isAuditable() {
        EClass eClass = ItemUtil.getTypeEClass(this);
        if (eClass == null) {
            return false;
        }
        return RepositoryPackage.eINSTANCE.getAuditable().isSuperTypeOf(eClass);
    }

    public boolean isUnmanaged() {
        EClass eClass = ItemUtil.getTypeEClass(this);
        if (eClass == null) {
            return false;
        }
        return RepositoryPackage.eINSTANCE.getUnmanagedItem().isSuperTypeOf(eClass);
    }

    public boolean isSimple() {
        EClass eClass = ItemUtil.getTypeEClass(this);
        if (eClass == null) {
            return false;
        }
        return RepositoryPackage.eINSTANCE.getSimpleItem().isSuperTypeOf(eClass);
    }

    public IItem createItem() {
        EObject eObject;
        this.ensureConcrete();
        EClass eClass = ItemUtil.getTypeEClass(this);
        if (eClass != null && (eObject = eClass.getEPackage().getEFactoryInstance().create(eClass)) instanceof Item) {
            Item item = (Item)eObject;
            item.initNew();
            return item;
        }
        return null;
    }

    private void ensureConcrete() {
        if (this.isAbstract()) {
            throw new IllegalStateException("Cannot create abstract items");
        }
    }

    public IItem createItem(Object origin) {
        EObject eObject;
        this.ensureConcrete();
        if (origin == null) {
            throw new IllegalArgumentException();
        }
        EClass eClass = ItemUtil.getTypeEClass(this);
        if (eClass != null && (eObject = eClass.getEPackage().getEFactoryInstance().create(eClass)) instanceof Item) {
            Item item = (Item)eObject;
            item.setOrigin(origin);
            item.initNew();
            return item;
        }
        return null;
    }

    public IItemHandle createItemHandle(UUID itemId, UUID optionalStateId) {
        EObject eObject;
        this.ensureConcrete();
        if (itemId == null) {
            throw new IllegalArgumentException();
        }
        EClass eClass = ItemUtil.getHandleEClass(this);
        if (eClass != null && (eObject = eClass.getEPackage().getEFactoryInstance().create(eClass)) instanceof ItemHandle) {
            ItemHandle handle = (ItemHandle)eObject;
            handle.setItemId(itemId);
            handle.setStateId(optionalStateId);
            return handle;
        }
        return null;
    }

    public IItemHandle createItemHandle(Object origin, UUID itemId, UUID optionalStateId) {
        this.ensureConcrete();
        if (origin == null) {
            throw new IllegalArgumentException();
        }
        IItemHandle handle = this.createItemHandle(itemId, optionalStateId);
        ((ItemHandle)handle).setOrigin(origin);
        return handle;
    }

    public boolean allowsStateExtensions() {
        return ItemUtil.allowsStateExtensions(this);
    }

    public String idPropertyName() {
        return ItemUtil.getIdProperty(this);
    }

    public IDynamicItemQueryModel getQueryModel() {
        return (IDynamicItemQueryModel)ItemUtil.getQueryModel(this);
    }

    public boolean isPublic() {
        return ComponentRegistry.INSTANCE.isUsingPublicReadAccessPolicy(this);
    }

    public boolean isProtected() {
        return ComponentRegistry.INSTANCE.isUsingProtectedReadAccessPolicy(this);
    }

    public boolean isApplicationManaged() {
        return ComponentRegistry.INSTANCE.isUsingApplicationManagedReadAccessPolicy(this);
    }

    public boolean isInternal() {
        return ComponentRegistry.INSTANCE.isUsingInternalReadAccessPolicy(this);
    }
}

