/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.model.impl;

import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.model.ExternalUser;
import com.ibm.team.repository.common.model.ExternalUserStatus;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.model.impl.DetailEntryImpl;
import com.ibm.team.repository.common.model.impl.HelperImpl;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalUserImpl
extends HelperImpl
implements ExternalUser {
    protected EList fullNames;
    protected EList userIds;
    protected EList emailAddresses;
    protected EMap detailFields;
    protected ExternalUserStatus status;
    protected static final int STATUS_ESETFLAG = 2;

    protected ExternalUserImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return RepositoryPackage.Literals.EXTERNAL_USER;
    }

    @Override
    public List getFullNames() {
        if (this.fullNames == null) {
            this.fullNames = new EDataTypeUniqueEList.Unsettable(String.class, (InternalEObject)this, 1);
        }
        return this.fullNames;
    }

    @Override
    public void unsetFullNames() {
        if (this.fullNames != null) {
            ((InternalEList.Unsettable)this.fullNames).unset();
        }
    }

    @Override
    public boolean isSetFullNames() {
        return this.fullNames != null && ((InternalEList.Unsettable)this.fullNames).isSet();
    }

    @Override
    public List getUserIds() {
        if (this.userIds == null) {
            this.userIds = new EDataTypeUniqueEList.Unsettable(String.class, (InternalEObject)this, 2);
        }
        return this.userIds;
    }

    @Override
    public void unsetUserIds() {
        if (this.userIds != null) {
            ((InternalEList.Unsettable)this.userIds).unset();
        }
    }

    @Override
    public boolean isSetUserIds() {
        return this.userIds != null && ((InternalEList.Unsettable)this.userIds).isSet();
    }

    @Override
    public List getEmailAddresses() {
        if (this.emailAddresses == null) {
            this.emailAddresses = new EDataTypeUniqueEList.Unsettable(String.class, (InternalEObject)this, 3);
        }
        return this.emailAddresses;
    }

    @Override
    public void unsetEmailAddresses() {
        if (this.emailAddresses != null) {
            ((InternalEList.Unsettable)this.emailAddresses).unset();
        }
    }

    @Override
    public boolean isSetEmailAddresses() {
        return this.emailAddresses != null && ((InternalEList.Unsettable)this.emailAddresses).isSet();
    }

    @Override
    public Map getDetailFields() {
        if (this.detailFields == null) {
            this.detailFields = new EcoreEMap.Unsettable(RepositoryPackage.Literals.DETAIL_ENTRY, DetailEntryImpl.class, (InternalEObject)this, 4);
        }
        return this.detailFields.map();
    }

    @Override
    public void unsetDetailFields() {
        if (this.detailFields != null) {
            ((InternalEList.Unsettable)this.detailFields).unset();
        }
    }

    @Override
    public boolean isSetDetailFields() {
        return this.detailFields != null && ((InternalEList.Unsettable)this.detailFields).isSet();
    }

    @Override
    public ExternalUserStatus getStatus() {
        return this.status;
    }

    public NotificationChain basicSetStatus(ExternalUserStatus newStatus, NotificationChain msgs) {
        ExternalUserStatus oldStatus = this.status;
        this.status = newStatus;
        boolean oldStatusESet = (this.ALL_FLAGS & 2) != 0;
        this.ALL_FLAGS |= 2;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldStatus, (Object)newStatus, !oldStatusESet);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setStatus(ExternalUserStatus newStatus) {
        if (newStatus != this.status) {
            NotificationChain msgs = null;
            if (this.status != null) {
                msgs = ((InternalEObject)this.status).eInverseRemove((InternalEObject)this, -6, null, msgs);
            }
            if (newStatus != null) {
                msgs = ((InternalEObject)newStatus).eInverseAdd((InternalEObject)this, -6, null, msgs);
            }
            if ((msgs = this.basicSetStatus(newStatus, msgs)) != null) {
                msgs.dispatch();
            }
        } else {
            boolean oldStatusESet = (this.ALL_FLAGS & 2) != 0;
            this.ALL_FLAGS |= 2;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)newStatus, (Object)newStatus, !oldStatusESet));
            }
        }
    }

    public NotificationChain basicUnsetStatus(NotificationChain msgs) {
        ExternalUserStatus oldStatus = this.status;
        this.status = null;
        boolean oldStatusESet = (this.ALL_FLAGS & 2) != 0;
        this.ALL_FLAGS &= 0xFFFFFFFD;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 2, 5, (Object)oldStatus, null, oldStatusESet);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void unsetStatus() {
        if (this.status != null) {
            NotificationChain msgs = null;
            msgs = ((InternalEObject)this.status).eInverseRemove((InternalEObject)this, -6, null, msgs);
            if ((msgs = this.basicUnsetStatus(msgs)) != null) {
                msgs.dispatch();
            }
        } else {
            boolean oldStatusESet = (this.ALL_FLAGS & 2) != 0;
            this.ALL_FLAGS &= 0xFFFFFFFD;
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 5, null, null, oldStatusESet));
            }
        }
    }

    @Override
    public boolean isSetStatus() {
        return (this.ALL_FLAGS & 2) != 0;
    }

    @Override
    public String getUserId() {
        List userIds = this.getUserIds();
        if (userIds == null || userIds.size() == 0) {
            return null;
        }
        return (String)userIds.get(0);
    }

    @Override
    public String getFullName() {
        List fullNames = this.getFullNames();
        if (fullNames == null || fullNames.size() == 0) {
            return null;
        }
        return (String)fullNames.get(0);
    }

    @Override
    public String getEmailAddress() {
        List emailAddresses = this.getEmailAddresses();
        if (emailAddresses == null || emailAddresses.size() == 0) {
            return null;
        }
        return (String)emailAddresses.get(0);
    }

    @Override
    public IStatus isValidUser() {
        ExternalUserStatus status = this.getStatus();
        if (status.isValid()) {
            return this.createOKStatus();
        }
        return this.createErrorStatus(status.getMessage());
    }

    private IStatus createOKStatus() {
        return new Status(0, "com.ibm.team.repository.common", "Valid User");
    }

    private IStatus createErrorStatus(String message) {
        return new Status(4, "com.ibm.team.repository.common", 4, message, null);
    }

    @Override
    public IStatus isValidUser(List<String> propertiesToTest) {
        IStatus status;
        if (propertiesToTest.contains(IContributor.USERID_PROPERTY) && (status = this.validateUserId()).getSeverity() == 4) {
            return status;
        }
        if (propertiesToTest.contains(IContributor.NAME_PROPERTY) && (status = this.validateName()).getSeverity() == 4) {
            return status;
        }
        if (propertiesToTest.contains(IContributor.EMAIL_ADDRESS_PROPERTY)) {
            return this.validateEmailAddress();
        }
        return this.createOKStatus();
    }

    private IStatus validateUserId() {
        List userIds = this.getUserIds();
        if (userIds != null && userIds.size() > 1) {
            return this.createErrorStatus(Messages.getServerString("ExternalUserImpl.ErrorMoreThanOneId"));
        }
        boolean isValidUserId = this.isListOfStringsValid(userIds);
        if (!isValidUserId) {
            return this.createErrorStatus(Messages.getServerString("ExternalUserImpl.ErrorMissingId"));
        }
        return this.createOKStatus();
    }

    private IStatus validateName() {
        List fullNames = this.getFullNames();
        boolean isValidName = this.isListOfStringsValid(fullNames);
        if (!isValidName) {
            return this.createErrorStatus(Messages.getServerString("ExternalUserImpl.ErrorMissingName"));
        }
        return this.createOKStatus();
    }

    private IStatus validateEmailAddress() {
        List emailAddresses = this.getEmailAddresses();
        boolean isValidEmailAddress = this.isListOfStringsValid(emailAddresses);
        if (!isValidEmailAddress) {
            return this.createErrorStatus(Messages.getServerString("ExternalUserImpl.ErrorMissingEmail"));
        }
        return new Status(0, "com.ibm.team.repository.common", "Valid User");
    }

    private boolean isListOfStringsValid(List<String> values) {
        if (values == null || values.size() == 0) {
            return false;
        }
        boolean validName = false;
        for (String fullName : values) {
            if (fullName == null || fullName.trim().length() == 0) continue;
            validName = true;
        }
        return validName;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 4: {
                return ((InternalEList)((EMap.InternalMapView)this.getDetailFields()).eMap()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return this.basicUnsetStatus(msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getFullNames();
            }
            case 2: {
                return this.getUserIds();
            }
            case 3: {
                return this.getEmailAddresses();
            }
            case 4: {
                if (coreType) {
                    return ((EMap.InternalMapView)this.getDetailFields()).eMap();
                }
                return this.getDetailFields();
            }
            case 5: {
                return this.getStatus();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.getFullNames().clear();
                this.getFullNames().addAll((Collection)newValue);
                return;
            }
            case 2: {
                this.getUserIds().clear();
                this.getUserIds().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getEmailAddresses().clear();
                this.getEmailAddresses().addAll((Collection)newValue);
                return;
            }
            case 4: {
                ((EStructuralFeature.Setting)((EMap.InternalMapView)this.getDetailFields()).eMap()).set(newValue);
                return;
            }
            case 5: {
                this.setStatus((ExternalUserStatus)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.unsetFullNames();
                return;
            }
            case 2: {
                this.unsetUserIds();
                return;
            }
            case 3: {
                this.unsetEmailAddresses();
                return;
            }
            case 4: {
                this.unsetDetailFields();
                return;
            }
            case 5: {
                this.unsetStatus();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.isSetFullNames();
            }
            case 2: {
                return this.isSetUserIds();
            }
            case 3: {
                return this.isSetEmailAddresses();
            }
            case 4: {
                return this.isSetDetailFields();
            }
            case 5: {
                return this.isSetStatus();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (fullNames: ");
        result.append(this.fullNames);
        result.append(", userIds: ");
        result.append(this.userIds);
        result.append(", emailAddresses: ");
        result.append(this.emailAddresses);
        result.append(')');
        return result.toString();
    }
}

