/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;

public class StandaloneUtil {
    public static String getBundleNameForPluginXml(URL pluginXml) {
        try {
            String path = pluginXml.getPath();
            String manifestPath = String.valueOf(StandaloneUtil.getParentPath(path)) + "META-INF/MANIFEST.MF";
            URL manifest = new URL(pluginXml.getProtocol(), pluginXml.getHost(), pluginXml.getPort(), manifestPath);
            return StandaloneUtil.getBundleNameForManifest(manifest);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getBundleNameForManifest(URL manifest) throws IOException {
        return StandaloneUtil.getBundleSymbolicName(manifest.openStream(), "Bundle-SymbolicName:");
    }

    public static String getFragmentHostForManifest(URL manifest) throws IOException {
        return StandaloneUtil.getBundleSymbolicName(manifest.openStream(), "Fragment-Host:");
    }

    public static String getParentPath(String path) {
        int idx = path.lastIndexOf(47);
        if (idx == -1) {
            return "/";
        }
        if (idx == path.length() - 1) {
            return StandaloneUtil.getParentPath(path.substring(0, idx));
        }
        return path.substring(0, idx + 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getBundleSymbolicName(InputStream in, String header) throws IOException {
        try {
            String line;
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            boolean foundHeader = false;
            while (true) {
                if ((line = r.readLine()) == null) {
                    return null;
                }
                if (!foundHeader) {
                    if (!line.startsWith(header)) continue;
                    foundHeader = true;
                    line = line.substring(header.length());
                }
                if (!line.startsWith(" ")) {
                    return null;
                }
                if ((line = line.trim()).length() != 0) break;
            }
            int idx = line.indexOf(59);
            if (idx != -1) {
                line = line.substring(0, idx);
            }
            String string = line;
            return string;
        }
        finally {
            in.close();
        }
    }
}

