/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.UUID;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.AbstractEnumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectSizer {
    private static Log logger = LogFactory.getLog(ObjectSizer.class);
    private static List unsizeableObjectList = new ArrayList(10);
    private final Map<Object, Object> visited = new IdentityHashMap<Object, Object>();

    public static long getSize(Object object) {
        if (object == null) {
            return 0L;
        }
        ObjectSizer sizer = new ObjectSizer();
        long size = sizer.getSize(object, 0L);
        return size;
    }

    private ObjectSizer() {
    }

    private long getSize(Collection<?> objects) {
        if (objects == null) {
            return 0L;
        }
        long size = 8L;
        Iterator<?> i = objects.iterator();
        while (i.hasNext()) {
            size += this.getSize(i.next(), 4L);
        }
        return size;
    }

    private long getSize(Map<?, ?> objects) {
        if (objects == null) {
            return 0L;
        }
        long size = 32L;
        for (Map.Entry<?, ?> entry : objects.entrySet()) {
            size += 4L;
            size += this.getSize(entry.getKey(), 4L);
            size += this.getSize(entry.getValue(), 4L);
        }
        return size;
    }

    private long getSize(Object[] objects) {
        if (objects == null) {
            return 0L;
        }
        long size = 8L;
        int i = 0;
        while (i < objects.length) {
            size = objects[i] != null ? (size += this.getSize(objects[i], 4L)) : (size += 4L);
            ++i;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize(Object object, long extra) {
        if (object == null) {
            return 0L;
        }
        if (this.visited.containsKey(object)) {
            return 0L;
        }
        this.visited.put(object, null);
        if (object instanceof Integer) {
            return 4L;
        }
        if (object instanceof Float) {
            return 4L;
        }
        if (object instanceof Double) {
            return 8L;
        }
        if (object instanceof Long) {
            return 8L;
        }
        if (object instanceof Short) {
            return 2L;
        }
        if (object instanceof Byte) {
            return 1L;
        }
        if (object instanceof Boolean) {
            return 1L;
        }
        if (object instanceof Character) {
            return 2L;
        }
        if (object instanceof String) {
            return extra + 8L + 24L + (long)(((String)object).length() * 2);
        }
        if (object instanceof UUID) {
            return extra + 8L + 16L;
        }
        if (object instanceof Collection) {
            return extra + 8L + this.getSize((Collection)object);
        }
        if (object instanceof Map) {
            return extra + 8L + this.getSize((Map)object);
        }
        if (object instanceof Object[]) {
            return extra + 8L + this.getSize((Object[])object);
        }
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            long size = extra + 8L + 20L;
            for (EStructuralFeature feature : eObject.eClass().getEAllStructuralFeatures()) {
                if (eObject.eIsSet(feature)) {
                    Object value = eObject.eGet(feature);
                    size += this.getSize(value, 4L);
                    continue;
                }
                size += 4L;
            }
            return size;
        }
        if (object instanceof Timestamp) {
            return 28L + extra;
        }
        if (object instanceof AbstractEnumerator) {
            AbstractEnumerator enumerator = (AbstractEnumerator)object;
            long nameSize = ObjectSizer.getSize(enumerator.getName());
            long literalSize = ObjectSizer.getSize(enumerator.getLiteral());
            return nameSize + literalSize + 4L + 8L + extra;
        }
        if (object instanceof Date) {
            return 28L + extra;
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            long stringSize = ObjectSizer.getSize(bigDecimal.toString());
            return stringSize + 8L + extra;
        }
        if (object instanceof Sizeable) {
            Sizeable sizeable = (Sizeable)object;
            long size = sizeable.getObjectSize(this);
            return size + extra;
        }
        String className = object.getClass().getName();
        if ("com.ibm.team.repository.client.internal.TeamRepository".equals(className)) {
            return 0L;
        }
        List list = unsizeableObjectList;
        synchronized (list) {
            block28: {
                if (!unsizeableObjectList.contains(className)) break block28;
                return 0L;
            }
            String message = "Unhandled ObjectSizer Class Case : '%s'";
            logger.warn((Object)String.format(message, className));
            unsizeableObjectList.add(className);
            return 0L;
        }
    }

    public static interface Sizeable {
        public long getObjectSize(ObjectSizer var1);
    }
}

