/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.IVirtualType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.ImmutablePropertyException;
import com.ibm.team.repository.common.internal.querypath.AbstractQueryPathModel;
import com.ibm.team.repository.common.model.Helper;
import com.ibm.team.repository.common.model.HelperType;
import com.ibm.team.repository.common.model.Item;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.model.RepositoryFactory;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.model.Type;
import com.ibm.team.repository.common.model.Virtual;
import com.ibm.team.repository.common.model.VirtualType;
import com.ibm.team.repository.common.query.ast.IDynamicQueryModel;
import com.ibm.team.repository.common.util.NLS;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EContentAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemUtil {
    private static final EReference ITEM_STRING_EXTENSIONS = RepositoryPackage.eINSTANCE.getItem_StringExtensions();
    private static final EReference ITEM_INT_EXTENSIONS = RepositoryPackage.eINSTANCE.getItem_IntExtensions();
    private static final EReference ITEM_BOOLEAN_EXTENSIONS = RepositoryPackage.eINSTANCE.getItem_BooleanExtensions();
    private static final EReference ITEM_TIMESTAMP_EXTENSIONS = RepositoryPackage.eINSTANCE.getItem_TimestampExtensions();
    private static final EReference ITEM_LONG_EXTENSIONS = RepositoryPackage.eINSTANCE.getItem_LongExtensions();
    private static final EReference ITEM_MEDIUM_STRING_EXTENSIONS = RepositoryPackage.eINSTANCE.getItem_MediumStringExtensions();
    private static final EReference ITEM_LARGE_STRING_EXTENSIONS = RepositoryPackage.eINSTANCE.getItem_LargeStringExtensions();
    private static final EReference ITEM_BIG_DECIMAL_EXTENSIONS = RepositoryPackage.eINSTANCE.getItem_BigDecimalExtensions();
    private static final Set<EStructuralFeature> EXTENSIONS_FEATURES = new HashSet<EStructuralFeature>(10);
    private static final String[] EXTENSIONS_FEATURE_NAMES;
    public static final UUID DELETED_UUID;
    public static final long SMALL_STRING_BYTES = 250L;
    public static final long MEDIUM_STRING_BYTES = 1000L;
    public static final long LARGE_STRING_BYTES = 32768L;
    private static final String TEAM_PACKAGE_ANNOTATION = "teamPackage";
    private static final String TEAM_CLASS_ANNOTATION = "teamClass";
    private static final String BASE_PACKAGE_DETAIL = "clientBasePackage";
    private static final String PACKAGE_SUFFIX_DETAIL = "clientPackageSuffix";
    private static final String QUERYMODEL_PACKAGE_DETAIL = "queryModelPackage";
    private static final String ALLOWS_STATE_EXTENSIONS_DETAIL = "allowsStateExtensions";
    private static String FACADE_FOR_CLASS_DETAIL;
    private static final String TEAM_ATTRIBUTE_ANNOTATION = "teamAttribute";
    private static final String QUERYABLE_PROPERTY_STEREOTYPE = "queryableProperty";
    private static final String UNIQUE_PROPERTY = "unique";
    private static final String ID_DETAIL = "id";
    private static final String TEAM_REFERENCE_ANNOTATION = "teamReference";
    private static final String MIN_RETRIEVAL_PROFILE_DETAIL = "minRetrievalProfile";
    private static final String SMALL_ACCESS_PROFILE = "SMALL";
    private static final String DB_STRING_SIZE_DETAIL = "dbStringSize";
    private static final String SMALL_DB_STRING_SIZE = "SMALL";
    private static final String MEDIUM_DB_STRING_SIZE = "MEDIUM";
    private static final String LARGE_DB_STRING_SIZE = "LARGE";
    private static final EDataType ESTRING;
    private static final Object lock;
    private static final ConcurrentMap<EClass, TypeAdapter> classToType;
    public static final Comparator itemIdComparator;
    public static final Comparator stateIdComparator;

    static {
        EXTENSIONS_FEATURES.add((EStructuralFeature)ITEM_STRING_EXTENSIONS);
        EXTENSIONS_FEATURES.add((EStructuralFeature)ITEM_INT_EXTENSIONS);
        EXTENSIONS_FEATURES.add((EStructuralFeature)ITEM_BOOLEAN_EXTENSIONS);
        EXTENSIONS_FEATURES.add((EStructuralFeature)ITEM_TIMESTAMP_EXTENSIONS);
        EXTENSIONS_FEATURES.add((EStructuralFeature)ITEM_LONG_EXTENSIONS);
        EXTENSIONS_FEATURES.add((EStructuralFeature)ITEM_MEDIUM_STRING_EXTENSIONS);
        EXTENSIONS_FEATURES.add((EStructuralFeature)ITEM_LARGE_STRING_EXTENSIONS);
        EXTENSIONS_FEATURES.add((EStructuralFeature)ITEM_BIG_DECIMAL_EXTENSIONS);
        EXTENSIONS_FEATURE_NAMES = new String[8];
        ItemUtil.EXTENSIONS_FEATURE_NAMES[0] = ITEM_STRING_EXTENSIONS.getName();
        ItemUtil.EXTENSIONS_FEATURE_NAMES[1] = ITEM_INT_EXTENSIONS.getName();
        ItemUtil.EXTENSIONS_FEATURE_NAMES[2] = ITEM_BOOLEAN_EXTENSIONS.getName();
        ItemUtil.EXTENSIONS_FEATURE_NAMES[3] = ITEM_TIMESTAMP_EXTENSIONS.getName();
        ItemUtil.EXTENSIONS_FEATURE_NAMES[4] = ITEM_LONG_EXTENSIONS.getName();
        ItemUtil.EXTENSIONS_FEATURE_NAMES[5] = ITEM_MEDIUM_STRING_EXTENSIONS.getName();
        ItemUtil.EXTENSIONS_FEATURE_NAMES[6] = ITEM_LARGE_STRING_EXTENSIONS.getName();
        ItemUtil.EXTENSIONS_FEATURE_NAMES[7] = ITEM_BIG_DECIMAL_EXTENSIONS.getName();
        DELETED_UUID = UUID.valueOf("_PhSpUCSGEdqXm8cK8FbAAQ");
        FACADE_FOR_CLASS_DETAIL = "facadeForClass";
        ESTRING = EcorePackage.eINSTANCE.getEString();
        lock = new Object();
        classToType = new ConcurrentHashMap<EClass, TypeAdapter>();
        itemIdComparator = new ItemIdComparator();
        stateIdComparator = new StateIdComparator();
    }

    public static EClass getTypeEClass(Type type) {
        EClass eClass = type.getAssociatedEClass();
        if (eClass == null) {
            eClass = ItemUtil.getEClass(type.getName(), type.getNamespaceURI());
            type.setAssociatedEClass(eClass);
        }
        return eClass;
    }

    public static EClass getHandleEClass(ItemType itemType) {
        EClass eClass = ItemUtil.getTypeEClass(itemType);
        TypeAdapter itemTypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return itemTypeAdapter.getHandleEClass();
    }

    public static EClass getItemEClass(ItemType itemType) {
        EClass eClass = ItemUtil.getTypeEClass(itemType);
        TypeAdapter itemTypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return itemTypeAdapter.getItemEClass();
    }

    public static EClass getItemEClass(EClass handleEClass) {
        if (handleEClass == null) {
            throw new IllegalArgumentException("Must specify an EClass");
        }
        if (!RepositoryPackage.eINSTANCE.getItemHandle().isSuperTypeOf(handleEClass) || handleEClass == RepositoryPackage.eINSTANCE.getAuditable() || handleEClass == RepositoryPackage.eINSTANCE.getSimpleItem() || handleEClass == RepositoryPackage.eINSTANCE.getUnmanagedItem()) {
            throw new IllegalArgumentException("EClass: " + handleEClass.toString());
        }
        TypeAdapter typeAdapter = ItemUtil.getTypeAdapter(handleEClass);
        return typeAdapter.getItemEClass();
    }

    public static EClass resolveReferenceTypeCompletely(EReference reference) {
        EClass target = ItemUtil.getTargetClassIfFacade(reference.getEReferenceType());
        if (ItemUtil.isHandle(target)) {
            return ItemUtil.getItemEClass(target);
        }
        return target;
    }

    public static IDynamicQueryModel getQueryModel(ItemType itemType) {
        EClass eClass = ItemUtil.getTypeEClass(itemType);
        TypeAdapter itemTypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return itemTypeAdapter.getQueryModel();
    }

    public static EClass getEClass(String className, String namespace) {
        EClassifier eClassifier;
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(namespace);
        if (ePackage != null && (eClassifier = ePackage.getEClassifier(className)) instanceof EClass) {
            return (EClass)eClassifier;
        }
        return null;
    }

    public static EPackage getEPackage(String namespace) {
        return EPackage.Registry.INSTANCE.getEPackage(namespace);
    }

    public static List getPropertyNames(Type type) {
        EClass eClass = ItemUtil.getTypeEClass(type);
        TypeAdapter typeAdapter = ItemUtil.getTypeAdapter(eClass);
        return typeAdapter.getPropertyNames();
    }

    public static List getValidFetchPropertyNames(Type type) {
        EClass eClass = ItemUtil.getTypeEClass(type);
        TypeAdapter typeAdapter = ItemUtil.getTypeAdapter(eClass);
        return typeAdapter.getValidFetchPropertyNames();
    }

    public static long getMaxSizeInBytes(EStructuralFeature feature) {
        if (feature == null) {
            throw new IllegalArgumentException("Feature must not be null");
        }
        if (feature.getEType() == ESTRING) {
            StringSize size = ItemUtil.getStringSize((EAttribute)feature);
            switch (size) {
                case LARGE: {
                    return 32768L;
                }
                case MEDIUM: {
                    return 1000L;
                }
                case SMALL: {
                    return 250L;
                }
            }
            throw new IllegalArgumentException("Unsupported string size");
        }
        String msg = NLS.bind("Property {0} is not a string property", feature.getName(), new Object[0]);
        throw new IllegalArgumentException(msg);
    }

    public static StringSize getStringSize(EAttribute stringAttribute) {
        String stringSize;
        EAnnotation annotation = stringAttribute.getEAnnotation(TEAM_ATTRIBUTE_ANNOTATION);
        if (annotation != null && (stringSize = (String)annotation.getDetails().get((Object)DB_STRING_SIZE_DETAIL)) != null) {
            if (stringSize.equals("SMALL")) {
                return StringSize.SMALL;
            }
            if (stringSize.equals(MEDIUM_DB_STRING_SIZE)) {
                return StringSize.MEDIUM;
            }
            if (stringSize.equals(LARGE_DB_STRING_SIZE)) {
                return StringSize.LARGE;
            }
        }
        return StringSize.SMALL;
    }

    @Deprecated
    public static long getMaxSize(EStructuralFeature feature) {
        if (feature.getEType() == ESTRING) {
            long sizeInBytes = ItemUtil.getMaxSizeInBytes(feature);
            return sizeInBytes / 2L;
        }
        return -1L;
    }

    @Deprecated
    public static boolean isStringSmallEnough(EStructuralFeature feature, String string) {
        return ItemUtil.validateStringPropertySize(feature, string) != null;
    }

    public static StringLengthViolation validateStringPropertySize(EStructuralFeature feature, String value) {
        long maxBytes;
        if (feature == null) {
            String msg = String.format("Feature must not be null", new Object[0]);
            throw new IllegalArgumentException(msg);
        }
        if (feature.getEType() != ESTRING) {
            String msg = String.format("Feature \"%s\" is not a string property", feature.getName());
            throw new IllegalArgumentException(msg);
        }
        if (value == null) {
            String msg = String.format("Null value encountered validating string size for %s", feature.getName());
            throw new IllegalArgumentException(msg);
        }
        long bytes = ItemUtil.getUtf8ByteLength(value);
        if (bytes <= (maxBytes = ItemUtil.getMaxSizeInBytes(feature))) {
            return null;
        }
        return new StringLengthViolation(maxBytes, bytes);
    }

    public static List getMinimalPropertyNames(ItemType itemType) {
        EClass eClass = ItemUtil.getTypeEClass(itemType);
        TypeAdapter itemTypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return itemTypeAdapter.getMinimalPropertyNames();
    }

    public static boolean allowsStateExtensions(ItemType itemType) {
        EClass eClass = ItemUtil.getTypeEClass(itemType);
        return ItemUtil.allowsStateExtensions(eClass);
    }

    public static boolean allowsStateExtensions(EClass eClass) {
        TypeAdapter itemTypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return itemTypeAdapter.allowsStateExtensions();
    }

    public static String getIdProperty(ItemType itemType) {
        EClass eClass = ItemUtil.getTypeEClass(itemType);
        return ItemUtil.getIdProperty(eClass);
    }

    public static String getIdProperty(EClass eClass) {
        TypeAdapter itemTypeAdapter = ItemUtil.getTypeAdapter(eClass);
        return itemTypeAdapter.getIdProperty();
    }

    public static ItemHandle createItemHandle(EClass eClass, UUID itemId, UUID optionalStateId) {
        EObject object = eClass.getEPackage().getEFactoryInstance().create(eClass);
        if (object instanceof ItemHandle) {
            ItemHandle handle = (ItemHandle)object;
            handle.setItemId(itemId);
            if (optionalStateId != null) {
                handle.setStateId(optionalStateId);
            }
            return handle;
        }
        return null;
    }

    public static ItemHandle createItemHandle(ItemType itemType, UUID itemId, UUID optionalStateId) {
        EClass eClass = ItemUtil.getHandleEClass(itemType);
        return ItemUtil.createItemHandle(eClass, itemId, optionalStateId);
    }

    public static ItemHandle newItemHandle(ItemHandle itemHandle, boolean includeStateId) {
        EClass eClass = ItemUtil.getHandleEClass((ItemType)itemHandle.getItemType());
        UUID itemId = itemHandle.getItemId();
        UUID optionalStateId = includeStateId ? itemHandle.getStateId() : null;
        ItemHandle newItemHandle = ItemUtil.createItemHandle(eClass, itemId, optionalStateId);
        newItemHandle.setOrigin(itemHandle.getOrigin());
        return newItemHandle;
    }

    public static ItemType itemTypeFor(ItemHandle handle) {
        EClass eClass = ((EObject)handle).eClass();
        return ItemUtil.itemTypeFor(eClass);
    }

    public static ItemType itemTypeFor(String name, String namespaceURI) {
        EClassifier classifier;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        EPackage ePackage = null;
        ePackage = EPackage.Registry.INSTANCE.getEPackage(namespaceURI);
        if (ePackage != null && (classifier = ePackage.getEClassifier(name)) instanceof EClass) {
            return ItemUtil.itemTypeFor((EClass)classifier);
        }
        return null;
    }

    public static List<IItemType> itemTypeFor(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        ArrayList<IItemType> typesList = new ArrayList<IItemType>();
        IItemType[] types = IItemType.IRegistry.INSTANCE.getAllItemTypes();
        int i = 0;
        while (i < types.length) {
            if (name.equals(types[i].getName())) {
                typesList.add(types[i]);
            }
            ++i;
        }
        return typesList;
    }

    public static ItemType itemTypeFor(EClass eClass) {
        if (eClass == null) {
            throw new NullPointerException("Must specify an EClass");
        }
        if (!RepositoryPackage.eINSTANCE.getItemHandle().isSuperTypeOf(eClass) || eClass == RepositoryPackage.eINSTANCE.getAuditable() || eClass == RepositoryPackage.eINSTANCE.getAuditableHandle() || eClass == RepositoryPackage.eINSTANCE.getSimpleItem() || eClass == RepositoryPackage.eINSTANCE.getSimpleItemHandle() || eClass == RepositoryPackage.eINSTANCE.getUnmanagedItem() || eClass == RepositoryPackage.eINSTANCE.getUnmanagedItemHandle()) {
            throw new IllegalArgumentException("EClass: " + eClass.toString());
        }
        TypeAdapter typeAdapter = ItemUtil.getTypeAdapter(eClass);
        return (ItemType)typeAdapter.getType();
    }

    public static HelperType helperTypeFor(Helper helper) {
        EClass eClass = ((EObject)helper).eClass();
        return ItemUtil.helperTypeFor(eClass);
    }

    public static HelperType helperTypeFor(String name, String namespaceURI) {
        EClassifier classifier;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        EPackage ePackage = null;
        ePackage = EPackage.Registry.INSTANCE.getEPackage(namespaceURI);
        if (ePackage != null && (classifier = ePackage.getEClassifier(name)) instanceof EClass) {
            return ItemUtil.helperTypeFor((EClass)classifier);
        }
        return null;
    }

    public static HelperType helperTypeFor(EClass eClass) {
        if (eClass == null || !RepositoryPackage.eINSTANCE.getHelper().isSuperTypeOf(eClass)) {
            throw new IllegalArgumentException();
        }
        TypeAdapter typeAdapter = ItemUtil.getTypeAdapter(eClass);
        return (HelperType)typeAdapter.getType();
    }

    public static VirtualType virtualTypeFor(Virtual virtual) {
        EClass eClass = ((EObject)virtual).eClass();
        return ItemUtil.virtualTypeFor(eClass);
    }

    public static VirtualType virtualTypeFor(String name, String namespaceURI) {
        EClassifier classifier;
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (namespaceURI == null) {
            throw new IllegalArgumentException();
        }
        EPackage ePackage = null;
        ePackage = EPackage.Registry.INSTANCE.getEPackage(namespaceURI);
        if (ePackage != null && (classifier = ePackage.getEClassifier(name)) instanceof EClass) {
            return ItemUtil.virtualTypeFor((EClass)classifier);
        }
        return null;
    }

    public static List<IVirtualType> virtualTypeFor(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        ArrayList<IVirtualType> typesList = new ArrayList<IVirtualType>();
        IVirtualType[] types = IVirtualType.IRegistry.INSTANCE.getAllVirtualTypes();
        int i = 0;
        while (i < types.length) {
            if (name.equals(types[i].getName())) {
                typesList.add(types[i]);
            }
            ++i;
        }
        return typesList;
    }

    public static VirtualType virtualTypeFor(EClass eClass) {
        if (eClass == null || !RepositoryPackage.eINSTANCE.getVirtual().isSuperTypeOf(eClass)) {
            throw new IllegalArgumentException();
        }
        TypeAdapter typeAdapter = ItemUtil.getTypeAdapter(eClass);
        return (VirtualType)typeAdapter.getType();
    }

    private static TypeAdapter getTypeAdapter(EClass eClass) {
        TypeAdapter typeAdapter = (TypeAdapter)classToType.get(eClass);
        if (typeAdapter != null) {
            return typeAdapter;
        }
        EClass handleEClass = null;
        if (RepositoryPackage.eINSTANCE.getItemHandle().isSuperTypeOf(eClass)) {
            String eClassName = eClass.getName();
            if (eClassName.endsWith("Handle")) {
                String nonHandleClazzName = eClassName.substring(0, eClassName.length() - 6);
                handleEClass = eClass;
                eClass = (EClass)eClass.getEPackage().getEClassifier(nonHandleClazzName);
                eClassName = eClass.getName();
            } else {
                handleEClass = (EClass)eClass.getEPackage().getEClassifier(String.valueOf(eClassName) + "Handle");
            }
        }
        Type type = null;
        type = RepositoryPackage.eINSTANCE.getHelper().isSuperTypeOf(eClass) ? RepositoryFactory.eINSTANCE.createHelperType() : (RepositoryPackage.eINSTANCE.getVirtual().isSuperTypeOf(eClass) ? RepositoryFactory.eINSTANCE.createVirtualType() : (handleEClass != null || RepositoryPackage.eINSTANCE.getItem().isSuperTypeOf(eClass) ? RepositoryFactory.eINSTANCE.createItemType() : RepositoryFactory.eINSTANCE.createVirtualType()));
        type.setName(eClass.getName());
        type.setNamespaceURI(eClass.getEPackage().getNsURI());
        type.setAbstract(eClass.isAbstract());
        type.setAssociatedEClass(eClass);
        typeAdapter = new TypeAdapter(type, eClass, handleEClass);
        TypeAdapter currentValue = classToType.putIfAbsent(eClass, typeAdapter);
        if (currentValue != null) {
            return currentValue;
        }
        if (handleEClass != null) {
            classToType.putIfAbsent(handleEClass, typeAdapter);
        }
        return typeAdapter;
    }

    public static String itemType2String(EClass eClass) {
        return String.valueOf(eClass.getEPackage().getNsURI()) + '#' + eClass.getName();
    }

    public static String itemType2String(IType type) {
        return String.valueOf(type.getNamespaceURI()) + '#' + type.getName();
    }

    public static String typeToName(IType type) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        return String.valueOf(type.getNamespaceURI()) + '.' + type.getName();
    }

    public static IItemType nameToItemType(String name) {
        int index = name.lastIndexOf(46);
        if (index > 0 && name.endsWith(".")) {
            throw new IllegalArgumentException("Illegal syntax for qualified typename - ends with '.'");
        }
        if (index == -1) {
            List<IItemType> types = ItemUtil.itemTypeFor(name);
            if (types.isEmpty()) {
                return null;
            }
            if (types.size() > 1) {
                throw new IllegalArgumentException("There are more than one registered names for '" + name + '\'');
            }
            return types.get(0);
        }
        String suffix = name.substring(index + 1);
        String namespace = name.substring(0, index);
        return ItemUtil.itemTypeFor(suffix, namespace);
    }

    public static IVirtualType nameToVirtualType(String name) {
        int index = name.lastIndexOf(46);
        if (index > 0 && name.endsWith(".")) {
            throw new IllegalArgumentException("Illegal syntax for qualified typename - ends with '.'");
        }
        if (index == -1) {
            List<IVirtualType> types = ItemUtil.virtualTypeFor(name);
            if (types.isEmpty()) {
                return null;
            }
            if (types.size() > 1) {
                throw new IllegalArgumentException("There are more than one registered names for '" + name + '\'');
            }
            return types.get(0);
        }
        String suffix = name.substring(index + 1);
        String namespace = name.substring(0, index);
        return ItemUtil.virtualTypeFor(suffix, namespace);
    }

    public static ItemType string2ItemType(String strItemType) {
        int index = strItemType.lastIndexOf(35);
        if (index < 0 || index != strItemType.indexOf(35)) {
            throw new IllegalArgumentException("Malformed ITEM_TYPE: " + strItemType);
        }
        String nsURI = strItemType.substring(0, index);
        String name = strItemType.substring(index + 1);
        EPackage pkg = EPackage.Registry.INSTANCE.getEPackage(nsURI);
        if (pkg == null) {
            throw new IllegalArgumentException("Unknown namespace in: " + strItemType);
        }
        EClassifier eClass = pkg.getEClassifier(name);
        if (eClass instanceof EClass) {
            return ItemUtil.itemTypeFor((EClass)eClass);
        }
        throw new IllegalArgumentException("Unknown class in: " + strItemType);
    }

    public static ItemType string2ItemType(String strItemType, Map cachedTranslations) {
        Object translation = cachedTranslations.get(strItemType);
        if (translation != null) {
            ItemType result = (ItemType)translation;
            return result;
        }
        ItemType itemType = ItemUtil.string2ItemType(strItemType);
        cachedTranslations.put(strItemType, itemType);
        return itemType;
    }

    public static List<EStructuralFeature> getPersistentStructuralFeatures(ItemType itemType) {
        if (itemType == null) {
            return null;
        }
        EClass eClass = ItemUtil.getTypeEClass(itemType);
        return ItemUtil.getPersistentStructuralFeatures(eClass);
    }

    public static List<EStructuralFeature> getPersistentStructuralFeatures(EClass eClass) {
        if (eClass == null) {
            return null;
        }
        TypeAdapter typeAdapter = ItemUtil.getTypeAdapter(eClass);
        return typeAdapter.getPersistentStructuralFeatures();
    }

    public static boolean isPersistent(EClass eClass, EStructuralFeature feature) {
        if (eClass == null) {
            return false;
        }
        TypeAdapter typeAdapter = ItemUtil.getTypeAdapter(eClass);
        return typeAdapter.isPersistent(eClass, feature);
    }

    public static boolean isSubclass(EClass base, EClass test) {
        return base != test && base.isSuperTypeOf(test) && ItemUtil.isSameKind(base, test);
    }

    public static boolean isSameKind(EClass typeA, EClass typeB) {
        if (ItemUtil.isHandle(typeA)) {
            return ItemUtil.isHandle(typeB);
        }
        if (ItemUtil.isHandle(typeB)) {
            return ItemUtil.isHandle(typeA);
        }
        return true;
    }

    public static boolean isSameItemType(IItemType typeA, IItemType typeB) {
        return typeA.getNamespaceURI().equals(typeB.getNamespaceURI()) && typeA.getName().equals(typeB.getName());
    }

    public static boolean isHandle(EClass eClass) {
        return RepositoryPackage.eINSTANCE.getItemHandle().isSuperTypeOf(eClass) && !RepositoryPackage.eINSTANCE.getItem().isSuperTypeOf(eClass);
    }

    public static boolean isHandle(EReference eReference) {
        EClass type = ItemUtil.getTargetClassIfFacade(eReference.getEReferenceType());
        return ItemUtil.isHandle(type);
    }

    public static boolean isImmutableFeature(EStructuralFeature feature) {
        return feature.equals(RepositoryPackage.eINSTANCE.getItemHandle_Immutable());
    }

    public static EClass getTargetClassIfFacade(EClass eClass) {
        String facadeClassName = ItemUtil.getValue((EModelElement)eClass, TEAM_CLASS_ANNOTATION, FACADE_FOR_CLASS_DETAIL);
        if (facadeClassName == null || facadeClassName.length() == 0) {
            return eClass;
        }
        return (EClass)eClass.getEPackage().getEClassifier(facadeClassName);
    }

    public static EClass getTargetClassIfFacade(EReference reference) {
        return ItemUtil.getTargetClassIfFacade(reference.getEReferenceType());
    }

    private static String getValue(EModelElement element, String annotationSource, String detail) {
        EAnnotation annotation = element.getEAnnotation(annotationSource);
        if (annotation == null) {
            return null;
        }
        return (String)annotation.getDetails().get((Object)detail);
    }

    public static boolean isInstanceOf(IItemType type, IItem item) {
        EClass typeClass = (EClass)type.getAdapter(EClass.class);
        boolean result = typeClass.isInstance((Object)item);
        return result;
    }

    public static boolean isInstanceOf(IItemType type, IItemHandle handle) {
        EClass typeClass = ItemUtil.getHandleEClass((ItemType)type);
        boolean result = typeClass.isInstance((Object)handle);
        return result;
    }

    public static boolean equivItemRef(IItemHandle lhs, IItemHandle rhs) {
        if (lhs == null) {
            return rhs == null;
        }
        return lhs.sameItemId(rhs);
    }

    public static boolean itemInCollection(IItemHandle item, Collection itemCollection) {
        return ItemUtil.itemInCollection(itemIdComparator, item, itemCollection);
    }

    public static boolean itemInCollection(Comparator comparator, IItemHandle item, Collection itemCollection) {
        for (IItemHandle nextItem : itemCollection) {
            if (comparator.compare(item, nextItem) != 0) continue;
            return true;
        }
        return false;
    }

    public static IItemHandle findItem(IItemHandle item, Collection itemList) {
        for (IItemHandle nextItem : itemList) {
            if (!item.sameItemId(nextItem)) continue;
            return nextItem;
        }
        return null;
    }

    public static Collection retainAll(Collection items, Collection itemsToRetain) {
        return ItemUtil.select(items, itemsToRetain, true);
    }

    public static Collection removeAll(Collection items, Collection itemsToRemove) {
        return ItemUtil.select(items, itemsToRemove, false);
    }

    private static Collection select(Collection items, Collection itemsToMatch, boolean matching) {
        ArrayList<IItemHandle> selected = new ArrayList<IItemHandle>();
        for (IItemHandle current : items) {
            if (ItemUtil.itemInCollection(current, itemsToMatch)) {
                if (!matching) continue;
                selected.add(current);
                continue;
            }
            if (matching) continue;
            selected.add(current);
        }
        return selected;
    }

    public static boolean isSame(Collection lhs, Collection rhs) {
        return ItemUtil.isSame(itemIdComparator, lhs, rhs);
    }

    public static boolean isSame(Comparator comparator, Collection lhs, Collection rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.size() != rhs.size()) {
            return false;
        }
        for (IItemHandle current : lhs) {
            if (ItemUtil.itemInCollection(comparator, current, rhs)) continue;
            return false;
        }
        for (IItemHandle current : rhs) {
            if (ItemUtil.itemInCollection(comparator, current, lhs)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSameList(List lhs, List rhs) {
        if (lhs == null || rhs == null) {
            return false;
        }
        if (lhs.size() != rhs.size()) {
            return false;
        }
        Iterator lhsIter = lhs.iterator();
        Iterator rhsIter = rhs.iterator();
        while (lhsIter.hasNext()) {
            IItemHandle right;
            if (!rhsIter.hasNext()) {
                return false;
            }
            IItemHandle left = (IItemHandle)lhsIter.next();
            if (left.sameItemId(right = (IItemHandle)rhsIter.next())) continue;
            return false;
        }
        return !rhsIter.hasNext();
    }

    public static Collection itemsToHandles(Collection items) {
        ArrayList<ItemHandle> handles = new ArrayList<ItemHandle>(items.size());
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            handles.add(ItemUtil.newItemHandle((ItemHandle)iter.next(), true));
        }
        return handles;
    }

    public static void clearHelperIds(EObject object) {
        TreeIterator iter = object.eAllContents();
        EObject child = null;
        while (iter.hasNext()) {
            child = (EObject)iter.next();
            if (!(child instanceof Helper)) continue;
            ((Helper)child).setInternalId(null);
        }
    }

    public static void protect(ItemHandle itemHandle) {
        ProtectAdapter.INSTANCE.add(itemHandle);
    }

    public static void unprotect(ItemHandle itemHandle) {
        ProtectAdapter.INSTANCE.remove(itemHandle);
    }

    private static long getUtf8ByteLength(String string) {
        int length = string.length();
        long bytes = 0L;
        int i = 0;
        while (i < length) {
            char ch = string.charAt(i);
            bytes = (ch & 0xFF80) == 0 ? ++bytes : ((ch & 0xF800) == 0 ? (bytes += 2L) : (bytes += 3L));
            ++i;
        }
        return bytes;
    }

    public static boolean isProtected(ItemHandle itemHandle) {
        boolean result = ProtectAdapter.INSTANCE.isAdapterOf(itemHandle);
        return result;
    }

    public static Map createItemIdKeyMap() {
        return new TreeMap(itemIdComparator);
    }

    public static Map createStateIdKeyMap() {
        return new TreeMap(stateIdComparator);
    }

    public static boolean listsEqual(List list1, List list2, Comparator cmp) {
        int size2;
        if (list1 == list2) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        int size1 = list1.size();
        if (size1 != (size2 = list2.size())) {
            return false;
        }
        Iterator i1 = list1.iterator();
        Iterator i2 = list2.iterator();
        while (i1.hasNext() && i2.hasNext()) {
            Object elem2;
            Object elem1 = i1.next();
            if (cmp.compare(elem1, elem2 = i2.next()) == 0) continue;
            return false;
        }
        return true;
    }

    private static boolean getBooleanProperty(EModelElement element, String stereotype, String propertyName, boolean defaultValue) {
        String prop = ItemUtil.primGetProperty(element, stereotype, propertyName);
        return prop == null ? defaultValue : prop.toLowerCase(Locale.ENGLISH).equals(Boolean.TRUE.toString());
    }

    public static boolean isQueryable(EStructuralFeature feature) {
        EAnnotation ann = feature.getEAnnotation(QUERYABLE_PROPERTY_STEREOTYPE);
        return ann != null;
    }

    public static boolean isUnique(EStructuralFeature feature) {
        return ItemUtil.isQueryable(feature) && ItemUtil.getBooleanProperty((EModelElement)feature, QUERYABLE_PROPERTY_STEREOTYPE, UNIQUE_PROPERTY, false);
    }

    public static boolean isStateExtensionsFeature(EStructuralFeature feature) {
        return EXTENSIONS_FEATURES.contains(feature);
    }

    public static String[] getStateExtensionsPropertyNamesAsImplemented() {
        return EXTENSIONS_FEATURE_NAMES;
    }

    public static String[] expandPropertiesForStateExtensions(IItemType type, String[] properties) {
        if (properties == null) {
            return null;
        }
        if (!type.allowsStateExtensions()) {
            return properties;
        }
        LinkedHashSet<String> aSet = new LinkedHashSet<String>(Arrays.asList(properties));
        boolean needsExpansion = false;
        boolean bl = needsExpansion = aSet.contains("com.ibm.team.repository.item.allStateExtensions") || ItemUtil.containsAny(aSet, EXTENSIONS_FEATURE_NAMES);
        if (needsExpansion) {
            aSet.remove("com.ibm.team.repository.item.allStateExtensions");
            aSet.addAll(Arrays.asList(EXTENSIONS_FEATURE_NAMES));
            return aSet.toArray(new String[aSet.size()]);
        }
        return properties;
    }

    private static boolean containsAny(Set aSet, String[] any) {
        int i = 0;
        while (i < any.length) {
            if (aSet.contains(any[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static String primGetProperty(EModelElement element, String stereotype, String propertyName) {
        EAnnotation ann = element.getEAnnotation(stereotype);
        return ann == null ? null : (String)ann.getDetails().get((Object)propertyName);
    }

    public static abstract class AbstractIdComparator
    implements Comparator {
        private static final int lt = -1;
        private static final int eq = 0;
        private static final int gt = 1;

        protected abstract UUID getId(Object var1);

        public final int compare(Object o1, Object o2) {
            UUID id2;
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            UUID id1 = this.getId(o1);
            if (id1 == (id2 = this.getId(o2))) {
                return 0;
            }
            if (id1 == null) {
                return 1;
            }
            if (id2 == null) {
                return -1;
            }
            return id1.compareTo(id2);
        }
    }

    private static final class ItemIdComparator
    extends AbstractIdComparator {
        private ItemIdComparator() {
        }

        protected UUID getId(Object o) {
            ItemHandle handle = (ItemHandle)o;
            return handle.getItemId();
        }
    }

    private static class ProtectAdapter
    extends EContentAdapter {
        private static final EClass HELPER = RepositoryPackage.eINSTANCE.getHelper();
        public static ProtectAdapter INSTANCE = new ProtectAdapter();

        private ProtectAdapter() {
        }

        public void add(ItemHandle itemHandle) {
            this.add((EObject)itemHandle.getAdapter(EObject.class));
        }

        public void remove(ItemHandle itemHandle) {
            this.remove((EObject)itemHandle.getAdapter(EObject.class));
        }

        public boolean isAdapterOf(ItemHandle itemHandle) {
            return this.isAdapterOf((EObject)itemHandle.getAdapter(EObject.class));
        }

        public void notifyChanged(Notification notification) {
            EReference ref;
            Object newValue;
            Item item;
            super.notifyChanged(notification);
            if (notification.isTouch()) {
                return;
            }
            int eventType = notification.getEventType();
            if (eventType < 0 || eventType > 7) {
                return;
            }
            EObject eObject = (EObject)notification.getNotifier();
            if (eObject == null) {
                return;
            }
            EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
            if (feature == null) {
                return;
            }
            if (!ItemUtil.isPersistent(eObject.eClass(), feature)) {
                return;
            }
            ItemHandle itemHandle = this.getItemHandle(eObject);
            if (itemHandle == null) {
                return;
            }
            if (itemHandle.isImmutable()) {
                throw new ImmutablePropertyException(eObject, feature.getName());
            }
            if (eObject instanceof Item && (item = (Item)eObject).isWorkingCopy() && !notification.wasSet()) {
                throw new ImmutablePropertyException(eObject, feature.getName());
            }
            if ((notification.getEventType() == 3 || notification.getEventType() == 1) && (newValue = notification.getNewValue()) != null && feature instanceof EReference && HELPER.isSuperTypeOf(ItemUtil.getTargetClassIfFacade(ref = (EReference)feature))) {
                Helper helper = (Helper)newValue;
                helper.setInternalId(null);
                ItemUtil.clearHelperIds((EObject)helper);
            }
        }

        public void setTarget(Notifier object) {
            Collection contents = this.getContents(object);
            if (contents != null) {
                EClass eClass = ((EObject)object).eClass();
                for (EObject elem : contents) {
                    EReference containmentFeature = elem.eContainmentFeature();
                    if (!ItemUtil.isPersistent(eClass, (EStructuralFeature)containmentFeature)) continue;
                    elem.eAdapters().add((Object)this);
                }
            }
        }

        public void unsetTarget(Object notifier) {
            this.target = null;
            Collection contents = this.getContents(notifier);
            if (contents != null) {
                Iterator i = contents.iterator();
                while (i.hasNext()) {
                    ((Notifier)i.next()).eAdapters().remove((Object)this);
                }
            }
        }

        private Collection getContents(Object object) {
            if (object instanceof EObject) {
                return ((EObject)object).eContents();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void add(EObject eObject) {
            Object object = lock;
            synchronized (object) {
                if (!eObject.eAdapters().contains((Object)this)) {
                    eObject.eAdapters().add((Object)this);
                }
            }
        }

        private void remove(EObject eObject) {
            eObject.eAdapters().remove((Object)this);
        }

        private boolean isAdapterOf(EObject eObject) {
            return eObject.eAdapters().contains((Object)this);
        }

        private ItemHandle getItemHandle(EObject eObject) {
            EObject eContainer = eObject;
            while (eContainer != null) {
                if (eContainer instanceof ItemHandle) {
                    return (ItemHandle)eContainer;
                }
                eContainer = eContainer.eContainer();
            }
            return null;
        }
    }

    private static final class StateIdComparator
    extends AbstractIdComparator {
        private StateIdComparator() {
        }

        protected UUID getId(Object o) {
            ItemHandle handle = (ItemHandle)o;
            return handle.getStateId();
        }
    }

    public static class StringLengthViolation {
        private final long maxSize;
        private final long actualSize;

        public StringLengthViolation(long maxSize, long actualSize) {
            this.maxSize = maxSize;
            this.actualSize = actualSize;
        }

        public long getMaxSize() {
            return this.maxSize;
        }

        public long getActualSize() {
            return this.actualSize;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StringSize {
        SMALL,
        MEDIUM,
        LARGE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeAdapter {
        private final Type type;
        private final EClass itemEClass;
        private final EClass handleEClass;
        private final boolean allowsStateExtensions;
        private final String idPropertyName;
        private final List<String> propertyNames;
        private final List<String> validFetchPropertyNames;
        private final List<String> minimalPropertyNames;
        private final List<EStructuralFeature> persistentStructuralFeatures;
        private final IDynamicQueryModel queryModel;

        public TypeAdapter(Type itemType, EClass eClass, EClass handleEClass) {
            EStructuralFeature idFeature;
            String trueValue = Boolean.TRUE.toString();
            this.type = itemType;
            this.itemEClass = eClass;
            this.handleEClass = handleEClass;
            EAnnotation annotation = eClass.getEAnnotation(ItemUtil.TEAM_CLASS_ANNOTATION);
            this.allowsStateExtensions = annotation != null && trueValue.equals(annotation.getDetails().get((Object)ItemUtil.ALLOWS_STATE_EXTENSIONS_DETAIL));
            EList features = eClass.getEAllStructuralFeatures();
            ArrayList<EStructuralFeature> idPropertyNameFeatures = new ArrayList<EStructuralFeature>();
            ArrayList<String> propertyNames = new ArrayList<String>(features.size());
            ArrayList<String> validFetchPropertyNames = new ArrayList<String>(features.size());
            ArrayList<String> minimalPropertyNames = new ArrayList<String>(features.size());
            for (EStructuralFeature feature : features) {
                boolean add = false;
                boolean isStateExtensionsFeature = ItemUtil.isStateExtensionsFeature(feature);
                if (isStateExtensionsFeature) {
                    if (this.allowsStateExtensions) {
                        add = true;
                    }
                } else if (this.isPersistent(eClass, feature)) {
                    add = true;
                }
                if (add) {
                    String minRetrievalProfile;
                    validFetchPropertyNames.add(feature.getName());
                    propertyNames.add(feature.getName());
                    annotation = feature.getEAnnotation(feature instanceof EAttribute ? ItemUtil.TEAM_ATTRIBUTE_ANNOTATION : ItemUtil.TEAM_REFERENCE_ANNOTATION);
                    if (annotation != null && (minRetrievalProfile = (String)annotation.getDetails().get((Object)ItemUtil.MIN_RETRIEVAL_PROFILE_DETAIL)) != null && minRetrievalProfile.equals("SMALL")) {
                        minimalPropertyNames.add(feature.getName());
                    }
                }
                if (!(feature instanceof EAttribute) || !feature.getEType().equals(ESTRING) && !feature.getEType().equals(EcorePackage.eINSTANCE.getEInt()) || (annotation = feature.getEAnnotation(ItemUtil.TEAM_ATTRIBUTE_ANNOTATION)) == null || !trueValue.equals(annotation.getDetails().get((Object)ItemUtil.ID_DETAIL))) continue;
                idPropertyNameFeatures.add(feature);
            }
            if (this.allowsStateExtensions) {
                validFetchPropertyNames.add("com.ibm.team.repository.item.allStateExtensions");
            }
            this.idPropertyName = (idFeature = TypeAdapter.selectMostDerivedFeature(idPropertyNameFeatures, Collections.singletonList(eClass))) != null ? idFeature.getName() : null;
            this.propertyNames = Collections.unmodifiableList(propertyNames);
            this.minimalPropertyNames = Collections.unmodifiableList(minimalPropertyNames);
            List<EStructuralFeature> persistentStructuralFeatures = this.internalGetPersistentStructuralFeatures();
            this.persistentStructuralFeatures = Collections.unmodifiableList(persistentStructuralFeatures);
            this.validFetchPropertyNames = Collections.unmodifiableList(validFetchPropertyNames);
            this.queryModel = this.internalGetQueryModel();
        }

        public IDynamicQueryModel getQueryModel() {
            return this.queryModel;
        }

        public List<EStructuralFeature> getPersistentStructuralFeatures() {
            return this.persistentStructuralFeatures;
        }

        public boolean isPersistent(EClass eClass, EStructuralFeature feature) {
            if (!feature.isChangeable() || feature.isTransient() || feature.isVolatile() || feature.isDerived()) {
                return false;
            }
            if (ItemUtil.isStateExtensionsFeature(feature)) {
                return this.allowsStateExtensions;
            }
            return true;
        }

        public boolean allowsStateExtensions() {
            return this.allowsStateExtensions;
        }

        public String getIdProperty() {
            return this.idPropertyName;
        }

        public Type getType() {
            return this.type;
        }

        public EClass getHandleEClass() {
            return this.handleEClass;
        }

        public List<String> getPropertyNames() {
            return this.propertyNames;
        }

        public List<String> getValidFetchPropertyNames() {
            return this.validFetchPropertyNames;
        }

        public List<String> getMinimalPropertyNames() {
            return this.minimalPropertyNames;
        }

        private static EStructuralFeature selectMostDerivedFeature(List features, List classList) {
            if (features.isEmpty() || classList.isEmpty()) {
                return null;
            }
            for (EClass eClass : classList) {
                for (EStructuralFeature feature : features) {
                    if (!feature.getEContainingClass().equals(eClass)) continue;
                    return feature;
                }
            }
            Iterator classIter = classList.iterator();
            classList = new ArrayList();
            while (classIter.hasNext()) {
                EClass eClass;
                eClass = (EClass)classIter.next();
                classList.addAll(eClass.getESuperTypes());
            }
            return TypeAdapter.selectMostDerivedFeature(features, classList);
        }

        private List<EStructuralFeature> internalGetPersistentStructuralFeatures() {
            ArrayList<EStructuralFeature> persistentStructuralFeatures = new ArrayList<EStructuralFeature>();
            for (EStructuralFeature feature : this.itemEClass.getEAllStructuralFeatures()) {
                if (!this.isPersistent(this.itemEClass, feature)) continue;
                persistentStructuralFeatures.add(feature);
            }
            return persistentStructuralFeatures;
        }

        private IDynamicQueryModel internalGetQueryModel() {
            String parentPackageName = this.getQueryPackage(this.itemEClass);
            String name = this.itemEClass.getName();
            String queryModelName = String.valueOf(parentPackageName) + ".Base" + name + "QueryModel" + '$' + name + "QueryModel";
            Class instanceClass = this.itemEClass.getInstanceClass();
            if (instanceClass == null) {
                return null;
            }
            ClassLoader cl = instanceClass.getClassLoader();
            if (cl == null) {
                return null;
            }
            Class<?> clazz = null;
            try {
                clazz = cl.loadClass(queryModelName);
            }
            catch (ClassNotFoundException classNotFoundException) {}
            if (clazz == null) {
                return null;
            }
            Field root = null;
            try {
                root = clazz.getField("ROOT");
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchFieldException noSuchFieldException) {}
            if (root == null) {
                return null;
            }
            AbstractQueryPathModel statik = null;
            try {
                statik = (AbstractQueryPathModel)root.get(null);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            if (statik == null) {
                return null;
            }
            return AbstractQueryPathModel.getImplementation(statik);
        }

        private String getQueryPackage(EClass eClass) {
            EPackage pack = eClass.getEPackage();
            if (pack == null) {
                throw new IllegalStateException("EClass must be in a package");
            }
            String result = pack.getName();
            EAnnotation e = pack.getEAnnotation(ItemUtil.TEAM_PACKAGE_ANNOTATION);
            if (e != null) {
                String suffix;
                String queryPackage = (String)e.getDetails().get((Object)ItemUtil.QUERYMODEL_PACKAGE_DETAIL);
                if (queryPackage != null) {
                    return queryPackage;
                }
                String base = (String)e.getDetails().get((Object)ItemUtil.BASE_PACKAGE_DETAIL);
                if (base != null) {
                    result = String.valueOf(base) + '.' + pack.getName();
                }
                if ((suffix = (String)e.getDetails().get((Object)ItemUtil.PACKAGE_SUFFIX_DETAIL)) != null) {
                    result = String.valueOf(result) + '.' + suffix;
                }
            }
            return String.valueOf(result) + ".query";
        }

        public EClass getItemEClass() {
            return this.itemEClass;
        }
    }
}

