/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.internal.util.StandaloneExtensionRegistry;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.internal.registry.RegistryProviderFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.spi.IRegistryProvider;
import org.eclipse.osgi.service.localization.BundleLocalization;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalExtensionMessages {
    private static final Log LOGGER = LogFactory.getLog(InternalExtensionMessages.class);
    private static final char CARET_TOKEN = '^';
    private static final InternalExtensionMessages INSTANCE = new InternalExtensionMessages();
    private BundleLocalization bundleLocalization;
    private ILocaleProvider localeProvider;

    public static InternalExtensionMessages getInstance() {
        return INSTANCE;
    }

    private InternalExtensionMessages() {
    }

    public void bind(BundleLocalization bundleLocalization) {
        this.setBundleLocalization(bundleLocalization);
    }

    private ILocaleProvider createLocaleProvider() {
        return new ILocaleProvider(){

            @Override
            public Enumeration<Locale> getLocales() {
                Locale locale = Locale.getDefault();
                Vector<Locale> vector = new Vector<Locale>(1);
                vector.add(locale);
                Enumeration<Locale> enumeration = vector.elements();
                return enumeration;
            }
        };
    }

    public String getAttribute(String name, IConfigurationElement element) {
        if (name == null) {
            throw new IllegalArgumentException("name must not be null");
        }
        if (element == null) {
            throw new IllegalArgumentException("element must not be null");
        }
        String value = element.getAttribute(name);
        String result = this.localize(value, element);
        return result;
    }

    private Bundle getBundle(IConfigurationElement element) {
        String name = this.getContributorName(element);
        Bundle bundle = this.getBundle(name);
        return bundle;
    }

    private Bundle getBundle(String symbolicName) {
        if (symbolicName == null) {
            throw new IllegalArgumentException("symbolicName must not be null");
        }
        Bundle bundle = Platform.getBundle((String)symbolicName);
        return bundle;
    }

    private BundleLocalization getBundleLocalization() {
        return this.bundleLocalization;
    }

    private String getContributorName(IConfigurationElement element) {
        IContributor contributor = element.getContributor();
        String name = contributor.getName();
        return name;
    }

    private IRegistryProvider getDefaultRegistryProvider() {
        return RegistryProviderFactory.getDefault();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ILocaleProvider getLocaleProvider() {
        InternalExtensionMessages internalExtensionMessages = this;
        synchronized (internalExtensionMessages) {
            if (this.localeProvider == null) {
                this.setLocaleProvider(this.createLocaleProvider());
            }
            return this.localeProvider;
        }
    }

    private Enumeration<Locale> getLocales() {
        ILocaleProvider provider = this.getLocaleProvider();
        Enumeration<Locale> locales = provider.getLocales();
        return locales;
    }

    public String getMessage(String value, String symbolicName) {
        if (value == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        String key = this.toNlsKey(value);
        if (key == null) {
            return value;
        }
        Bundle bundle = this.getBundle(symbolicName);
        Enumeration<Locale> locales = this.getLocales();
        String result = bundle != null ? this.localize(key, bundle, locales) : this.localize(key, symbolicName, locales);
        if (result == null) {
            result = value;
        }
        return result;
    }

    private ResourceBundle getResourceBundle(Bundle bundle, Locale locale) {
        String value = locale.toString();
        BundleLocalization service = this.getBundleLocalization();
        ResourceBundle resourceBundle = service.getLocalization(bundle, value);
        return resourceBundle;
    }

    private ResourceBundle getResourceBundle(String contributorName, Locale locale) {
        ResourceBundle resourceBundle = null;
        StandaloneExtensionRegistry provider = this.getStandaloneExtensionRegistry();
        if (provider != null) {
            resourceBundle = provider.getResourceBundle(contributorName, locale);
        }
        if (resourceBundle == null) {
            String message = String.format("Failed to find a ResourceBundle in \"%s\" for the locale %s.", contributorName, locale);
            this.logError(message);
        }
        return resourceBundle;
    }

    private StandaloneExtensionRegistry getStandaloneExtensionRegistry() {
        StandaloneExtensionRegistry registry = null;
        IRegistryProvider provider = this.getDefaultRegistryProvider();
        if (provider instanceof StandaloneExtensionRegistry) {
            registry = (StandaloneExtensionRegistry)provider;
        } else {
            String message = String.format("Unrecognized IRegistryProvider: %s", provider);
            this.logError(message);
        }
        return registry;
    }

    public String getValue(IConfigurationElement element) {
        if (element == null) {
            throw new IllegalArgumentException("element must not be null");
        }
        String value = element.getValue();
        String result = this.localize(value, element);
        return result;
    }

    private String localize(String value, Bundle bundle, Enumeration<Locale> locales) {
        String result = null;
        while (result == null && locales.hasMoreElements()) {
            Locale locale = locales.nextElement();
            ResourceBundle resourceBundle = this.getResourceBundle(bundle, locale);
            result = this.getResource(value, resourceBundle);
        }
        return result;
    }

    private String localize(String value, IConfigurationElement element) {
        String result;
        String key = this.toNlsKey(value);
        if (key == null) {
            return value;
        }
        Bundle bundle = this.getBundle(element);
        Enumeration<Locale> locales = this.getLocales();
        if (bundle != null) {
            result = this.localize(key, bundle, locales);
        } else {
            String name = this.getContributorName(element);
            result = this.localize(key, name, locales);
        }
        if (result == null) {
            result = value;
        }
        return result;
    }

    private String getResource(String value, ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            throw new IllegalArgumentException("resourceBundle must not be null");
        }
        String result = null;
        if (resourceBundle != null) {
            try {
                result = resourceBundle.getString(value);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return result;
    }

    private String localize(String value, String contributorName, Enumeration<Locale> locales) {
        String result = null;
        while (result == null && locales.hasMoreElements()) {
            Locale locale = locales.nextElement();
            ResourceBundle resourceBundle = this.getResourceBundle(contributorName, locale);
            result = this.getResource(value, resourceBundle);
        }
        return result;
    }

    private void logError(String message) {
        LOGGER.error((Object)message);
    }

    private void setBundleLocalization(BundleLocalization bundleLocalization) {
        this.bundleLocalization = bundleLocalization;
    }

    public void setLocaleProvider(ILocaleProvider localeProvider) {
        this.localeProvider = localeProvider;
    }

    private String toNlsKey(String value) {
        String key = null;
        if (value != null && value.length() > 1) {
            boolean required;
            char ch = value.charAt(0);
            boolean bl = required = ch == '^';
            if (required) {
                key = value.substring(1);
            }
        }
        return key;
    }

    public void unbind() {
        this.setBundleLocalization(null);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ILocaleProvider {
        public Enumeration<Locale> getLocales();
    }
}

