/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.internal.util.IFutureValue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FutureValue<V>
implements IFutureValue<V> {
    private final Sync<V> sync = new Sync();

    protected FutureValue(V value) {
        this.sync.innerSet(value);
    }

    protected FutureValue() {
    }

    @Override
    public boolean isCancelled() {
        return this.sync.innerIsCancelled();
    }

    @Override
    public boolean isDone() {
        return this.sync.innerIsDone();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.sync.innerCancel(mayInterruptIfRunning)) {
            this.done();
            return true;
        }
        return false;
    }

    @Override
    public V get() throws InterruptedException {
        return this.sync.innerGet();
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        long nanos = unit.toNanos(timeout);
        return this.sync.innerGet(nanos);
    }

    @Override
    public V getIfSet() {
        V tmp = this.sync.innerGetIfSet();
        if (tmp != null) {
            return tmp;
        }
        return null;
    }

    protected void done() {
    }

    protected boolean set(V v) {
        if (this.sync.innerSet(v)) {
            this.done();
            return true;
        }
        return false;
    }

    protected boolean isCreatorThread() {
        return this.sync.innerIsCreatorThread();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Sync<V>
    extends AbstractQueuedSynchronizer {
        private static final int UNSET = 0;
        private static final int SET = 1;
        private static final int CANCELLED = 2;
        private volatile V result = null;
        private volatile Thread creatorThread = Thread.currentThread();

        public boolean innerIsCreatorThread() {
            return Thread.currentThread() == this.creatorThread;
        }

        private boolean setOrCancelled(int state) {
            return state != 0;
        }

        @Override
        protected int tryAcquireShared(int ignore) {
            return this.innerIsDone() ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int ignore) {
            this.creatorThread = null;
            return true;
        }

        boolean innerIsCancelled() {
            return this.getState() == 2;
        }

        boolean innerIsDone() {
            int s = this.getState();
            boolean done = this.setOrCancelled(s);
            if (!done) {
                return false;
            }
            return this.creatorThread == null;
        }

        V innerGetIfSet() {
            return this.result;
        }

        V innerGet() throws InterruptedException {
            this.assertNotInCreatorThreadOrDone();
            this.acquireSharedInterruptibly(0);
            if (this.getState() == 2) {
                throw new CancellationException();
            }
            return this.result;
        }

        V innerGet(long nanosTimeout) throws InterruptedException, TimeoutException {
            this.assertNotInCreatorThreadOrDone();
            if (!this.tryAcquireSharedNanos(0, nanosTimeout)) {
                throw new TimeoutException();
            }
            if (this.getState() == 2) {
                throw new CancellationException();
            }
            return this.result;
        }

        boolean innerSet(V v) {
            int s;
            this.assertInCreatorThreadOrDone();
            do {
                if (!this.setOrCancelled(s = this.getState())) continue;
                return false;
            } while (!this.compareAndSetState(s, 1));
            this.result = v;
            this.releaseShared(0);
            return true;
        }

        boolean innerCancel(boolean mayInterruptIfRunning) {
            Thread r;
            int s;
            do {
                if (!this.setOrCancelled(s = this.getState())) continue;
                return false;
            } while (!this.compareAndSetState(s, 2));
            if (mayInterruptIfRunning && (r = this.creatorThread) != null) {
                r.interrupt();
            }
            this.releaseShared(0);
            return true;
        }

        private void assertInCreatorThreadOrDone() {
            if (Thread.currentThread() == this.creatorThread) {
                return;
            }
            if (this.innerIsDone()) {
                return;
            }
            throw new IllegalStateException("Must only call from creator's thread!");
        }

        private void assertNotInCreatorThreadOrDone() {
            if (Thread.currentThread() != this.creatorThread) {
                return;
            }
            if (this.innerIsDone()) {
                return;
            }
            throw new IllegalStateException("Must not call from creator's thread!");
        }
    }
}

