/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.querypath;

import com.ibm.team.repository.common.internal.queryast.ComparisonOp;
import com.ibm.team.repository.common.internal.queryast.ElementType;
import com.ibm.team.repository.common.internal.queryast.FeaturePath;
import com.ibm.team.repository.common.internal.queryast.FilterElement;
import com.ibm.team.repository.common.internal.queryast.FunctionType;
import com.ibm.team.repository.common.internal.queryast.InList;
import com.ibm.team.repository.common.internal.queryast.Like;
import com.ibm.team.repository.common.internal.queryast.Literal;
import com.ibm.team.repository.common.internal.queryast.NumericScalarFunction;
import com.ibm.team.repository.common.internal.queryast.QueryDataElement;
import com.ibm.team.repository.common.internal.queryast.QueryastFactory;
import com.ibm.team.repository.common.internal.queryast.ScalarFunction;
import com.ibm.team.repository.common.internal.queryast.StringScalarFunction;
import com.ibm.team.repository.common.internal.querypath.AbstractQueryModelField;
import com.ibm.team.repository.common.internal.querypath.IQueryPath;
import com.ibm.team.repository.common.query.ast.IInListValueSource;
import com.ibm.team.repository.common.query.ast.INumeric;
import com.ibm.team.repository.common.query.ast.INumericScalarFunction;
import com.ibm.team.repository.common.query.ast.IPredicate;
import com.ibm.team.repository.common.query.ast.IString;
import com.ibm.team.repository.common.query.ast.IStringField;
import com.ibm.team.repository.common.query.ast.IStringScalarFunction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringField
extends AbstractQueryModelField
implements IStringField {
    public StringField(IQueryPath aModel, String aName) {
        this.name(aName);
        this.parent(aModel);
    }

    @Override
    public ElementType getFieldType() {
        return ElementType.STRING_LITERAL;
    }

    @Override
    public IPredicate _in(String[] strings) {
        this.checkInPredicateValueArray(strings);
        this.checkInPredicateValueArray(strings);
        FeaturePath field = QueryastFactory.eINSTANCE.createFeaturePath(this);
        InList inList = QueryastFactory.eINSTANCE.createInList();
        inList.setField(field);
        String[] stringArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            Literal literal = QueryastFactory.eINSTANCE.createStringLiteral(string);
            inList.getValues().add((Object)literal);
            ++n2;
        }
        return inList;
    }

    @Override
    public IPredicate _in(IString[] stringArray) {
        this.checkInPredicateValueArray(stringArray);
        FeaturePath field = QueryastFactory.eINSTANCE.createFeaturePath(this);
        InList inList = QueryastFactory.eINSTANCE.createInList();
        inList.setField(field);
        IString[] iStringArray = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            IString string = iStringArray[n2];
            this.checkInPredicateNullValue(string);
            FilterElement filterElement = QueryastFactory.eINSTANCE.createFilterElement(string);
            inList.getValues().add((Object)filterElement);
            ++n2;
        }
        return inList;
    }

    @Override
    public IPredicate _like(IString string) {
        FilterElement pattern = QueryastFactory.eINSTANCE.createFilterElement(string);
        return this.createLikePredicate(pattern, null);
    }

    @Override
    public IPredicate _like(String string) {
        Literal pattern = QueryastFactory.eINSTANCE.createStringLiteral(string);
        return this.createLikePredicate(pattern, null);
    }

    @Override
    public IPredicate _like(String pattern, char escape) {
        Literal patternLit = QueryastFactory.eINSTANCE.createStringLiteral(pattern);
        Literal escapeLit = QueryastFactory.eINSTANCE.createStringLiteral(Character.toString(escape));
        return this.createLikePredicate(patternLit, escapeLit);
    }

    @Override
    public IPredicate _like(IString pattern, char escape) {
        FilterElement patternLit = QueryastFactory.eINSTANCE.createFilterElement(pattern);
        Literal escapeLit = QueryastFactory.eINSTANCE.createStringLiteral(Character.toString(escape));
        return this.createLikePredicate(patternLit, escapeLit);
    }

    @Override
    public IPredicate _ignoreCaseLike(IString string) {
        FilterElement pattern = QueryastFactory.eINSTANCE.createFilterElement(string);
        return this.createIgnoreCaseLikePredicate(pattern, null);
    }

    @Override
    public IPredicate _ignoreCaseLike(String string) {
        Literal pattern = QueryastFactory.eINSTANCE.createStringLiteral(string);
        return this.createIgnoreCaseLikePredicate(pattern, null);
    }

    @Override
    public IPredicate _ignoreCaseLike(String pattern, char escape) {
        Literal patternLit = QueryastFactory.eINSTANCE.createStringLiteral(pattern);
        Literal escapeLit = QueryastFactory.eINSTANCE.createStringLiteral(Character.toString(escape));
        return this.createIgnoreCaseLikePredicate(patternLit, escapeLit);
    }

    @Override
    public IPredicate _ignoreCaseLike(IString pattern, char escape) {
        FilterElement patternLit = QueryastFactory.eINSTANCE.createFilterElement(pattern);
        Literal escapeLit = QueryastFactory.eINSTANCE.createStringLiteral(Character.toString(escape));
        return this.createIgnoreCaseLikePredicate(patternLit, escapeLit);
    }

    private Like createLikePredicate(FilterElement pattern, FilterElement escape) {
        Like like = QueryastFactory.eINSTANCE.createLike();
        FilterElement expression = QueryastFactory.eINSTANCE.createFilterElement(this);
        like.setExpression(expression);
        like.setPattern(pattern);
        if (escape != null) {
            like.setEscape(escape);
        }
        return like;
    }

    private IPredicate createIgnoreCaseLikePredicate(FilterElement pattern, FilterElement escape) {
        Like like = this.createLikePredicate(pattern, escape);
        like.setIgnoreCase(true);
        return like;
    }

    @Override
    public INumericScalarFunction _indexOf(IString aString, Integer i) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LOCATE_LITERAL);
        this.addASTFieldToScalarFunction(numericScalarFunction);
        QueryDataElement queryDataElement = QueryastFactory.eINSTANCE.createQueryDataElement(aString);
        numericScalarFunction.getArgs().add((Object)queryDataElement);
        Literal literal = QueryastFactory.eINSTANCE.createNumericLiteral(i);
        numericScalarFunction.getArgs().add((Object)literal);
        return numericScalarFunction;
    }

    @Override
    public INumericScalarFunction _indexOf(IString aString, INumeric i) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LOCATE_LITERAL);
        this.addASTFieldToScalarFunction(numericScalarFunction);
        QueryDataElement queryDataElement1 = QueryastFactory.eINSTANCE.createQueryDataElement(aString);
        numericScalarFunction.getArgs().add((Object)queryDataElement1);
        QueryDataElement queryDataElement2 = QueryastFactory.eINSTANCE.createQueryDataElement(i);
        numericScalarFunction.getArgs().add((Object)queryDataElement2);
        return numericScalarFunction;
    }

    @Override
    public INumericScalarFunction _indexOf(IString aString) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LOCATE_LITERAL);
        this.addASTFieldToScalarFunction(numericScalarFunction);
        QueryDataElement queryDataElement1 = QueryastFactory.eINSTANCE.createQueryDataElement(aString);
        numericScalarFunction.getArgs().add((Object)queryDataElement1);
        return numericScalarFunction;
    }

    @Override
    public INumericScalarFunction _indexOf(String aString, Integer i) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LOCATE_LITERAL);
        this.addASTFieldToScalarFunction(numericScalarFunction);
        Literal literal1 = QueryastFactory.eINSTANCE.createStringLiteral(aString);
        numericScalarFunction.getArgs().add((Object)literal1);
        Literal literal2 = QueryastFactory.eINSTANCE.createNumericLiteral(i);
        numericScalarFunction.getArgs().add((Object)literal2);
        return numericScalarFunction;
    }

    @Override
    public INumericScalarFunction _indexOf(String aString, INumeric i) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LOCATE_LITERAL);
        this.addASTFieldToScalarFunction(numericScalarFunction);
        Literal literal1 = QueryastFactory.eINSTANCE.createStringLiteral(aString);
        numericScalarFunction.getArgs().add((Object)literal1);
        QueryDataElement queryDataElement2 = QueryastFactory.eINSTANCE.createQueryDataElement(i);
        numericScalarFunction.getArgs().add((Object)queryDataElement2);
        return numericScalarFunction;
    }

    @Override
    public INumericScalarFunction _indexOf(String aString) {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LOCATE_LITERAL);
        this.addASTFieldToScalarFunction(numericScalarFunction);
        Literal literal1 = QueryastFactory.eINSTANCE.createStringLiteral(aString);
        numericScalarFunction.getArgs().add((Object)literal1);
        return numericScalarFunction;
    }

    @Override
    public INumericScalarFunction _length() {
        NumericScalarFunction numericScalarFunction = this.createNumericScalarFunction(FunctionType.LENGTH_LITERAL);
        this.addASTFieldToScalarFunction(numericScalarFunction);
        return numericScalarFunction;
    }

    @Override
    public IStringScalarFunction _lower() {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.LOWER_LITERAL);
        this.addASTFieldToScalarFunction(stringScalarFunction);
        return stringScalarFunction;
    }

    @Override
    public IStringScalarFunction _upper() {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.UPPER_LITERAL);
        this.addASTFieldToScalarFunction(stringScalarFunction);
        return stringScalarFunction;
    }

    @Override
    public IStringScalarFunction _substring(Integer i1, Integer i2) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.SUBSTRING_LITERAL);
        this.addASTFieldToScalarFunction(stringScalarFunction);
        Literal literal1 = QueryastFactory.eINSTANCE.createNumericLiteral(i1);
        stringScalarFunction.getArgs().add((Object)literal1);
        Literal literal2 = QueryastFactory.eINSTANCE.createNumericLiteral(i2);
        stringScalarFunction.getArgs().add((Object)literal2);
        return stringScalarFunction;
    }

    @Override
    public IStringScalarFunction _substring(Integer i1, INumeric i2) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.SUBSTRING_LITERAL);
        this.addASTFieldToScalarFunction(stringScalarFunction);
        Literal literal1 = QueryastFactory.eINSTANCE.createNumericLiteral(i1);
        stringScalarFunction.getArgs().add((Object)literal1);
        QueryDataElement queryDataElement2 = QueryastFactory.eINSTANCE.createQueryDataElement(i2);
        stringScalarFunction.getArgs().add((Object)queryDataElement2);
        return stringScalarFunction;
    }

    @Override
    public IStringScalarFunction _substring(INumeric i1, Integer i2) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.SUBSTRING_LITERAL);
        this.addASTFieldToScalarFunction(stringScalarFunction);
        QueryDataElement queryDataElement1 = QueryastFactory.eINSTANCE.createQueryDataElement(i1);
        stringScalarFunction.getArgs().add((Object)queryDataElement1);
        Literal literal2 = QueryastFactory.eINSTANCE.createNumericLiteral(i2);
        stringScalarFunction.getArgs().add((Object)literal2);
        return stringScalarFunction;
    }

    @Override
    public IStringScalarFunction _substring(INumeric i1, INumeric i2) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.SUBSTRING_LITERAL);
        this.addASTFieldToScalarFunction(stringScalarFunction);
        QueryDataElement queryDataElement1 = QueryastFactory.eINSTANCE.createQueryDataElement(i1);
        stringScalarFunction.getArgs().add((Object)queryDataElement1);
        QueryDataElement queryDataElement2 = QueryastFactory.eINSTANCE.createQueryDataElement(i2);
        stringScalarFunction.getArgs().add((Object)queryDataElement2);
        return stringScalarFunction;
    }

    @Override
    public IStringScalarFunction _concat(IString s) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.CONCAT_LITERAL);
        this.addASTFieldToScalarFunction(stringScalarFunction);
        QueryDataElement queryDataElement = QueryastFactory.eINSTANCE.createQueryDataElement(s);
        stringScalarFunction.getArgs().add((Object)queryDataElement);
        return stringScalarFunction;
    }

    @Override
    public IStringScalarFunction _concat(String s) {
        StringScalarFunction stringScalarFunction = this.createStringScalarFunction(FunctionType.CONCAT_LITERAL);
        this.addASTFieldToScalarFunction(stringScalarFunction);
        Literal literal = QueryastFactory.eINSTANCE.createStringLiteral(s);
        stringScalarFunction.getArgs().add((Object)literal);
        return stringScalarFunction;
    }

    private StringScalarFunction createStringScalarFunction(FunctionType functionType) {
        StringScalarFunction stringScalarFunction = QueryastFactory.eINSTANCE.createStringScalarFunction(functionType);
        return stringScalarFunction;
    }

    private NumericScalarFunction createNumericScalarFunction(FunctionType functionType) {
        NumericScalarFunction numericScalarFunction = QueryastFactory.eINSTANCE.createNumericScalarFunction(functionType);
        return numericScalarFunction;
    }

    private void addASTFieldToScalarFunction(ScalarFunction scalarFunction) {
        FeaturePath astField = QueryastFactory.eINSTANCE.createFeaturePath(this);
        scalarFunction.getArgs().add((Object)astField);
    }

    @Override
    public IPredicate _eq(IString string) {
        return this.createBasicComparison(ComparisonOp.EQUALS_LITERAL, string);
    }

    @Override
    public IPredicate _eq(String stringToCompare) {
        return this.createBasicComparison(ComparisonOp.EQUALS_LITERAL, stringToCompare);
    }

    @Override
    public IPredicate _notEq(IString string) {
        return this.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, string);
    }

    @Override
    public IPredicate _notEq(String stringToCompare) {
        return this.createBasicComparison(ComparisonOp.NOT_EQUALS_LITERAL, stringToCompare);
    }

    private IPredicate createBasicComparison(ComparisonOp op, String stringToCompare) {
        FeaturePath field = QueryastFactory.eINSTANCE.createFeaturePath(this);
        return QueryastFactory.eINSTANCE.createBasicComparison(op, (FilterElement)field, stringToCompare);
    }

    private IPredicate createBasicComparison(ComparisonOp op, IString stringToCompare) {
        FeaturePath field = QueryastFactory.eINSTANCE.createFeaturePath(this);
        return QueryastFactory.eINSTANCE.createBasicComparison(op, (FilterElement)field, stringToCompare);
    }

    @Override
    public IPredicate _inLargeList(IInListValueSource<String> inputSource) {
        FeaturePath field = QueryastFactory.eINSTANCE.createFeaturePath(this);
        InList inList = QueryastFactory.eINSTANCE.createInList();
        inList.setField(field);
        inList.setInputValueSource(inputSource);
        return inList;
    }
}

