/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common;

import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.IType;
import com.ibm.team.repository.common.IVirtualType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.internal.util.ItemUtil;
import com.ibm.team.repository.common.internal.util.LocationUtil;
import com.ibm.team.repository.common.model.Content;
import com.ibm.team.repository.common.model.ItemType;
import com.ibm.team.repository.common.model.RepositoryFactory;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Location {
    public static final String SLASH = "/";
    public static final String DOT = ".";
    public static final String DOTDOT = "..";
    public static final String RESOURCE_NS = "resource";
    public static final String ITEM_NAME_NS = "itemName";
    public static final String ITEM_PATH_NS = "itemPath";
    public static final String ITEM_COL_NS = "itemCol";
    public static final String ITEM_OID_NS = "itemOid";
    public static final String VIRTUAL_NS = "virtual";
    public static final String VIRTUAL_PATH_NS = "virtualPath";
    public static final String VIRTUAL_COL_NS = "virtualCol";
    public static final String CONTENT_NS = "content";
    public static final String REPO_NS = "com.ibm.team.repository";
    public static final String REPO_NAMED_ITEM_NS = "com.ibm.team.repository/itemName";
    public static final String REPO_ITEM_PATH_NS = "com.ibm.team.repository/itemPath";
    public static final String REPO_ITEM_COLLECTION_NS = "com.ibm.team.repository/itemCol";
    public static final String REPO_ITEM_OID_NS = "com.ibm.team.repository/itemOid";
    public static final String REPO_VIRTUAL_PATH_NS = "com.ibm.team.repository/virtualPath";
    public static final String REPO_VIRTUAL_COLLECTION_NS = "com.ibm.team.repository/virtualCol";
    private static final String CURR_STATE_URI_PREFIX_NS = "repo/csid";
    private static final String ITEM_STATE_URI_PREFIX_NS = "repo/sid";
    public static final String SERVICE_BINDING_PREFIX = "service";
    public static final String DEFAULT_SERVICE_BINDING = "{default}";
    private static Log _logger = LogFactory.getLog(Location.class);
    private static boolean _useResourceNS = true;
    private final String _repoUri;
    private final String _relativeUri;
    private final String _query;
    private final String _fragment;
    private final IItemHandle _itemHandle;
    private final IType _locType;
    private final String _serviceName;
    private static final boolean _useLongTypeName = true;
    private static final Pattern patternSlash = Pattern.compile("/");
    static final Map<String, String> _itemTypeShortNameMap = new HashMap<String, String>();

    static {
        _itemTypeShortNameMap.put("AnalysisContribution", "com.ibm.team.analysis");
        _itemTypeShortNameMap.put("Attachment", "com.ibm.team.workitem");
        _itemTypeShortNameMap.put("Attribute", "com.ibm.team.workitem");
        _itemTypeShortNameMap.put("AuditableBaseline", REPO_NS);
        _itemTypeShortNameMap.put("AuditableLink", "com.ibm.team.links");
        _itemTypeShortNameMap.put("Baseline", "com.ibm.team.scm");
        _itemTypeShortNameMap.put("BaselineSet", "com.ibm.team.scm");
        _itemTypeShortNameMap.put("BuildActivities", "com.ibm.team.build");
        _itemTypeShortNameMap.put("BuildAverageData", "com.ibm.team.build");
        _itemTypeShortNameMap.put("BuildDefinition", "com.ibm.team.build");
        _itemTypeShortNameMap.put("BuildEngine", "com.ibm.team.build");
        _itemTypeShortNameMap.put("BuildEngineActivity", "com.ibm.team.build");
        _itemTypeShortNameMap.put("BuildRequest", "com.ibm.team.build");
        _itemTypeShortNameMap.put("BuildResult", "com.ibm.team.build");
        _itemTypeShortNameMap.put("BuildResultContributions", "com.ibm.team.build");
        _itemTypeShortNameMap.put("Category", "com.ibm.team.workitem");
        _itemTypeShortNameMap.put("ChangeEvent", REPO_NS);
        _itemTypeShortNameMap.put("ChangeHistory", "com.ibm.team.scm");
        _itemTypeShortNameMap.put("ChangeSet", "com.ibm.team.scm");
        _itemTypeShortNameMap.put("CompileContribution", "com.ibm.team.build");
        _itemTypeShortNameMap.put("CompilePackage", "com.ibm.team.build");
        _itemTypeShortNameMap.put("Component", "com.ibm.team.scm");
        _itemTypeShortNameMap.put("ComponentEntry", "com.ibm.team.scm");
        _itemTypeShortNameMap.put("Configuration", "com.ibm.team.scm");
        _itemTypeShortNameMap.put("ConnectionInfoContribution", "com.ibm.team.repository.tests");
        _itemTypeShortNameMap.put("Contributor", REPO_NS);
        _itemTypeShortNameMap.put("ContributorAbsence", "com.ibm.team.apt.resource");
        _itemTypeShortNameMap.put("ContributorDetails", REPO_NS);
        _itemTypeShortNameMap.put("ContributorResourceDetails", "com.ibm.team.apt.resource");
        _itemTypeShortNameMap.put("ContributorSuspendRecord", "com.ibm.team.scm");
        _itemTypeShortNameMap.put("Dashboard", "com.ibm.team.dashboard");
        _itemTypeShortNameMap.put("DashboardContributorInfo", "com.ibm.team.dashboard");
        _itemTypeShortNameMap.put("Deliverable", "com.ibm.team.workitem");
        _itemTypeShortNameMap.put("DevelopmentLine", "com.ibm.team.process");
        _itemTypeShortNameMap.put("EmptyAuditable", "com.ibm.team.repository.tests.emptysubclass");
        _itemTypeShortNameMap.put("EmptySimpleItem", "com.ibm.team.repository.tests.emptysubclass");
        _itemTypeShortNameMap.put("EmptySubclass", "com.ibm.team.repository.tests.emptysubclass");
        _itemTypeShortNameMap.put("EmptyVersionable", "com.ibm.team.repository.tests.emptysubclass");
        _itemTypeShortNameMap.put("ExternalProxy", "com.ibm.team.interop");
        _itemTypeShortNameMap.put("ExternalRepositoryConnection", "com.ibm.team.interop");
        _itemTypeShortNameMap.put("ExternalState", "com.ibm.team.interop");
        _itemTypeShortNameMap.put("Fichier", "com.ibm.team.repository.tests");
        _itemTypeShortNameMap.put("FileItem", "com.ibm.team.filesystem");
        _itemTypeShortNameMap.put("Folder", "com.ibm.team.scm");
        _itemTypeShortNameMap.put("FolderDescriptor", "com.ibm.team.reports");
        _itemTypeShortNameMap.put("FolderLastModifiedInWorkspaceEntry", "com.ibm.team.scm");
        _itemTypeShortNameMap.put("FullORMBaseline", "com.ibm.team.repository.tests");
        _itemTypeShortNameMap.put("HistoricBasis", "com.ibm.team.scm");
        _itemTypeShortNameMap.put("Iteration", "com.ibm.team.process");
        _itemTypeShortNameMap.put("IterationPlanRecord", "com.ibm.team.apt");
        _itemTypeShortNameMap.put("IterationType", "com.ibm.team.process");
        _itemTypeShortNameMap.put("JUnitTestClass", "com.ibm.team.build");
        _itemTypeShortNameMap.put("JUnitTestSuiteContribution", "com.ibm.team.build");
        _itemTypeShortNameMap.put("Log", "com.ibm.team.repository.tests");
        _itemTypeShortNameMap.put("LogContributor", "com.ibm.team.repository.tests");
        _itemTypeShortNameMap.put("LogEvent", "com.ibm.team.repository.tests");
        _itemTypeShortNameMap.put("LogExContribution", "com.ibm.team.repository.tests");
        _itemTypeShortNameMap.put("LogProblem", "com.ibm.team.repository.tests");
        _itemTypeShortNameMap.put("MigratedAuditable", "com.ibm.team.migration.handler.tests");
        _itemTypeShortNameMap.put("NestedHelperLists", "com.ibm.team.repository.tests.nestedhelperlists");
        _itemTypeShortNameMap.put("Opaque", "com.ibm.team.opaque");
        _itemTypeShortNameMap.put("PartyDetails", "com.ibm.team.repository.tests");
        _itemTypeShortNameMap.put("PrimitiveItem", "com.ibm.team.repository.internal.tests.primitiveattributes");
        _itemTypeShortNameMap.put("ProcessAttachment", "com.ibm.team.process");
        _itemTypeShortNameMap.put("ProcessChangeEventCheck", "com.ibm.team.process");
        _itemTypeShortNameMap.put("ProcessDefinition", "com.ibm.team.process");
        _itemTypeShortNameMap.put("ProcessDomainDefinition", "com.ibm.team.process");
        _itemTypeShortNameMap.put("ProjectArea", "com.ibm.team.process");
        _itemTypeShortNameMap.put("QueryDescriptor", "com.ibm.team.workitem.query");
        _itemTypeShortNameMap.put("RefItem", "com.ibm.team.repository.tests.refpatterns");
        _itemTypeShortNameMap.put("RefItemSubclass", "com.ibm.team.repository.tests.refpatterns");
        _itemTypeShortNameMap.put("ReportDescriptor", "com.ibm.team.reports");
        _itemTypeShortNameMap.put("ReportQueryDescriptor", "com.ibm.team.reports");
        _itemTypeShortNameMap.put("RepositoryProgressMonitor", "com.ibm.team.scm");
        _itemTypeShortNameMap.put("RepositoryRoot", REPO_NS);
        _itemTypeShortNameMap.put("SCMFichier", "com.ibm.team.scm.tests");
        _itemTypeShortNameMap.put("SameNsPrefixAsTestAuditable", "com.ibm.team.repository.tests2");
        _itemTypeShortNameMap.put("ServerVersionRecord", REPO_NS);
        _itemTypeShortNameMap.put("SimpleFile", "com.ibm.team.process.simplefile");
        _itemTypeShortNameMap.put("Suspended", "com.ibm.team.scm");
        _itemTypeShortNameMap.put("SyncInfo", "com.ibm.team.interop");
        _itemTypeShortNameMap.put("SyncRule", "com.ibm.team.interop");
        _itemTypeShortNameMap.put("Team", "com.ibm.team.repository.tests");
        _itemTypeShortNameMap.put("TeamArea", "com.ibm.team.process");
        _itemTypeShortNameMap.put("TestAud2", "com.ibm.team.migration.tests");
        _itemTypeShortNameMap.put("TestAuditableRenamed", "com.ibm.team.migration.tests");
        _itemTypeShortNameMap.put("TwoHelperInstances", "com.ibm.team.repository.tests.twohelperinstances");
        _itemTypeShortNameMap.put("UserDataContribution", "com.ibm.team.repository.tests");
        _itemTypeShortNameMap.put("Versionable", "com.ibm.team.scm");
        _itemTypeShortNameMap.put("WikiPage", "com.ibm.team.foundation.wiki");
        _itemTypeShortNameMap.put("WikiPageAttachment", "com.ibm.team.foundation.wiki");
        _itemTypeShortNameMap.put("WorkItem", "com.ibm.team.workitem");
        _itemTypeShortNameMap.put("WorkResourceDetails", "com.ibm.team.apt.resource");
        _itemTypeShortNameMap.put("Workspace", "com.ibm.team.scm");
    }

    public static Location location(URI resource) throws TeamRepositoryException {
        if (resource == null) {
            throw new IllegalArgumentException("resource must not be null");
        }
        if (resource.getScheme() == null) {
            return Location.locationFromRelUri(resource);
        }
        return Location.locationFromAbsUri(resource);
    }

    public static Location location(Location loc, String repoUrl, String serviceName) {
        if (loc == null) {
            throw new IllegalArgumentException("location must not be null");
        }
        return new Location(loc, repoUrl, serviceName);
    }

    public static Location collectionLocation(IItemType itemType, String repoUrl, String query, String serviceName) {
        if (itemType == null) {
            throw new IllegalArgumentException("itemType must not be null");
        }
        return new Location(Location.toCollectionURI(itemType, query), null, itemType, repoUrl, serviceName);
    }

    public static Location collectionLocation(IVirtualType type, String repoUrl, String query, String serviceName) {
        if (type == null) {
            throw new IllegalArgumentException("itemType must not be null");
        }
        return new Location(Location.toCollectionURI(type, query), null, type, repoUrl, serviceName);
    }

    public static Location serviceLocation(String repoUri, Class clazz, String path, String query) {
        if (repoUri == null) {
            throw new IllegalArgumentException("repoUri must not be null");
        }
        if (path == null) {
            path = new String();
        }
        if (query != null) {
            path = String.valueOf(path) + '?' + query;
        }
        String className = null;
        if (clazz != null) {
            className = clazz.getName();
        }
        return new Location(path, null, null, repoUri, className);
    }

    public static Location serviceLocation(String repoUri, Class clazz) {
        if (repoUri == null) {
            throw new IllegalArgumentException("repoUri must not be null");
        }
        return Location.serviceLocation(repoUri, clazz, null, null);
    }

    public static Location namedLocation(IItem item, String repoUrl, String query, String serviceName) {
        if (item == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        return new Location(Location.itemToNamedURI(item, query), item, item.getItemType(), repoUrl, serviceName);
    }

    public static Location namedLocation(IItem item, String repoUrl) {
        return Location.namedLocation(item, repoUrl, null, null);
    }

    public static Location pathLocation(IItemType itemType, String repoUrl, String[] path, String query, String serviceName) {
        if (itemType == null) {
            throw new IllegalArgumentException("itemType must not be null");
        }
        return new Location(Location.toPathUri(itemType, path, query), null, itemType, repoUrl, serviceName);
    }

    public static Location pathLocation(IItemType itemType, String repoUrl, String[] path) {
        return Location.pathLocation(itemType, repoUrl, path, null, null);
    }

    public static Location pathLocation(IVirtualType virtualType, String repoUrl, String[] path, String query, String serviceName) {
        if (virtualType == null) {
            throw new IllegalArgumentException("itemType must not be null");
        }
        return new Location(Location.toPathUri(virtualType, path, query), null, virtualType, repoUrl, serviceName);
    }

    public static Location virtualLocation(String repoUrl, String[] path, String query, String serviceName) {
        return new Location(Location.toPathUri(null, path, query), null, null, repoUrl, serviceName);
    }

    public static Location pathLocation(IVirtualType virtualType, String repoUrl, String[] path) {
        return Location.pathLocation(virtualType, repoUrl, path, null, null);
    }

    public static Location virtualLocation(String repoUrl, String[] path) {
        return Location.virtualLocation(repoUrl, path, null, null);
    }

    public static Location itemLocation(IItemHandle item, String repoUrl, String query, String serviceName) {
        if (item == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        if (item.getStateId() != null && item.isAuditable()) {
            item = ItemUtil.createItemHandle((ItemType)item.getItemType(), item.getItemId(), null);
        }
        return new Location(Location.toItemURI(item, query), item, item.getItemType(), repoUrl, serviceName);
    }

    public static Location itemLocation(IItemHandle item, String repoUrl) {
        return Location.itemLocation(item, repoUrl, null, null);
    }

    public static Location stateLocation(IItemHandle item, String repoUrl, String query, String serviceName) {
        if (item == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        if (!item.isUnmanaged() && !item.isAuditable()) {
            throw new IllegalArgumentException("If the specified item is of type Managed, it must be of type Auditable");
        }
        return new Location(Location.toStateURI(item, query), item, item.getItemType(), repoUrl, serviceName);
    }

    public static Location stateLocation(IItemHandle item, String repoUrl) {
        return Location.stateLocation(item, repoUrl, null, null);
    }

    public static Location contentCollectionLocation(String repoUrl, String serviceName) {
        return new Location(CONTENT_NS, null, null, repoUrl, serviceName);
    }

    public static Location contentLocation(IContent content, String repoUrl, String serviceName) {
        if (content == null) {
            throw new IllegalArgumentException("content must not be null");
        }
        String relativeURI = Location.toContentURI(content);
        return new Location(relativeURI, null, null, repoUrl, serviceName);
    }

    public static Location contentLocation(IContent content, String repoUri) {
        return Location.contentLocation(content, repoUri, null);
    }

    public boolean isAbsolute() {
        return this._repoUri != null;
    }

    public boolean isNamed() {
        return Location.isNamedUri(this._relativeUri);
    }

    public boolean isItemPath() {
        return Location.isItemPathUri(this._relativeUri);
    }

    public boolean isItemOid() {
        return Location.isOidUri(this._relativeUri);
    }

    public boolean isVirtualPath() {
        return Location.isVirtualPathUri(this._relativeUri);
    }

    public boolean isItemCollection() {
        return Location.isItemCollectionUri(this._relativeUri);
    }

    public boolean isVirtualCollection() {
        return Location.isVirtualCollectionUri(this._relativeUri);
    }

    public boolean isItem() {
        return this.isItemOid() || this.isNamed() || this.isItemPath() || this.isItemCollection();
    }

    public boolean isVirtual() {
        return this.isVirtualPath() || this.isVirtualCollection();
    }

    public boolean isContentCollection() {
        return Location.isContentCollectionUri(this._relativeUri);
    }

    public boolean isContent() {
        return Location.isContentUri(this._relativeUri);
    }

    public String getNamedId() {
        if (!this.isNamed()) {
            throw new IllegalStateException("Location is not named");
        }
        return Location.nameForNamedURI(this._relativeUri);
    }

    public String getPath() {
        if (this.isItemPath()) {
            return this.getItemPath();
        }
        if (this.isVirtualPath()) {
            return this.getVirtualPath();
        }
        throw new IllegalStateException("Location does not reference a path");
    }

    public String getItemPath() {
        if (!this.isItemPath()) {
            throw new IllegalStateException("Location does not reference an item path");
        }
        return Location.pathForURI(this._relativeUri);
    }

    public String getVirtualPath() {
        if (!this.isVirtualPath()) {
            throw new IllegalStateException("Location does not reference an virtual path");
        }
        return Location.pathForURI(this._relativeUri);
    }

    public boolean hasPropertyPath() {
        return this._fragment != null;
    }

    public boolean hasQueryParms() {
        return this._query != null;
    }

    public Map getQueryParms() {
        return LocationUtil.parseQueryParameters(this._query);
    }

    public String getQueryString() {
        return this._query != null ? this._query : new String();
    }

    public String getPropertyPath() {
        return this._fragment != null ? this._fragment : new String();
    }

    public String getServiceName() {
        if (!this.isAbsolute()) {
            return new String();
        }
        if (this._serviceName == null) {
            return DEFAULT_SERVICE_BINDING;
        }
        return this._serviceName;
    }

    public URI toAbsoluteUri() {
        if (this._repoUri == null) {
            throw new IllegalStateException("Location was not constructed with absolute location information");
        }
        URI uri = null;
        try {
            uri = new URI(this._repoUri);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(String.format("Unexpected error constructing absolute URI: %s", e.getMessage()));
        }
        String fullPath = null;
        String servicePath = null;
        String basePath = Location.trimTrailingSlash(uri.getPath());
        if (this._serviceName != null) {
            servicePath = "service/" + this._serviceName;
            fullPath = String.valueOf(basePath) + SLASH + servicePath;
        } else {
            fullPath = String.valueOf(basePath) + SLASH + RESOURCE_NS;
        }
        if (this._relativeUri.length() > 0) {
            fullPath = String.valueOf(fullPath) + SLASH + this._relativeUri;
        }
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), fullPath, this._query, this._fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(String.format("Unexpected error constructing absolute URI: %s", e.getMessage()));
        }
    }

    public URI toRelativeUri() {
        try {
            return new URI(null, null, this._relativeUri, this._query, this._fragment);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(String.format("Unexpected error constructing absolute URI: %s", e.getMessage()));
        }
    }

    public URI toBaseUri() {
        if (this._repoUri == null) {
            return null;
        }
        URI uri = null;
        try {
            uri = new URI(this._repoUri);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(String.format("Unexpected error constructing base URI: %s", e.getMessage()));
        }
        String basePath = Location.trimTrailingSlash(uri.getPath());
        if (basePath == null) {
            return null;
        }
        String fullPath = null;
        if (this._serviceName != null) {
            String servicePath = "service/" + this._serviceName;
            fullPath = String.valueOf(basePath) + SLASH + servicePath + SLASH;
        } else {
            fullPath = String.valueOf(basePath) + SLASH + RESOURCE_NS + SLASH;
        }
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), fullPath, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(String.format("Unexpected error constructing base URI: %s", e.getMessage()));
        }
    }

    public String getRepoUri() {
        return this._repoUri != null ? this._repoUri : new String();
    }

    private static String trimTrailingSlash(String uri) {
        if (uri == null) {
            return uri;
        }
        if (uri.endsWith(SLASH) || uri.endsWith("\\")) {
            int len = uri.length();
            if (len > 1) {
                return uri.substring(0, len - 1);
            }
            return new String();
        }
        return uri;
    }

    public IItemHandle getItemHandle() {
        return this._itemHandle;
    }

    public IType getType() {
        if (this._locType instanceof IItemType) {
            return this._locType;
        }
        if (this._locType instanceof IVirtualType) {
            return this._locType;
        }
        return null;
    }

    public IItemType getItemType() {
        if (this._locType instanceof IItemType) {
            return (IItemType)this._locType;
        }
        return null;
    }

    public IVirtualType getVirtualType() {
        if (this._locType instanceof IVirtualType) {
            return (IVirtualType)this._locType;
        }
        return null;
    }

    public IContent getContent() {
        if (this.isContent()) {
            String[] segments = this._relativeUri.split(SLASH);
            UUID contentId = UUID.valueOf(segments[segments.length - 1]);
            Content content = RepositoryFactory.eINSTANCE.createContent();
            content.setContentId(contentId);
            return content;
        }
        return null;
    }

    protected Location() {
        this._repoUri = null;
        this._relativeUri = null;
        this._query = null;
        this._fragment = null;
        this._itemHandle = null;
        this._locType = null;
        this._serviceName = null;
    }

    private Location(String relativeURI, IItemHandle itemHandle, IType type, String repositoryUri, String serviceName) {
        int fragmentNdx;
        if (relativeURI == null) {
            throw new IllegalArgumentException("relativeURI must not be null");
        }
        if (relativeURI.startsWith(SLASH)) {
            relativeURI = relativeURI.substring(1);
        }
        if ((fragmentNdx = (relativeURI = Location.canonicalizeTypedURI(relativeURI)).indexOf(35)) != -1) {
            this._fragment = fragmentNdx < relativeURI.length() - 1 ? relativeURI.substring(fragmentNdx + 1) : null;
            relativeURI = relativeURI.substring(0, fragmentNdx);
        } else {
            this._fragment = null;
        }
        int queryNdx = relativeURI.indexOf(63);
        if (queryNdx != -1) {
            this._query = queryNdx < relativeURI.length() - 1 ? relativeURI.substring(queryNdx + 1) : null;
            this._relativeUri = Location.trimTrailingSlash(relativeURI.substring(0, queryNdx));
        } else {
            this._query = null;
            this._relativeUri = Location.trimTrailingSlash(relativeURI);
        }
        this._repoUri = Location.trimTrailingSlash(repositoryUri);
        this._itemHandle = itemHandle;
        this._locType = type;
        this._serviceName = serviceName;
    }

    private Location(Location loc, String repositoryUri, String serviceName) {
        if (loc == null) {
            throw new IllegalArgumentException("loc must not be null");
        }
        this._repoUri = repositoryUri != null ? Location.trimTrailingSlash(repositoryUri) : loc._repoUri;
        this._serviceName = serviceName != null ? serviceName : loc._serviceName;
        this._relativeUri = loc._relativeUri;
        this._query = loc._query;
        this._fragment = loc._fragment;
        this._itemHandle = loc._itemHandle;
        this._locType = loc._locType;
    }

    private static IItemHandle itemOidUriToHandle(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        if (uri.startsWith(SLASH)) {
            uri = uri.substring(1);
        }
        uri = Location.removeFragmentAndQuery(uri);
        if ((uri = Location.trimTrailingSlash(uri)).startsWith(ITEM_OID_NS)) {
            uri = uri.substring(ITEM_OID_NS.length() + 1);
        } else if (uri.startsWith(REPO_ITEM_OID_NS)) {
            uri = uri.substring(REPO_ITEM_OID_NS.length() + 1);
        } else if (uri.startsWith(CURR_STATE_URI_PREFIX_NS)) {
            uri = uri.substring(CURR_STATE_URI_PREFIX_NS.length() + 1);
        } else if (uri.startsWith(ITEM_STATE_URI_PREFIX_NS)) {
            uri = uri.substring(ITEM_STATE_URI_PREFIX_NS.length() + 1);
        } else {
            String msg = String.format("uri '%s' is not a valid oid uri", uri);
            throw new IllegalArgumentException(msg);
        }
        String[] segments = uri.split(SLASH);
        if (segments.length < 2) {
            throw new IllegalArgumentException(String.format("Malformed current state URI selector: '%s'", uri));
        }
        IItemType itemType = Location.nameToItemType(segments[0]);
        if (itemType == null) {
            throw new IllegalArgumentException(String.format("Type specified in URI: '%s' is not a registered type", uri));
        }
        UUID itemId = UUID.valueOf(segments[1]);
        UUID stateId = null;
        if (segments.length > 2) {
            stateId = UUID.valueOf(segments[2]);
        }
        return itemType.createItemHandle(itemId, stateId);
    }

    private static boolean isOidUri(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        if (uri.startsWith(SLASH)) {
            uri = uri.substring(1);
        }
        if (uri.startsWith(ITEM_OID_NS) && uri.length() > ITEM_OID_NS.length() + 1) {
            return true;
        }
        if (uri.startsWith(REPO_ITEM_OID_NS) && uri.length() > REPO_ITEM_OID_NS.length() + 1) {
            return true;
        }
        if (uri.startsWith(CURR_STATE_URI_PREFIX_NS) && uri.length() > CURR_STATE_URI_PREFIX_NS.length() + 1) {
            return true;
        }
        return uri.startsWith(ITEM_STATE_URI_PREFIX_NS) && uri.length() > ITEM_STATE_URI_PREFIX_NS.length() + 1;
    }

    private static boolean isItemCollectionUri(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        if (uri.startsWith(SLASH)) {
            uri = uri.substring(1);
        }
        if (uri.startsWith(ITEM_COL_NS) && uri.length() > ITEM_COL_NS.length() + 1) {
            return true;
        }
        return uri.startsWith(REPO_ITEM_COLLECTION_NS) && uri.length() > REPO_ITEM_COLLECTION_NS.length() + 1;
    }

    private static boolean isVirtualCollectionUri(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        if (uri.startsWith(SLASH)) {
            uri = uri.substring(1);
        }
        if (uri.startsWith(VIRTUAL_COL_NS) && uri.length() > VIRTUAL_COL_NS.length() + 1) {
            return true;
        }
        return uri.startsWith(REPO_VIRTUAL_COLLECTION_NS) && uri.length() > REPO_VIRTUAL_COLLECTION_NS.length() + 1;
    }

    private static boolean isNamedUri(String uri) {
        String[] segments;
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        if (uri.startsWith(SLASH)) {
            uri = uri.substring(1);
        }
        if ((segments = uri.split(SLASH))[0].equals(DOT) || segments[0].equals(DOTDOT)) {
            return false;
        }
        if (uri.startsWith(ITEM_NAME_NS) && uri.length() > ITEM_NAME_NS.length() + 1) {
            return true;
        }
        if (uri.startsWith(REPO_NAMED_ITEM_NS) && uri.length() > REPO_NAMED_ITEM_NS.length() + 1) {
            return true;
        }
        if (uri.startsWith(REPO_ITEM_PATH_NS) && uri.length() > REPO_ITEM_PATH_NS.length() + 1) {
            return false;
        }
        if (uri.startsWith(REPO_ITEM_COLLECTION_NS) && uri.length() > REPO_ITEM_COLLECTION_NS.length() + 1) {
            return false;
        }
        if (uri.startsWith(REPO_ITEM_OID_NS) && uri.length() > REPO_ITEM_OID_NS.length() + 1) {
            return false;
        }
        if (uri.startsWith(CURR_STATE_URI_PREFIX_NS) && uri.length() > CURR_STATE_URI_PREFIX_NS.length() + 1) {
            return false;
        }
        if (uri.startsWith(ITEM_STATE_URI_PREFIX_NS) && uri.length() > ITEM_STATE_URI_PREFIX_NS.length() + 1) {
            return false;
        }
        if (uri.startsWith(REPO_VIRTUAL_COLLECTION_NS) && uri.length() > REPO_VIRTUAL_COLLECTION_NS.length() + 1) {
            return false;
        }
        if (uri.startsWith(REPO_VIRTUAL_PATH_NS) && uri.length() > REPO_VIRTUAL_PATH_NS.length() + 1) {
            return false;
        }
        if (uri.startsWith(ITEM_PATH_NS) && uri.length() > ITEM_PATH_NS.length() + 1) {
            return false;
        }
        if (uri.startsWith(ITEM_COL_NS) && uri.length() > ITEM_COL_NS.length() + 1) {
            return false;
        }
        if (uri.startsWith(ITEM_OID_NS) && uri.length() > ITEM_OID_NS.length() + 1) {
            return false;
        }
        if (uri.startsWith(VIRTUAL_COL_NS) && uri.length() > VIRTUAL_COL_NS.length() + 1) {
            return false;
        }
        if (uri.startsWith(VIRTUAL_PATH_NS) && uri.length() > VIRTUAL_PATH_NS.length() + 1) {
            return false;
        }
        if (uri.startsWith(CONTENT_NS) && uri.length() > CONTENT_NS.length() + 1) {
            return false;
        }
        if (uri.startsWith(VIRTUAL_NS) && uri.length() > VIRTUAL_NS.length() + 1) {
            return false;
        }
        return Location.nameToItemType(segments[0]) != null;
    }

    private static boolean isItemPathUri(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        if (uri.startsWith(SLASH)) {
            uri = uri.substring(1);
        }
        if (uri.startsWith(ITEM_PATH_NS) && uri.length() > ITEM_PATH_NS.length() + 1) {
            return true;
        }
        return uri.startsWith(REPO_ITEM_PATH_NS) && uri.length() > REPO_ITEM_PATH_NS.length() + 1;
    }

    private static boolean isVirtualPathUri(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        if (uri.startsWith(SLASH)) {
            uri = uri.substring(1);
        }
        if (uri.startsWith(VIRTUAL_COL_NS) && uri.length() > VIRTUAL_COL_NS.length()) {
            return false;
        }
        if (uri.startsWith(VIRTUAL_PATH_NS) && uri.length() > VIRTUAL_PATH_NS.length() + 1) {
            return true;
        }
        if (uri.startsWith(REPO_VIRTUAL_PATH_NS) && uri.length() > REPO_VIRTUAL_PATH_NS.length() + 1) {
            return true;
        }
        return uri.startsWith(VIRTUAL_NS) && uri.length() > VIRTUAL_NS.length() + 1;
    }

    private static boolean isContentCollectionUri(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        if (uri.startsWith(SLASH)) {
            uri = uri.substring(1);
        }
        if (uri.endsWith(SLASH)) {
            uri.substring(0, uri.length() - 1);
        }
        return uri.equals(CONTENT_NS);
    }

    private static boolean isContentUri(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        if (uri.startsWith(SLASH)) {
            uri = uri.substring(1);
        }
        return uri.startsWith(CONTENT_NS) && uri.length() > CONTENT_NS.length() + 1;
    }

    private static String canonicalizeTypedURI(String typedUri) {
        String[] segments;
        if (typedUri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        String retVal = typedUri;
        String pathPrefix = null;
        if (retVal.startsWith(ITEM_OID_NS)) {
            pathPrefix = retVal.substring(0, ITEM_OID_NS.length());
            retVal = retVal.substring(ITEM_OID_NS.length());
        } else if (retVal.startsWith(ITEM_COL_NS)) {
            pathPrefix = retVal.substring(0, ITEM_COL_NS.length());
            retVal = retVal.substring(ITEM_COL_NS.length());
        } else if (retVal.startsWith(ITEM_NAME_NS)) {
            pathPrefix = retVal.substring(0, ITEM_NAME_NS.length());
            retVal = retVal.substring(ITEM_NAME_NS.length());
        } else if (retVal.startsWith(ITEM_PATH_NS)) {
            pathPrefix = retVal.substring(0, ITEM_PATH_NS.length());
            retVal = retVal.substring(ITEM_PATH_NS.length());
        } else if (retVal.startsWith(VIRTUAL_COL_NS)) {
            pathPrefix = retVal.substring(0, VIRTUAL_COL_NS.length());
            retVal = retVal.substring(VIRTUAL_COL_NS.length());
        } else if (retVal.startsWith(VIRTUAL_PATH_NS)) {
            pathPrefix = retVal.substring(0, VIRTUAL_PATH_NS.length());
            retVal = retVal.substring(VIRTUAL_PATH_NS.length());
        } else if (retVal.startsWith(VIRTUAL_NS)) {
            pathPrefix = retVal.substring(0, VIRTUAL_NS.length());
            retVal = retVal.substring(VIRTUAL_NS.length());
        } else if (retVal.startsWith(REPO_ITEM_OID_NS)) {
            pathPrefix = retVal.substring(0, REPO_ITEM_OID_NS.length());
            retVal = retVal.substring(REPO_ITEM_OID_NS.length());
        } else if (retVal.startsWith(REPO_ITEM_COLLECTION_NS)) {
            pathPrefix = retVal.substring(0, REPO_ITEM_COLLECTION_NS.length());
            retVal = retVal.substring(REPO_ITEM_COLLECTION_NS.length());
        } else if (retVal.startsWith(REPO_NAMED_ITEM_NS)) {
            pathPrefix = retVal.substring(0, REPO_NAMED_ITEM_NS.length());
            retVal = retVal.substring(REPO_NAMED_ITEM_NS.length());
        } else if (retVal.startsWith(REPO_ITEM_PATH_NS)) {
            pathPrefix = retVal.substring(0, REPO_ITEM_PATH_NS.length());
            retVal = retVal.substring(REPO_ITEM_PATH_NS.length());
        } else if (retVal.startsWith(REPO_VIRTUAL_COLLECTION_NS)) {
            pathPrefix = retVal.substring(0, REPO_VIRTUAL_COLLECTION_NS.length());
            retVal = retVal.substring(REPO_VIRTUAL_COLLECTION_NS.length());
        } else if (retVal.startsWith(REPO_VIRTUAL_PATH_NS)) {
            pathPrefix = retVal.substring(0, REPO_VIRTUAL_PATH_NS.length());
            retVal = retVal.substring(REPO_VIRTUAL_PATH_NS.length());
        } else if (retVal.startsWith(CURR_STATE_URI_PREFIX_NS)) {
            pathPrefix = retVal.substring(0, CURR_STATE_URI_PREFIX_NS.length());
            retVal = retVal.substring(CURR_STATE_URI_PREFIX_NS.length());
        } else if (retVal.startsWith(ITEM_STATE_URI_PREFIX_NS)) {
            pathPrefix = retVal.substring(0, ITEM_STATE_URI_PREFIX_NS.length());
            retVal = retVal.substring(ITEM_STATE_URI_PREFIX_NS.length());
        }
        boolean startedWithSlash = false;
        if (retVal.startsWith(SLASH)) {
            retVal = retVal.substring(1);
            startedWithSlash = true;
        }
        if ((segments = (retVal = Location.trimTrailingSlash(retVal)).split(SLASH)).length == 0) {
            segments = new String[]{retVal};
        }
        if (segments[0].equals(DOT) || segments[0].equals(DOTDOT)) {
            return Location.trimTrailingSlash(typedUri);
        }
        int dot = segments[0].indexOf(46);
        if (dot != -1) {
            return Location.trimTrailingSlash(typedUri);
        }
        IType type = null;
        try {
            type = Location.nameToItemType(segments[0]);
        }
        catch (Exception exception) {}
        if (type == null) {
            try {
                type = ItemUtil.nameToVirtualType(segments[0]);
            }
            catch (Exception exception) {}
        }
        if (type == null) {
            return Location.trimTrailingSlash(typedUri);
        }
        StringBuffer buf = new StringBuffer(64);
        if (pathPrefix != null) {
            buf.append(pathPrefix);
        }
        if (startedWithSlash) {
            buf.append(SLASH);
        }
        buf.append(ItemUtil.typeToName(type));
        int i = 1;
        while (i < segments.length) {
            buf.append(SLASH);
            buf.append(segments[i]);
            ++i;
        }
        return buf.toString();
    }

    private static String nameForNamedURI(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        if (uri.startsWith(SLASH)) {
            uri = uri.substring(1);
        }
        if (uri.startsWith(ITEM_NAME_NS)) {
            uri = uri.substring(ITEM_NAME_NS.length() + 1);
        } else if (uri.startsWith(REPO_NAMED_ITEM_NS)) {
            uri = uri.substring(REPO_NAMED_ITEM_NS.length() + 1);
        }
        String[] segments = uri.split(SLASH);
        if (segments.length < 2) {
            throw new IllegalArgumentException(String.format("Malformed named URI selector: '%s'", uri));
        }
        return segments[1];
    }

    private static String pathForURI(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        if (uri.startsWith(SLASH)) {
            uri = uri.substring(1);
        }
        if (uri.startsWith(REPO_ITEM_PATH_NS)) {
            uri = uri.substring(REPO_ITEM_PATH_NS.length() + 1);
        } else if (uri.startsWith(REPO_VIRTUAL_PATH_NS)) {
            uri = uri.substring(REPO_VIRTUAL_PATH_NS.length() + 1);
        } else if (uri.startsWith(ITEM_PATH_NS)) {
            uri = uri.substring(ITEM_PATH_NS.length() + 1);
        } else if (uri.startsWith(VIRTUAL_PATH_NS)) {
            uri = uri.substring(VIRTUAL_PATH_NS.length() + 1);
        } else {
            if (uri.startsWith(VIRTUAL_COL_NS)) {
                throw new IllegalArgumentException("This method only valid for item and virtual paths");
            }
            if (!uri.startsWith(VIRTUAL_NS)) {
                throw new IllegalArgumentException("This method only valid for item and virtual paths");
            }
        }
        String[] segments = uri.split(SLASH);
        if (segments.length < 2) {
            return new String();
        }
        StringBuffer buf = new StringBuffer(128);
        buf.append(segments[1]);
        int i = 2;
        while (i < segments.length) {
            buf.append('/');
            buf.append(segments[i]);
            ++i;
        }
        return buf.toString();
    }

    private static String toItemURI(IItemHandle item, String query) {
        if (item == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        if (item.getItemId() == null) {
            throw new IllegalArgumentException("item must reference an item id");
        }
        StringBuffer buf = new StringBuffer(128);
        if (_useResourceNS) {
            buf.append(ITEM_OID_NS);
        } else {
            buf.append(REPO_ITEM_OID_NS);
        }
        IItemType type = item.getItemType();
        buf.append(SLASH);
        buf.append(ItemUtil.typeToName(type));
        buf.append(SLASH);
        buf.append(item.getItemId().getUuidValue());
        if (query != null) {
            buf.append(String.valueOf('?') + query);
        }
        return buf.toString();
    }

    private static String toPathUri(IItemType type, String[] path, String query) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        String pathPrefix = null;
        pathPrefix = _useResourceNS ? ITEM_PATH_NS : REPO_ITEM_PATH_NS;
        return Location.pathUri(type, pathPrefix, path, query);
    }

    private static String toPathUri(IVirtualType type, String[] path, String query) {
        String pathPrefix = null;
        pathPrefix = _useResourceNS ? (type == null ? VIRTUAL_NS : VIRTUAL_PATH_NS) : REPO_VIRTUAL_PATH_NS;
        return Location.pathUri(type, pathPrefix, path, query);
    }

    private static String pathUri(IType type, String pathType, String[] path, String query) {
        if (pathType == null) {
            throw new IllegalArgumentException("pathType must not be null");
        }
        if (path == null) {
            path = new String[]{};
        }
        StringBuffer buf = new StringBuffer(pathType);
        buf.append(SLASH);
        if (type != null) {
            buf.append(ItemUtil.typeToName(type));
        }
        int i = 0;
        while (i < path.length) {
            if (type != null || i != 0) {
                buf.append(SLASH);
            }
            buf.append(path[i]);
            ++i;
        }
        if (query != null) {
            buf.append(String.valueOf('?') + query);
        }
        return buf.toString();
    }

    private static String toStateURI(IItemHandle item, String query) {
        if (item == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        if (item.getItemId() == null) {
            throw new IllegalArgumentException("item must reference an item id");
        }
        if (item.getStateId() == null) {
            throw new IllegalArgumentException("item must reference a state id");
        }
        StringBuffer buf = new StringBuffer(128);
        if (_useResourceNS) {
            buf.append(ITEM_OID_NS);
        } else {
            buf.append(REPO_ITEM_OID_NS);
        }
        IItemType type = item.getItemType();
        buf.append(SLASH);
        buf.append(ItemUtil.typeToName(type));
        buf.append(SLASH);
        buf.append(item.getItemId().getUuidValue());
        buf.append(SLASH);
        buf.append(item.getStateId().getUuidValue());
        if (query != null) {
            buf.append(String.valueOf('?') + query);
        }
        return buf.toString();
    }

    public static String itemToNamedURI(IItem item, String query) {
        if (item == null) {
            throw new IllegalArgumentException("item must not be null");
        }
        StringBuffer buf = new StringBuffer(128);
        if (_useResourceNS) {
            buf.append(ITEM_NAME_NS);
        } else {
            buf.append(REPO_NAMED_ITEM_NS);
        }
        IItemType type = item.getItemType();
        buf.append(SLASH);
        buf.append(ItemUtil.typeToName(type));
        buf.append(SLASH);
        Object value = LocationUtil.namedIdentifierPropValue(item);
        if (value == null || value.toString().length() == 0) {
            throw new IllegalArgumentException("named identifier value is empty");
        }
        buf.append(value);
        if (query != null) {
            buf.append(String.valueOf('?') + query);
        }
        return buf.toString();
    }

    private static String toContentURI(IContent content) {
        if (content == null) {
            throw new IllegalArgumentException("content must not be null");
        }
        if (content.getContentId() == null) {
            throw new IllegalArgumentException("content must reference a content id");
        }
        StringBuffer buf = new StringBuffer(CONTENT_NS);
        buf.append(SLASH);
        buf.append(content.getContentId().getUuidValue());
        return buf.toString();
    }

    private static String toCollectionURI(IType type, String query) {
        if (type == null) {
            throw new IllegalArgumentException("type must not be null");
        }
        String colType = null;
        if (type instanceof IVirtualType) {
            colType = _useResourceNS ? VIRTUAL_COL_NS : REPO_VIRTUAL_COLLECTION_NS;
        } else if (type instanceof IItemType) {
            colType = _useResourceNS ? ITEM_COL_NS : REPO_ITEM_COLLECTION_NS;
        } else {
            throw new IllegalArgumentException(String.format("Unsupported type '%s' specified", ItemUtil.typeToName(type)));
        }
        StringBuffer buf = new StringBuffer(128);
        buf.append(colType);
        buf.append(SLASH);
        buf.append(ItemUtil.typeToName(type));
        if (query != null) {
            buf.append('?');
            buf.append(query);
        }
        return buf.toString();
    }

    private static IItemType itemCollectionToType(String uri) {
        if (uri.startsWith(SLASH)) {
            uri = uri.substring(1);
        }
        if (!uri.startsWith(REPO_ITEM_COLLECTION_NS) && !uri.startsWith(ITEM_COL_NS)) {
            throw new IllegalArgumentException(String.format("uri '%s' does not refer to a collection", uri));
        }
        uri = Location.removeFragmentAndQuery(uri);
        if ((uri = (uri = Location.trimTrailingSlash(uri)).startsWith(REPO_ITEM_COLLECTION_NS) ? uri.substring(REPO_ITEM_COLLECTION_NS.length() + 1) : uri.substring(ITEM_COL_NS.length() + 1)).endsWith(SLASH)) {
            uri = uri.substring(0, uri.length() - 1);
        }
        return Location.nameToItemType(uri);
    }

    private static IVirtualType virtualCollectionToType(String uri) {
        if (uri.startsWith(SLASH)) {
            uri = uri.substring(1);
        }
        if (!uri.startsWith(REPO_VIRTUAL_COLLECTION_NS) && !uri.startsWith(VIRTUAL_COL_NS)) {
            throw new IllegalArgumentException(String.format("uri '%s' does not refer to a collection", uri));
        }
        uri = Location.removeFragmentAndQuery(uri);
        if ((uri = (uri = Location.trimTrailingSlash(uri)).startsWith(REPO_VIRTUAL_COLLECTION_NS) ? uri.substring(REPO_VIRTUAL_COLLECTION_NS.length() + 1) : uri.substring(VIRTUAL_COL_NS.length() + 1)).endsWith(SLASH)) {
            uri = uri.substring(0, uri.length() - 1);
        }
        return ItemUtil.nameToVirtualType(uri);
    }

    private static IItemType namedUriToItemType(String uri) {
        if (uri.startsWith(SLASH)) {
            uri = uri.substring(1);
        }
        uri = Location.removeFragmentAndQuery(uri);
        if ((uri = Location.trimTrailingSlash(uri)).startsWith(ITEM_NAME_NS)) {
            uri = uri.substring(ITEM_NAME_NS.length() + 1);
        } else if (uri.startsWith(REPO_NAMED_ITEM_NS)) {
            uri = uri.substring(REPO_NAMED_ITEM_NS.length() + 1);
        }
        String[] segments = uri.split(SLASH);
        if (segments.length < 2) {
            throw new IllegalArgumentException(String.format("Malformed named URI selector: '%s'", uri));
        }
        return Location.nameToItemType(segments[0]);
    }

    private static IItemType itemPathToItemType(String uri) {
        if (uri.startsWith(SLASH)) {
            uri = uri.substring(1);
        }
        if (!uri.startsWith(ITEM_PATH_NS) && !uri.startsWith(REPO_ITEM_PATH_NS)) {
            throw new IllegalArgumentException(String.format("uri '%s' does not refer to an item path", uri));
        }
        uri = Location.removeFragmentAndQuery(uri);
        uri = (uri = Location.trimTrailingSlash(uri)).startsWith(ITEM_PATH_NS) ? uri.substring(ITEM_PATH_NS.length() + 1) : uri.substring(REPO_ITEM_PATH_NS.length() + 1);
        String[] segments = uri.split(SLASH);
        return Location.nameToItemType(segments[0]);
    }

    private static IVirtualType virtualPathToType(String uri) {
        if (uri.startsWith(SLASH)) {
            uri = uri.substring(1);
        }
        if (uri.startsWith(VIRTUAL_COL_NS) || !uri.startsWith(VIRTUAL_PATH_NS) && !uri.startsWith(REPO_VIRTUAL_PATH_NS) && !uri.startsWith(VIRTUAL_NS)) {
            throw new IllegalArgumentException(String.format("uri '%s' is not a virtual path resource", uri));
        }
        uri = Location.removeFragmentAndQuery(uri);
        uri = (uri = Location.trimTrailingSlash(uri)).startsWith(REPO_VIRTUAL_PATH_NS) ? uri.substring(REPO_VIRTUAL_PATH_NS.length() + 1) : (uri.startsWith(VIRTUAL_PATH_NS) ? uri.substring(VIRTUAL_PATH_NS.length() + 1) : uri.substring(VIRTUAL_NS.length() + 1));
        String[] segments = uri.split(SLASH);
        return ItemUtil.nameToVirtualType(segments[0]);
    }

    private static Location locationFromRelUri(URI resource) {
        if (resource == null) {
            throw new IllegalArgumentException("resource must not be null");
        }
        String relativeUri = Location.relativeURI(resource);
        IItemHandle itemHandle = null;
        IType type = null;
        if (Location.isOidUri(relativeUri)) {
            itemHandle = Location.itemOidUriToHandle(relativeUri);
            type = itemHandle.getItemType();
        }
        if (type == null) {
            type = Location.relativeUriToType(relativeUri);
        }
        return new Location(relativeUri, itemHandle, type, null, null);
    }

    private static Location locationFromAbsUri(URI resource) throws TeamRepositoryException {
        String[] parts;
        boolean parseService;
        if (resource == null) {
            throw new IllegalArgumentException("resource must not be null");
        }
        String pathStr = resource.getPath() != null ? resource.getPath() : new String();
        String resourceStr = null;
        try {
            resourceStr = URLDecoder.decode(resource.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new TeamRepositoryException("errors decoding referenced URI: " + e.getMessage());
        }
        int pathServiceNdx = pathStr.indexOf("/service/");
        int pathResourceNdx = pathStr.indexOf("/resource/");
        if (pathServiceNdx == -1 && pathResourceNdx == -1) {
            String path = resource.getPath() != null ? resource.getPath() : new String();
            String repoPart = null;
            if (resource.getScheme() != null && resource.getSchemeSpecificPart() != null) {
                repoPart = String.valueOf(resource.getScheme()) + ':' + resource.getSchemeSpecificPart();
            }
            return new Location(path, null, null, repoPart, null);
        }
        if (pathServiceNdx != -1 && pathResourceNdx != -1) {
            throw new IllegalArgumentException(String.format("Malformed resource URI: '%s'", resourceStr));
        }
        int serviceNdx = resourceStr.indexOf("/service/");
        int resourceNdx = resourceStr.indexOf("/resource/");
        String baseUri = null;
        String relPart = null;
        String relativeUri = new String();
        String serviceName = null;
        boolean bl = parseService = serviceNdx > 0;
        if (parseService) {
            baseUri = resourceStr.substring(0, serviceNdx);
            relPart = resourceStr.substring(serviceNdx);
            parts = patternSlash.split(relPart, 4);
            if (parts == null || parts.length < 3) {
                throw new IllegalArgumentException(String.format("Malformed resource has unrecognized service name and resource identifier - %s", resourceStr));
            }
            serviceName = parts[2];
            if (parts.length > 3) {
                relativeUri = parts[3];
            }
        } else {
            baseUri = resourceStr.substring(0, resourceNdx);
            relPart = resourceStr.substring(resourceNdx + 1);
            parts = patternSlash.split(relPart, 2);
            if (parts == null || parts.length < 2) {
                throw new IllegalArgumentException(String.format("Malformed resource has resource syntax form - %s", resourceStr));
            }
            relativeUri = parts[1];
        }
        IItemHandle itemHandle = null;
        IType type = null;
        if (Location.isOidUri(relativeUri)) {
            itemHandle = Location.itemOidUriToHandle(relativeUri);
            type = itemHandle.getItemType();
        }
        if (type == null) {
            type = Location.relativeUriToType(relativeUri);
        }
        return new Location(relativeUri, itemHandle, type, baseUri, serviceName);
    }

    private static IType relativeUriToType(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("relativeUri must not be null");
        }
        IType type = null;
        if (uri.startsWith(SLASH)) {
            uri = uri.substring(1);
        }
        if (Location.isOidUri(uri)) {
            type = Location.itemOidUriToHandle(uri).getItemType();
        } else if (Location.isItemCollectionUri(uri)) {
            type = Location.itemCollectionToType(uri);
        } else if (Location.isVirtualCollectionUri(uri)) {
            type = Location.virtualCollectionToType(uri);
        } else if (Location.isNamedUri(uri)) {
            type = Location.namedUriToItemType(uri);
        } else if (Location.isItemPathUri(uri)) {
            type = Location.itemPathToItemType(uri);
        } else if (Location.isVirtualPathUri(uri)) {
            type = Location.virtualPathToType(uri);
        }
        return type;
    }

    private static String relativeURI(URI resource) {
        if (resource == null) {
            throw new IllegalArgumentException("resource must not be null");
        }
        if (resource.getScheme() != null) {
            throw new IllegalArgumentException("resource must not be absolute");
        }
        String path = resource.getPath();
        if (path.length() == 0) {
            return new String();
        }
        if (path.startsWith(SLASH)) {
            path = path.substring(1);
        }
        StringBuffer buf = new StringBuffer(path);
        if (resource.getQuery() != null) {
            buf.append(String.valueOf('?') + resource.getQuery());
        }
        if (resource.getFragment() != null) {
            buf.append(String.valueOf('#') + resource.getFragment());
        }
        return buf.toString();
    }

    private static String removeFragmentAndQuery(String relativeURI) {
        int queryNdx;
        if (relativeURI == null) {
            throw new IllegalArgumentException("relativeURI must not be null");
        }
        String uri = relativeURI;
        int fragmentNdx = uri.indexOf(35);
        if (fragmentNdx != -1) {
            uri = uri.substring(0, fragmentNdx);
        }
        if ((queryNdx = uri.indexOf(63)) != -1) {
            uri = Location.trimTrailingSlash(uri.substring(0, queryNdx));
        }
        return uri;
    }

    public boolean equals(Object obj) {
        block7: {
            block6: {
                try {
                    if (this != obj) break block6;
                    return true;
                }
                catch (RuntimeException e) {
                    _logger.info((Object)e.getMessage(), (Throwable)e);
                    return false;
                }
            }
            if (obj != null && obj.getClass() == this.getClass()) break block7;
            return false;
        }
        Location that = (Location)obj;
        if (this.isAbsolute() && that.isAbsolute()) {
            URI thisUri = null;
            URI thatUri = null;
            thisUri = this.toAbsoluteUri();
            thatUri = that.toAbsoluteUri();
            return thisUri.equals(thatUri);
        }
        if (!this.isAbsolute() && !that.isAbsolute()) {
            URI thisUri = null;
            URI thatUri = null;
            thisUri = this.toRelativeUri();
            thatUri = that.toRelativeUri();
            return thisUri.equals(thatUri);
        }
        return false;
    }

    public int hashCode() {
        URI uri;
        try {
            uri = null;
            uri = this.isAbsolute() ? this.toAbsoluteUri() : this.toRelativeUri();
        }
        catch (RuntimeException e) {
            _logger.info((Object)e.getMessage(), (Throwable)e);
            return -1;
        }
        return uri.hashCode();
    }

    public String toString() {
        String string = new String();
        try {
            string = this.isAbsolute() ? this.toAbsoluteUri().toString() : this.toRelativeUri().toString();
        }
        catch (RuntimeException e) {
            _logger.error((Object)e.getMessage(), (Throwable)e);
            return new String();
        }
        return string;
    }

    private static IItemType nameToItemType(String name) {
        if (name.equals(DOT) || name.equals(DOTDOT)) {
            return null;
        }
        int index = name.lastIndexOf(46);
        if (index > 0 && name.charAt(name.length() - 1) == '.') {
            throw new IllegalStateException("Illegal syntax for qualified typename - ends with '.'");
        }
        if (index == -1) {
            List<IItemType> types = ItemUtil.itemTypeFor(name);
            if (types.isEmpty()) {
                return null;
            }
            if (types.size() == 1) {
                return types.get(0);
            }
            String componentNS = _itemTypeShortNameMap.get(name);
            if (componentNS == null) {
                throw new IllegalStateException(String.format("More than one component has registered the item type name '%s'", name));
            }
            return ItemUtil.itemTypeFor(name, componentNS);
        }
        String suffix = name.substring(index + 1);
        String namespace = name.substring(0, index);
        return ItemUtil.itemTypeFor(suffix, namespace);
    }
}

