/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.util.NLS;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LineDelimiter {
    LINE_DELIMITER_NONE(0),
    LINE_DELIMITER_LF(1),
    LINE_DELIMITER_CR(2),
    LINE_DELIMITER_CRLF(3),
    LINE_DELIMITER_PLATFORM(4);

    private static final String[] PRETTY_NAME;
    private final int columnValue;
    private static final boolean IS_CRLF_PLATFORM;
    private static final boolean IS_LF_PLATFORM;
    private static final boolean IS_CR_PLATFORM;

    static {
        PRETTY_NAME = new String[]{"None", "LF (Unix)", "CR (Mac)", "CRLF (Windows)", "Platform"};
        IS_CRLF_PLATFORM = Arrays.equals(System.getProperty("line.separator").toCharArray(), new char[]{'\r', '\n'});
        IS_LF_PLATFORM = Arrays.equals(System.getProperty("line.separator").toCharArray(), new char[]{'\n'});
        IS_CR_PLATFORM = Arrays.equals(System.getProperty("line.separator").toCharArray(), new char[]{'\r'});
    }

    private LineDelimiter(int columnValue) {
        this.columnValue = columnValue;
    }

    public int columnValue() {
        return this.columnValue;
    }

    public static LineDelimiter getLineDelimiter(int columnValue) {
        LineDelimiter[] lineDelimiterArray = LineDelimiter.values();
        int n = lineDelimiterArray.length;
        int n2 = 0;
        while (n2 < n) {
            LineDelimiter delimiter = lineDelimiterArray[n2];
            if (delimiter.columnValue() == columnValue) {
                return delimiter;
            }
            ++n2;
        }
        return null;
    }

    public static LineDelimiter fromString(String name) {
        if (name == null) {
            return null;
        }
        int i = 0;
        while (i < PRETTY_NAME.length) {
            if (name.equals(PRETTY_NAME[i])) {
                return LineDelimiter.values()[i];
            }
            ++i;
        }
        return null;
    }

    public String asQuery() throws TeamRepositoryException {
        if (this == LINE_DELIMITER_NONE) {
            return "";
        }
        if (this == LINE_DELIMITER_LF) {
            return "LF";
        }
        if (this == LINE_DELIMITER_CR) {
            return "CR";
        }
        if (this == LINE_DELIMITER_CRLF) {
            return "CRLF";
        }
        String msg = NLS.bind(Messages.getServerString("TeamContent.ErrorInvalidLineEnding"), (Object)this, new Object[0]);
        throw new TeamRepositoryException(msg);
    }

    public static LineDelimiter fromQuery(String query) {
        if (query == null || query.length() == 0) {
            return LINE_DELIMITER_NONE;
        }
        if (query.equals("LF")) {
            return LINE_DELIMITER_LF;
        }
        if (query.equals("CR")) {
            return LINE_DELIMITER_CR;
        }
        if (query.equals("CRLF")) {
            return LINE_DELIMITER_CRLF;
        }
        throw new IllegalArgumentException("Unrecognized query string for delimiter type");
    }

    public static LineDelimiter getPlatformDelimiter() {
        if (IS_CRLF_PLATFORM) {
            return LINE_DELIMITER_CRLF;
        }
        if (IS_LF_PLATFORM) {
            return LINE_DELIMITER_LF;
        }
        if (IS_CR_PLATFORM) {
            return LINE_DELIMITER_CR;
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return PRETTY_NAME[this.columnValue];
    }
}

