/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize.internal.json;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.repository.common.serialize.IPrimitiveHandler;
import com.ibm.team.repository.common.serialize.IPrimitiveRegistry;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.serialize.internal.Serializer;
import com.ibm.team.repository.common.serialize.internal.SerializingWriter;
import com.ibm.team.repository.common.serialize.internal.Util;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class JSONSerializer_03
extends Serializer {
    private static final IPrimitiveRegistry PrimitiveReg = IPrimitiveRegistry.INSTANCE;
    public static final String KEY_EPACKAGE = "@EPackage";
    public static final String KEY_ECLASS = "@EClass";
    public static final String KEY_LOCATION = "@Location";

    public String getFormat() {
        return "json";
    }

    public String getVersion() {
        return "0.3";
    }

    protected void serializeEObject(SerializingWriter sWriter, EObject object, Class expectedType) throws SerializeException {
        JSONObject jsonObject = this.serializeEObject(object, expectedType);
        jsonObject.put((Object)"@serializeVersion", (Object)"0.3");
        try {
            jsonObject.serialize((Writer)sWriter, sWriter.isVerbose());
        }
        catch (IOException e) {
            throw SerializeException.from(e);
        }
    }

    private JSONObject serializeEObject(EObject eObject, Class expectedType) throws SerializeException {
        if (eObject == null) {
            return null;
        }
        JSONObject jsonObject = new JSONObject();
        if (this.shouldMorphItemToHandle(eObject, expectedType)) {
            eObject = this.morphItemToHandle(eObject);
        }
        EClass eClass = eObject.eClass();
        jsonObject.put((Object)KEY_EPACKAGE, (Object)eClass.getEPackage().getNsURI());
        jsonObject.put((Object)KEY_ECLASS, (Object)eClass.getName());
        if (eObject instanceof IItemHandle) {
            IItemHandle item = (IItemHandle)eObject;
            if (this.getRepoUri() == null) {
                throw new SerializeException(Messages.getServerString("JSONSerializer_03.ErrorMissingRepository"));
            }
            Location loc = null;
            loc = item.hasStateId() ? Location.stateLocation((IItemHandle)item, (String)this.getRepoUri()) : Location.itemLocation((IItemHandle)item, (String)this.getRepoUri());
            jsonObject.put((Object)KEY_LOCATION, (Object)loc.toAbsoluteUri().toString());
        }
        List sfs = Util.getStructuralFeatures(eClass, null);
        for (EStructuralFeature sf : sfs) {
            if (!eObject.eIsSet(sf)) continue;
            Object value = eObject.eGet(sf);
            String key = sf.getName();
            Class valueExpectedType = sf.getEType().getInstanceClass();
            Object serializedValue = this.serializeObject(value, valueExpectedType);
            jsonObject.put((Object)key, serializedValue);
        }
        return jsonObject;
    }

    private Object serializeObject(Object value, Class expectedType) throws SerializeException {
        if (value == null) {
            return null;
        }
        Class<?> valueClass = value.getClass();
        if (value instanceof EObject) {
            EObject eValue = (EObject)value;
            return this.serializeEObject(eValue, expectedType);
        }
        if (value instanceof List) {
            return this.serializeList((List)value, expectedType);
        }
        if (valueClass.isArray()) {
            return this.serializeArray(value, expectedType);
        }
        if (PrimitiveReg.isPrimitive(valueClass)) {
            return this.serializePrimitive(value, valueClass);
        }
        if (value instanceof Enumerator) {
            return ((Enumerator)value).getLiteral();
        }
        throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONSerializer_03.ErrorUnserializableValue"), (Object)value, (Object[])new Object[0]));
    }

    private Object serializePrimitive(Object value, Class valueClass) throws SerializeException {
        if (value == null) {
            return null;
        }
        if (valueClass == Boolean.class) {
            return value;
        }
        if (valueClass == String.class) {
            return value;
        }
        if (Number.class.isAssignableFrom(valueClass)) {
            return value;
        }
        IPrimitiveHandler primHandler = IPrimitiveRegistry.INSTANCE.getHandler(valueClass);
        if (primHandler == null) {
            throw new SerializeException(NLS.bind((String)Messages.getServerString("JSONSerializer_03.ErrorMissingHandler"), (Object)valueClass.getName(), (Object[])new Object[0]));
        }
        return primHandler.objectToString(value);
    }

    private JSONArray serializeList(List list, Class expectedType) throws SerializeException {
        JSONArray result = new JSONArray(list.size());
        for (Object element : list) {
            Object serializedElement = this.serializeObject(element, expectedType);
            result.add(serializedElement);
        }
        return result;
    }

    private JSONArray serializeArray(Object array, Class expectedType) throws SerializeException {
        int length = Array.getLength(array);
        JSONArray result = new JSONArray(length);
        int i = 0;
        while (i < length) {
            Object element = Array.get(array, i);
            Object serializedElement = this.serializeObject(element, expectedType);
            result.add(serializedElement);
            ++i;
        }
        return result;
    }
}

