/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.serialize.internal;

import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.serialize.IPrimitiveRegistry;
import com.ibm.team.repository.common.serialize.SerializeException;
import com.ibm.team.repository.common.serialize.internal.ObjectGraphVisitor;
import com.ibm.team.repository.common.serialize.internal.ObjectGraphVisitorInfo;
import com.ibm.team.repository.common.serialize.internal.Util;
import com.ibm.team.repository.common.util.NLS;
import java.lang.reflect.Array;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ObjectGraphWalker {
    private final Object root;
    private final ObjectGraphVisitorInfo info;

    public static ObjectGraphWalker newInstance(Object root) {
        return new ObjectGraphWalker(root);
    }

    private ObjectGraphWalker(Object root) {
        this.root = root;
        this.info = new ObjectGraphVisitorInfo();
    }

    public void walk(ObjectGraphVisitor visitor) throws SerializeException {
        this.walk(visitor, this.root, null, null, -1);
    }

    private void walk(ObjectGraphVisitor visitor, Object object, Object container, EStructuralFeature structuralFeature, int index) throws SerializeException {
        this.info.object = object;
        this.info.container = container;
        this.info.structuralFeature = structuralFeature;
        this.info.index = index;
        if (object == null) {
            visitor.visit(this.info);
            return;
        }
        if (IPrimitiveRegistry.INSTANCE.isPrimitive(object.getClass())) {
            visitor.visit(this.info);
            return;
        }
        if (object instanceof EObject) {
            visitor.visit(this.info);
            this.walkEObject(visitor, (EObject)object);
        } else if (object instanceof Enumerator) {
            visitor.visit(this.info);
        } else if (object instanceof List) {
            this.walkList(visitor, (List)object, container, structuralFeature);
        } else if (object.getClass().isArray()) {
            this.walkArray(visitor, object, container, structuralFeature);
        } else {
            throw new SerializeException(NLS.bind((String)Messages.getServerString("ObjectGraphWalker.UnknownType"), object.getClass(), (Object[])new Object[0]));
        }
    }

    private void walkEObject(ObjectGraphVisitor visitor, EObject eObject) throws SerializeException {
        List sfs = Util.getStructuralFeatures(eObject.eClass(), null);
        for (EStructuralFeature sf : sfs) {
            if (sf.isTransient()) continue;
            Object value = eObject.eGet(sf);
            this.walk(visitor, value, eObject, sf, -1);
        }
    }

    private void walkList(ObjectGraphVisitor visitor, List list, Object container, EStructuralFeature structuralFeature) throws SerializeException {
        int index = 0;
        for (Object element : list) {
            this.walk(visitor, element, container, structuralFeature, index);
            ++index;
        }
    }

    private void walkArray(ObjectGraphVisitor visitor, Object array, Object container, EStructuralFeature structuralFeature) throws SerializeException {
        int length = Array.getLength(array);
        int index = 0;
        while (index < length) {
            Object element = Array.get(array, index);
            this.walk(visitor, element, container, structuralFeature, index);
            ++index;
        }
    }
}

